/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextBox {
    private String text;
    private int textLength;
    private int width;
    private int height;
    private Font font = Font.getFont((int)64, (int)0, (int)0);
    private int maxLineNum;
    private int lineSize;
    private int totalPage;
    private int[] lineNum;
    private int[] linePos;
    private int currentLen;
    private int wordNumber;
    private int letterLength;
    private int currentIndex;
    private int currentLine;
    private int totalLine;
    private int lineIndex;
    private int pageIndex;
    private int imgWordW;
    private int imgWordH;

    public TextBox(int imgWordW, int imgWordH) {
        this.setBoxSize(24, 22);
        this.imgWordW = imgWordW;
        this.imgWordH = imgWordH;
    }

    public void Close() {
        this.text = null;
        this.lineNum = null;
        this.linePos = null;
    }

    private void resetBox() {
        this.lineSize = this.width - 4;
        this.maxLineNum = (this.height - 2) / (this.imgWordH + 2);
        if (this.text != null) {
            this.setString(this.text);
        }
    }

    private void newLine(int state) {
        ++this.currentLine;
        this.currentLen = 0;
        this.linePos[++this.lineIndex] = this.currentIndex - (state << 1);
        this.linePos[++this.lineIndex] = this.currentIndex + 1;
        if (this.currentLine == this.maxLineNum) {
            ++this.totalPage;
            this.totalLine += this.currentLine;
            this.lineNum[++this.pageIndex] = this.totalLine;
            this.currentLine = 0;
        }
    }

    public void setString(String text) {
        this.text = text;
        this.textLength = text.length();
        this.lineNum = new int[this.textLength + 1];
        this.linePos = new int[this.textLength << 1];
        this.currentIndex = 0;
        this.wordNumber = 0;
        this.letterLength = 0;
        this.currentLen = 0;
        this.currentLine = 0;
        this.totalLine = 0;
        this.pageIndex = 0;
        this.lineIndex = 0;
        this.lineNum[this.pageIndex] = 0;
        this.linePos[this.lineIndex] = 0;
        this.totalPage = 0;
        while (this.currentIndex < this.textLength) {
            String currentChar = text.substring(this.currentIndex, this.currentIndex + 1);
            if (!currentChar.equals(" ") && !currentChar.equals("/")) {
                this.wordNumber = 1;
                while (this.currentIndex + this.wordNumber < this.textLength && !text.substring(this.currentIndex + this.wordNumber, this.currentIndex + this.wordNumber + 1).equals(" ") && !text.substring(this.currentIndex + this.wordNumber, this.currentIndex + this.wordNumber + 1).equals("/")) {
                    ++this.wordNumber;
                }
                this.letterLength = this.imgWordW * this.wordNumber;
                if (this.letterLength > this.lineSize) {
                    for (int i = 0; i < this.wordNumber; ++i) {
                        currentChar = text.substring(this.currentIndex, this.currentIndex + 1);
                        this.letterLength = this.imgWordW;
                        if (this.currentLen + this.letterLength > this.lineSize) {
                            this.newLine(0);
                        } else {
                            this.currentLen += this.letterLength;
                        }
                        ++this.currentIndex;
                    }
                    continue;
                }
                if (this.currentLen + this.letterLength > this.lineSize) {
                    --this.currentIndex;
                    this.newLine(0);
                    this.currentIndex += this.wordNumber;
                    this.currentLen = this.letterLength;
                    continue;
                }
                this.currentIndex += this.wordNumber;
                this.currentLen += this.letterLength;
                continue;
            }
            if (currentChar.equals("/")) {
                ++this.currentIndex;
                if (this.currentIndex >= this.textLength) continue;
                currentChar = text.substring(this.currentIndex, this.currentIndex + 1);
                if (currentChar.equals("n") || currentChar.equals("N")) {
                    if (this.currentIndex == this.textLength - 1) {
                        --this.currentIndex;
                        break;
                    }
                    this.newLine(1);
                } else if (currentChar.equals("p") || currentChar.equals("P")) {
                    if (this.currentIndex == this.textLength - 1) {
                        --this.currentIndex;
                        break;
                    }
                    ++this.currentLine;
                    this.currentLen = 0;
                    this.linePos[++this.lineIndex] = this.currentIndex - 2;
                    this.linePos[++this.lineIndex] = this.currentIndex + 1;
                    ++this.totalPage;
                    this.totalLine += this.currentLine;
                    this.lineNum[++this.pageIndex] = this.totalLine;
                    this.currentLine = 0;
                } else {
                    --this.currentIndex;
                    this.currentLen += this.imgWordW;
                    if (this.currentLen >= this.lineSize) {
                        if (this.currentLen > this.lineSize) {
                            --this.currentIndex;
                        }
                        this.newLine(0);
                    }
                }
                ++this.currentIndex;
                continue;
            }
            this.currentLen += this.imgWordW;
            if (this.currentLen >= this.lineSize) {
                if (this.currentLen > this.lineSize) {
                    --this.currentIndex;
                }
                this.newLine(0);
            }
            ++this.currentIndex;
        }
        if (this.currentLine != 0 || this.currentLen != 0) {
            ++this.totalPage;
            this.totalLine += this.currentLine + 1;
            this.linePos[++this.lineIndex] = this.currentIndex - 1;
            this.lineNum[++this.pageIndex] = this.totalLine;
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.resetBox();
    }

    public void setBoxSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.resetBox();
    }

    public int page() {
        return Math.max(1, this.totalPage);
    }

    public void paintText(Graphics g, int x, int y, int col, int currentPage) {
        g.setColor(col);
        g.setFont(this.font);
        for (int i = 0; i < this.lineNum[currentPage + 1] - this.lineNum[currentPage]; ++i) {
            g.drawString(this.text.substring(this.linePos[i + this.lineNum[currentPage] << 1], this.linePos[(i + this.lineNum[currentPage] << 1) + 1] + 1), x + (this.width >> 1), y + (this.height - (this.lineNum[currentPage + 1] - this.lineNum[currentPage]) * (this.font.getHeight() + 2) >> 1) + i * (this.font.getHeight() + 2), 17);
        }
    }

    public void paintText(Graphics g, int x, int y, int col, int currentPage, Image word) {
        g.setColor(col);
        g.setFont(this.font);
        for (int i = 0; i < this.lineNum[currentPage + 1] - this.lineNum[currentPage]; ++i) {
            FrameWork.imgStr.paint(g, this.text.substring(this.linePos[i + this.lineNum[currentPage] << 1], this.linePos[(i + this.lineNum[currentPage] << 1) + 1] + 1), x + (this.width >> 1), y + (this.height - (this.lineNum[currentPage + 1] - this.lineNum[currentPage]) * (this.imgWordH + 2) >> 1) + i * (this.imgWordH + 2), 17, word, 7, 11);
        }
    }

    public void paintText(Graphics g, int x, int y, Image word, int top, int bottom) {
        for (int i = 0; i < this.totalLine; ++i) {
            if (y + i * (this.imgWordH + 2) <= top || y + i * (this.imgWordH + 2) >= bottom) continue;
            FrameWork.imgStr.paint(g, this.text.substring(this.linePos[i << 1], this.linePos[(i << 1) + 1] + 1), x + (this.width >> 1), y + i * (this.imgWordH + 2), 17, word, 7, 11);
        }
    }

    public void paintText1(Graphics g, int x, int y, int col, int top, int bottom) {
        g.setColor(col);
        g.setFont(this.font);
        for (int i = 0; i < this.totalLine; ++i) {
            if (y + i * (this.imgWordH + 10) <= top || y + i * (this.imgWordH + 10) >= bottom) continue;
            g.drawString(this.text.substring(this.linePos[i << 1], this.linePos[(i << 1) + 1] + 1), x + (this.width >> 1), y + i * (this.imgWordH + 10), 17);
        }
    }

    public int getWordLength() {
        return this.totalLine * (this.imgWordH + 2);
    }
}

