/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class Sound {
    private InputStream sound;
    public int currentSound = -1;
    private String soundType;
    private String soundRes;
    private Player player;
    private VolumeControl synth;

    public boolean soundOpen(int i) {
        if (i == this.currentSound) {
            return false;
        }
        try {
            if (this.player != null && this.player.getState() == 400) {
                this.player.stop();
                this.player.deallocate();
                this.player.close();
                this.player = null;
            }
            this.setType(Constant.soundType[i]);
            this.sound = this.getClass().getResourceAsStream("/sound/" + i + "." + this.soundType);
            this.player = Manager.createPlayer((InputStream)this.sound, (String)("audio/" + this.soundRes));
            if (this.player.getState() == 100) {
                this.player.realize();
            }
            if (this.player.getState() == 200) {
                this.player.prefetch();
            }
            this.synth = (VolumeControl)this.player.getControl("VolumeControl");
            this.currentSound = i;
            this.sound = null;
            System.gc();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void soundPlay(int loop) {
        if (this.player == null || this.player.getState() == 400) {
            return;
        }
        try {
            if (this.player.getState() == 100) {
                this.player.realize();
            }
            if (this.player.getState() == 200) {
                this.player.prefetch();
            }
            if (loop != 0) {
                this.player.setLoopCount(loop);
            }
            this.player.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void soundPause() {
        try {
            if (this.player == null) {
                return;
            }
            if (this.player.getState() == 400) {
                this.player.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void soundStop() {
        try {
            if (this.player == null) {
                return;
            }
            if (this.player.getState() == 400) {
                this.player.stop();
                this.player.setMediaTime(0L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void soundlevel(int level) {
        try {
            if (this.synth != null) {
                this.synth.setLevel(level * 20);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.player.getState() == 300) {
            this.player.deallocate();
        }
        if (this.player.getState() == 100) {
            this.player.deallocate();
        }
        this.player.close();
        this.player = null;
        this.sound = null;
        System.gc();
    }

    public void soundReset(long mediaTime) {
        try {
            this.player.setMediaTime(mediaTime);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public int soundState() {
        if (this.player == null) {
            return -1;
        }
        return this.player.getState();
    }

    private void setType(int t) {
        if (t == 0) {
            this.soundType = "amr";
            this.soundRes = "amr";
        } else if (t == 1) {
            this.soundType = "mid";
            this.soundRes = "midi";
        } else if (t == 2) {
            this.soundType = "wav";
            this.soundRes = "x-wav";
        }
    }
}

