/*
 * Decompiled with CFR 0.152.
 */
package JAMine.solver;

import JAMine.JAgamecanvas;
import java.util.Vector;

public final class MineAI {
    private int rows;
    private int cols;
    private byte level;
    private static final int ADJ_MINES = 15;
    private static final int FLAGP1 = 32;
    private static final int FLAGP2 = 64;
    private static final int UNCOVERED = 128;
    byte[][] mineField;
    private static final int NOFLAG = 15;
    private static final int FLAG1C = 1;
    private static final int FLAG1U = 2;
    private static final int FLAG2C = 4;
    private static final int FLAG2U = 8;
    private static final int SAFE = 32;
    byte[][] status;
    short[][] riskProbs;
    public int x;
    public int y;
    Vector moves;

    public MineAI(byte[][] byArray, int n, int n2, byte by) {
        this.rows = n;
        this.cols = n2;
        this.level = by;
        this.mineField = byArray;
        this.status = new byte[this.rows][this.cols];
        this.riskProbs = new short[this.rows][this.cols];
        JAgamecanvas.rand.setSeed(System.currentTimeMillis());
        this.moves = new Vector(8, 1);
    }

    public boolean play(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.x = -1;
        this.y = -1;
        boolean bl = false;
        for (n7 = 0; n7 < this.rows; ++n7) {
            n6 = 0;
            while (n6 < this.cols) {
                byte[] byArray = this.status[n7];
                int n8 = n6++;
                byArray[n8] = (byte)(byArray[n8] & 0xFFFFFFDF);
            }
        }
        for (n7 = 0; n7 < this.rows; ++n7) {
            for (n6 = 0; n6 < this.cols; ++n6) {
                if (JAgamecanvas.testFlag(this.mineField[n7][n6], 32) && this.noFlag(this.status[n7][n6])) {
                    byte[] byArray = this.status[n7];
                    int n9 = n6;
                    byArray[n9] = (byte)(byArray[n9] | 2);
                }
                if (JAgamecanvas.testFlag(this.mineField[n7][n6], 32) || JAgamecanvas.testFlag(this.mineField[n7][n6], 64)) continue;
                byte[] byArray = this.status[n7];
                int n10 = n6;
                byArray[n10] = (byte)(byArray[n10] & 0xFFFFFFF0);
            }
        }
        n7 = 0;
        n6 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        byte by = 0;
        byte by2 = 0;
        int n14 = 0;
        this.moves.removeAllElements();
        for (n5 = 0; n5 < this.rows; ++n5) {
            for (n4 = 0; n4 < this.cols; ++n4) {
                by = this.mineField[n5][n4];
                if (!JAgamecanvas.testFlag(by, 128)) {
                    if (!this.noFlag(this.status[n5][n4])) continue;
                    ++n14;
                    continue;
                }
                n7 = JAgamecanvas.getAdjMines(by);
                if (n7 == 0) continue;
                n12 = 0;
                n6 = 0;
                n11 = 0;
                this.x = -1;
                this.y = -1;
                for (n3 = n5 - 1; n3 <= n5 + 1; ++n3) {
                    for (n2 = n4 - 1; n2 <= n4 + 1; ++n2) {
                        if (n3 < 0 || n2 < 0 || n3 >= this.rows || n2 >= this.cols || JAgamecanvas.testFlag(by2 = this.mineField[n3][n2], 128)) continue;
                        if (!JAgamecanvas.testFlag(by2, 32) && !JAgamecanvas.testFlag(by2, 64)) {
                            ++n12;
                            this.moves.addElement(new int[]{n3, n2});
                            continue;
                        }
                        if (JAgamecanvas.testFlag(this.status[n3][n2], 2) || JAgamecanvas.testFlag(this.status[n3][n2], 8)) {
                            ++n11;
                            this.moves.addElement(new int[]{n3, n2});
                            continue;
                        }
                        if (!JAgamecanvas.testFlag(this.status[n3][n2], 4) && !JAgamecanvas.testFlag(this.status[n3][n2], 1)) continue;
                        ++n6;
                    }
                }
                if (!this.checkMoves(n5, n4, this.moves, n7, n, n12, n6, n11)) continue;
                return true;
            }
        }
        if (this.level > 0) {
            this.moves.removeAllElements();
            for (n5 = 0; n5 < this.rows; ++n5) {
                for (n4 = 0; n4 < this.cols; ++n4) {
                    by = this.mineField[n5][n4];
                    if (!JAgamecanvas.testFlag(by, 128) || (n7 = JAgamecanvas.getAdjMines(by)) == 0) continue;
                    n12 = 0;
                    n6 = 0;
                    n11 = 0;
                    this.x = -1;
                    this.y = -1;
                    for (n3 = n5 - 1; n3 <= n5 + 1; ++n3) {
                        for (n2 = n4 - 1; n2 <= n4 + 1; ++n2) {
                            if (n3 < 0 || n2 < 0 || n3 >= this.rows || n2 >= this.cols) continue;
                            by2 = this.mineField[n3][n2];
                            if (!JAgamecanvas.testFlag(by2, 32) && !JAgamecanvas.testFlag(by2, 64)) {
                                if (!JAgamecanvas.testFlag(by2, 128) && !JAgamecanvas.testFlag(this.status[n3][n2], 32)) {
                                    ++n12;
                                    this.moves.addElement(new int[]{n3, n2});
                                    continue;
                                }
                                if (JAgamecanvas.testFlag(by2, 128) || !JAgamecanvas.testFlag(this.status[n3][n2], 32)) continue;
                                ++n13;
                                continue;
                            }
                            if (JAgamecanvas.testFlag(this.status[n3][n2], 2) || JAgamecanvas.testFlag(this.status[n3][n2], 8)) {
                                ++n11;
                                this.moves.addElement(new int[]{n3, n2});
                                continue;
                            }
                            if (!JAgamecanvas.testFlag(this.status[n3][n2], 1) && !JAgamecanvas.testFlag(this.status[n3][n2], 4)) continue;
                            ++n6;
                        }
                    }
                    if (n12 == 0 || !this.checkMoves(n5, n4, this.moves, n7, n, n12, n6, n11)) continue;
                    return true;
                }
            }
        }
        for (n5 = 0; n5 < this.rows; ++n5) {
            for (n4 = 0; n4 < this.cols; ++n4) {
                by = this.mineField[n5][n4];
                if (!JAgamecanvas.testFlag(this.status[n5][n4], 32) || JAgamecanvas.testFlag(by, 128) || !this.noFlag(this.status[n5][n4])) continue;
                this.x = n5;
                this.y = n4;
                return false;
            }
        }
        for (n5 = 0; n5 < this.rows; ++n5) {
            for (n4 = 0; n4 < this.cols; ++n4) {
                this.riskProbs[n5][n4] = -256;
            }
        }
        for (n5 = 0; n5 < this.rows; ++n5) {
            for (n4 = 0; n4 < this.cols; ++n4) {
                n13 = 0;
                n12 = 0;
                n6 = 0;
                n11 = 0;
                by = this.mineField[n5][n4];
                if (!JAgamecanvas.testFlag(by, 128)) {
                    block18: for (n3 = n5 - 1; n3 <= n5 + 1; ++n3) {
                        for (n2 = n4 - 1; n2 <= n4 + 1; ++n2) {
                            if (n3 < 0 || n2 < 0 || n3 >= this.rows || n2 >= this.cols) continue;
                            by2 = this.mineField[n3][n2];
                            if (!JAgamecanvas.testFlag(by2, 128)) break block18;
                            ++n13;
                            break block18;
                        }
                    }
                    if (n13 == 0) continue;
                    this.riskProbs[n5][n4] = 2560;
                    continue;
                }
                n7 = JAgamecanvas.getAdjMines(by);
                for (n3 = n5 - 1; n3 <= n5 + 1; ++n3) {
                    for (n2 = n4 - 1; n2 <= n4 + 1; ++n2) {
                        if (n3 < 0 || n2 < 0 || n3 >= this.rows || n2 >= this.cols || JAgamecanvas.testFlag(by2 = this.mineField[n3][n2], 128) || !this.noFlag(this.status[n3][n2]) && JAgamecanvas.testFlag(this.status[n3][n2], 1) && JAgamecanvas.testFlag(this.status[n3][n2], 4)) continue;
                        ++n12;
                    }
                }
                if (n12 == 0) continue;
                short[] sArray = this.riskProbs[n5];
                int n15 = n4;
                sArray[n15] = (short)(sArray[n15] + (short)((n7 << 16) / n12 * 256 / 65535));
            }
        }
        n5 = 0x640000;
        for (n4 = 0; n4 < this.rows; ++n4) {
            for (n3 = 0; n3 < this.cols; ++n3) {
                if (JAgamecanvas.testFlag(this.mineField[n4][n3], 128) || !this.noFlag(this.status[n4][n3]) || (n2 = (this.riskProbs[n4][n3] << 16) / 256 / 65535) == -1 || n2 >= n5) continue;
                n5 = n2;
                this.x = n4;
                this.y = n3;
            }
        }
        if (this.x != -1 && this.y != -1) {
            return false;
        }
        if (this.x == -1 && n14 != 0) {
            n4 = Math.abs(JAgamecanvas.rand.nextInt() % n14);
            for (n3 = 0; n3 < this.rows; ++n3) {
                for (n2 = 0; n2 < this.cols && n4 >= 0; ++n2) {
                    by = this.mineField[n3][n2];
                    if (JAgamecanvas.testFlag(by, 128) || !this.noFlag(this.status[n3][n2]) || --n4 > 0) continue;
                    this.x = n3;
                    this.y = n2;
                    return false;
                }
            }
        }
        this.x = 0;
        this.y = 0;
        return false;
    }

    private boolean noFlag(byte by) {
        return (by & 1) == 0 && (by & 2) == 0 && (by & 4) == 0 && (by & 8) == 0;
    }

    private boolean checkMoves(int n, int n2, Vector vector, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray;
        int n8;
        if (n4 > 0 && n5 > 0 && n5 <= n3 - (n6 + n7)) {
            for (n8 = 0; n8 < vector.size(); ++n8) {
                nArray = (int[])vector.elementAt(n8);
                if (this.noFlag(this.status[nArray[0]][nArray[1]])) {
                    this.x = nArray[0];
                    this.y = nArray[1];
                    continue;
                }
                if (JAgamecanvas.testFlag(this.status[nArray[0]][nArray[1]], 2) && this.verifyFlag(nArray[0], nArray[1])) {
                    byte[] byArray = this.status[nArray[0]];
                    int n9 = nArray[1];
                    byArray[n9] = (byte)(byArray[n9] & 0xFFFFFFF0);
                    byte[] byArray2 = this.status[nArray[0]];
                    int n10 = nArray[1];
                    byArray2[n10] = (byte)(byArray2[n10] | 1);
                    ++n6;
                    continue;
                }
                if (!JAgamecanvas.testFlag(this.status[nArray[0]][nArray[1]], 8) || !this.verifyFlag(nArray[0], nArray[1])) continue;
                byte[] byArray = this.status[nArray[0]];
                int n11 = nArray[1];
                byArray[n11] = (byte)(byArray[n11] & 0xFFFFFFF0);
                byte[] byArray3 = this.status[nArray[0]];
                int n12 = nArray[1];
                byArray3[n12] = (byte)(byArray3[n12] | 4);
                ++n6;
            }
            if (this.x != -1 && this.y != -1) {
                byte[] byArray = this.status[this.x];
                int n13 = this.y;
                byArray[n13] = (byte)(byArray[n13] & 0xFFFFFFF0);
                byte[] byArray4 = this.status[this.x];
                int n14 = this.y;
                byArray4[n14] = (byte)(byArray4[n14] | 4);
                return true;
            }
        }
        if (n5 == 0 && vector.size() != 0) {
            for (n8 = 0; n8 < vector.size(); ++n8) {
                nArray = (int[])vector.elementAt(n8);
                if (JAgamecanvas.testFlag(this.status[nArray[0]][nArray[1]], 2) && this.verifyFlag(nArray[0], nArray[1])) {
                    byte[] byArray = this.status[nArray[0]];
                    int n15 = nArray[1];
                    byArray[n15] = (byte)(byArray[n15] & 0xFFFFFFF0);
                    byte[] byArray5 = this.status[nArray[0]];
                    int n16 = nArray[1];
                    byArray5[n16] = (byte)(byArray5[n16] | 1);
                    ++n6;
                    continue;
                }
                if (!JAgamecanvas.testFlag(this.status[nArray[0]][nArray[1]], 8) || !this.verifyFlag(nArray[0], nArray[1])) continue;
                byte[] byArray = this.status[nArray[0]];
                int n17 = nArray[1];
                byArray[n17] = (byte)(byArray[n17] & 0xFFFFFFF0);
                byte[] byArray6 = this.status[nArray[0]];
                int n18 = nArray[1];
                byArray6[n18] = (byte)(byArray6[n18] | 4);
                ++n6;
            }
        }
        if (n6 == n3) {
            for (int i = n - 1; i <= n + 1; ++i) {
                for (int j = n2 - 1; j <= n2 + 1; ++j) {
                    if (i < 0 || j < 0 || i >= this.rows || j >= this.cols || JAgamecanvas.testFlag((byte)(n8 = this.mineField[i][j]), 128) || !this.noFlag(this.status[i][j]) && !JAgamecanvas.testFlag(this.status[i][j], 2) && !JAgamecanvas.testFlag(this.status[i][j], 8)) continue;
                    byte[] byArray = this.status[i];
                    int n19 = j;
                    byArray[n19] = (byte)(byArray[n19] | 0x20);
                }
            }
        }
        return false;
    }

    private boolean verifyFlag(int n, int n2) {
        int n3 = 0;
        for (int i = n - 1; i <= n + 1; ++i) {
            for (int j = n2 - 1; j <= n2 + 1; ++j) {
                byte by;
                if (i < 0 || j < 0 || i >= this.rows || j >= this.cols || !JAgamecanvas.testFlag(by = this.mineField[i][j], 128)) continue;
                n3 = JAgamecanvas.getAdjMines(by);
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                for (int k = i - 1; k <= i + 1; ++k) {
                    for (int i2 = j - 1; i2 <= j + 1; ++i2) {
                        if (k < 0 || i2 < 0 || k >= this.rows || i2 >= this.cols) continue;
                        byte by2 = this.mineField[k][i2];
                        if (JAgamecanvas.testFlag(this.status[k][i2], 2) || JAgamecanvas.testFlag(this.status[k][i2], 8)) {
                            ++n5;
                            continue;
                        }
                        if (JAgamecanvas.testFlag(this.status[k][i2], 1) || JAgamecanvas.testFlag(this.status[k][i2], 4)) {
                            ++n4;
                            continue;
                        }
                        if (JAgamecanvas.testFlag(by2, 128) || !this.noFlag(this.status[k][i2])) continue;
                        ++n6;
                    }
                }
                if (n4 == n3) {
                    return false;
                }
                if (n4 + n5 + n6 != n3) continue;
                return true;
            }
        }
        return false;
    }

    public byte[] getStatus() {
        byte[] byArray = new byte[this.rows * this.cols];
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (this.noFlag(this.status[i][j])) {
                    byArray[n++] = 0;
                    continue;
                }
                if (JAgamecanvas.testFlag(this.status[i][j], 2)) {
                    byArray[n++] = 1;
                    continue;
                }
                if (JAgamecanvas.testFlag(this.status[i][j], 1)) {
                    byArray[n++] = 2;
                    continue;
                }
                if (JAgamecanvas.testFlag(this.status[i][j], 8)) {
                    byArray[n++] = 3;
                    continue;
                }
                if (!JAgamecanvas.testFlag(this.status[i][j], 4)) continue;
                byArray[n++] = 4;
            }
        }
        return byArray;
    }

    public void setStatus(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (byArray[n] == 1) {
                    byte[] byArray2 = this.status[i];
                    int n2 = j;
                    byArray2[n2] = (byte)(byArray2[n2] | 2);
                } else if (byArray[n] == 2) {
                    byte[] byArray3 = this.status[i];
                    int n3 = j;
                    byArray3[n3] = (byte)(byArray3[n3] | 1);
                } else if (byArray[n] == 3) {
                    byte[] byArray4 = this.status[i];
                    int n4 = j;
                    byArray4[n4] = (byte)(byArray4[n4] | 8);
                } else if (byArray[n] == 4) {
                    byte[] byArray5 = this.status[i];
                    int n5 = j;
                    byArray5[n5] = (byte)(byArray5[n5] | 4);
                }
                ++n;
            }
        }
    }

    public void clean() {
        this.status = null;
        this.riskProbs = null;
        this.moves.removeAllElements();
        this.moves.trimToSize();
        this.moves = null;
    }
}

