/*
 * Decompiled with CFR 0.152.
 */
package com.JavArt.game;

import com.JavArt.game.Layer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR = 2;
    public int refX;
    public int refY;
    public int frames;
    public int[] rawFrameSequence;
    public int[] customFrameSequence;
    public int currentFrameIndex;
    public int transform = 0;
    public int rawHeight;
    public int rawWidth;
    public int collisionX;
    public int collisionY;
    public int collisionWidth;
    public int collisionHeight;
    private Image sprite;

    public Sprite(Sprite sprite) {
    }

    public Sprite(Image image) {
        this(image, image.getWidth(), image.getHeight());
    }

    public Sprite(Image image, int n, int n2) {
        this.setImage(image, n, n2);
    }

    public Sprite getSprite() {
        return this;
    }

    public final void paint(Graphics graphics) {
        int n = this.getFrameSequence()[this.currentFrameIndex];
        int n2 = -this.rawWidth * n;
        int n3 = 0;
        if (this.transform == 2) {
            graphics.drawRegion(this.sprite, this.rawWidth * n, n3, this.rawWidth, this.rawHeight, 2, this.getX() + this.refX + this.refX - this.rawWidth, this.getY(), 0);
        } else {
            graphics.drawRegion(this.sprite, this.rawWidth * n, n3, this.rawWidth, this.rawHeight, 0, this.getX(), this.getY(), 0);
        }
    }

    public final boolean collidesWith(Sprite sprite, boolean bl) {
        return false;
    }

    public void defineCollisionRectangle(int n, int n2, int n3, int n4) {
        this.collisionX = n;
        this.collisionY = n2;
        this.collisionWidth = n3;
        this.collisionHeight = n4;
    }

    public int getRefPixelX() {
        return this.getX() + this.refX;
    }

    public int getRefPixelY() {
        return this.getY() + this.refY;
    }

    public void defineReferencePixel(int n, int n2) {
        this.refX = n;
        this.refY = n2;
    }

    public void setRefPixelPosition(int n, int n2) {
        this.setPosition(n - this.refX, n2 - this.refY);
    }

    public void setTransform(int n) {
        this.transform = n;
    }

    public void setImage(Image image, int n, int n2) {
        this.rawWidth = n;
        this.rawHeight = n2;
        this.setWidth(n);
        this.setHeight(n2);
        this.defineCollisionRectangle(0, 0, n, n2);
        if (image != null) {
            this.frames = image.getWidth() / this.rawWidth * (image.getHeight() / this.rawHeight);
        }
        this.sprite = image;
    }

    private int[] getFrameSequence() {
        if (this.customFrameSequence != null) {
            return this.customFrameSequence;
        }
        return this.rawFrameSequence;
    }

    public int getFrameSequenceLength() {
        return this.getFrameSequence().length;
    }

    public final int getFrame() {
        return this.currentFrameIndex;
    }

    public void nextFrame() {
        ++this.currentFrameIndex;
        this.currentFrameIndex %= this.getFrameSequenceLength();
    }

    public void prevFrame() {
        this.currentFrameIndex = --this.currentFrameIndex;
        if (this.currentFrameIndex < 0) {
            this.currentFrameIndex = this.getFrameSequenceLength() - 1;
        }
    }

    public void setFrame(int n) {
        this.currentFrameIndex = n;
    }

    public void setFrameSequence(int[] nArray) {
        this.currentFrameIndex = 0;
        this.customFrameSequence = new int[nArray.length];
        System.arraycopy(nArray, 0, this.customFrameSequence, 0, nArray.length);
    }
}

