/*
 * Decompiled with CFR 0.152.
 */
package com.JavArt.custom.media.MMAPI;

import JAMine.JAgamecanvas;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class gamesounds
implements Runnable,
PlayerListener {
    Thread thethread;
    boolean noThread = true;
    long mediaPosition = -1L;
    JAgamecanvas canvas = null;
    private static boolean themeStarted = false;
    public static boolean playingTheme = false;
    public static boolean musicstate = false;
    public static boolean soundstate = false;
    public static boolean midsupport = false;
    public static boolean amrsupport = false;
    public static boolean mmfsupport = false;
    public static boolean wavsupport = false;
    private static Player currentPlayer = null;
    private static String soundPath;
    private static final String SOUNDPAK = "SND.PAK";
    private static int themeIndex;
    private static final String[] Themes;
    private static final String[] FXfile;
    private static Vector FXbuff;
    String FXType = "amr";
    String FXMime = "amr";
    boolean started = false;
    boolean forcedestroy = false;
    int newTune = -1;

    public gamesounds(String string, JAgamecanvas jAgamecanvas) {
        this.canvas = jAgamecanvas;
        soundPath = string;
        soundstate = true;
        musicstate = true;
        String[] stringArray = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("mid") != -1) {
                midsupport = true;
            }
            if (stringArray[i].compareTo("audio/amr") == 0) {
                amrsupport = true;
            }
            if (stringArray[i].compareTo("audio/mmf") == 0) {
                mmfsupport = true;
            }
            if (stringArray[i].indexOf("wav") == -1) continue;
            wavsupport = true;
        }
        if (!amrsupport) {
            if (wavsupport) {
                this.FXType = "wav";
                this.FXMime = "x-wav";
            } else if (mmfsupport) {
                this.FXType = "mmf";
                this.FXMime = "mmf";
            }
        }
        playingTheme = false;
        themeStarted = false;
        if (!(amrsupport || wavsupport || mmfsupport)) {
            soundstate = false;
        }
        if (!midsupport) {
            musicstate = false;
        }
        if (this.thethread == null && !this.noThread) {
            this.thethread = new Thread(this);
            this.thethread.start();
        }
    }

    public void playSoundFX(int n) {
        if (!soundstate) {
            return;
        }
        this.newTune = n;
        themeIndex = -1;
        playingTheme = false;
        if (this.noThread) {
            this.stopCurrentSoundFX();
            this.createPlayer(0, this.newTune, this.FXType, this.FXMime);
            try {
                currentPlayer.start();
            }
            catch (Throwable throwable) {
                this.stopCurrentSoundFX();
            }
        } else {
            this.started = true;
        }
    }

    public void stopCurrentSoundFX() {
        if (currentPlayer != null) {
            try {
                currentPlayer.removePlayerListener((PlayerListener)this);
                currentPlayer.stop();
                currentPlayer.deallocate();
                currentPlayer.close();
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentPlayer = null;
        }
    }

    public void pushMediaTime() {
        if (playingTheme && musicstate && currentPlayer != null) {
            this.mediaPosition = currentPlayer.getMediaTime();
            this.destroyTheme();
        }
    }

    public void popMediaTime() {
        try {
            if (this.mediaPosition != -1L && musicstate) {
                this.playTheme();
                currentPlayer.setMediaTime(this.mediaPosition);
                Thread.sleep(250L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mediaPosition = -1L;
    }

    public void playTheme(int n) {
        if (!musicstate) {
            return;
        }
        this.newTune = -1;
        themeIndex = n + FXfile.length;
        playingTheme = true;
        themeStarted = false;
        if (this.noThread) {
            this.playTheme();
        }
    }

    public void playTheme() {
        this.stopCurrentSoundFX();
        this.createPlayer(0, themeIndex, "mid", "midi");
        try {
            if (themeIndex >= FXfile.length) {
                currentPlayer.addPlayerListener((PlayerListener)this);
            }
            VolumeControl volumeControl = (VolumeControl)currentPlayer.getControl("javax.microedition.media.control.VolumeControl");
            volumeControl.setLevel(60);
            currentPlayer.start();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroyTheme() {
        playingTheme = false;
        themeStarted = true;
        if (this.noThread) {
            this.stopCurrentSoundFX();
        }
    }

    public boolean getThemeState() {
        return musicstate;
    }

    public boolean getSoundState() {
        return soundstate;
    }

    public static void setSoundState(boolean bl) {
    }

    public void bgm(int n) {
        this.playTheme(n);
    }

    public static void managesounds(boolean bl, boolean bl2) {
        musicstate = bl;
        soundstate = bl2;
    }

    public boolean createPlayer(int n, int n2, String string, String string2) {
        InputStream inputStream = null;
        if (n2 >= 0 && FXbuff.size() > 0 && FXbuff.elementAt(n2) != null) {
            inputStream = new ByteArrayInputStream((byte[])FXbuff.elementAt(n2));
        }
        if (inputStream == null) {
            inputStream = n2 < FXfile.length ? this.getClass().getResourceAsStream(soundPath + FXfile[n2] + "." + string) : this.getClass().getResourceAsStream(soundPath + Themes[n2 - FXfile.length]);
        }
        try {
            currentPlayer = Manager.createPlayer(inputStream, (String)("audio/" + string2));
            currentPlayer.setLoopCount(1);
        }
        catch (Exception exception) {
            this.stopCurrentSoundFX();
            return false;
        }
        try {
            currentPlayer.realize();
        }
        catch (Exception exception) {
            this.stopCurrentSoundFX();
            return false;
        }
        return true;
    }

    public void run() {
        int n = 50;
        while (true) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l = System.currentTimeMillis();
            if (playingTheme) {
                if (!themeStarted) {
                    this.playTheme();
                    themeStarted = true;
                }
            } else if (themeStarted) {
                this.stopCurrentSoundFX();
                themeStarted = false;
            }
            if (this.started && this.newTune != -1) {
                this.started = false;
                this.stopCurrentSoundFX();
                this.createPlayer(0, this.newTune, this.FXType, this.FXMime);
                try {
                    currentPlayer.start();
                }
                catch (Exception exception) {
                    this.stopCurrentSoundFX();
                }
            }
            long l2 = System.currentTimeMillis() - l;
            if (System.currentTimeMillis() - l >= (long)n) continue;
            try {
                Thread.sleep((long)n - l2);
            }
            catch (Exception exception) {
            }
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (!playingTheme || themeIndex < FXfile.length) {
            return;
        }
        if (string.equals("endOfMedia") || string.equals("stopped")) {
            try {
                currentPlayer.setMediaTime(0L);
                currentPlayer.stop();
                this.playTheme();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void playEmpty() {
        try {
            currentPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/JAMine/snd/s8.mid"), (String)"audio/midi");
            currentPlayer.setLoopCount(-1);
            currentPlayer.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    static {
        themeIndex = -1;
        Themes = new String[]{"0.mid", "1.mid", "2.mid", "3.mid", "4.mid"};
        FXfile = new String[]{"nuke", "uncover", "flag", "timebonus", "freemine", "radar", "buy"};
        FXbuff = new Vector();
    }
}

