/*
 * Decompiled with CFR 0.152.
 */
package com.zenops.gts;

import com.nokia.mid.ui.DirectUtils;
import com.zenops.gts.Game;
import com.zenops.gts.Main;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public abstract class Base
extends Canvas
implements Runnable {
    private static int softKeyLeft = -6;
    private static int softKeyRight = -7;
    protected static final int TRANS_NONE = 0;
    protected static final int TRANS_MIRROR_ROT180 = 1;
    protected static final int TRANS_MIRROR = 2;
    protected static final int TRANS_ROT180 = 3;
    protected static final int TRANS_MIRROR_ROT270 = 4;
    protected static final int TRANS_ROT90 = 5;
    protected static final int TRANS_ROT270 = 6;
    protected static final int TRANS_MIRROR_ROT90 = 7;
    private static final int SOUND_PLAYED = 400;
    protected static Main main;
    protected static String msgError;
    protected static long key;
    protected static long keyEvent;
    protected static final long IKEY_0 = 65536L;
    protected static final long IKEY_1 = 131072L;
    protected static final long IKEY_2 = 262144L;
    protected static final long IKEY_3 = 524288L;
    protected static final long IKEY_4 = 0x100000L;
    protected static final long IKEY_5 = 0x200000L;
    protected static final long IKEY_6 = 0x400000L;
    protected static final long IKEY_7 = 0x800000L;
    protected static final long IKEY_8 = 0x1000000L;
    protected static final long IKEY_9 = 0x2000000L;
    protected static final long IKEY_POUND = 8L;
    protected static final long IKEY_STAR = 1024L;
    protected static final long IKEY_SEL = 256L;
    protected static final long IKEY_SOFT1 = 0x20000000L;
    protected static final long IKEY_SOFT2 = 0x40000000L;
    protected static final long IKEY_SOFT = 0x60000000L;
    protected static long IKEY_UP;
    protected static long IKEY_LEFT;
    protected static long IKEY_RIGHT;
    protected static long IKEY_DOWN;
    protected static long KEY_UP;
    protected static long KEY_LEFT;
    protected static long KEY_RIGHT;
    protected static long KEY_DOWN;
    protected static final long KEY_SEL = 0x200100L;
    protected static byte phaseCurrent;
    protected static byte phaseNext;
    private static final int TIMEGAMEMAXDELTA = 100;
    private static final int TIMEMINSLEEP = 3;
    private static final int TIMEGAMEINTERVAL = 20;
    private static final int TIMEAUXILIARYINTERVAL = 300;
    private static long timeOld;
    protected static int timeDelta;
    private static boolean flagFocus;
    protected static boolean flagRedrawAll;
    protected static final byte SK_NULL = -1;
    protected static Font fontCurrent;
    protected static int fontCurrentHeight;
    protected static int fontCurrentTopPad;
    protected static int screenWidth;
    protected static int screenHeight;
    private static int xClip;
    private static int yClip;
    private static int wClip;
    private static int hClip;
    protected static final String GAMEOPTIONS_RECORD_STORE = "GameOptions";
    protected static byte[] arrayGameOptions;
    protected static final byte GAMEOPTIONS_LANG = 0;
    protected static final byte GAMEOPTIONS_SOUND = 1;
    protected static final byte GAMEOPTIONS_VIBRA = 2;
    protected static final byte GAMEOPTIONS_DISPLAY = 3;
    protected static final byte NB_GAMEOPTIONS = 4;
    protected static String[] arrayStringBaseText;
    private static final String STR_SEPARATOR = "/";
    protected static final byte DISPLAY_PORTRAIT = 0;
    protected static final byte DISPLAY_LANDSCAPE_90 = 1;
    protected static final byte DISPLAY_LANDSCAPE_270 = 2;
    protected static final byte DISPLAY_MODE_NB = 3;
    private static Image imageDoubleBuffering;
    private static Graphics graphicsDoubleBuffering;
    protected static final byte SOUNDMIDI = 0;
    protected static final byte SOUNDWAVE = 1;
    private static final String[] soundFormat;
    private static Player currentSoundPlayed;
    private static int currentSoundPlayedLoop;
    protected static Image[] imgSK;
    protected static int barProgressCurrent;
    private static Base base;
    private static int paintCount;
    private static Object syncObject;
    private static boolean auxiliaryTaskRunning;

    protected Base(Main _main) {
        System.out.println("Base ctor");
        main = _main;
        timeOld = System.currentTimeMillis();
        new Thread(this).start();
        base = this;
    }

    public void keyPressed(int _param) {
        msgError = msgError + "[" + _param + "] ";
        int keycode = _param;
        if (keycode < 0) {
            if (keycode == softKeyLeft) {
                keyEvent |= 0x20000000L;
                return;
            }
            if (keycode == softKeyRight) {
                keyEvent |= 0x40000000L;
                return;
            }
            keycode = this.getGameAction(keycode);
        }
        keyEvent |= (long)(1 << keycode);
        key |= (long)(1 << keycode);
    }

    public void keyReleased(int param) {
        int keycode = param;
        if (param < 0) {
            keycode = this.getGameAction(param);
        }
        key &= (long)(~(1 << keycode));
    }

    protected static final void sleep(int _ms) {
        try {
            Thread.sleep(_ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void baseResume() {
        key = 0L;
        keyEvent = 0L;
        flagRedrawAll = true;
        if (currentSoundPlayed != null && currentSoundPlayedLoop < 0) {
            Base.playSound(currentSoundPlayed, currentSoundPlayedLoop, false, false);
        }
    }

    protected void showNotify() {
        if (!flagFocus) {
            flagFocus = true;
            Game.resume();
        }
    }

    protected void hideNotify() {
        try {
            Base.stopSound();
            Base.stopVibra();
        }
        catch (Exception exception) {
            // empty catch block
        }
        flagFocus = false;
    }

    private static final String getNumNameSimple(int _num) {
        char[] c = new char[]{_num < 10 ? (char)(48 + _num) : (char)(65 + (_num - 10))};
        return new String(c);
    }

    private static final String getNumName(int _num) {
        int a = _num / 36;
        int b = _num % 36;
        if (a == 0) {
            return Base.getNumNameSimple(b);
        }
        int c = a / 36;
        int d = a % 36;
        if (c == 0) {
            return Base.getNumNameSimple(a).concat(Base.getNumNameSimple(b));
        }
        return Base.getNumNameSimple(c).concat(Base.getNumNameSimple(d).concat(Base.getNumNameSimple(b)));
    }

    private static String getPath(int _index_File) {
        return STR_SEPARATOR + Base.getNumName(_index_File);
    }

    private static String getPath(int _index_Dir, int _index_File) {
        return STR_SEPARATOR + Base.getNumName(_index_Dir) + STR_SEPARATOR + Base.getNumName(_index_File);
    }

    private static InputStream getInputStream(String _path_Name) {
        return Runtime.getRuntime().getClass().getResourceAsStream(_path_Name);
    }

    protected static final InputStream getInputStream(int _index_File) {
        return Base.getInputStream(Base.getPath(_index_File));
    }

    protected static final InputStream getInputStream(int _index_Dir, int _index_File) {
        return Base.getInputStream(Base.getPath(_index_Dir, _index_File));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String[] loadTxt(int _indexFile, int _indexString, int _nb) {
        FilterInputStream dis = null;
        String[] stringTab = null;
        try {
            int i;
            dis = new DataInputStream(Base.getInputStream(_indexFile));
            for (i = 0; i < _indexString; ++i) {
                ((DataInputStream)dis).readUTF();
            }
            stringTab = new String[_nb];
            for (i = 0; i < _nb; ++i) {
                StringBuffer buffer = new StringBuffer(((DataInputStream)dis).readUTF());
                for (int char_Index = 0; char_Index < buffer.length() - 1; ++char_Index) {
                    if (buffer.charAt(char_Index) != '\\' || buffer.charAt(char_Index + 1) != 'n') continue;
                    buffer.setCharAt(char_Index, '\n');
                    buffer.deleteCharAt(char_Index + 1);
                }
                stringTab[i] = buffer.toString();
            }
        }
        catch (Exception e) {
            System.out.println("ex loadTxt " + e.getMessage());
            msgError = msgError + "ex loadTxt " + e.getMessage();
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception e) {}
        }
        Base.incProgress();
        return stringTab;
    }

    protected static final String[] dispose(String[] _txt) {
        if (_txt != null) {
            for (int i = 0; i < _txt.length; ++i) {
                _txt[i] = null;
            }
        }
        return null;
    }

    protected static final String[][] dispose(String[][] _txt) {
        if (_txt != null) {
            for (int i = 0; i < _txt.length; ++i) {
                Base.dispose(_txt[i]);
            }
        }
        return null;
    }

    protected static void cutSystemString(String _s, Vector _vtxt, int _w) {
        int startIndex = 0;
        int currentIndex = 0;
        int nextCut = -1;
        int nextTry = -1;
        _vtxt.removeAllElements();
        while (startIndex < _s.length()) {
            boolean cut = false;
            int nextBlank = _s.indexOf(32, currentIndex);
            int nextReturn = _s.indexOf(10, currentIndex);
            nextTry = nextBlank == -1 || nextReturn == -1 ? Math.max(nextBlank, nextReturn) : Math.min(nextBlank, nextReturn);
            if (nextTry == -1) {
                if (fontCurrent.stringWidth(_s.substring(startIndex, _s.length())) <= _w || nextCut == -1) {
                    nextCut = _s.length();
                }
                cut = true;
            } else if (nextTry == nextBlank) {
                if (fontCurrent.stringWidth(_s.substring(startIndex, nextTry)) > _w && nextCut != -1) {
                    cut = true;
                } else {
                    nextCut = nextTry;
                }
            } else if (nextTry == nextReturn) {
                if (fontCurrent.stringWidth(_s.substring(startIndex, nextTry)) <= _w || nextCut == -1) {
                    nextCut = nextTry;
                }
                cut = true;
            }
            if (cut) {
                _vtxt.addElement(_s.substring(startIndex, nextCut));
                currentIndex = startIndex = nextCut + 1;
                nextCut = -1;
                continue;
            }
            currentIndex = Math.max(currentIndex, nextTry) + 1;
        }
    }

    protected static final Image loadImg(String _pathName) {
        Image img = null;
        try {
            img = Image.createImage((String)_pathName);
        }
        catch (Exception e) {
            System.out.println("ex loadImg " + e.getMessage());
            e.printStackTrace();
            msgError = msgError + "ex loadImg " + _pathName;
        }
        Base.incProgress();
        return img;
    }

    protected static final Image loadImg(int _indexFile) {
        return Base.loadImg(Base.getPath(_indexFile));
    }

    protected static final Image loadImg(int _indexDir, int _index) {
        return Base.loadImg(Base.getPath(_indexDir, _index));
    }

    protected static final Image[] loadDirImg(int _indexDir, int _index, int _nb) {
        Image[] imgTab = new Image[_nb];
        for (int i = 0; i < _nb; ++i) {
            imgTab[i] = Base.loadImg(_indexDir, i + _index);
        }
        return imgTab;
    }

    protected static final Image dispose(Image _img) {
        return null;
    }

    protected static final Image[] dispose(Image[] _imgTab) {
        if (_imgTab != null) {
            for (int i = _imgTab.length - 1; i >= 0; --i) {
                _imgTab[i] = Base.dispose(_imgTab[i]);
            }
        }
        return null;
    }

    protected static void playVibra(int _duration) {
        if (arrayGameOptions[2] != 0) {
            Display.getDisplay((MIDlet)main).vibrate(_duration);
        }
    }

    protected static void stopVibra() {
        Display.getDisplay((MIDlet)main).vibrate(0);
    }

    protected static void setVibraVolume(int _volume) {
        if (_volume == 0) {
            Base.stopVibra();
        }
        Base.arrayGameOptions[2] = (byte)_volume;
        Base.saveRecord(GAMEOPTIONS_RECORD_STORE, arrayGameOptions);
    }

    protected static int getVibraVolume() {
        return arrayGameOptions[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Player loadSound(int _type, String _pathName) {
        InputStream is = null;
        Player ply = null;
        try {
            is = Base.getInputStream(_pathName);
            ply = Manager.createPlayer((InputStream)is, (String)soundFormat[_type]);
            ply.realize();
            ply.prefetch();
        }
        catch (Exception e) {
            System.out.println("ex loadSnd " + _type + " " + e.getMessage());
            msgError = msgError + "ex loadSnd " + _type + " " + e.getMessage();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        Base.incProgress();
        return ply;
    }

    protected static final Player loadSound(int _type, int _indexFile) {
        return Base.loadSound(_type, Base.getPath(_indexFile));
    }

    protected static final Player loadSound(int _type, int _indexDir, int _indexFile) {
        return Base.loadSound(_type, Base.getPath(_indexDir, _indexFile));
    }

    protected static final Player[] loadDirSound(int _type, int _indexDir, int _index, int _nb) {
        Player[] plyTab = new Player[_nb];
        for (int i = 0; i < _nb; ++i) {
            plyTab[i] = Base.loadSound(_type, _indexDir, _index + i);
        }
        return plyTab;
    }

    protected static final Player dispose(Player _snd) {
        try {
            if (_snd != null) {
                _snd.stop();
                _snd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static final Player[] dispose(Player[] _sndTab) {
        if (_sndTab != null) {
            for (int i = _sndTab.length - 1; i >= 0; --i) {
                _sndTab[i] = Base.dispose(_sndTab[i]);
            }
        }
        return null;
    }

    protected static void setSoundVolume(int _volume) {
        Base.arrayGameOptions[1] = (byte)_volume;
        Base.saveRecord(GAMEOPTIONS_RECORD_STORE, arrayGameOptions);
        if (_volume == 0) {
            try {
                currentSoundPlayed.stop();
                currentSoundPlayed.deallocate();
            }
            catch (Exception exception) {}
        } else if (currentSoundPlayedLoop < 0) {
            Base.playSound(currentSoundPlayed, currentSoundPlayedLoop, false, false);
        }
    }

    protected static int getSoundVolume() {
        if (arrayGameOptions == null) {
            return 0;
        }
        return arrayGameOptions[1];
    }

    protected static void playSound(Player _snd, int _loop, boolean _override, boolean _isWav) {
        if (_snd == null) {
            return;
        }
        try {
            if (currentSoundPlayed != null && currentSoundPlayed.getState() == 400) {
                if (!_override || currentSoundPlayed == _snd) {
                    return;
                }
                if (arrayGameOptions[1] != 0) {
                    currentSoundPlayed.stop();
                }
            }
            currentSoundPlayed = _snd;
            currentSoundPlayedLoop = _loop;
            if (arrayGameOptions[1] != 0) {
                _snd.setLoopCount(_loop);
                _snd.start();
            }
        }
        catch (Exception e) {
            System.out.println("ex playSound " + e.getMessage());
            msgError = msgError + "ex playSound " + e.getMessage();
        }
    }

    protected static void stopSound() {
        try {
            if (currentSoundPlayed != null) {
                currentSoundPlayed.stop();
            }
        }
        catch (Exception e) {
            System.out.println("ex Stopsound() " + e.getMessage());
            msgError = msgError + "ex stopSound " + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] loadBin(String _pathName) {
        FilterInputStream dis = null;
        byte[] byteTab = null;
        try {
            dis = new DataInputStream(Base.getInputStream(_pathName));
            byteTab = new byte[dis.available()];
            ((DataInputStream)dis).readFully(byteTab, 0, byteTab.length);
        }
        catch (Exception e) {
            System.out.println("ex loadBin " + e + " << " + _pathName);
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception exception) {}
        }
        Base.incProgress();
        return byteTab;
    }

    protected static final byte[] loadBin(int _indexFile) {
        return Base.loadBin(Base.getPath(_indexFile));
    }

    protected static final byte[] loadBin(int _indexDir, int _indexFile) {
        return Base.loadBin(Base.getPath(_indexDir, _indexFile));
    }

    protected static final byte[][] loadDirBin(int _indexDir, int _indexFile, int _nb) {
        byte[][] byteTab = new byte[_nb][];
        for (int i = 0; i < _nb; ++i) {
            byteTab[i] = Base.loadBin(_indexDir, _indexFile + i);
        }
        return byteTab;
    }

    protected static void incProgress() {
        ++barProgressCurrent;
        if (!auxiliaryTaskRunning) {
            return;
        }
        base.callBackAuxRun(phaseCurrent);
        if (System.currentTimeMillis() - timeOld > 300L) {
            timeOld = System.currentTimeMillis();
            Base.paint();
        }
    }

    protected static void startAuxiliaryTask() {
        auxiliaryTaskRunning = true;
    }

    protected static void stopAuxiliaryTask() {
        auxiliaryTaskRunning = false;
    }

    protected static boolean isAtFirstPass() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.setFullScreenMode(true);
        Base.sleep(500);
        this.callBackInstallGame();
        while (true) {
            try {
                while (true) {
                    if (phaseCurrent != phaseNext) {
                        System.out.println("change phase " + phaseCurrent + "->" + phaseNext);
                        this.callBackClose(phaseCurrent, phaseNext);
                        System.gc();
                        this.callBackInit(phaseCurrent, phaseNext);
                        flagRedrawAll = true;
                        phaseCurrent = phaseNext;
                    }
                    this.callBackRun(phaseCurrent);
                    Base.paint();
                    timeDelta = (int)(System.currentTimeMillis() - timeOld);
                    timeOld = System.currentTimeMillis();
                    while (true) {
                        Base.sleep(Math.max(20 - timeDelta, 3));
                        Object object = syncObject;
                        synchronized (object) {
                            if (paintCount <= 0) {
                                paintCount = 0;
                                break;
                            }
                        }
                    }
                    timeDelta = Math.min(timeDelta, 100);
                }
            }
            catch (Exception e) {
                System.out.println("Exception occurs during RUN, phase = " + phaseCurrent);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected static void baseExit() {
        Base.stopSound();
        Base.stopVibra();
        main.exit();
    }

    protected static void setLocalPaint(int _xClip, int _yClip, int _wClip, int _hClip) {
        xClip = _xClip;
        yClip = _yClip;
        wClip = _wClip;
        hClip = _hClip;
    }

    protected static void setDisplayMode(byte _mode) {
        _mode = 0;
        screenWidth = base.getWidth();
        screenHeight = base.getHeight();
        imageDoubleBuffering = null;
        graphicsDoubleBuffering = null;
        IKEY_UP = 2L;
        IKEY_LEFT = 4L;
        IKEY_RIGHT = 32L;
        IKEY_DOWN = 64L;
        KEY_UP = IKEY_UP | 0x40000L;
        KEY_LEFT = IKEY_LEFT | 0x100000L;
        KEY_RIGHT = IKEY_RIGHT | 0x400000L;
        KEY_DOWN = IKEY_DOWN | 0x1000000L;
        Base.setLocalPaint(0, 0, screenWidth, screenHeight);
        Base.arrayGameOptions[3] = _mode;
        Base.saveRecord(GAMEOPTIONS_RECORD_STORE, arrayGameOptions);
    }

    protected static void switchDisplayMode() {
        Base.setDisplayMode((byte)((arrayGameOptions[3] + 1) % 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void paint() {
        Object object = syncObject;
        synchronized (object) {
            if (++paintCount > 1) {
                --paintCount;
                return;
            }
        }
        base.repaint(xClip, yClip, wClip, hClip);
        base.serviceRepaints();
        flagRedrawAll = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics _g) {
        this.paintPhase(_g, phaseCurrent);
        Object object = syncObject;
        synchronized (object) {
            --paintCount;
        }
    }

    private void paintPhase(Graphics _g, byte _phase) {
        try {
            if (_phase < 0) {
                return;
            }
            _g.setFont(fontCurrent);
            _g.setClip(xClip, yClip, wClip, hClip);
            this.callBackPaint(_g, _phase);
            if (flagRedrawAll) {
                byte[] tabSK = this.getSKIndex(_phase);
                for (int k = 0; k < 3; ++k) {
                    try {
                        byte sk = tabSK[k];
                        if (sk == -1) continue;
                        _g.drawImage(imgSK[sk], k * (screenWidth >> 1), screenHeight, 0x20 | (k == 0 ? 4 : (k == 1 ? 1 : 8)));
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Exception occurs in painting SK, phase = " + _phase);
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable e) {
            System.out.println("Exception occurs in paintPhase, phase = " + _phase + " " + e.toString());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final byte[] loadRecord(String name) {
        RecordStore record = null;
        byte[] buffer = null;
        try {
            record = RecordStore.openRecordStore((String)name, (boolean)false);
            buffer = record.getRecord(1);
        }
        catch (Exception ex) {
        }
        finally {
            try {
                record.closeRecordStore();
            }
            catch (Exception e) {}
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void saveRecord(String name, byte[] _rec) {
        RecordStore record = null;
        try {
            record = RecordStore.openRecordStore((String)name, (boolean)true);
            if (record != null) {
                if (record.getNumRecords() == 0) {
                    record.addRecord(_rec, 0, _rec.length);
                } else {
                    record.setRecord(1, _rec, 0, _rec.length);
                }
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                record.closeRecordStore();
            }
            catch (Exception e) {}
        }
    }

    protected static Image createAlphaImage(Image img, int alpha) {
        int[] rgb = new int[img.getWidth() * img.getHeight()];
        img.getRGB(rgb, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
        for (int i = 0; i < rgb.length; ++i) {
            int col = rgb[i];
            rgb[i] = col & 0xFFFFFF | alpha * (col >> 24 & 0xFF) >> 8 << 24;
        }
        Base.incProgress();
        return Image.createRGBImage((int[])rgb, (int)img.getWidth(), (int)img.getHeight(), (boolean)true);
    }

    static void zenDrawImageNokia(Graphics g, Image img, int transform, int x, int y, int anchor) {
        switch (transform) {
            case 0: {
                transform = 0;
                break;
            }
            case 1: {
                transform = 16384;
                break;
            }
            case 2: {
                transform = 8192;
                break;
            }
            case 3: {
                transform = 180;
                break;
            }
            case 4: {
                transform = 16474;
                break;
            }
            case 5: {
                transform = 90;
                break;
            }
            case 6: {
                transform = 270;
                break;
            }
            case 7: {
                transform = 16654;
            }
        }
        DirectUtils.getDirectGraphics((Graphics)g).drawImage(img, x, y, anchor, transform);
    }

    static void zenDrawRGBNokia(Graphics g, int[] rgb, int offset, int scanlength, int x, int y, int w, int h, boolean alpha) {
        DirectUtils.getDirectGraphics((Graphics)g).drawPixels(rgb, alpha, offset, scanlength, x, y, w, h, 0, 8888);
    }

    protected void drawString(Graphics _g, Font _font, String _str, int _x, int _y, int _anchor) {
        Font old_Font = _g.getFont();
        _g.setFont(_font);
        _g.drawString(_str, _x, _y, _anchor);
        _g.setFont(old_Font);
    }

    protected abstract byte[] getSKIndex(int var1);

    protected abstract void callBackAuxRun(byte var1);

    protected abstract void callBackInstallGame();

    protected abstract void callBackRun(byte var1);

    protected abstract void callBackInit(byte var1, byte var2);

    protected abstract void callBackClose(byte var1, byte var2);

    protected abstract void callBackPaint(Graphics var1, byte var2);

    static {
        msgError = "";
        phaseCurrent = (byte)-1;
        phaseNext = (byte)-1;
        flagRedrawAll = true;
        fontCurrent = null;
        soundFormat = new String[]{"audio/midi", "audio/x-wav"};
        currentSoundPlayed = null;
        syncObject = new Object();
        auxiliaryTaskRunning = false;
    }
}

