/*
 * Decompiled with CFR 0.152.
 */
package com.zenops.gts;

import com.zenops.gts.Character;
import com.zenops.gts.Game;
import com.zenops.gts.Placeable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

class Floor {
    private static final int[][] BG_OFFSET_Y = new int[][]{{48, 48}, {24, 24}, {48, 48}, {24, 48}};
    static int TILE_SIZE = 24;
    private static final int[] CHARACTER_OFFSET_Y = new int[]{22, 16, 16};
    private static final int CAMERA_HEAD_OFFSET_X = 0;
    private static final int CAMERA_HEAD_OFFSET_Y = -13;
    private static final int CAMERA_ZONE_OFFSET_X = 12;
    private static final int CAMERA_ZONE_OFFSET_Y = 0;
    private static final int[][] BG_INFO = new int[][]{{TILE_SIZE << 1, 0}, {TILE_SIZE * 3, 0xFFFFFF}, {TILE_SIZE, 8772}, {TILE_SIZE << 1, 0}};
    static final byte PHYSICS_NONE = 0;
    static final byte PHYSICS_WALL = 1;
    static final byte PHYSICS_LIFT = 2;
    static final byte PHYSICS_DOOR = 3;
    static final byte PHYSICS_BREAKABLE = 4;
    static final byte PHYSICS_DISPLAY = 5;
    static final byte PHYSICS_TAKEABLE = 6;
    static final byte PHYSICS_END = 7;
    static final byte PHYSICS_SCRIPT = 8;
    static final byte PHYSICS_CRACKED_WALL = 9;
    static final byte PHYSICS_INSULT = 10;
    static final boolean[] IS_OBSTACLE = new boolean[]{false, false, true, true, false, false, true, true, true, false, false, false, false, false, false, false, false, false, true, true, false, false};
    static byte SECOND_ACTION_PLANE = (byte)4;
    static byte FIRST_ACTION_PLANE = (byte)5;
    static int NB_PLANES = 7;
    static short referenceFloorLevel;
    short level;
    int posX;
    int posY;
    short length;
    byte[] defaultSequences = new byte[NB_PLANES];
    byte[][] tileSequences = null;
    byte[][] tileMap;
    byte[][] tilePhysics;
    static int nbTileX;
    static int nbTileY;
    static int zoneX;
    static int zoneY;
    static int zoneWidth;
    static int zoneHeight;
    static int startTileY;
    static int endTileY;
    static int startOffsetY;
    Vector respawnBuffer = new Vector();
    Vector objectList = new Vector();
    short[] triggers;
    boolean[] activeTriggers;
    Placeable[][] cameraLinks;
    boolean[] cameraLinksDrawn;
    boolean wasVisited;

    Floor(int x, int y, int length) {
        this.posX = x * TILE_SIZE << 10;
        this.posY = y * TILE_SIZE * NB_PLANES << 8;
        this.length = (short)length;
    }

    Floor(int x, int y, int length, byte FGBGFlag) {
        this.posX = x * TILE_SIZE << 10;
        this.posY = y * TILE_SIZE * NB_PLANES << 8;
        this.length = (short)length;
    }

    void prepare() {
        int i;
        this.tileMap = new byte[NB_PLANES][this.length];
        System.out.println("COMPUTE TILE MAP...");
        for (int i2 = 0; i2 < NB_PLANES; ++i2) {
            int j;
            if (this.defaultSequences[i2] != -1) {
                for (j = 0; j < this.length / Game.envSequences[this.defaultSequences[i2]].length + 1; ++j) {
                    System.arraycopy(Game.envSequences[this.defaultSequences[i2]], 0, this.tileMap[i2], j * Game.envSequences[this.defaultSequences[i2]].length, Math.min(Game.envSequences[this.defaultSequences[i2]].length, this.length - j * Game.envSequences[this.defaultSequences[i2]].length));
                }
                continue;
            }
            for (j = 0; j < this.length; ++j) {
                this.tileMap[i2][j] = -1;
            }
        }
        for (i = 0; i < this.tileSequences.length; ++i) {
            byte type = this.tileSequences[i][0];
            byte plane = this.tileSequences[i][1];
            for (int j = 2; j < this.tileSequences[i].length; ++j) {
                this.tileMap[plane][Game.getUnsignedValue((byte)this.tileSequences[i][j])] = type;
            }
        }
        System.out.println("COPY RESPAWN BUFFER...");
        for (i = 0; i < this.respawnBuffer.size(); ++i) {
            Character tmp = new Character((Character)Game.get(this.respawnBuffer, i));
            System.out.println("ADD RESPAWNABLE " + tmp);
            this.objectList.addElement(tmp);
        }
        this.tilePhysics = new byte[2][this.length];
        System.out.println("ADD TRIGGERS...");
        if (this.triggers != null) {
            for (int i3 = 0; i3 < this.triggers.length; ++i3) {
                if (!this.activeTriggers[i3]) continue;
                int tile = this.triggers[i3] >> 8 & 0xFF;
                byte script = (byte)(this.triggers[i3] & 0xFF);
                System.out.println(tile);
                if (script != -1) {
                    byte by = (byte)(0x80 | script & 0xF);
                    this.tilePhysics[1][tile] = by;
                    this.tilePhysics[0][tile] = by;
                } else {
                    this.tilePhysics[1][tile] = 112;
                    this.tilePhysics[0][tile] = 112;
                }
                System.out.println("ADD TRIGGER " + script + " AT " + tile);
            }
        }
        System.out.println("UPDATE PHYSICS...");
        for (i = 0; i < this.objectList.size(); ++i) {
            Game.get(this.objectList, i).updatePhysics();
        }
        System.out.println("ADD GRAPHIC OBJECTS (PER OBJ)...");
        block12: for (int i4 = this.objectList.size() - 1; i4 >= 0; --i4) {
            Placeable obj = Game.get(this.objectList, i4);
            switch (obj.category << 8 | obj.type) {
                case 4: 
                case 5: {
                    this.objectList.addElement(new Placeable(0, 9, this, obj.tile + 1, obj.plane));
                    continue block12;
                }
                case 0: 
                case 1: {
                    if (Game.environment == 4) continue block12;
                    this.objectList.addElement(new Placeable(0, 10, this, obj.tile - 1, obj.plane - 1));
                }
            }
        }
        Game.sortBuffer(this.objectList, false);
        this.wasVisited = true;
    }

    void release() {
        block7: for (int i = 0; i < this.objectList.size(); ++i) {
            Placeable obj = Game.get(this.objectList, i);
            switch (obj.category) {
                case 0: {
                    switch (obj.type) {
                        case 9: 
                        case 10: {
                            Game.removeElement(this.objectList, obj);
                            --i;
                        }
                    }
                    continue block7;
                }
                case 5: {
                    if ((obj.value & 0x40000000) != 0) {
                        System.out.println("REMOVE RESPAWNABLE : " + obj);
                        Game.removeElement(this.objectList, obj);
                        --i;
                        continue block7;
                    }
                    if (((Character)obj).health <= 0) {
                        System.out.println("REMOVE DEAD : " + obj);
                        Game.removeElement(this.objectList, obj);
                        --i;
                        continue block7;
                    }
                    if (((Character)obj).getAIStep() == 0 || ((Character)obj).getAIStep() == 1) continue block7;
                    ((Character)obj).goBackToWayPoint();
                    ((Character)obj).setAnim((byte)0, true, true);
                }
            }
        }
        this.tileMap = null;
        this.tilePhysics = null;
    }

    static void initZoneDimension(int x, int y, int width, int height) {
        zoneX = x;
        zoneY = y;
        zoneWidth = width;
        zoneHeight = height;
        nbTileX = zoneWidth / TILE_SIZE + 2;
        Floor.initYPos(Game.phaseCurrent == 7);
    }

    static void initYPos(boolean full) {
        if (full) {
            nbTileY = NB_PLANES;
            startTileY = 0;
            endTileY = NB_PLANES;
        } else {
            nbTileY = Math.min(NB_PLANES, zoneHeight / TILE_SIZE + 1);
            if (nbTileY > 5) {
                if ((nbTileY & 1) != (NB_PLANES & 1)) {
                    ++nbTileY;
                }
                startTileY = Math.max(0, NB_PLANES - nbTileY >> 1);
            } else {
                startTileY = Math.max(0, FIRST_ACTION_PLANE + 1 - nbTileY);
            }
            endTileY = Math.min(NB_PLANES, startTileY + nbTileY);
        }
        startOffsetY = nbTileY * TILE_SIZE - zoneHeight >> (nbTileY > 5 ? 1 : 0);
        if ((FIRST_ACTION_PLANE - startTileY + 1) * TILE_SIZE - startOffsetY > zoneHeight) {
            startOffsetY = (FIRST_ACTION_PLANE + 1) * TILE_SIZE - zoneHeight;
        }
    }

    int getFloorLevel() {
        return -(this.posY >> 8) / (TILE_SIZE * NB_PLANES);
    }

    static int getScreenX(int camX, int posX) {
        return zoneX + posX - camX;
    }

    static int getScreenY(int camY, int posY) {
        return -startTileY * TILE_SIZE + zoneY - startOffsetY + posY - camY;
    }

    static int getTileScreenY(int camY, int plane) {
        return (plane - startTileY) * TILE_SIZE + zoneY - startOffsetY - camY;
    }

    static int getCharacterPosY(int plane) {
        return plane * TILE_SIZE + CHARACTER_OFFSET_Y[plane - (SECOND_ACTION_PLANE - 1)];
    }

    int getTileX(int x) {
        return Math.max(0, Math.min(this.length - 1, x / TILE_SIZE));
    }

    int getTileY(int y) {
        return Math.max(0, Math.min(NB_PLANES - 1, y / TILE_SIZE));
    }

    int getTileXMin(int x) {
        return this.getTileX(x - TILE_SIZE);
    }

    int getTileXMax(int x) {
        return this.getTileX(x + Game.screenWidth + TILE_SIZE);
    }

    static int getXPosInTile(int tile, int x) {
        return x - tile * TILE_SIZE;
    }

    static int getYPosInTile(int plane, int y) {
        return y - plane * TILE_SIZE;
    }

    void initCameraLinksDrawing() {
        if (this.cameraLinksDrawn == null) {
            return;
        }
        for (int i = 0; i < this.cameraLinksDrawn.length; ++i) {
            this.cameraLinksDrawn[i] = false;
        }
    }

    void drawCameraLink(Graphics g, int x, int y, Placeable obj, int categoryAndType) {
        int index;
        switch (categoryAndType) {
            case 11: {
                index = 0;
                break;
            }
            case 1024: 
            case 1025: 
            case 1026: {
                index = 1;
                break;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < this.cameraLinks.length; ++i) {
            if (obj != this.cameraLinks[i][index]) continue;
            if (this.cameraLinksDrawn[i]) {
                return;
            }
            Placeable obj2 = this.cameraLinks[i][1 - index];
            g.setColor(0xFF0000);
            if (index == 0) {
                g.drawLine(Floor.getScreenX(x, obj.posX >> 8) + 0, Floor.getScreenY(y, obj.posY >> 8) + -13, Floor.getScreenX(x, obj2.posX >> 8) + 12, Floor.getScreenY(y, obj2.posY >> 8) + 0);
                g.drawLine(Floor.getScreenX(x, obj.posX >> 8) + 0, Floor.getScreenY(y, obj.posY >> 8) + -13, Floor.getScreenX(x, obj2.posX >> 8) - 12, Floor.getScreenY(y, obj2.posY >> 8) + 0);
            } else {
                g.drawLine(Floor.getScreenX(x, obj2.posX >> 8) + 0, Floor.getScreenY(y, obj2.posY >> 8) + -13, Floor.getScreenX(x, obj.posX >> 8) + 12, Floor.getScreenY(y, obj.posY >> 8) + 0);
                g.drawLine(Floor.getScreenX(x, obj2.posX >> 8) + 0, Floor.getScreenY(y, obj2.posY >> 8) + -13, Floor.getScreenX(x, obj.posX >> 8) - 12, Floor.getScreenY(y, obj.posY >> 8) + 0);
            }
            this.cameraLinksDrawn[i] = true;
        }
    }

    void drawTiles(Graphics g, int x, int y) {
        int startX = x / TILE_SIZE;
        int endX = startX + nbTileX;
        int offsetX = x % TILE_SIZE;
        g.setColor(0);
        for (int i = startX; i < endX; ++i) {
            for (int j = startTileY; j < endTileY; ++j) {
                if (i < 0 || i >= this.length) {
                    g.fillRect((i - startX) * TILE_SIZE + zoneX - offsetX, Floor.getTileScreenY(y, j), TILE_SIZE, TILE_SIZE);
                    continue;
                }
                if (this.tileMap[j][i] == -1) continue;
                g.drawImage(Game.imgTile[this.tileMap[j][i]], (i - startX) * TILE_SIZE + zoneX - offsetX, Floor.getTileScreenY(y, j), 20);
            }
        }
    }

    void setPhysics(int tile, int plane, int physics) {
        if (plane < 0 || plane >= NB_PLANES || tile < 0 || tile >= this.length) {
            return;
        }
        byte[] byArray = this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)];
        int n = tile;
        byArray[n] = (byte)(byArray[n] & 0xF);
        byte[] byArray2 = this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)];
        int n2 = tile;
        byArray2[n2] = (byte)(byArray2[n2] | physics << 4);
    }

    int getPhysics(int tile, int plane) {
        if (Character.processPhysics) {
            return this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)][tile] >> 4 & 0xF;
        }
        if ((this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)][tile] >> 4 & 0xF) == 6) {
            return 6;
        }
        return 0;
    }

    boolean checkObstacle(int tile, int plane, boolean inTheAir) {
        return IS_OBSTACLE[((this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)][tile] >> 4 & 0xF) << 1) + (inTheAir ? 1 : 0)];
    }

    boolean checkPassThrough(int tile, int plane, boolean inTheAir) {
        if (!this.checkObstacle(tile, plane, inTheAir) || !Character.processCollisions) {
            return true;
        }
        return !((this.getCorner(tile, plane, 0) || this.getCorner(tile, plane, 1)) & (this.getCorner(tile, plane, 2) || this.getCorner(tile, plane, 3)));
    }

    void setCorner(int tile, int plane, int corner, boolean blocked) {
        if (plane < 0 || plane >= NB_PLANES || tile < 0 || tile >= this.length) {
            return;
        }
        this.setPhysics(tile, plane, this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)][tile] >> 4);
        if (blocked) {
            byte[] byArray = this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)];
            int n = tile;
            byArray[n] = (byte)(byArray[n] | 1 << corner);
        } else {
            byte[] byArray = this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)];
            int n = tile;
            byArray[n] = (byte)(byArray[n] & ~(1 << corner));
        }
    }

    private boolean getCorner(int tile, int plane, int corner) {
        if (!this.checkObstacle(tile, plane, false)) {
            return false;
        }
        return (this.tilePhysics[plane - SECOND_ACTION_PLANE][tile] >> corner & 1) != 0;
    }

    private int checkSingleObstacle(int tile, int plane, int dir, boolean in) {
        if (dir > 0) {
            if (!this.checkObstacle(tile, plane, false)) {
                return tile;
            }
            if (!(!in || this.getCorner(tile, plane, 2) && this.getCorner(tile, plane, 3))) {
                return tile;
            }
            if (!in && this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 1)) {
                return -1;
            }
            if (this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 3) && tile < this.length - 1) {
                return tile + 1;
            }
            if (this.getCorner(tile, plane, 1) && this.getCorner(tile, plane, 2) && tile > 0) {
                return tile - 1;
            }
            if (in && this.getCorner(tile, plane, 2) && this.getCorner(tile, plane, 3)) {
                return -1;
            }
            return tile;
        }
        if (!this.checkObstacle(tile, plane, false)) {
            return tile;
        }
        if (!(!in || this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 1))) {
            return tile;
        }
        if (!in && this.getCorner(tile, plane, 2) && this.getCorner(tile, plane, 3)) {
            return -1;
        }
        if (this.getCorner(tile, plane, 1) && this.getCorner(tile, plane, 2) && tile < this.length - 1) {
            return tile + 1;
        }
        if (this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 3) && tile > 0) {
            return tile - 1;
        }
        if (in && this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 1)) {
            return -1;
        }
        return tile;
    }

    boolean checkChangingPlanePath(int tile, int dir) {
        if (!Character.processCollisions) {
            return true;
        }
        int plane = Math.max(0, -Game.sign(dir, true)) + SECOND_ACTION_PLANE;
        int nextTile = this.checkSingleObstacle(tile, plane, dir, true);
        if (nextTile != -1) {
            nextTile = this.checkSingleObstacle(nextTile, plane + dir, dir, false);
        }
        return nextTile != -1;
    }

    int getSlideDir(int tile, int plane, int dirY, int x) {
        if (dirY >= 0) {
            if (this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 1)) {
                return Game.sign(1 - Floor.getXPosInTile(tile, x) / (TILE_SIZE >> 1) << 1, true);
            }
            if (this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 3)) {
                return -1;
            }
            if (this.getCorner(tile, plane, 1) && this.getCorner(tile, plane, 2)) {
                return 1;
            }
            return Game.sign(1 - Floor.getXPosInTile(tile, x) / (TILE_SIZE >> 1) << 1, true);
        }
        if (this.getCorner(tile, plane, 2) && this.getCorner(tile, plane, 3)) {
            return Game.sign(1 - Floor.getXPosInTile(tile, x) / (TILE_SIZE >> 1) << 1, true);
        }
        if (this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 3)) {
            return 1;
        }
        if (this.getCorner(tile, plane, 1) && this.getCorner(tile, plane, 2)) {
            return -1;
        }
        return Game.sign(1 - Floor.getXPosInTile(tile, x) / (TILE_SIZE >> 1) << 1, true);
    }

    int getTilePosMaxX(int tile, int plane, int dir, int x, int y, Character charac, boolean stayOut) {
        if (dir >= 0) {
            int max = this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 2) ? 0 : (this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 3) ? Floor.getYPosInTile(plane, y) : (this.getCorner(tile, plane, 1) && this.getCorner(tile, plane, 2) ? TILE_SIZE - Floor.getYPosInTile(plane, y) : TILE_SIZE));
            if (Floor.getXPosInTile(tile, x) < max - (stayOut ? 1 : 0)) {
                return Floor.getXPosInTile(tile, x);
            }
            if (charac != null && this.checkObstacle(tile, plane, false)) {
                charac.againstObstacle = (byte)(this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)][tile] >> 4 & 0xF);
            }
            return max - (stayOut ? 1 : 0);
        }
        int max = this.getCorner(tile, plane, 1) && this.getCorner(tile, plane, 3) ? TILE_SIZE : (this.getCorner(tile, plane, 1) && this.getCorner(tile, plane, 2) ? TILE_SIZE - Floor.getYPosInTile(plane, y) : (this.getCorner(tile, plane, 0) && this.getCorner(tile, plane, 3) ? Floor.getYPosInTile(plane, y) : 0));
        if (Floor.getXPosInTile(tile, x) > max + (stayOut ? 1 : 0)) {
            return Floor.getXPosInTile(tile, x);
        }
        if (charac != null && this.checkObstacle(tile, plane, false)) {
            charac.againstObstacle = (byte)(this.tilePhysics[Math.max(0, plane - SECOND_ACTION_PLANE)][tile] >> 4 & 0xF);
        }
        return max + (stayOut ? 1 : 0);
    }
}

