/*
 * Decompiled with CFR 0.152.
 */
package com.zenops.gts;

import com.zenops.gts.Base;
import javax.microedition.lcdui.Image;

public abstract class ZenImgDecoder {
    private static final long PNG_SIGNATURE = -8552249625308161526L;
    private static final int PNG_IHDR_CODE = 1229472850;
    private static final int PNG_PLTE_CODE = 1347179589;
    private static final int PNG_tRNS_CODE = 1951551059;
    private static final int PNG_IDAT_CODE = 1229209940;
    private static final int PNG_IEND_CODE = 1229278788;
    private static final int PNG_SIGNATURE_LENGTH = 8;
    private static final int PNG_IHDR_LENGTH = 13;
    private static final int PNG_CHUNK_DEFINITION_LENGTH = 12;
    private static final int ZPAL_TYPE_NO_TRANSPARENCY = 0;
    private static final int ZPAL_TYPE_COLOR_KEY = 1;
    private static final int ZPAL_TYPE_ALPHA_TABLE = 2;
    private static final int ZPAL_TYPE_INDEX = 2;
    private static final int ZIMG_BIT_DEPTH_INDEX = 3;
    private static final int ZIMG_NB_IMAGES_INDEX = 4;
    private static long[] CRCTable = null;

    public static Image[] decodeZIMG(byte[] zpal, byte[] zimg) {
        System.out.println("Creating generic chunks");
        byte[] ihdr = ZenImgDecoder.createHeaderChunk(zimg[3]);
        byte[] plte = ZenImgDecoder.createPaletteChunk(zpal);
        byte[] trns = ZenImgDecoder.createTransparencyChunk(zpal);
        byte[] iend = ZenImgDecoder.createEndChunk();
        int nbImages = ZenImgDecoder.readShort(zimg, 4);
        Image[] img = new Image[nbImages];
        System.out.println("Number of images : " + nbImages);
        int offset = 6;
        for (int i = 0; i < nbImages; ++i) {
            System.out.println("Processing image " + i);
            byte[] idat = ZenImgDecoder.createDataChunk(zimg, offset, ihdr);
            byte[] buffer = ZenImgDecoder.createPNGBuffer(ihdr, plte, trns, idat, iend);
            img[i] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
            offset = ZenImgDecoder.goToNextImage(zimg, offset);
            Base.incProgress();
        }
        return img;
    }

    public static void releaseRessource() {
        CRCTable = null;
    }

    private static byte[] createPNGBuffer(byte[] ihdr, byte[] plte, byte[] trns, byte[] idat, byte[] iend) {
        byte[] png = new byte[8 + ihdr.length + plte.length + trns.length + idat.length + iend.length];
        int offset = 0;
        offset = ZenImgDecoder.writeLong(png, offset, -8552249625308161526L);
        System.arraycopy(ihdr, 0, png, offset, ihdr.length);
        System.arraycopy(plte, 0, png, offset += ihdr.length, plte.length);
        System.arraycopy(trns, 0, png, offset += plte.length, trns.length);
        System.arraycopy(idat, 0, png, offset += trns.length, idat.length);
        System.arraycopy(iend, 0, png, offset += idat.length, iend.length);
        offset += iend.length;
        return png;
    }

    private static byte[] createHeaderChunk(int bitDepth) {
        System.out.print("Creating IHDR chunk... ");
        byte[] ihdr = new byte[25];
        int offset = 0;
        offset = ZenImgDecoder.writeInt(ihdr, offset, 13);
        offset = ZenImgDecoder.writeInt(ihdr, offset, 1229472850);
        offset = ZenImgDecoder.writeLong(ihdr, offset, 0L);
        offset = ZenImgDecoder.writeByte(ihdr, offset, (byte)bitDepth);
        offset = ZenImgDecoder.writeByte(ihdr, offset, (byte)3);
        offset = ZenImgDecoder.writeByte(ihdr, offset, (byte)0);
        offset = ZenImgDecoder.writeByte(ihdr, offset, (byte)0);
        offset = ZenImgDecoder.writeByte(ihdr, offset, (byte)0);
        offset = ZenImgDecoder.writeInt(ihdr, offset, 0);
        System.out.println("DONE");
        return ihdr;
    }

    private static byte[] createPaletteChunk(byte[] zpal) {
        System.out.print("Creating PLTE chunk... ");
        byte paletteType = zpal[2];
        int dataSize = 0;
        switch (paletteType) {
            case 0: {
                dataSize = zpal.length - 3;
                break;
            }
            case 1: {
                dataSize = zpal.length - 4;
                break;
            }
            case 2: {
                dataSize = zpal.length - 3 - (zpal.length >> 1);
            }
        }
        byte[] plte = new byte[dataSize + 12];
        int offset = 0;
        offset = ZenImgDecoder.writeInt(plte, offset, dataSize);
        offset = ZenImgDecoder.writeInt(plte, offset, 1347179589);
        switch (paletteType) {
            case 0: {
                System.arraycopy(zpal, 3, plte, offset, dataSize);
                offset += dataSize;
                break;
            }
            case 1: {
                System.arraycopy(zpal, 4, plte, offset, dataSize);
                offset += dataSize;
                break;
            }
            case 2: {
                int currentColorIndex = 0;
                for (int i = 0; i < dataSize / 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        offset = ZenImgDecoder.writeByte(plte, offset, zpal[3 + (currentColorIndex << 1) + j]);
                    }
                    ++currentColorIndex;
                }
                break;
            }
        }
        offset = ZenImgDecoder.writeInt(plte, offset, ZenImgDecoder.computeCRC(plte, 4, dataSize + 4));
        System.out.println("DONE");
        return plte;
    }

    private static byte[] createTransparencyChunk(byte[] zpal) {
        System.out.print("Creating tRNS chunk... ");
        byte paletteType = zpal[2];
        byte[] trns = null;
        if (paletteType != 0) {
            int dataSize = 0;
            switch (paletteType) {
                case 1: {
                    dataSize = (zpal.length - 4) / 3;
                    break;
                }
                case 2: {
                    dataSize = zpal.length - 3 >> 2;
                }
            }
            trns = new byte[dataSize + 12];
            int offset = 0;
            offset = ZenImgDecoder.writeInt(trns, offset, dataSize);
            offset = ZenImgDecoder.writeInt(trns, offset, 1951551059);
            switch (paletteType) {
                case 1: {
                    int transparentColor = zpal[3] & 0xFF;
                    for (int i = 0; i < dataSize; ++i) {
                        offset = ZenImgDecoder.writeByte(trns, offset, (byte)-1);
                    }
                    ZenImgDecoder.writeByte(trns, 8 + transparentColor, (byte)0);
                    break;
                }
                case 2: {
                    for (int i = 0; i < dataSize; ++i) {
                        offset = ZenImgDecoder.writeByte(trns, offset, zpal[6 + (i << 2)]);
                    }
                    break;
                }
            }
            offset = ZenImgDecoder.writeInt(trns, offset, ZenImgDecoder.computeCRC(trns, 4, dataSize + 4));
        } else {
            trns = new byte[]{};
        }
        System.out.println("DONE");
        return trns;
    }

    private static byte[] createDataChunk(byte[] zimg, int offsetIn, byte[] ihdr) {
        System.out.print("Creating IDAT chunk... ");
        short width = ZenImgDecoder.readShort(zimg, offsetIn);
        short height = ZenImgDecoder.readShort(zimg, offsetIn + 2);
        int dataSize = ZenImgDecoder.readInt(zimg, offsetIn + 4);
        ZenImgDecoder.writeInt(ihdr, 8, width);
        ZenImgDecoder.writeInt(ihdr, 12, height);
        ZenImgDecoder.writeInt(ihdr, 21, ZenImgDecoder.computeCRC(ihdr, 4, 17));
        byte[] idat = new byte[dataSize + 12];
        int offsetOut = 0;
        offsetOut = ZenImgDecoder.writeInt(idat, offsetOut, dataSize);
        offsetOut = ZenImgDecoder.writeInt(idat, offsetOut, 1229209940);
        System.arraycopy(zimg, offsetIn + 8, idat, offsetOut, dataSize);
        offsetOut += dataSize;
        offsetOut = ZenImgDecoder.writeInt(idat, offsetOut, ZenImgDecoder.computeCRC(idat, 4, dataSize + 4));
        System.out.println("DONE");
        return idat;
    }

    private static byte[] createEndChunk() {
        System.out.print("Creating IEND chunk... ");
        byte[] iend = new byte[12];
        int offset = 0;
        offset = ZenImgDecoder.writeInt(iend, offset, 0);
        offset = ZenImgDecoder.writeInt(iend, offset, 1229278788);
        offset = ZenImgDecoder.writeInt(iend, offset, ZenImgDecoder.computeCRC(iend, 4, 4));
        System.out.println("DONE");
        return iend;
    }

    private static int goToNextImage(byte[] zimg, int offset) {
        return offset + ZenImgDecoder.readInt(zimg, offset + 4) + 8;
    }

    private static int computeCRC(byte[] data, int offset, int length) {
        long c = 0xFFFFFFFFL;
        if (CRCTable == null) {
            ZenImgDecoder.makeCRCTable();
        }
        for (int i = offset; i < length + offset; ++i) {
            c = CRCTable[(int)((c ^ (long)data[i]) & 0xFFL)] ^ c >> 8;
        }
        return (int)(c ^ 0xFFFFFFFFL);
    }

    private static void makeCRCTable() {
        CRCTable = new long[256];
        for (int i = 0; i < 256; ++i) {
            long c = i;
            for (int j = 0; j < 8; ++j) {
                if ((c & 1L) != 0L) {
                    c = 0xEDB88320L ^ c >> 1;
                    continue;
                }
                c >>= 1;
            }
            ZenImgDecoder.CRCTable[i] = c;
        }
    }

    private static int writeLong(byte[] data, int offset, long l) {
        data[offset++] = (byte)(l >> 56 & 0xFFL);
        data[offset++] = (byte)(l >> 48 & 0xFFL);
        data[offset++] = (byte)(l >> 40 & 0xFFL);
        data[offset++] = (byte)(l >> 32 & 0xFFL);
        data[offset++] = (byte)(l >> 24 & 0xFFL);
        data[offset++] = (byte)(l >> 16 & 0xFFL);
        data[offset++] = (byte)(l >> 8 & 0xFFL);
        data[offset++] = (byte)(l & 0xFFL);
        return offset;
    }

    private static int writeInt(byte[] data, int offset, int i) {
        data[offset++] = (byte)(i >> 24 & 0xFF);
        data[offset++] = (byte)(i >> 16 & 0xFF);
        data[offset++] = (byte)(i >> 8 & 0xFF);
        data[offset++] = (byte)(i & 0xFF);
        return offset;
    }

    private static int writeByte(byte[] data, int offset, byte b) {
        data[offset++] = b;
        return offset;
    }

    private static int readInt(byte[] data, int offset) {
        int i = 0;
        i += (data[offset++] & 0xFF) << 24;
        i += (data[offset++] & 0xFF) << 16;
        i += (data[offset++] & 0xFF) << 8;
        return i += data[offset++] & 0xFF;
    }

    private static short readShort(byte[] data, int offset) {
        short s = 0;
        s = (short)(s + ((data[offset++] & 0xFF) << 8));
        s = (short)(s + (data[offset++] & 0xFF));
        return s;
    }
}

