/*
 * Decompiled with CFR 0.152.
 */
package com.zenops.gts;

import com.zenops.gts.Character;
import com.zenops.gts.Floor;
import com.zenops.gts.Game;
import com.zenops.gts.Placeable;

class Moveable
extends Placeable {
    static final int[] SPEED = new int[]{6656, 12544, 19200, 6656, 12544, 19200};
    static final int[] WAYPOINT_WAIT_TIMES = new int[]{0, 1000, 2500, 4000};
    static final int SHOT_TILE_NB = 5;
    static final int AI_SIGHT_TILE_NB = 5;
    static final int AI_EAR_TILE_NB = 6;
    static final int AI_RELOAD_TIME = 1000;
    static final int AI_SEARCH_TIME = 4000;
    static final int AI_LOOK_TIME = 2000;
    static final int AI_SURPRISED_TIME = 500;
    static boolean processAI = true;
    static final byte TYPE_CAMERA_SLOW = 0;
    static final byte TYPE_CAMERA_MEDIUM = 1;
    static final byte TYPE_CAMERA_FAST = 2;
    static final byte TYPE_LASER_SLOW = 3;
    static final byte TYPE_LASER_MEDIUM = 4;
    static final byte TYPE_LASER_FAST = 5;
    static final byte AI_STEP_WAYPOINT_MOVE = 0;
    static final byte AI_STEP_WAYPOINT_WAIT = 1;
    static final byte AI_STEP_SEARCH = 2;
    static final byte AI_STEP_ALERT = 3;
    static final byte AI_STEP_WAYPOINT_BACK = 4;
    static final byte AI_STEP_LOOK = 5;
    static final byte AI_STEP_SURPRISED = 6;
    static int AISight = 5;
    static final byte MAX_ID = 0;
    static final byte AGENT99_ID = 1;
    static final byte FIRST_CUSTOM_ID = 2;
    static byte currentID = (byte)2;
    byte ID;
    byte[] wayPoints;
    byte lookingDir;
    byte movingDir;
    byte planeDir;
    boolean isMoving;
    boolean isChangingPlane;
    boolean isFlying;
    int nextPlaneIndex;
    byte nextAIStep = (byte)-1;

    Moveable() {
        this.ID = currentID;
        System.out.println("CREATE MOVEABLE WITH ID : " + this.ID);
        currentID = (byte)(currentID + 1);
    }

    Moveable(Moveable moveable) {
        this.init(moveable.category, moveable.type, moveable.floor, moveable.tile, moveable.plane);
        this.ID = moveable.ID;
        this.value = 0x40000000;
        if (moveable.wayPoints != null) {
            this.wayPoints = new byte[moveable.wayPoints.length];
            System.arraycopy(moveable.wayPoints, 0, this.wayPoints, 0, moveable.wayPoints.length);
        }
    }

    Moveable(byte type, Floor floor, int tile, int plane) {
        this();
        this.init((byte)4, type, floor, tile, plane);
        this.posY = Floor.getCharacterPosY(plane) << 8;
        switch (this.category << 8 | type) {
            case 1027: 
            case 1028: 
            case 1029: {
                int color = Game.getNextInt(170);
                this.animTimer = 0xFF0000 | color << 8 | color;
            }
        }
    }

    void move(int sens, boolean updateLook) {
        this.isMoving = true;
        if (this.isChangingPlane) {
            return;
        }
        this.movingDir = this.lookingDir = Game.sign(sens, true);
    }

    boolean changePlane(int sens, boolean checkCollisions) {
        if (!this.isChangingPlane) {
            this.nextPlaneIndex = this.plane + sens;
            this.isChangingPlane = true;
            this.planeDir = (byte)sens;
            return true;
        }
        return false;
    }

    void simulate(int timeDelta) {
        int oldPosX = this.posX;
        if (processAI) {
            this.processAI(timeDelta);
        }
        if (this.isChangingPlane) {
            int nextPlanePos = Floor.getCharacterPosY(this.nextPlaneIndex) << 8;
            int deltaY = Game.sign(nextPlanePos - this.posY, false) * Math.min(Math.abs(nextPlanePos - this.posY), Math.abs(SPEED[this.type] * timeDelta >> 10));
            this.posY += deltaY;
            if (this.posY >> 8 == nextPlanePos >> 8) {
                this.posY = nextPlanePos;
                this.isChangingPlane = false;
                this.planeDir = 0;
            }
            this.plane = (byte)this.floor.getTileY(this.posY >> 8);
        } else if (this.isMoving) {
            int move = this.movingDir * (SPEED[this.type] * timeDelta >> 10);
            this.posX += move;
        }
        this.tile = (byte)this.floor.getTileX(this.posX >> 8);
        if (this.tile == Game.player.tile && this.plane == Game.player.plane) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: {
                    if (Game.oldAlert) break;
                    Game.alarm = 0;
                    Game.onAlert = true;
                    AISight = Game.currentFloor.getTileXMax(Game.cameraPosX >> 8) - Game.currentFloor.getTileXMin(Game.cameraPosX >> 8);
                    for (int i = -1; i <= 1; i += 2) {
                        int spawningTile = i == -1 ? this.floor.getTileXMin(Game.cameraPosX >> 8) : this.floor.getTileXMax(Game.cameraPosX >> 8);
                        int spawningPlane = Game.player.plane;
                        boolean spawn = true;
                        while (this.floor.checkObstacle(spawningTile, this.plane, false)) {
                            if (this.plane == Game.player.plane) {
                                spawningTile += i;
                            } else {
                                spawningPlane = Floor.FIRST_ACTION_PLANE + Floor.SECOND_ACTION_PLANE - this.plane;
                            }
                            if (spawningTile >= 0 && spawningTile < this.floor.length) continue;
                            spawn = false;
                            break;
                        }
                        if (!spawn) continue;
                        Character enemy = new Character(2, this.floor, spawningTile, spawningPlane);
                        enemy.isAlarmSpawn = true;
                        enemy.lookingDir = (byte)(-i);
                        enemy.wayPoints = new byte[1];
                        Game.currentMoveableList.addElement(enemy);
                        this.floor.objectList.addElement(enemy);
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (Game.player.type == 0 && Game.player.animType == 15) break;
                    byte sens = Game.sign(Game.oldPlayerPosX - oldPosX, true);
                    if (Game.laserImmunity == -1) {
                        Game.player.isBeingHit(sens, false, 0, null, Game.LASER_HIT);
                        Game.laserImmunity = 0;
                    }
                    if (this.isMoving) break;
                    Game.player.posX = Game.oldPlayerPosX;
                }
            }
        }
        this.computeDisplayPriority();
        this.isMoving = false;
        this.movingDir = 0;
    }

    void initWayPointValue(int nextWayPoint, boolean computeNextTile, boolean initPlane) {
        int nextTile;
        if (this.wayPoints == null) {
            return;
        }
        int sens = (-Game.getBits(this.wayPoints[nextWayPoint], 6, 1) + 1 << 1) - 1;
        int nextPlane = initPlane ? this.plane - Floor.SECOND_ACTION_PLANE : Game.getBits(this.value, 29, 1);
        int n = nextTile = computeNextTile ? (nextTile = this.tile + sens * (this.wayPoints[nextWayPoint] & 0xF)) : Game.getBits(this.value, 15, 8);
        if ((this.wayPoints[nextWayPoint] & 0x80) != 0) {
            nextPlane = 1 - (this.plane - Floor.SECOND_ACTION_PLANE);
            if (nextPlane < 0 || nextPlane > 1 || (nextPlane << 1) - 1 != sens) {
                nextPlane = this.plane - Floor.SECOND_ACTION_PLANE;
            } else {
                this.changePlane(sens, true);
            }
        } else {
            this.lookingDir = (byte)sens;
        }
        this.value = (this.value & 0xC0000000) + ((nextPlane & 1) << 29) + ((nextWayPoint & 0x3F) << 23) + ((nextTile & 0xFF) << 15) + 0;
    }

    protected void initAIValue(int step) {
        this.value &= Short.MIN_VALUE;
        this.value |= (step & 0xF) << 11;
    }

    protected byte getAIStep() {
        return (byte)Game.getBits(this.value, 11, 4);
    }

    protected boolean incrementTime(int timeDelta, int timeLimit) {
        int val = this.value & 0x7FF;
        if ((val += timeDelta >> 2) << 2 >= timeLimit) {
            return true;
        }
        this.value += timeDelta >> 2;
        return false;
    }

    private void processAI(int timeDelta) {
        if (this.wayPoints == null) {
            return;
        }
        int currentWayPoint = Game.getBits(this.value, 23, 6);
        int nextTile = Game.getBits(this.value, 15, 8);
        switch (this.getAIStep()) {
            case 0: {
                boolean changeStep = false;
                if ((this.wayPoints[currentWayPoint] & 0x80) != 0) {
                    changeStep = !this.isChangingPlane;
                } else {
                    int delta = Floor.getXPosInTile(nextTile, this.posX >> 8) - (Floor.TILE_SIZE >> 1);
                    if (delta != 0 && Game.sign(delta, true) != this.lookingDir) {
                        this.move(this.lookingDir, false);
                    } else {
                        changeStep = true;
                        this.posX = nextTile * Floor.TILE_SIZE + (Floor.TILE_SIZE >> 1) << 8;
                    }
                }
                if (!changeStep) break;
                this.initAIValue(1);
                this.processAI(0);
                break;
            }
            case 1: {
                if (!this.incrementTime(timeDelta, WAYPOINT_WAIT_TIMES[Game.getBits(this.wayPoints[currentWayPoint], 4, 2)])) break;
                ++currentWayPoint;
                this.initWayPointValue(currentWayPoint %= this.wayPoints.length, true, false);
                if (this.wayPoints.length <= 1) break;
                this.processAI(0);
            }
        }
    }
}

