/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game.physics;

import com.sorrent.game.physics.Vector2D;

public final class PMaths {
    private static final int[] cosTbl = new int[]{1024, 1024, 1023, 1023, 1022, 1020, 1018, 1016, 1014, 1011, 1008, 1005, 1002, 998, 994, 989, 984, 979, 974, 968, 962, 956, 949, 943, 935, 928, 920, 912, 904, 896, 887, 878, 868, 859, 849, 839, 828, 818, 807, 796, 784, 773, 761, 749, 737, 724, 711, 698, 685, 672, 658, 644, 630, 616, 602, 587, 573, 558, 543, 527, 512, 496, 481, 465, 449, 433, 416, 400, 384, 367, 350, 333, 316, 299, 282, 265, 248, 230, 213, 195, 178, 160, 143, 125, 107, 89, 71, 54, 36, 18, 0};

    public static int pSin(int n) {
        if (n < 180) {
            if (n > 90) {
                return cosTbl[n - 90];
            }
            return cosTbl[90 - n];
        }
        if ((n -= 180) > 90) {
            return -cosTbl[n - 90];
        }
        return -cosTbl[90 - n];
    }

    public static int pCos(int n) {
        if (n < 180) {
            if (n > 90) {
                return -cosTbl[180 - n];
            }
            return cosTbl[n];
        }
        if ((n -= 180) > 90) {
            return cosTbl[180 - n];
        }
        return -cosTbl[n];
    }

    public static void pInitUnitVector(Vector2D vector2D, int n) {
        vector2D.init(PMaths.pCos(n), PMaths.pSin(n));
    }

    public static int ABS(int n) {
        return n >= 0 ? n : -n;
    }
}

