/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game.physics;

import com.sorrent.game.physics.CollisionContact;
import com.sorrent.game.physics.Vector2D;

public abstract class Body {
    public static final int BODY_TYPE_GENERIC = 0;
    public static final int BODY_TYPE_RIGID_AABB = 1;
    public static final int BODY_TYPE_ENV = 2;
    public static final int BODY_TYPE_USER = 3;
    public static final int COLLISION_NONE = 0;
    public static final int COLLISION_PENETRATING = 1;
    public static final int COLLISION_COLLIDING = 2;
    public static final int PHYSICS_DEFAULT_BOUNCING_COEF = 512;
    public int type;
    public int mass;
    public Vector2D pos;
    public Vector2D predictedPos;
    public Vector2D vel;
    public Vector2D predictedVel;
    public Vector2D force;
    public boolean canCollide;
    public boolean canMove;
    public boolean toBeRemoved;
    public int bouncingCoef;
    public Body prev;
    public Body next;

    public void setAllPosition(Vector2D vector2D) {
        this.pos.init(vector2D);
        this.predictedPos.init(vector2D);
    }

    public void setAllPosition(int n, int n2) {
        this.pos.init(n, n2);
        this.predictedPos.init(this.pos);
    }

    public Body(int n, int n2) {
        this.type = n;
        this.mass = n2;
        this.canCollide = true;
        this.canMove = true;
        this.bouncingCoef = 512;
        this.prev = null;
        this.next = null;
        this.toBeRemoved = false;
        this.pos = new Vector2D();
        this.vel = new Vector2D();
        this.predictedVel = new Vector2D();
        this.predictedPos = new Vector2D();
        this.force = new Vector2D();
    }

    public void predictedToCurrent() {
        if (this.canMove) {
            this.pos.init(this.predictedPos);
            this.vel.init(this.predictedVel);
        }
    }

    public void addForce(Body body) {
    }

    public void buildBoundingBox() {
    }

    public abstract boolean supportCollision(Body var1);

    public void computeForces(Body body) {
    }

    public abstract int checkForCollision(Body var1, CollisionContact var2);

    public abstract void resolveCollision(CollisionContact var1);

    public boolean collisionNotify(CollisionContact collisionContact) {
        return true;
    }

    public void destroyedNotify() {
    }
}

