/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game;

import com.sorrent.game.physics.Particle;
import com.sorrent.game.physics.Vector2D;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AquaParticles {
    public static final int AP_PARTICLES = 0;
    public static final int AP_EXPLOSIONS = 1;
    public static final int AP_EXTRA_PARTICLES = 2;
    public static final int AP_PROJECTILE_SMOKE = 3;
    private int type;
    public int lifeAdder;
    public int defaultLife;
    public int frameToUse;
    public static final int amount = 10;
    public int cnt;
    public Particle[] particles;
    public int realOffsetX;
    public int realOffsetY;
    protected Image[] as;
    public static final byte[] remapSmokeFrames = new byte[]{2, 1, 0, 0, 0, 0};

    public AquaParticles(int n) {
        this.type = n;
        this.defaultLife = 255;
        this.lifeAdder = 20;
        this.realOffsetX = 0;
        this.realOffsetY = 0;
        this.particles = new Particle[10];
        for (int i = 9; i >= 0; --i) {
            this.particles[i] = new Particle();
        }
        this.removeAllParticles();
        switch (this.type) {
            case 3: {
                this.defaultLife = 3;
                this.lifeAdder = 1;
                break;
            }
            case 2: {
                this.frameToUse = 0;
                this.lifeAdder = 20;
                break;
            }
            case 1: {
                this.lifeAdder = 5;
            }
        }
    }

    public void removeAllParticles() {
        this.cnt = 0;
        for (int i = 0; i < 10; ++i) {
            this.particles[i].used = false;
        }
    }

    public void setGraphics(Image[] imageArray) {
        this.as = imageArray;
    }

    public void removeParticle(Particle particle) {
        particle.used = false;
        --this.cnt;
    }

    public void addParticle(Vector2D vector2D, Vector2D vector2D2) {
        if (this.cnt == 10) {
            int n = this.particles[0].life;
            int n2 = 0;
            for (int i = 1; i < 10; ++i) {
                if (this.particles[i].life >= n) continue;
                n = this.particles[i].life;
                n2 = i;
            }
            this.particles[n2].init(vector2D);
            this.particles[n2].velocity.init(vector2D2);
            this.particles[n2].life = this.defaultLife;
            this.particles[n2].used = true;
        } else {
            ++this.cnt;
            for (int i = 0; i < 10; ++i) {
                if (this.particles[i].used) continue;
                this.particles[i].init(vector2D);
                this.particles[i].velocity.init(vector2D2);
                this.particles[i].life = this.defaultLife;
                this.particles[i].used = true;
                return;
            }
        }
    }

    public void updatePhysics() {
        if (this.cnt == 0) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (!this.particles[i].used) continue;
            Particle particle = this.particles[i];
            particle.addEqual(particle.velocity);
            particle.life -= this.lifeAdder;
            if (particle.life > 0) continue;
            if (particle.life == -this.lifeAdder) {
                this.removeParticle(particle);
                continue;
            }
            particle.life = 0;
        }
    }

    public void drawAllParticles(Graphics graphics, int n, int n2) {
        this.realOffsetX = n;
        this.realOffsetY = n2;
        int n3 = 0;
        if (this.cnt == 0) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (this.particles[i].used) {
                ++n3;
                this.drawParticle(graphics, this.particles[i]);
            }
            if (n3 != this.cnt) continue;
            return;
        }
    }

    public void drawParticle(Graphics graphics, Particle particle) {
        int n = particle.x - this.realOffsetX >> 10;
        int n2 = -particle.y + this.realOffsetY >> 10;
        Image image = null;
        switch (this.type) {
            case 1: {
                if (this.as == null) {
                    return;
                }
                int n3 = this.as.length * (255 - particle.life) >> 8;
                if (n3 >= this.as.length) {
                    n3 = this.as.length - 1;
                }
                image = this.as[n3];
                break;
            }
            case 3: {
                if (this.as == null) {
                    return;
                }
                image = this.as[this.as.length - 3 + remapSmokeFrames[particle.life]];
                break;
            }
            case 2: {
                if (this.as == null) {
                    return;
                }
                image = this.as[this.frameToUse];
                break;
            }
            case 0: {
                graphics.setColor(particle.life, particle.life >> 1, 0);
                graphics.fillRect(n, n2, 1, 1);
                return;
            }
        }
        graphics.drawImage(image, n - (image.getWidth() >> 1), n2 - image.getHeight(), 20);
    }
}

