/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CustomFont {
    private static final int FLAG_BIG_ENDIAN = 1;
    public static final int CONTROL_TYPE_NULL = 0;
    public static final int CONTROL_TYPE_SPACE = 1;
    public static final int CONTROL_TYPE_TAB = 2;
    public static final int CONTROL_TYPE_NEWLINE = 3;
    private Font m_font;
    private int m_color;
    private Image m_image;
    private int m_ascent;
    private int m_height;
    private int m_charSpacing;
    private int m_lineSpacing;
    private int m_chars;
    private char[] m_charValue;
    private int[] m_charRef;
    private short[] m_charXOffset;
    private short[] m_charYOffset;
    private byte[] m_charWidth;
    private byte[] m_charHeight;
    private byte[] m_charHAdjust;
    private byte[] m_charVAdjust;
    private byte[] m_charHSpacing;
    private byte[] m_controlType;
    private byte[] m_controlSpacing;

    public CustomFont(Font font, int n) {
        this.m_font = font;
        this.m_color = n;
        this.m_height = font.getHeight();
        this.m_ascent = font.getBaselinePosition();
    }

    public CustomFont(Image image, byte[] byArray) {
        this.m_image = image;
        this.setFontMetrics(byArray);
    }

    public CustomFont(Image image, InputStream inputStream) {
        this.m_image = image;
        this.setFontMetrics(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFontMetrics(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.setFontMetrics(byteArrayInputStream);
        }
        catch (Exception exception) {
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setFontMetrics(InputStream inputStream) {
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n2 = dataInputStream.readUnsignedByte();
            int n3 = dataInputStream.readUnsignedByte();
            int n4 = dataInputStream.readUnsignedByte();
            int n5 = dataInputStream.readUnsignedByte();
            this.m_ascent = dataInputStream.readUnsignedByte();
            this.m_height = dataInputStream.readUnsignedByte();
            this.m_charSpacing = dataInputStream.readByte();
            this.m_lineSpacing = dataInputStream.readByte();
            int n6 = dataInputStream.readUnsignedShort();
            int n7 = dataInputStream.readUnsignedShort();
            this.m_chars = n6 + n7;
            this.m_charValue = new char[this.m_chars];
            this.m_charRef = new int[this.m_chars];
            char[] cArray = new char[n6];
            this.m_charXOffset = new short[n6];
            this.m_charYOffset = new short[n6];
            this.m_charWidth = new byte[n6];
            this.m_charHeight = new byte[n6];
            this.m_charHAdjust = new byte[n6];
            this.m_charVAdjust = new byte[n6];
            this.m_charHSpacing = new byte[n6];
            char[] cArray2 = new char[n7];
            this.m_controlType = new byte[n7];
            this.m_controlSpacing = new byte[n7];
            for (n = 0; n < n6; ++n) {
                cArray[n] = dataInputStream.readChar();
                this.m_charXOffset[n] = dataInputStream.readShort();
                this.m_charYOffset[n] = dataInputStream.readShort();
                this.m_charWidth[n] = dataInputStream.readByte();
                this.m_charHeight[n] = dataInputStream.readByte();
                this.m_charHAdjust[n] = dataInputStream.readByte();
                this.m_charVAdjust[n] = dataInputStream.readByte();
                this.m_charHSpacing[n] = dataInputStream.readByte();
                dataInputStream.readByte();
            }
            for (n = 0; n < n7; ++n) {
                cArray2[n] = dataInputStream.readChar();
                this.m_controlType[n] = dataInputStream.readByte();
                this.m_controlSpacing[n] = dataInputStream.readByte();
            }
            n = 0;
            int n8 = 0;
            int n9 = 0;
            while (n < this.m_chars) {
                if (n9 == n7 || n8 < n6 && cArray[n8] < cArray2[n9]) {
                    this.m_charRef[n] = n8 + 1;
                    this.m_charValue[n++] = cArray[n8++];
                    continue;
                }
                this.m_charRef[n] = -n9 - 1;
                this.m_charValue[n++] = cArray2[n9++];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getCharIndex(char c) {
        int n = 0;
        int n2 = this.m_chars - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            if (this.m_charValue[n3] == c) {
                return this.m_charRef[n3];
            }
            if (this.m_charValue[n3] > c) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        return 0;
    }

    public int getHeight() {
        return this.m_height;
    }

    public int getAscent() {
        return this.m_ascent;
    }

    public int stringWidth(String string) {
        return this.substringWidth(string, 0, string.length());
    }

    public int substringWidth(String string, int n, int n2) {
        if (this.m_font != null) {
            return this.m_font.substringWidth(string, n, n2);
        }
        int n3 = 0;
        if (string != null) {
            int n4 = n + n2;
            for (int i = n; i < n4; ++i) {
                n3 += this.charWidth(string.charAt(i));
            }
        }
        return n3;
    }

    public int charWidth(char c) {
        if (this.m_font != null) {
            return this.m_font.charWidth(c);
        }
        int n = 0;
        int n2 = this.getCharIndex(c);
        if (n2 > 0) {
            n = this.m_charWidth[n2 - 1] + this.m_charSpacing;
        } else if (n2 < 0) {
            n2 = -1 - n2;
            switch (this.m_controlType[n2]) {
                case 1: 
                case 2: {
                    n = this.m_controlSpacing[n2];
                }
            }
        }
        return n;
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 += this.charWidth(cArray[i]);
        }
        return n3;
    }

    public void paint(Graphics graphics, String string, int n, int n2) {
        this.paint(graphics, string.toCharArray(), 0, string.length(), n, n2, graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight(), 20);
    }

    public void paint(Graphics graphics, String string, int n, int n2, int n3) {
        this.paint(graphics, string.toCharArray(), 0, string.length(), n, n2, graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight(), n3);
    }

    public void paint(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.paint(graphics, string.toCharArray(), 0, string.length(), n, n2, n3, n4, n5, n6, 20);
    }

    public void paint(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.paint(graphics, string.toCharArray(), 0, string.length(), n, n2, n3, n4, n5, n6, n7);
    }

    public void paint(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.m_font != null) {
            graphics.setColor(this.m_color);
            graphics.setFont(this.m_font);
            graphics.drawChars(cArray, n, n2, n3, n4, n9);
            return;
        }
        if ((n9 & 1) != 0) {
            n3 -= this.charsWidth(cArray, n, n2) / 2;
        }
        if ((n9 & 8) != 0) {
            n3 -= this.charsWidth(cArray, n, n2);
        }
        if ((n9 & 0x20) != 0) {
            n4 -= this.m_height;
        }
        int n10 = n + n2;
        for (int i = n; i < n10; ++i) {
            int n11 = this.getCharIndex(cArray[i]);
            if (n11 > 0) {
                byte by = this.m_charWidth[--n11];
                byte by2 = this.m_charHeight[n11];
                byte by3 = this.m_charHAdjust[n11];
                byte by4 = this.m_charVAdjust[n11];
                byte by5 = this.m_charHSpacing[n11];
                int n12 = n3 + by3;
                int n13 = n4 + by4;
                int n14 = Math.max(n12, n5);
                int n15 = Math.max(n13, n6);
                int n16 = (n7 < 0 ? n12 + by : Math.min(n12 + by, n5 + n7)) - n14;
                int n17 = (n8 < 0 ? n13 + by2 : Math.min(n13 + by2, n6 + n8)) - n15;
                if (n16 > 0 && n17 > 0) {
                    graphics.setClip(n14, n15, n16, n17);
                    graphics.drawImage(this.m_image, n3 + by3 - this.m_charXOffset[n11], n4 + by4 - this.m_charYOffset[n11], 20);
                }
                n3 += by + this.m_charSpacing;
                continue;
            }
            if (n11 >= 0) continue;
            n11 = -1 - n11;
            switch (this.m_controlType[n11]) {
                case 1: 
                case 2: {
                    n3 += this.m_controlSpacing[n11];
                }
            }
        }
        graphics.setClip(n5, n6, n7, n8);
    }
}

