/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game.physics;

import com.sorrent.game.AquaObject;
import com.sorrent.game.physics.Body;
import com.sorrent.game.physics.CollisionContact;
import com.sorrent.game.physics.Vector2D;

public class BodyEnv
extends Body {
    public static final int BODYENV_GRAVITY = 10035;
    public static final int BODYENV_FRICTION = 712;
    public static final int BODYENV_BOUNCING = 500;
    public int frictionCoef;
    public static Vector2D tempV = new Vector2D();

    public BodyEnv() {
        super(2, 0);
        this.canMove = false;
        this.canCollide = true;
        this.bouncingCoef = 500;
        this.frictionCoef = 712;
    }

    public boolean supportCollision(Body body) {
        return body.type == 1;
    }

    public int checkForCollision(Body body, CollisionContact collisionContact) {
        if (body.type == 1) {
            AquaObject aquaObject = (AquaObject)body;
            if (aquaObject.col_y1 < 0) {
                collisionContact.collisionHandler = this;
                collisionContact.collisionableObject = body;
                collisionContact.collisionNormal.init(0, 1024);
                return 1;
            }
            if (aquaObject.col_y1 <= aquaObject.colDistance) {
                collisionContact.collisionHandler = this;
                collisionContact.collisionableObject = body;
                collisionContact.collisionNormal.init(0, 1024);
                return 2;
            }
        }
        return 0;
    }

    public void resolveCollision(CollisionContact collisionContact) {
        int n = 1024 - (collisionContact.collisionHandler.bouncingCoef + collisionContact.collisionableObject.bouncingCoef);
        int n2 = 1024 + collisionContact.collisionHandler.bouncingCoef - n >> 5;
        int n3 = collisionContact.collisionableObject.predictedVel.y >> 5;
        collisionContact.collisionableObject.predictedVel.y -= n3 * n2;
    }

    public void addForce(Body body) {
        CollisionContact collisionContact = new CollisionContact();
        int n = this.checkForCollision(body, collisionContact);
        if (n == 0) {
            Vector2D vector2D = tempV.init(0, -(313 * (body.mass >> 5)));
            body.force.addEqual(vector2D);
        }
        if (n != 0 && this.frictionCoef != 0) {
            int n2 = this.frictionCoef * body.predictedVel.x >> 10;
            n2 = (n2 >> 5) * (body.mass >> 5);
            Vector2D vector2D = tempV.init(n2, 0);
            body.force.subEqual(vector2D);
        }
        if (n != 0 && body.predictedVel.y < 0) {
            int n3 = body.predictedVel.y >> 5;
            int n4 = 1024 - (this.bouncingCoef + body.bouncingCoef);
            int n5 = 1024 + this.bouncingCoef - n4 >> 5;
            int n6 = -n3 * n5 >> 5;
            if (n6 < 0) {
                n6 = -n6;
            }
            Vector2D vector2D = tempV.init(0, n6 * (body.mass >> 5));
            body.force.addEqual(vector2D);
        }
    }
}

