/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game;

import com.sorrent.resource.ResourceMgr;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class AquaResourceAnimatedSprite {
    public Image[] images = null;
    private int numFrames;
    private int numImages;
    private int id;
    public boolean showonce;
    private boolean clip;
    public int frameWidth;
    public int frameHeight;

    public AquaResourceAnimatedSprite(int n, int n2, int n3) {
        this.id = n;
        this.numFrames = n2;
        this.numImages = n3;
        this.showonce = false;
        this.clip = n3 < n2;
    }

    public Image[] getData() {
        return this.images;
    }

    public void obtainResource() {
        if (this.images != null) {
            return;
        }
        this.images = new Image[this.numImages];
        for (int i = 0; i < this.numImages; ++i) {
            this.images[i] = ResourceMgr.getImage(this.id + i);
        }
        this.frameWidth = this.images[0].getWidth();
        this.frameHeight = this.images[0].getHeight();
        if (this.clip) {
            this.frameWidth /= this.numFrames;
        }
    }

    public void releaseResource() {
        boolean bl = false;
        for (int i = 0; i < this.numImages; ++i) {
            ResourceMgr.free(1, this.id + i);
            bl = true;
        }
        if (bl) {
            this.images = null;
        }
    }

    public void drawTopLeft(Graphics graphics, int n, int n2, int n3) {
        if (this.clip) {
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            graphics.clipRect(n2, n3, this.frameWidth, this.frameHeight);
            graphics.drawImage(this.images[0], n2 - n * this.frameWidth, n3, 20);
            graphics.setClip(n4, n5, n6, n7);
        } else {
            graphics.drawImage(this.images[n], n2, n3, 20);
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        if (this.clip) {
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            graphics.clipRect(n2 -= this.frameWidth >> 1, n3 - this.frameHeight, this.frameWidth, this.frameHeight);
            graphics.drawImage(this.images[0], n2 - n * this.frameWidth, n3, 36);
            graphics.setClip(n4, n5, n6, n7);
        } else {
            graphics.drawImage(this.images[n], n2, n3, 33);
        }
    }
}

