/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game;

import com.sorrent.game.AquaCanvas;
import com.sorrent.game.AquaResourceAnimatedSprite;
import com.sorrent.game.physics.PMaths;
import com.sorrent.game.physics.Vector2D;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AquaPlayer {
    public static final int APT_SHAKEMASTER = 0;
    public static final int APT_FRYLOCK = 1;
    public static final int APT_MEATWAD = 2;
    public static final int AQUA_ANGLEDIFF_FRYLOCK = 20;
    public static final int AQUA_ANGLEDIFF_MEATWAD = 10;
    public static final int AQUA_ANGLEDIFF_MASTERSHAKE = 15;
    public static final int AQUA_FORCE_FRYLOCK = 7;
    public static final int AQUA_FORCE_MEATWAD = 5;
    public static final int AQUA_FORCE_MASTERSHAKE = 6;
    public static final int AQUA_PICKUP_DELAY = 50;
    public static final int AQUA_BALANCE_MINSPEED = 30;
    public static final int AQUA_BALANCE_MULT = 10;
    public static Vector2D pos = new Vector2D();
    public static int speed;
    public static int maxSpeed;
    public static int balanceDirection;
    public static int balanceSpeed;
    public static boolean balanced;
    public static int accel;
    public static int curAccel;
    public static int lastAnimeTime;
    public static int force;
    public static int angleDiff;
    public static boolean createSmoke;
    public static int type;
    protected static int lastSmokeTime;
    protected static AquaResourceAnimatedSprite resource;
    protected static byte[] frames;
    protected static byte[] idleFrames;
    protected static int frameIndex;
    protected static int firstFrameForTrigger;
    protected static boolean triggered;
    protected static int animeDelay;
    protected static int curAnimeDelay;
    private static int lastJumpTime;
    private static int jumpOffset;
    private static int jumpAngle;
    private static final byte[] shake_walk;
    private static final byte[] shake_attack;
    private static final byte[] fry_meat_walk;
    private static final byte[] meat_attack;
    private static final byte[] fry_attack;

    public static void createPlayer(int n) {
        speed = 0;
        maxSpeed = 15360;
        lastAnimeTime = 0;
        createSmoke = true;
        frameIndex = 0;
        pos.init(40960, 0);
        AquaCanvas.balance_cur = 0;
        AquaCanvas.balance_last = 0;
        balanceDirection = 1;
        balanceSpeed = 30;
        balanced = false;
        curAccel = 0;
        accel = 0;
        triggered = false;
        lastJumpTime = 0;
        type = n;
        switch (n) {
            case 1: {
                createSmoke = false;
                resource = AquaCanvas.rsc_fry;
                frames = fry_meat_walk;
                jumpAngle = 0;
                firstFrameForTrigger = 4;
                force = 7;
                angleDiff = 20;
                animeDelay = 200;
                break;
            }
            case 2: {
                resource = AquaCanvas.rsc_meat;
                frames = fry_meat_walk;
                firstFrameForTrigger = 5;
                force = 5;
                angleDiff = 10;
                animeDelay = 150;
                break;
            }
            case 0: {
                resource = AquaCanvas.rsc_shake;
                frames = shake_walk;
                jumpOffset = 0;
                firstFrameForTrigger = 3;
                force = 6;
                angleDiff = 15;
                animeDelay = 70;
            }
        }
        resource.obtainResource();
        idleFrames = frames;
    }

    public static void reset() {
        pos.init(40960, 0);
        AquaCanvas.balance_cur = 0;
        AquaCanvas.balance_last = 0;
        balanceDirection = 1;
        balanceSpeed = 30;
        lastAnimeTime = 0;
        frameIndex = 0;
    }

    public static void delete() {
        if (resource != null) {
            resource.releaseResource();
        }
    }

    public static void drawLines(Graphics graphics, int n, int n2, int n3) {
        if (speed > maxSpeed * 3 / 4 && AquaCanvas.gameStatus == 8) {
            int n4 = AquaCanvas.RNDnext() % n3;
            int n5 = AquaCanvas.RNDnext() % 40;
            int n6 = AquaCanvas.RNDnext() % 20 + 5;
            graphics.setColor(0xFFFFFF);
            graphics.drawLine(n - n6 - n5, n2 - n4, n - n6, n2 - n4);
        }
    }

    public static void animate() {
        int n;
        if (type == 2) {
            if (curAnimeDelay > 120) {
                curAnimeDelay = 120;
            }
            if (frames == idleFrames && speed <= 512) {
                return;
            }
        } else if (type == 1) {
            curAnimeDelay = animeDelay;
        }
        if ((n = AquaCanvas.time_game) - lastAnimeTime > curAnimeDelay) {
            if (createSmoke && n - lastSmokeTime > 200 + curAnimeDelay && speed > 5000) {
                Vector2D vector2D = AquaCanvas.tempV1.init(AquaPlayer.pos.x - 3000, AquaPlayer.pos.y);
                lastSmokeTime = n + AquaCanvas.RNDnext() % 500;
                AquaCanvas.pe_smoke.lifeAdder = 20;
                Vector2D vector2D2 = AquaCanvas.tempV2.init(speed >> 1, 500);
                AquaCanvas.pe_smoke.addParticle(vector2D, vector2D2);
            }
            lastAnimeTime = n;
            if (frames[++frameIndex] == -1) {
                frameIndex = 0;
                if (frames != idleFrames) {
                    frames = idleFrames;
                }
            } else if (!triggered && frames[frameIndex] == firstFrameForTrigger) {
                triggered = true;
                AquaPlayer.triggerLaunch();
            }
        }
        if (type == 0) {
            if (curAnimeDelay > 120) {
                curAnimeDelay = 120;
            }
            if (n - lastJumpTime > curAnimeDelay) {
                lastJumpTime = n;
                int n2 = jumpOffset = jumpOffset == 0 ? 1024 : 0;
            }
            if (speed < 512) {
                jumpOffset = 0;
            }
        } else if (type == 1 && n - lastJumpTime > 1) {
            lastJumpTime = n;
            jumpAngle = (jumpAngle + 10) % 360;
        }
    }

    public static void draw(Graphics graphics, int n, int n2) {
        if (type == 1) {
            AquaPlayer.drawShadow(graphics, n, n2);
            n2 -= 3000;
            if (frames[frameIndex] != firstFrameForTrigger) {
                n2 += PMaths.pCos(jumpAngle) << 1;
            }
        } else if (type == 0) {
            n2 += jumpOffset;
        }
        int n3 = AquaPlayer.pos.x - n >> 10;
        int n4 = -AquaPlayer.pos.y + n2 >> 10;
        AquaPlayer.drawLines(graphics, n3, n4, AquaPlayer.resource.frameHeight);
        resource.draw(graphics, frames[frameIndex], n3, n4);
        if (type == 1 && frames[frameIndex] == firstFrameForTrigger) {
            graphics.drawImage(AquaCanvas.rsc_light.getData(), n3 + 0 + 22 - (AquaPlayer.resource.frameWidth >> 1), n4 + 13 - AquaPlayer.resource.frameHeight, 20);
            graphics.drawImage(AquaCanvas.rsc_light.getData(), n3 + 22 - (AquaPlayer.resource.frameWidth >> 1), n4 + 13 - AquaPlayer.resource.frameHeight, 20);
        }
    }

    private static void drawShadow(Graphics graphics, int n, int n2) {
        Image image = AquaCanvas.rsc_shadow.getData();
        int n3 = AquaPlayer.pos.x - n >> 10;
        int n4 = n2 >> 10;
        graphics.drawImage(image, n3 -= image.getWidth() >> 1, n4 -= image.getHeight() >> 1, 20);
    }

    public static boolean tick() {
        if (AquaCanvas.gameStatus == 8) {
            if (AquaCanvas.pickupVisible && AquaCanvas.time_game - AquaCanvas.time_pickup > 50) {
                AquaCanvas.time_pickup = AquaCanvas.time_game;
                if (++AquaCanvas.pickupFrame == AquaCanvas.rsc_pickup.getData().length) {
                    AquaCanvas.pickupVisible = false;
                }
            }
            if ((AquaCanvas.m_keyPressed & 0x10) != 0 && !balanced) {
                int n = AquaCanvas.balance_cur;
                accel = balanceDirection == 1 ? (n > 0 ? 255 - n : 255 + n) : (n < 0 ? 255 + n : 255 - n);
                AquaCanvas.balance_last = AquaCanvas.balance_cur;
                AquaCanvas.pickupVisible = true;
                AquaCanvas.pickupFrame = 0;
                AquaCanvas.time_pickup = AquaCanvas.time_game;
                balanced = true;
                int n2 = 1 + speed * 3 / maxSpeed;
                accel /= n2;
                AquaCanvas.freeKeyBuffer();
            }
            if (curAccel > (accel -= 1 + speed * 120 / (maxSpeed * 16))) {
                curAccel -= 1 + speed * 15 / maxSpeed;
            }
            if (curAccel < accel) {
                curAccel += 1 + speed * 15 / maxSpeed;
            }
            if ((speed += curAccel) < 0) {
                speed = 0;
            }
            if (speed >= maxSpeed) {
                speed = maxSpeed;
            }
            if (speed == 0) {
                curAccel = 0;
                accel = 0;
            }
            AquaPlayer.pos.x += speed;
            if (AquaPlayer.pos.x >= AquaCanvas.projectile_startPoint) {
                AquaPlayer.pos.x = AquaCanvas.projectile_startPoint;
                AquaCanvas.gameStatus = 16;
                AquaCanvas.lastAngleTime = AquaCanvas.time_game;
                AquaCanvas.pe_smoke.removeAllParticles();
            }
            if ((AquaCanvas.balance_cur += balanceDirection * balanceSpeed) <= -255) {
                AquaCanvas.pickupVisible = false;
                AquaCanvas.balance_cur = -255;
                balanceDirection = 1;
                balanceSpeed = speed * 10 / maxSpeed;
                balanceSpeed += 30;
                balanced = false;
            }
            if (AquaCanvas.balance_cur >= 255) {
                AquaCanvas.pickupVisible = false;
                AquaCanvas.balance_cur = 255;
                balanceDirection = -1;
                balanceSpeed = speed * 10 / maxSpeed;
                balanceSpeed += 30;
                balanced = false;
            }
            AquaCanvas.player_speed = speed;
            AquaCanvas.player_maxSpeed = maxSpeed;
            curAnimeDelay = animeDelay * (maxSpeed - speed) / maxSpeed;
        } else {
            curAnimeDelay = AquaCanvas.gameStatus == 64 ? 150 : animeDelay;
        }
        AquaPlayer.animate();
        return true;
    }

    public static void triggerLaunch() {
        AquaCanvas.triggerLaunch();
    }

    public static void setToAttack() {
        frameIndex = 0;
        switch (type) {
            case 1: {
                frames = fry_attack;
                break;
            }
            case 2: {
                frames = meat_attack;
                animeDelay = 70;
                break;
            }
            case 0: {
                frames = shake_attack;
            }
        }
    }

    static {
        shake_walk = new byte[]{0, -1};
        shake_attack = new byte[]{1, 2, 3, 3, -1};
        fry_meat_walk = new byte[]{0, 1, -1};
        meat_attack = new byte[]{2, 3, 4, 5, 5, 4, 3, -1};
        fry_attack = new byte[]{2, 3, 4, 4, -1};
    }
}

