/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game;

import com.sorrent.game.AMenu;
import com.sorrent.game.AquaLevel;
import com.sorrent.game.AquaObject;
import com.sorrent.game.AquaParticles;
import com.sorrent.game.AquaPlayer;
import com.sorrent.game.AquaResourceAnimatedSprite;
import com.sorrent.game.AquaResourceImage;
import com.sorrent.game.GameData;
import com.sorrent.game.GameMIDletAQUA;
import com.sorrent.game.physics.PMaths;
import com.sorrent.game.physics.PhysicsEngine;
import com.sorrent.game.physics.Vector2D;
import com.sorrent.resource.ResourceMgr;
import com.sorrent.sound.SoundManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class AquaCanvas
extends Canvas
implements Runnable,
CommandListener {
    public static final int ASTATUS_STARTUP = 2;
    public static final int ASTATUS_SPLASH = 4;
    public static final int ASTATUS_MENU = 8;
    public static final int ASTATUS_INITIALIZING = 16;
    public static final int ASTATUS_PLAYING = 32;
    public static final int ASTATUS_PREPLAYING = 64;
    public static final int ASTATUS_INFO = 128;
    public static final int ASTATUS_INFO2 = 256;
    public static final int ASTATUS_GAMELOBBY = 512;
    public static final int ASTATUS_SOUND_SPLASH = 1024;
    public static final int AGS_READY = 2;
    public static final int AGS_TARGET = 4;
    public static final int AGS_RUN = 8;
    public static final int AGS_ANGLE = 16;
    public static final int AGS_MANGA = 32;
    public static final int AGS_PRELAUNCH = 64;
    public static final int AGS_DELAY = 128;
    public static final int AGS_SIMU = 256;
    public static final int AGS_PAUSE = 512;
    public static final int AGS_END = 1024;
    public static final int AGS_END2 = 2048;
    public static final String AQUA_PARAMS_NAME = "aqp";
    public static final int AQUA_PARAMS_SIZE = 70;
    public static boolean DEMO_MODE = false;
    public static final int AQUA_PARTICLES_CNT = 10;
    public static final int AQUA_PARTICLES_LIFE = 255;
    public static final int AQUA_PARTICLES_LIFEADDER = 20;
    public static final int AQUA_CAMERA_STEPS_TO_RECENTER = 10;
    public static final int AQUA_BOTTOM_BORDER = 25;
    public static final int AQUA_OBJECTS_YADDITIONAL = 9;
    public static final int AQUA_SPEEDBAR_OFFSET = 8;
    public static final int AQUA_BACKLAYER_XSPEED = 128;
    public static final int AQUA_BACKLAYER_YSPEED = 32;
    public static final int AQUA_HUD_ANGLETONUMBER = 4;
    public static final int AQUA_PIXELS_IN_METER = 10;
    public static final int AQUA_BALANCE_Y = 30;
    public static final int AQUA_DISTANCE_HEIGHT = 7;
    public static final int AQUA_DISTANCE_BORDER = 0;
    public static final int AQUA_ANGLE_MAXSPEED = 10;
    public static final int AQUA_DELAY_ANGLE = 500;
    public static final int AQUA_EXPLOSIONS_IMPACT = 1000000;
    public static final int AQUA_SPLASH_CN = 2000;
    public static final int AQUA_SPLASH_MS = 1100;
    public static final int AQUA_MENU_TOPSPACE = 8;
    public static final int AQUA_MENU_SPACE = 8;
    public static final int AQUA_MENU_HORIZONTALSPACE = 10;
    public static final int AQUA_DELAY_LAUNCH = 150;
    public static final int AQUA_MANGA_PARTICLESCNT = 5;
    public static final int AQUA_MANGA_OPEN = 10;
    public static final int AQUA_MANGA_CLOSE = 10;
    public static final int AQUA_MANGA_ENTER = 20;
    public static final int AQUA_MANGA_VEL = 7;
    public static final int AQUA_MANGA_TIME = 1000;
    public static final int AQUA_SCORE_TIME = 2000;
    public static final int AQUA_DEFAULT_LEVELS = 0;
    public static final int AQUA_SCORE_HITOBJECT = 1000;
    public static final int RND_MAX_VALUE = 997;
    public static final int KEY_UP = 1;
    public static final int KEY_DOWN = 2;
    public static final int KEY_LEFT = 4;
    public static final int KEY_RIGHT = 8;
    public static final int KEY_FIRE = 16;
    public static final int KEY_0 = 32;
    public static final int KEY_1 = 64;
    public static final int KEY_2 = 128;
    public static final int KEY_3 = 256;
    public static final int KEY_4 = 512;
    public static final int KEY_5 = 1024;
    public static final int KEY_6 = 2048;
    public static final int KEY_7 = 4096;
    public static final int KEY_8 = 8192;
    public static final int KEY_9 = 16384;
    public static final int KEY_POUNDK = 32768;
    public static final int KEY_STARK = 65536;
    public static final int KEY_SOFTKEY_POS = 131072;
    public static final int KEY_SOFTKEY_NEG = 262144;
    public static final int KEY_CLEAR = -8;
    public static final Font FONT_NORMAL = Font.getDefaultFont();
    public static final Font FONT_LARGE = Font.getFont((int)0, (int)0, (int)16);
    public static final Font FONT_BOLD = Font.getFont((int)0, (int)1, (int)0);
    public static AquaResourceImage rsc_sky1;
    public static AquaResourceImage rsc_bg1;
    public static AquaResourceImage rsc_hud;
    public static AquaResourceImage rsc_max;
    public static AquaResourceImage rsc_angle;
    public static AquaResourceImage rsc_s;
    public static AquaResourceImage rsc_slast;
    public static AquaResourceImage rsc_scur;
    public static AquaResourceImage rsc_up;
    public static AquaResourceImage rsc_down;
    public static AquaResourceImage rsc_line;
    public static AquaResourceImage rsc_line2;
    public static AquaResourceImage rsc_manga;
    public static AquaResourceImage rsc_sfry;
    public static AquaResourceImage rsc_smeat;
    public static AquaResourceImage rsc_smaster;
    public static AquaResourceImage rsc_shadow;
    public static AquaResourceImage rsc_light;
    public static AquaResourceAnimatedSprite rsc_nl;
    public static AquaResourceAnimatedSprite rsc_ns;
    public static AquaResourceAnimatedSprite rsc_fry;
    public static AquaResourceAnimatedSprite rsc_shake;
    public static AquaResourceAnimatedSprite rsc_meat;
    public static AquaResourceAnimatedSprite rsc_pickup;
    public static AquaResourceAnimatedSprite rsc_radio;
    public static AquaResourceAnimatedSprite rsc_expl;
    public static AquaResourceAnimatedSprite rsc_smoke;
    public static AquaResourceAnimatedSprite rsc_fire;
    public static AquaResourceAnimatedSprite rsc_spring;
    public static AquaResourceAnimatedSprite rsc_cube;
    public static AquaResourceAnimatedSprite rsc_tv;
    public static AquaResourceAnimatedSprite rsc_dyna;
    public static AquaResourceAnimatedSprite rsc_apple;
    public static AquaResourceAnimatedSprite rsc_apple2;
    public static AquaResourceAnimatedSprite rsc_err;
    public static AquaResourceAnimatedSprite rsc_ini;
    public static AquaResourceAnimatedSprite rsc_brain;
    public static AquaResourceAnimatedSprite rsc_sphere;
    public static AquaResourceAnimatedSprite rsc_car;
    public static AquaResourceAnimatedSprite rsc_ship;
    public static AquaResourceAnimatedSprite rsc_small;
    public static AquaResourceAnimatedSprite rsc_pool;
    public static AquaResourceAnimatedSprite rsc_fargate;
    public static AquaResourceAnimatedSprite rsc_extra;
    public static AquaResourceAnimatedSprite rsc_boule;
    public static AquaResourceAnimatedSprite rsc_bomb;
    public static AquaResourceAnimatedSprite rsc_bidle;
    public static AquaResourceAnimatedSprite rsc_bair;
    public static AquaResourceAnimatedSprite rsc_puppet;
    public static AquaResourceAnimatedSprite rsc_scores;
    public static AquaResourceImage rsc_splash;
    public static AquaResourceImage rsc_cn;
    public static AquaResourceImage rsc_ms;
    public static AquaResourceImage rsc_block;
    public static AquaParticles pe_particles;
    public static AquaParticles pe_explosions;
    public static AquaParticles pe_explosions2;
    public static AquaParticles pe_smoke;
    public static AquaParticles pe_extra_0;
    public static AquaParticles pe_extra_1;
    public static AquaParticles pe_extra_2;
    public static AquaParticles pe_psmoke;
    public static boolean soundEnabled;
    public static int[] scores;
    public static int maxLevel;
    public static int selectedLevel;
    public static int status;
    public static int gameStatus;
    public static int oldGameStatus;
    public static int screenWidth;
    public static int screenHeight;
    public static int screenHalfWidth;
    public static int screenHeightMenu;
    public static int player_speed;
    public static int player_maxSpeed;
    public static int player_angle;
    public static int projectile_distance;
    public static int projectile_startPoint;
    public static int balance_cur;
    public static int balance_last;
    public static int time_pickup;
    public static boolean pickupVisible;
    public static int pickupFrame;
    public static int playerType;
    public static int impactSpeed;
    public static int time_game;
    public static int total_time;
    public static int lastAngleTime;
    public static int lastFlashTime;
    public static boolean flashVisible;
    public static Random rndGen;
    public static final int MAX_AQUA_OBJECTS = 60;
    public static int numAquaObjects;
    public static AquaObject[] vGfx;
    public static int launchTime;
    public static boolean simuShouldStop;
    public static boolean levelUnlocked;
    public static int score_total;
    public static int score_max;
    public static int score_current;
    public static int score_time;
    public static int manga_time;
    public static int score_status;
    public static String[] score_text;
    public static String[] objective_1;
    public static String[] objective_2;
    public static String[] finished_text;
    public static String[] objective_1_demo;
    public static String[] objective_1_demo2;
    public static boolean paused;
    public static int end2_status;
    private static Vector2D projectileStartPoint;
    private static int angleDir;
    private static boolean initialized;
    private static int splashStatus;
    private static int lastSplashTime;
    private static Vector2D[] mangaParticles;
    private static Vector2D[] mangaParticlesSpeed;
    private static int[] mangaParticlesType;
    private static int mangaStatus;
    private static int mangaWidth;
    private static int mangaHeight;
    private static int mangaPos;
    private static int mangaSpeed;
    private static int mangaTime;
    private static AquaResourceImage mangaImage;
    private static String mangaTaunt;
    private static int mangaTauntPos;
    private static boolean mangaLayerVisible;
    private static int mangaNewText;
    private static int lastSmokeTime;
    private static int lastLongBlinkTime;
    private static boolean lastLongVisible;
    private static int target_pos;
    private static int target_dest;
    private static String target_text;
    private static Vector2D target_cam;
    private static boolean target_camDone;
    public static Vector2D tempV1;
    public static Vector2D tempV2;
    public static int resProgressTotal;
    public static int resProgressCurrent;
    private static AquaCanvas m_instance;
    public static int m_keyPressed;
    public static int m_positivePriority;
    public static int m_negativePriority;
    public static Command m_cmdPositive;
    public static Command m_cmdNegative;
    public static boolean cheatsEnabled;
    public static Thread animationThread;
    public static Graphics gameGraphics;
    public static boolean forceRepaintHUD;
    public static int m_totalScore;
    public static int playerHeight;
    public Image buffer;
    private static CommandListener listener;
    private static Command cmdLeft;
    private static Command cmdRight;
    private static int fadeDownY;
    private static int softkeyBoxHeight;
    private static final int SOFTKEY_TEXT_COLOR = 0xFFFFFF;
    private static final int FADE_DOWN_TICK_RATE = 20;
    private static final int SOFTKEY_TEXT_XOFFSET = 2;
    private static final int SOFTKEY_TEXT_YOFFSET = 1;
    private static final int CANVAS_HEIGHT_VARIANCE = 0;
    private static final int SOFTKEY_BOX_HEIGHT = 4;
    public static long m_lastTime;
    public static final int MENUINDEX_ROOT0 = -1;
    public static final int MENUINDEX_MAIN = 0;
    public static final int MENUINDEX_MAININGAME = 1;
    public static final int MENUINDEX_SELECTPLAYER = 2;
    public static final int MENUINDEX_SELECTLEVEL = 3;
    public static final int MENUINDEX_ABOUT = 4;
    public static final int MENUINDEX_INSTRUCTIONS = 5;
    public static final int MENUINDEX_INSTRUCTIONS_1 = 6;
    public static final int MENUINDEX_INSTRUCTIONS_2 = 7;
    public static final int MENUINDEX_SETTINGS = 8;
    public static final int MENUINDEX_HS = 9;
    public static final int MENUINDEX_CHEATS = 10;
    public static final int MENUINDEX_LEADERBOARD = 11;
    public static final int MENUINDEX_LBCONNECT = 12;
    public static final int MENUINDEX_LBFAILED = 13;
    public static final int MENUINDEX_EXITCONF = 14;
    public static final int MENUINDEX_LANGUAGE = 15;
    public static final int MENUINDEX_GET_THE_GAME = 16;
    public static final int MENUINDEX_START_TRIAL = 17;
    public static final int MENUINDEX_MORE_GLU_GAME = 18;
    public static final int MENUINDEX_DEMO_INFO = 19;
    public static boolean jad_demo_1;
    public static boolean jad_demo_2;
    public static boolean jad_upsell_1;
    public static boolean jad_upsell_2;
    public static byte[] i_main;
    public static byte[] i_mainingame;
    public static final byte[] i_help;
    public static final byte[] i_selplayer;
    public static final byte[] i_settings_on;
    public static final byte[] i_settings_off;
    public static final byte[] i_cheats_on;
    public static final byte[] i_cheats_off;
    public static final byte[] i_language;
    public static final String separator1 = " - ";
    public static final String separator2 = "\n";
    public static String[] i_topScoreNames;
    public static int[] i_topScores;

    public AquaCanvas() {
        this.setFullScreenMode(true);
        softkeyBoxHeight = FONT_NORMAL.getHeight() + 4;
        screenHeightMenu = screenHeight = this.getHeight() + 0;
        screenHeightMenu -= softkeyBoxHeight;
        screenWidth = this.getWidth();
        screenHalfWidth = screenWidth >> 1;
        AquaLevel.init();
        rsc_ms = new AquaResourceImage(1);
        AquaCanvas.rsc_ms.showonce = true;
        rsc_ms.obtainResource();
        m_instance = this;
        this.setCommandListener(this);
    }

    public static final void setStatus(int n) {
        if (n != 8) {
            int n2 = -1;
            int n3 = -1;
            switch (n) {
                case 4: {
                    if (splashStatus > 0) {
                        n2 = 3;
                    }
                    n3 = 32;
                    break;
                }
                case 1024: {
                    n2 = 139;
                    n3 = 140;
                    break;
                }
                case 32: {
                    n3 = 2;
                    break;
                }
                case 128: 
                case 256: {
                    n2 = jad_demo_2 && AquaLevel.index == 2 ? 137 : (levelUnlocked ? 6 : 40);
                    n3 = jad_demo_2 && AquaLevel.index == 2 ? 136 : 41;
                }
            }
            AquaCanvas.set_commands(n2, n3);
        } else {
            forceRepaintHUD = true;
        }
        status = n;
    }

    public static final int getRelDistance() {
        switch (playerType) {
            case 1: {
                return 45;
            }
            case 2: {
                return 20;
            }
            case 0: {
                return 30;
            }
        }
        return 0;
    }

    public static final void drawImageCentered(Graphics graphics, Image image) {
        graphics.drawImage(image, screenWidth - image.getWidth() >> 1, screenHeight - image.getHeight() >> 1, 20);
    }

    public static final boolean hudDistanceVisible() {
        int n = gameStatus;
        if (n == 512) {
            n = oldGameStatus;
        }
        return (n & 0x58) != 0;
    }

    public static final boolean isInitialized() {
        return initialized;
    }

    public static final boolean hudTopVisible() {
        int n = gameStatus;
        if (n == 512) {
            n = oldGameStatus;
        }
        return (n & 0xDA0) != 0;
    }

    public static final boolean hudBalanceVisible() {
        int n = gameStatus;
        if (n == 512) {
            n = oldGameStatus;
        }
        return n == 8;
    }

    public static final int getSignedRnd(int n) {
        int n2 = rndGen.nextInt();
        n2 = n2 < 0 ? -n2 : n2;
        int n3 = n2 % (n << 1);
        return n3 - n;
    }

    public static final int RNDnext() {
        int n = rndGen.nextInt();
        n = n < 0 ? -n : n;
        return n % 997;
    }

    public static final int RNDnext256() {
        int n = rndGen.nextInt();
        n = n < 0 ? -n : n;
        return n % 256;
    }

    public static final int RNDnextSigned() {
        int n = rndGen.nextInt();
        n = n < 0 ? -n : n;
        return 512 - n % 1025;
    }

    public static void delete() {
        if (score_text != null) {
            score_text = null;
        }
        if (objective_1 != null) {
            objective_1 = null;
        }
        if (objective_1_demo != null) {
            objective_1_demo = null;
        }
        if (objective_1_demo2 != null) {
            objective_1_demo2 = null;
        }
        if (objective_2 != null) {
            objective_2 = null;
        }
        AquaCanvas.menu_gfree();
    }

    public static int getSoftKey(int n) {
        int n2 = 0;
        switch (n) {
            case -202: 
            case -20: 
            case -6: 
            case 20: {
                n2 = 1;
                break;
            }
            case -203: 
            case -21: 
            case -7: 
            case 21: {
                n2 = 2;
            }
        }
        return n2;
    }

    public void keyPressed(int n) {
        if (n == 48) {
            return;
        }
        if (!GameMIDletAQUA.m_invertSoftkeys && AquaCanvas.getSoftKey(n) != 2 && status == 4 && splashStatus == 0) {
            return;
        }
        if (GameMIDletAQUA.m_invertSoftkeys && AquaCanvas.getSoftKey(n) != 1 && status == 4 && splashStatus == 0) {
            return;
        }
        if (n == -8) {
            return;
        }
        if (AquaCanvas.handleSoftkeys(n, (Displayable)this)) {
            return;
        }
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: {
                m_keyPressed |= 1;
                return;
            }
            case 6: {
                m_keyPressed |= 2;
                return;
            }
            case 2: {
                m_keyPressed |= 4;
                return;
            }
            case 5: {
                m_keyPressed |= 8;
                return;
            }
            case 8: {
                m_keyPressed |= 0x10;
                return;
            }
        }
        switch (n) {
            case 35: {
                m_keyPressed |= 0x8000;
                return;
            }
            case 42: {
                m_keyPressed |= 0x10000;
                return;
            }
            case 50: {
                m_keyPressed |= 0x81;
                return;
            }
            case 53: {
                m_keyPressed |= 0x410;
                return;
            }
            case 56: {
                m_keyPressed |= 0x2002;
                return;
            }
            case 48: {
                m_keyPressed |= 0x20;
                return;
            }
            case -8: {
                m_keyPressed |= 0x40000;
                return;
            }
        }
    }

    public static void freeKeyBuffer() {
        m_keyPressed = 0;
    }

    public static void init() {
        rsc_bg1 = new AquaResourceImage(4);
        rsc_sky1 = new AquaResourceImage(5);
        rsc_hud = new AquaResourceImage(7);
        rsc_max = new AquaResourceImage(8);
        rsc_angle = new AquaResourceImage(31);
        rsc_s = new AquaResourceImage(6);
        rsc_slast = new AquaResourceImage(30);
        rsc_scur = new AquaResourceImage(29);
        rsc_up = new AquaResourceImage(73);
        rsc_down = new AquaResourceImage(72);
        rsc_line = new AquaResourceImage(157);
        rsc_line2 = new AquaResourceImage(158);
        rsc_manga = new AquaResourceImage(156);
        rsc_sfry = new AquaResourceImage(43);
        rsc_smeat = new AquaResourceImage(50);
        rsc_smaster = new AquaResourceImage(36);
        rsc_shadow = new AquaResourceImage(144);
        rsc_light = new AquaResourceImage(42);
        rsc_nl = new AquaResourceAnimatedSprite(9, 10, 10);
        rsc_ns = new AquaResourceAnimatedSprite(19, 10, 10);
        rsc_fry = new AquaResourceAnimatedSprite(37, 5, 5);
        rsc_shake = new AquaResourceAnimatedSprite(32, 4, 4);
        rsc_meat = new AquaResourceAnimatedSprite(44, 6, 6);
        rsc_pickup = new AquaResourceAnimatedSprite(51, 3, 3);
        rsc_radio = new AquaResourceAnimatedSprite(54, 10, 10);
        rsc_expl = new AquaResourceAnimatedSprite(64, 5, 5);
        rsc_smoke = new AquaResourceAnimatedSprite(69, 3, 3);
        rsc_fire = new AquaResourceAnimatedSprite(81, 3, 3);
        rsc_spring = new AquaResourceAnimatedSprite(84, 2, 2);
        rsc_cube = new AquaResourceAnimatedSprite(96, 8, 8);
        rsc_tv = new AquaResourceAnimatedSprite(86, 10, 10);
        rsc_dyna = new AquaResourceAnimatedSprite(104, 8, 8);
        rsc_apple = new AquaResourceAnimatedSprite(120, 8, 8);
        rsc_apple2 = new AquaResourceAnimatedSprite(112, 8, 8);
        rsc_err = new AquaResourceAnimatedSprite(128, 4, 4);
        rsc_ini = new AquaResourceAnimatedSprite(132, 4, 4);
        rsc_brain = new AquaResourceAnimatedSprite(136, 8, 8);
        rsc_sphere = new AquaResourceAnimatedSprite(78, 2, 2);
        rsc_car = new AquaResourceAnimatedSprite(80, 1, 1);
        rsc_ship = new AquaResourceAnimatedSprite(145, 1, 1);
        rsc_small = new AquaResourceAnimatedSprite(159, 4, 4);
        rsc_pool = new AquaResourceAnimatedSprite(146, 1, 1);
        rsc_fargate = new AquaResourceAnimatedSprite(147, 2, 2);
        rsc_extra = new AquaResourceAnimatedSprite(75, 3, 3);
        rsc_boule = new AquaResourceAnimatedSprite(149, 1, 1);
        rsc_bomb = new AquaResourceAnimatedSprite(150, 1, 1);
        rsc_bidle = new AquaResourceAnimatedSprite(155, 1, 1);
        rsc_bair = new AquaResourceAnimatedSprite(151, 4, 4);
        rsc_puppet = new AquaResourceAnimatedSprite(163, 4, 4);
        rsc_scores = new AquaResourceAnimatedSprite(167, 3, 3);
        rsc_splash = new AquaResourceImage(3);
        AquaCanvas.rsc_splash.showonce = true;
        rsc_cn = new AquaResourceImage(2);
        AquaCanvas.rsc_cn.showonce = true;
        rsc_block = new AquaResourceImage(74);
        pe_particles = new AquaParticles(0);
        pe_explosions = new AquaParticles(1);
        pe_explosions2 = new AquaParticles(3);
        pe_smoke = new AquaParticles(1);
        pe_extra_0 = new AquaParticles(2);
        pe_extra_1 = new AquaParticles(2);
        pe_extra_2 = new AquaParticles(2);
        pe_psmoke = new AquaParticles(3);
        AquaCanvas.getPrefs();
        rsc_nl.obtainResource();
        rsc_splash.obtainResource();
        rsc_cn.obtainResource();
        rsc_block.obtainResource();
        rsc_up.obtainResource();
        rsc_down.obtainResource();
        rsc_sfry.obtainResource();
        rsc_smaster.obtainResource();
        rsc_smeat.obtainResource();
        rsc_fry.obtainResource();
        playerHeight = rsc_fry.getData()[0].getHeight();
        rsc_fry.releaseResource();
        rsc_small.obtainResource();
        rsc_scores.obtainResource();
        initialized = true;
    }

    public static void initNeededTexts() {
        score_text = AquaCanvas.wrapText(GameData.get(36), screenWidth - 10, FONT_NORMAL);
        GameData.text[36] = null;
        objective_1 = AquaCanvas.wrapText(GameData.get(109), screenWidth - 10, FONT_NORMAL);
        GameData.text[109] = null;
        objective_1_demo = AquaCanvas.wrapText(GameData.get(18), screenWidth - 10, FONT_NORMAL);
        GameData.text[18] = null;
        objective_1_demo2 = AquaCanvas.wrapText(GameData.get(131), screenWidth - 10, FONT_NORMAL);
        GameData.text[131] = null;
        objective_2 = AquaCanvas.wrapText(GameData.get(111), screenWidth - 10, FONT_NORMAL);
        GameData.text[111] = null;
        finished_text = AquaCanvas.wrapText(GameData.get(110), screenWidth - 10, FONT_NORMAL);
        GameData.text[110] = null;
    }

    public void hideNotify() {
    }

    public void showNotify() {
        if ((status & 0x70) != 0) {
            paused = true;
        }
    }

    public void run() {
        try {
            Thread thread = Thread.currentThread();
            do {
                long l = System.currentTimeMillis();
                int n = (int)(l - m_lastTime);
                m_lastTime = l;
                AquaCanvas.tick(n);
                this.repaint();
                this.serviceRepaints();
                if (n >= GameMIDletAQUA.m_tickRate) continue;
                try {
                    Thread.sleep(GameMIDletAQUA.m_tickRate - n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (thread == animationThread);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void startTick() {
        m_lastTime = System.currentTimeMillis();
        animationThread = new Thread(m_instance);
        animationThread.start();
    }

    public static boolean tick(int n) {
        int n2 = m_keyPressed;
        if ((total_time += 50) - lastFlashTime > 150) {
            lastFlashTime = total_time;
            flashVisible = !flashVisible;
        }
        switch (status) {
            case 256: {
                if (time_game - score_time > 2000) {
                    AquaCanvas.setStatus(128);
                }
            }
            case 128: {
                if ((time_game += 50) - lastLongBlinkTime > 500) {
                    lastLongBlinkTime = time_game;
                    boolean bl = lastLongVisible = !lastLongVisible;
                }
                if ((m_keyPressed & 0x20010) != 0) {
                    if (jad_demo_2 && AquaLevel.index == 2) {
                        try {
                            GameMIDletAQUA.m_instance.platformRequest(GameMIDletAQUA.ms_demoUrl);
                        }
                        catch (Exception exception) {
                        }
                        GameMIDletAQUA.m_instance.quitApp();
                        break;
                    }
                    AquaCanvas.freeKeyBuffer();
                    AquaCanvas.exitGame();
                    if (!AquaCanvas.initGame()) {
                        return false;
                    }
                    if (!AquaCanvas.startLevel(selectedLevel)) {
                        return false;
                    }
                    AquaCanvas.freeKeyBuffer();
                    AquaCanvas.setStatus(64);
                }
                if ((m_keyPressed & 0x40020) == 0) break;
                AquaCanvas.freeKeyBuffer();
                AquaCanvas.exitGame();
                AquaCanvas.setStatus(8);
                SoundManager.stop();
                SoundManager.play(131073);
                return AquaCanvas.initMenu();
            }
            case 8: {
                return AquaCanvas.menu_tick();
            }
            case 4: {
                if (n2 == 262144) {
                    GameMIDletAQUA.quitApp();
                    return false;
                }
                if (splashStatus == 0) {
                    if (total_time - lastSplashTime > 2000) {
                        lastSplashTime = total_time;
                        splashStatus = 1;
                        AquaCanvas.setStatus(4);
                        rsc_cn.releaseResource();
                        AquaCanvas.freeKeyBuffer();
                    }
                } else {
                    if ((n2 & 0x20010) != 0 || total_time - lastSplashTime > 2000) {
                        return AquaCanvas.gotoMainMenu();
                    }
                    if (total_time - lastLongBlinkTime > 500) {
                        lastLongBlinkTime = total_time;
                        lastLongVisible = !lastLongVisible;
                    }
                }
                return true;
            }
            case 1024: {
                if (n2 == 262144) {
                    AquaCanvas.freeKeyBuffer();
                    soundEnabled = false;
                    SoundManager.setSound(false);
                    return AquaCanvas.gotoSplash2();
                }
                if ((n2 & 0x20010) == 0) break;
                AquaCanvas.freeKeyBuffer();
                soundEnabled = true;
                SoundManager.setSound(true);
                return AquaCanvas.gotoSplash2();
            }
            case 2: {
                return AquaCanvas.gotoSplash();
            }
            case 16: {
                AquaCanvas.setStatus(64);
                AquaCanvas.exitMenu();
                if (!AquaCanvas.initGame()) {
                    return false;
                }
                if (AquaCanvas.startLevel(selectedLevel)) break;
                return false;
            }
            case 64: {
                AquaCanvas.setStatus(32);
                AquaLevel.cam_setFocusedObject(AquaPlayer.pos);
                AquaLevel.cam_recenter = false;
                if (!AquaLevel.cam_tick()) {
                    return false;
                }
                time_game = 0;
                target_pos = screenWidth;
                target_text = AquaLevel.objective_text;
                target_dest = -FONT_LARGE.stringWidth(target_text);
                target_camDone = true;
                if (AquaLevel.targetObject != null) {
                    target_cam.init(AquaLevel.targetObject.pos);
                    AquaLevel.cam_setFocusedObject(target_cam);
                    AquaLevel.cam_recenter = false;
                    if (!AquaLevel.cam_tick()) {
                        return false;
                    }
                    target_camDone = false;
                }
                gameStatus = 4;
                lastFlashTime = 0;
                flashVisible = false;
            }
            case 32: {
                if (AquaCanvas.tickGame(n)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static boolean gotoSplash() {
        AquaCanvas.freeKeyBuffer();
        AquaCanvas.setStatus(1024);
        return true;
    }

    public static boolean gotoSplash2() {
        AquaCanvas.freeKeyBuffer();
        AquaCanvas.setStatus(4);
        splashStatus = 0;
        lastSplashTime = total_time;
        rsc_ms.releaseResource();
        if (soundEnabled) {
            SoundManager.play(131073);
        }
        return true;
    }

    public static boolean gotoMainMenu() {
        lastSplashTime = total_time;
        m_keyPressed = 0;
        AquaCanvas.setStatus(8);
        rsc_splash.releaseResource();
        return AquaCanvas.initMenu();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void paint(Graphics graphics) {
        block20: {
            block22: {
                block21: {
                    block19: {
                        if (status != 8) break block19;
                        AquaCanvas.menu_draw(graphics);
                        break block20;
                    }
                    if (status != 32) break block21;
                    AquaCanvas.paintGame(graphics);
                    break block20;
                }
                if (status == 2) {
                    Image image = ResourceMgr.getImage(1);
                    int n = image.getHeight();
                    int n2 = screenHeight >> 1;
                    int n3 = n >> 3;
                    int n4 = n2 - (n + n3 + 4 >> 1);
                    int n5 = image.getWidth();
                    int n6 = (n5 - 2) * resProgressCurrent / resProgressTotal;
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, screenWidth, screenHeight + softkeyBoxHeight);
                    graphics.drawImage(image, screenHalfWidth, n4, 17);
                    graphics.setColor(0x444444);
                    graphics.fillRect(screenWidth - n5 >> 1, n4 += n + 4, n5, n3);
                    if (n6 > 0) {
                        graphics.setColor(0xCCCCCC);
                        graphics.fillRoundRect(screenWidth - n5 >> 1, n4, n6 + 1, n3 - 1, n3, n3);
                    }
                    return;
                }
                if (status != 4) break block22;
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, screenWidth, screenHeight);
                if (splashStatus == 0) {
                    graphics.drawImage(rsc_cn.getData(), screenHalfWidth, screenHeight >> 1, 3);
                    break block20;
                } else {
                    Image image = rsc_splash.getData();
                    int n = screenWidth - image.getWidth() >> 1;
                    int n7 = screenHeight - image.getHeight() >> 1;
                    if ((n7 -= 3) < 0) {
                        n7 = 0;
                    }
                    graphics.drawImage(image, n, n7 + 0, 20);
                    graphics.setFont(FONT_NORMAL);
                    int n8 = FONT_NORMAL.getHeight();
                    if (lastLongVisible && !DEMO_MODE) {
                        // empty if block
                    }
                }
                break block20;
            }
            if (status == 1024) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, screenWidth, screenHeight);
                AquaCanvas.drawTextCenterShadow4(graphics, GameData.text[138], screenHeight >> 1, FONT_NORMAL);
            } else if (status == 128) {
                boolean bl;
                AquaCanvas.drawBlocks(graphics);
                graphics.setFont(FONT_NORMAL);
                int n = FONT_NORMAL.getHeight();
                int n9 = 2 + n;
                boolean bl2 = bl = AquaLevel.index >= 15;
                String[] stringArray = AquaLevel.index == 2 && jad_demo_1 ? (bl ? finished_text : objective_1_demo) : (AquaLevel.index == 2 && jad_demo_2 ? (bl ? finished_text : objective_1_demo2) : (AquaLevel.success ? (bl ? finished_text : objective_1) : objective_2));
                int n10 = screenHeight - stringArray.length * n9 >> 1;
                for (int i = 0; i < stringArray.length; n10 += n9, ++i) {
                    AquaCanvas.drawTextCenterShadow(graphics, stringArray[i], n10, FONT_NORMAL);
                }
            } else if (status == 256) {
                AquaCanvas.drawBlocks(graphics);
                graphics.setFont(FONT_NORMAL);
                int n = FONT_NORMAL.getHeight();
                int n11 = 2 + n;
                if (AquaLevel.index == 2 && jad_demo_1) {
                    int n12 = screenHeight - objective_1_demo.length * n11 >> 1;
                    for (int i = 0; i < objective_1_demo.length; n12 += n11, ++i) {
                        AquaCanvas.drawTextCenterShadow(graphics, objective_1_demo[i], n12, FONT_NORMAL);
                    }
                } else if (AquaLevel.index == 2 && jad_demo_2) {
                    int n13 = screenHeight - objective_1_demo2.length * n11 >> 1;
                    for (int i = 0; i < objective_1_demo2.length; n13 += n11, ++i) {
                        AquaCanvas.drawTextCenterShadow(graphics, objective_1_demo2[i], n13, FONT_NORMAL);
                    }
                } else {
                    int n14 = screenHeight - score_text.length * n11 >> 1;
                    for (int i = 0; i < score_text.length; n14 += n11, ++i) {
                        AquaCanvas.drawTextCenterShadow(graphics, score_text[i], n14, FONT_NORMAL);
                    }
                }
            }
        }
        AquaCanvas.paintSoftkeys(graphics);
    }

    public static void drawBlocks(Graphics graphics) {
        Image image = rsc_block.getData();
        int n = image.getWidth();
        int n2 = image.getHeight();
        for (int i = 0; i < screenHeight; i += n2) {
            for (int j = 0; j < screenWidth; j += n) {
                graphics.drawImage(image, j, i, 20);
            }
        }
    }

    public static void paintGame(Graphics graphics) {
        int n;
        boolean bl;
        boolean bl2 = bl = forceRepaintHUD || AquaCanvas.hudDistanceVisible() || (gameStatus & 0x100) == 0;
        if (!bl) {
            graphics.setClip(0, 0, screenWidth, screenHeight - 25);
        }
        AquaLevel.drawBackground(graphics);
        AquaCanvas.paintObjects(graphics);
        if (bl) {
            AquaLevel.drawBackground2(graphics);
            AquaCanvas.paintHudBottom(graphics);
            forceRepaintHUD = false;
        }
        if (AquaCanvas.hudTopVisible()) {
            AquaCanvas.paintHudTop(graphics);
        }
        if (AquaCanvas.hudBalanceVisible()) {
            AquaCanvas.paintBalance(graphics);
        }
        if (AquaCanvas.hudDistanceVisible()) {
            AquaCanvas.paintDistance(graphics);
        }
        int n2 = screenHeight - 25 + 1;
        graphics.setFont(FONT_NORMAL);
        int n3 = FONT_NORMAL.getHeight();
        if (gameStatus == 4) {
            graphics.setFont(FONT_LARGE);
            if (target_pos >= target_dest) {
                n3 = FONT_LARGE.getHeight() + 2;
                graphics.setColor(0);
                graphics.fillRect(-1, 0, screenWidth + 2, n3 + 4);
                graphics.setColor(0xFFFF00);
                graphics.drawRect(-1, 0, screenWidth + 2, n3 + 4);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(target_text, target_pos, 3, 20);
            }
        }
        if (gameStatus == 2048 && end2_status >= 2) {
            int n4 = FONT_NORMAL.getHeight();
            n4 += 30;
            n = AquaCanvas.rsc_scores.frameWidth;
            int n5 = AquaCanvas.rsc_scores.frameHeight;
            int n6 = Math.max(13, n5);
            int n7 = screenWidth - (36 + n) >> 1;
            int n8 = 36 + n + 10;
            int n9 = screenWidth - n8 >> 1;
            int n10 = screenHeight - 61 >> 1;
            n4 = n10 + 3;
            if (lastLongVisible && score_status == 3 && AquaCanvas.isHighScore()) {
                int n11 = n4 - FONT_NORMAL.getHeight() + 18;
                graphics.setColor(0xFFFF00);
                graphics.fillRect(0, n11 - 1, screenWidth, FONT_NORMAL.getHeight() + 2);
                graphics.setColor(0);
                graphics.drawString(GameData.get(108), screenHalfWidth, n11 + 0, 17);
            }
            if (score_status != -1 && score_status != 3) {
                graphics.setColor(0);
                graphics.fillRect(n9, n4 - 3, n8, n6 + 5);
                graphics.setColor(0xFFFF00);
                graphics.drawRect(n9, n4 - 3, n8, n6 + 5);
                rsc_scores.drawTopLeft(graphics, score_status, n7 - 1, n4);
                AquaCanvas.drawNumber(graphics, score_max - score_current, n7 + 2 + n, n4 + 1, 4, 1, true);
            }
            graphics.setColor(0);
            graphics.fillRect(n9, (n4 += 25) - 3, n8, n6 + 5);
            graphics.setColor(0xFFFF00);
            graphics.drawRect(n9, n4 - 3, n8, n6 + 5);
            AquaCanvas.drawNumber(graphics, score_total, n7 + 2 + n, n4 + 1, 4, 1, true);
        }
        if (gameStatus == 2) {
            graphics.setFont(FONT_LARGE);
            n3 = FONT_LARGE.getHeight() + 2;
            String string = GameData.get(1);
            n = FONT_LARGE.stringWidth(string);
            graphics.setColor(0);
            graphics.fillRect(screenWidth - n - 8 >> 1, (screenHeight - n3 - 6 >> 1) - 0, n + 8, n3 + 6);
            graphics.setColor(0xFFFF00);
            graphics.drawRect(screenWidth - n - 8 >> 1, (screenHeight - n3 - 6 >> 1) - 0, n + 8, n3 + 6);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(string, screenHalfWidth + 0, (screenHeight - n3 - 2 >> 1) + 3 - 0, 17);
        } else if (gameStatus == 32 || gameStatus == 2048 && end2_status < 2) {
            AquaCanvas.drawManga(graphics);
        }
    }

    public static void paintBalance(Graphics graphics) {
        Image image = rsc_s.getData();
        int n = screenWidth - image.getWidth() >> 1;
        int n2 = 0 + (7 + (screenHeight - (playerHeight + 41)) / 3);
        int n3 = (image.getWidth() >> 1) - 3;
        graphics.drawImage(image, n, n2, 6);
        n = screenHalfWidth - 4;
        graphics.drawImage(rsc_slast.getData(), n + (n3 * balance_last >> 8), n2, 6);
        graphics.drawImage(rsc_scur.getData(), n + (n3 * balance_cur >> 8), n2, 6);
        if (pickupVisible) {
            image = rsc_pickup.getData()[pickupFrame];
            graphics.drawImage(image, (n += (n3 * balance_last >> 8) + (rsc_slast.getData().getWidth() >> 1)) - (image.getWidth() >> 1), n2, 6);
        }
    }

    public static void paintHudBottom(Graphics graphics) {
        int n = screenHeight - 24;
        Image image = rsc_hud.getData();
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        int n4 = 2;
        int n5 = screenHeight - 8 - n3;
        int n6 = n2 * player_speed / player_maxSpeed;
        int n7 = n2 - n6;
        int n8 = n4 + n6;
        graphics.setColor(16442205);
        graphics.fillRect(n8, n5, n7, n3);
        graphics.setColor(14614564);
        graphics.fillRect(n4, n5, n8, n3);
        graphics.drawImage(image, n4, n5, 20);
        n4 += image.getWidth();
        image = rsc_max.getData();
        graphics.drawImage(image, n4 - image.getWidth(), n5 - image.getHeight(), 20);
        image = rsc_angle.getData();
        n4 = screenWidth - image.getWidth() - 4 - ((AquaCanvas.rsc_nl.frameWidth << 1) + 5);
        n5 = n + 3;
        graphics.drawImage(image, n4, n5, 20);
        AquaCanvas.drawNumber(graphics, player_angle, n4 + image.getWidth() + 4, n5, 2, 1, true);
        graphics.setColor(0xFFFF00);
        graphics.drawRect(screenWidth - 3, n5, 2, 2);
        ++n4;
        n5 += image.getHeight() - 2;
        Vector2D vector2D = tempV1;
        PMaths.pInitUnitVector(vector2D, player_angle);
        vector2D.mulEqual(image.getWidth() - 1 << 10);
        graphics.setColor(0xFF0000);
        graphics.drawLine(n4, n5, n4 + (vector2D.x >> 10), n5 - (vector2D.y >> 10));
    }

    public static void paintHudTop(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 45, 18);
        graphics.setColor(0xFFFF00);
        graphics.drawLine(0, 18, 45, 18);
        graphics.drawLine(45, 0, 45, 18);
        int n = projectile_distance >> 1;
        if (n > 1023990) {
            n = 1023990;
        }
        int n2 = n >> 10;
        int n3 = (n & 0x3FF) * 100 >> 10;
        if (n < 1023990 || flashVisible) {
            AquaCanvas.drawNumber(graphics, n2, 5, 3, 3, 1, true);
            AquaCanvas.drawNumber(graphics, n3, 34, 3, 2, 1, false);
        }
    }

    public static void paintDistance(Graphics graphics) {
        int n = screenWidth - 10;
        Image[] imageArray = rsc_small.getData();
        int n2 = imageArray[0].getWidth();
        int n3 = imageArray[0].getHeight();
        graphics.setColor(0);
        graphics.fillRect(0, 0, screenWidth - 0, n3);
        graphics.drawImage(imageArray[3], screenWidth - 0, 0, 24);
        int n4 = 0;
        n4 = projectile_startPoint >= AquaPlayer.pos.x ? (n * AquaPlayer.pos.x >> 10) / (projectile_startPoint >> 10) : n;
        if (n4 != 0) {
            graphics.setColor(0xFFFF00);
            graphics.fillRect(1, 1, n4, n3 - 2);
        }
        graphics.drawImage(imageArray[playerType], n4, 0, 20);
    }

    public static void paintObjects(Graphics graphics) {
        int n = graphics.getClipHeight();
        int n2 = screenHeight - 34;
        graphics.setClip(0, 0, screenWidth, screenHeight - 25);
        int n3 = AquaLevel.getCameraStartXReal();
        int n4 = n2 >> 1;
        int n5 = AquaLevel.getCameraY() >> 10;
        int n6 = n5 - n4;
        if (n6 < 0) {
            n6 = 0;
        }
        int n7 = n2 + n6 << 10;
        pe_particles.drawAllParticles(graphics, n3, n7);
        pe_smoke.drawAllParticles(graphics, n3, n7);
        pe_psmoke.drawAllParticles(graphics, n3, n7);
        pe_extra_0.drawAllParticles(graphics, n3, n7);
        pe_extra_1.drawAllParticles(graphics, n3, n7);
        pe_extra_2.drawAllParticles(graphics, n3, n7);
        for (int i = 0; i < numAquaObjects; ++i) {
            AquaObject aquaObject = vGfx[i];
            if (!aquaObject.visible) continue;
            aquaObject.draw(graphics, n3, n7);
        }
        pe_explosions2.drawAllParticles(graphics, n3, n7);
        AquaPlayer.draw(graphics, n3, n7);
        pe_explosions.drawAllParticles(graphics, n3, n7);
        graphics.setClip(0, 0, screenWidth, n);
    }

    public static void drawNumber(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        AquaResourceAnimatedSprite aquaResourceAnimatedSprite = !bl ? rsc_ns : rsc_nl;
        int n6 = aquaResourceAnimatedSprite.frameWidth;
        n2 += (n6 + n5) * n4;
        while (n4 > 0) {
            --n4;
            int n7 = n;
            aquaResourceAnimatedSprite.drawTopLeft(graphics, n7 -= 10 * (n /= 10), n2 -= n6 + n5, n3);
        }
    }

    void AquaLoadingCB_black(Graphics graphics, int n, int n2) {
        graphics.setFont(FONT_BOLD);
        graphics.setColor(0);
        graphics.fillRect(0, 0, screenWidth, screenHeight);
        int n3 = FONT_BOLD.getHeight();
        int n4 = screenHeight + n3 >> 1;
        graphics.setColor(0xFFFFFF);
        graphics.drawString(GameData.get(0), screenHalfWidth, n4 - n3 - 2, 17);
        graphics.setColor(1973820);
        graphics.fillRect(0, n4 + 2, screenWidth * n / n2, 2);
    }

    void AquaLoadingCB_white(Graphics graphics, int n, int n2) {
        graphics.setFont(FONT_BOLD);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, screenWidth, screenHeight);
        int n3 = FONT_BOLD.getHeight();
        int n4 = screenHeight + n3 >> 1;
        graphics.setColor(0);
        graphics.drawString(GameData.get(0), screenHalfWidth, n4 - n3 - 2, 17);
        graphics.setColor(14803395);
        graphics.fillRect(0, n4 + 2, screenWidth * n / n2, 2);
    }

    void AquaLoadingCB_block(Graphics graphics, int n, int n2) {
        AquaCanvas.drawBlocks(graphics);
        graphics.setFont(FONT_BOLD);
        int n3 = FONT_BOLD.getHeight();
        int n4 = screenHeight + n3 >> 1;
        AquaCanvas.drawTextCenterShadow(graphics, GameData.get(0), n4 - n3 - 2, FONT_BOLD);
        graphics.setColor(0xFFFF00);
        graphics.fillRect(0, n4 + 2, screenWidth * n / n2, 2);
    }

    public static void drawTextCenterShadow3(Graphics graphics, String string, int n, Font font) {
        if (string != null) {
            graphics.setColor(0);
            int n2 = screenWidth - font.stringWidth(string) >> 1;
            graphics.drawString(string, n2 + 1, n + 1, 20);
            graphics.setColor(0xFF0000);
            graphics.drawString(string, n2, n, 20);
        }
    }

    public static void drawTextCenterShadow2(Graphics graphics, String string, int n, Font font) {
        if (string != null) {
            graphics.setColor(0xFFFFFF);
            int n2 = screenWidth - font.stringWidth(string) >> 1;
            graphics.drawString(string, n2 + 1, n + 1, 20);
            graphics.setColor(0);
            graphics.drawString(string, n2, n, 20);
        }
    }

    public static void drawTextCenterShadow(Graphics graphics, String string, int n, Font font) {
        if (string != null) {
            graphics.setColor(0);
            int n2 = screenWidth - font.stringWidth(string) >> 1;
            graphics.drawString(string, n2 + 1, n + 1, 20);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(string, n2, n, 20);
        }
    }

    public static void drawTextCenterShadow4(Graphics graphics, String string, int n, Font font) {
        if (string != null) {
            graphics.setColor(0);
            int n2 = screenWidth - font.stringWidth(string) >> 1;
            graphics.drawString(string, n2 + 1, n + 1, 20);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(string, n2, n, 20);
        }
    }

    public static void drawTextShadow(Graphics graphics, String string, int n, int n2, Font font) {
        if (string != null) {
            graphics.setColor(0);
            graphics.drawString(string, n + 1, n2 + 1, 20);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(string, n, n2, 20);
        }
    }

    public static boolean initMenu() {
        return AquaCanvas.menu_init(0);
    }

    public static void exitMenu() {
    }

    public static boolean initGame() {
        SoundManager.stop();
        rsc_hud.obtainResource();
        rsc_max.obtainResource();
        rsc_ns.obtainResource();
        rsc_angle.obtainResource();
        rsc_s.obtainResource();
        rsc_slast.obtainResource();
        rsc_scur.obtainResource();
        rsc_pickup.obtainResource();
        rsc_expl.obtainResource();
        rsc_smoke.obtainResource();
        rsc_extra.obtainResource();
        rsc_line2.obtainResource();
        rsc_line.obtainResource();
        rsc_manga.obtainResource();
        pe_explosions.setGraphics(AquaCanvas.rsc_expl.images);
        pe_explosions2.setGraphics(AquaCanvas.rsc_expl.images);
        pe_smoke.setGraphics(AquaCanvas.rsc_smoke.images);
        pe_psmoke.setGraphics(AquaCanvas.rsc_expl.images);
        pe_extra_0.setGraphics(AquaCanvas.rsc_extra.images);
        pe_extra_1.setGraphics(AquaCanvas.rsc_extra.images);
        pe_extra_2.setGraphics(AquaCanvas.rsc_extra.images);
        AquaCanvas.pe_extra_1.frameToUse = 1;
        AquaCanvas.pe_extra_2.frameToUse = 2;
        if (playerType == 1) {
            rsc_shadow.obtainResource();
            rsc_light.obtainResource();
            mangaImage = rsc_sfry;
        } else if (playerType == 2) {
            mangaImage = rsc_smeat;
        } else if (playerType == 0) {
            mangaImage = rsc_smaster;
        }
        mangaImage.obtainResource();
        return true;
    }

    public static void exitGame() {
        paused = false;
        rsc_shadow.releaseResource();
        rsc_light.releaseResource();
        AquaCanvas.pe_reset();
        PhysicsEngine.reset();
    }

    public static boolean startLevel(int n) {
        player_speed = 0;
        player_maxSpeed = 255;
        player_angle = 45;
        angleDir = 1;
        projectile_distance = 0;
        pickupVisible = false;
        simuShouldStop = true;
        AquaPlayer.delete();
        AquaPlayer.createPlayer(playerType);
        levelUnlocked = false;
        lastSmokeTime = 0;
        AquaCanvas.pe_reset();
        PhysicsEngine.reset();
        return AquaLevel.createLevel(n);
    }

    public static boolean getPrefs() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)AQUA_PARAMS_NAME, (boolean)true);
            if (recordStore.getNumRecords() != 1) {
                recordStore.closeRecordStore();
                AquaCanvas.erasePrefs();
                if (!AquaCanvas.writePrefs()) {
                    return false;
                }
            } else {
                byte[] byArray = recordStore.getRecord(1);
                recordStore.closeRecordStore();
                recordStore = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                GameMIDletAQUA.canSubmitScore = dataInputStream.readBoolean();
                soundEnabled = dataInputStream.readBoolean();
                maxLevel = dataInputStream.readInt();
                m_totalScore = 0;
                for (int i = 0; i < 16; ++i) {
                    AquaCanvas.scores[i] = dataInputStream.readInt();
                    m_totalScore += scores[i];
                }
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            return false;
        }
        SoundManager.setSound(soundEnabled);
        return true;
    }

    public static boolean writePrefs() {
        int n = 0;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(70);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(GameMIDletAQUA.canSubmitScore);
            dataOutputStream.writeBoolean(soundEnabled);
            dataOutputStream.writeInt(maxLevel);
            m_totalScore = 0;
            for (int i = 0; i < 16; ++i) {
                dataOutputStream.writeInt(scores[i]);
                m_totalScore += scores[i];
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream = null;
            RecordStore recordStore = RecordStore.openRecordStore((String)AQUA_PARAMS_NAME, (boolean)true);
            if (recordStore.getNumRecords() < 1) {
                n = recordStore.addRecord(byArray, 0, 70);
            } else {
                recordStore.setRecord(1, byArray, 0, 70);
                n = 1;
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n == 1;
    }

    public static void erasePrefs() {
        try {
            RecordStore.deleteRecordStore((String)AQUA_PARAMS_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void unlockNextLevel() {
        ++maxLevel;
        ++selectedLevel;
        levelUnlocked = true;
    }

    public static boolean shouldUnlock() {
        if (!AquaLevel.success) {
            return false;
        }
        int n = AquaLevel.index + 1;
        if (n > maxLevel && n < 16) {
            return !DEMO_MODE || n != 3;
        }
        return false;
    }

    public static boolean isHighScore() {
        return AquaLevel.score_total > scores[AquaLevel.index];
    }

    public static boolean writeScore() {
        if (AquaLevel.score_total > scores[AquaLevel.index]) {
            AquaCanvas.scores[AquaLevel.index] = AquaLevel.score_total;
            GameMIDletAQUA.canSubmitScore = true;
        }
        return AquaCanvas.writePrefs();
    }

    public static boolean tickGame(int n) {
        int n2;
        int n3;
        int n4 = m_keyPressed;
        if (paused || (n4 & 0x48000) != 0) {
            paused = true;
            AquaCanvas.freeKeyBuffer();
            AquaCanvas.setStatus(8);
            SoundManager.stop();
            return AquaCanvas.menu_init(1);
        }
        if (gameStatus == 1024) {
            AquaLevel.score_distance = projectile_distance >> 11;
            AquaLevel.score_total = AquaLevel.score_damage + AquaLevel.score_distance + AquaLevel.score_stars;
            if (AquaLevel.success_distance != 0 && AquaLevel.score_total >= AquaLevel.success_distance) {
                AquaLevel.success = true;
            }
            end2_status = 0;
            manga_time = time_game;
            gameStatus = 2048;
            mangaStatus = 0;
            mangaLayerVisible = false;
            n3 = 43;
            if (playerType == 1) {
                n3 = 65;
            } else if (playerType == 2) {
                n3 = 54;
            }
            if (AquaLevel.success) {
                n2 = AquaCanvas.RNDnext() % 5;
            } else {
                n3 += 5;
                n2 = AquaCanvas.RNDnext() % 6;
            }
            mangaTaunt = GameData.get(n3 + n2);
        }
        if (gameStatus == 2048) {
            if (end2_status == 1) {
                if ((selectedLevel == 1 || selectedLevel == 7 || selectedLevel == 13) && AquaLevel.success) {
                    if (time_game - manga_time > 14800) {
                        lastLongBlinkTime = time_game;
                        lastLongVisible = false;
                        score_current = 0;
                        score_max = 0;
                        score_total = 0;
                        score_status = -1;
                        score_time = time_game;
                        end2_status = 2;
                    }
                } else {
                    lastLongBlinkTime = time_game;
                    lastLongVisible = false;
                    score_current = 0;
                    score_max = 0;
                    score_total = 0;
                    score_status = -1;
                    score_time = time_game;
                    end2_status = 2;
                }
            }
            if (end2_status == 2) {
                time_game += 50;
                if (score_status == -1) {
                    score_status = 0;
                    score_max = AquaLevel.score_distance;
                    score_current = 0;
                    score_time = time_game;
                } else if (score_status == 3) {
                    if (time_game - lastLongBlinkTime > 500) {
                        lastLongBlinkTime = time_game;
                        lastLongVisible = !lastLongVisible;
                    }
                    score_total = AquaLevel.score_total;
                    if ((n4 & 0x20010) != 0) {
                        AquaCanvas.freeKeyBuffer();
                        if (AquaLevel.index == 2 && jad_demo_1) {
                            AquaCanvas.freeKeyBuffer();
                            AquaCanvas.setStatus(8);
                            return AquaCanvas.menu_init(19);
                        }
                        if (AquaCanvas.shouldUnlock()) {
                            score_time = time_game;
                            AquaCanvas.unlockNextLevel();
                            AquaCanvas.setStatus(256);
                        } else {
                            AquaCanvas.setStatus(128);
                        }
                        return AquaCanvas.writeScore();
                    }
                } else if (score_status != 3) {
                    if ((n4 & 0x20010) != 0) {
                        AquaCanvas.freeKeyBuffer();
                        score_time = time_game;
                        score_status = 3;
                        return true;
                    }
                    if (time_game - score_time > 500) {
                        n3 = 5;
                        if (score_current + n3 > score_max) {
                            n3 = score_max - score_current;
                        }
                        score_total += n3;
                        if ((score_current += n3) == score_max && score_max != 0) {
                            score_time = time_game;
                            score_current = 0;
                            score_max = 0;
                        } else if (score_current == score_max) {
                            score_time = time_game;
                            if (score_status == 0) {
                                score_status = 1;
                                score_max = AquaLevel.score_stars;
                                score_current = 0;
                            } else if (score_status == 1) {
                                score_status = 2;
                                score_max = AquaLevel.score_damage;
                                score_current = 0;
                            } else if (score_status == 2) {
                                score_status = 3;
                                score_current = 0;
                                score_max = 0;
                                score_time = time_game;
                            }
                        }
                    }
                }
            }
        }
        if (cheatsEnabled && (n4 & 0x10000) != 0) {
            if (AquaLevel.index == 2 && jad_demo_1) {
                AquaCanvas.freeKeyBuffer();
                AquaCanvas.setStatus(8);
                return AquaCanvas.menu_init(19);
            }
            AquaCanvas.freeKeyBuffer();
            AquaLevel.success = true;
            if (AquaCanvas.shouldUnlock()) {
                AquaCanvas.unlockNextLevel();
                AquaCanvas.setStatus(256);
            } else {
                AquaCanvas.setStatus(128);
            }
            return true;
        }
        if (gameStatus == 2) {
            if ((n4 & 0x10) != 0) {
                gameStatus = 8;
            }
            AquaCanvas.freeKeyBuffer();
            return true;
        }
        if (gameStatus == 4) {
            target_pos -= 4;
            if (!target_camDone) {
                AquaCanvas.target_cam.x -= 4000;
                AquaCanvas.target_cam.y -= 2000;
                if (AquaCanvas.target_cam.y < 0) {
                    AquaCanvas.target_cam.y = 0;
                }
                if (AquaCanvas.target_cam.x < AquaLevel.projectile.pos.x) {
                    AquaCanvas.target_cam.x = AquaLevel.projectile.pos.x;
                    target_camDone = true;
                }
            }
            if ((n4 & 0x10) != 0 || target_pos < target_dest && target_camDone) {
                AquaLevel.cam_setFocusedObject(AquaPlayer.pos);
                AquaLevel.cam_recenter = false;
                if (!AquaLevel.cam_tick()) {
                    return false;
                }
                time_game = 0;
                gameStatus = 2;
            }
            AquaCanvas.freeKeyBuffer();
            return AquaLevel.cam_tick();
        }
        if (gameStatus == 32 || gameStatus == 2048 && end2_status == 0) {
            boolean bl;
            int n5;
            int n6;
            if ((selectedLevel == 1 || selectedLevel == 7 || selectedLevel == 13) && AquaLevel.success) {
                if (time_game - manga_time > 10800) {
                    n3 = rsc_manga.getData().getHeight();
                    n2 = mangaImage.getData().getWidth();
                    n6 = 0;
                    if ((n4 & 0x10) != 0 && gameStatus == 2048) {
                        AquaCanvas.freeKeyBuffer();
                        end2_status = 1;
                        mangaHeight = 0;
                        mangaTauntPos = screenWidth << 1;
                    }
                    switch (mangaStatus) {
                        case 0: {
                            mangaWidth = screenWidth;
                            mangaHeight = 0;
                            mangaStatus = 1;
                            mangaPos = -n2 - 1;
                            mangaSpeed = 20;
                            mangaTauntPos = screenWidth;
                            for (n5 = 0; n5 < 5; ++n5) {
                                AquaCanvas.mangaParticlesType[n5] = AquaCanvas.RNDnext() % 2;
                                mangaParticles[n5].init(AquaCanvas.RNDnext() % screenWidth, AquaCanvas.RNDnext() % n3);
                                mangaParticlesSpeed[n5].init(-5 - AquaCanvas.RNDnext() % 10, 0);
                            }
                            break;
                        }
                        case 1: {
                            if (mangaHeight == n3 && mangaWidth == screenWidth) {
                                mangaStatus = 2;
                            }
                            mangaHeight += 10;
                            mangaWidth += 10;
                            break;
                        }
                        case 2: {
                            mangaPos += mangaSpeed;
                            mangaSpeed -= mangaSpeed >> 1;
                            if (mangaSpeed <= 0) {
                                mangaSpeed = 1;
                            }
                            if (mangaPos <= 0) break;
                            mangaPos = 0;
                            mangaTime = time_game;
                            if (gameStatus == 2048) {
                                mangaStatus = 5;
                                break;
                            }
                            mangaStatus = 3;
                            break;
                        }
                        case 5: {
                            n6 = FONT_NORMAL.stringWidth(mangaTaunt);
                            if ((mangaTauntPos -= 4) >= -n6) break;
                            mangaStatus = 4;
                            break;
                        }
                        case 3: {
                            if (time_game - mangaTime <= 1000) break;
                            mangaStatus = 4;
                            break;
                        }
                        case 4: {
                            if ((mangaHeight -= 10) >= 0) break;
                            mangaHeight = 0;
                            if (gameStatus != 2048) {
                                AquaCanvas.startLaunch();
                                return true;
                            }
                            end2_status = 1;
                        }
                    }
                    for (n5 = 0; n5 < 5; ++n5) {
                        bl = false;
                        mangaParticles[n5].addEqual(mangaParticlesSpeed[n5]);
                        if (mangaParticlesType[n5] == 0 && AquaCanvas.mangaParticles[n5].x < -rsc_line.getData().getWidth()) {
                            bl = true;
                        } else if (mangaParticlesType[n5] == 1 && AquaCanvas.mangaParticles[n5].x < -rsc_line2.getData().getWidth()) {
                            bl = true;
                        }
                        if (!bl) continue;
                        AquaCanvas.mangaParticlesType[n5] = AquaCanvas.RNDnext() % 2;
                        mangaParticles[n5].init(screenWidth, AquaCanvas.RNDnext() % n3);
                        mangaParticlesSpeed[n5].init(-5 - AquaCanvas.RNDnext() % 15, 0);
                    }
                    if (mangaWidth < 0) {
                        mangaWidth = 0;
                    }
                    if (mangaHeight < 0) {
                        mangaHeight = 0;
                    }
                    if (mangaHeight > n3) {
                        mangaHeight = n3;
                    }
                    if (mangaWidth > screenWidth) {
                        mangaWidth = screenWidth;
                    }
                }
            } else {
                n3 = rsc_manga.getData().getHeight();
                n2 = mangaImage.getData().getWidth();
                n6 = 0;
                if ((n4 & 0x10) != 0 && gameStatus == 2048) {
                    AquaCanvas.freeKeyBuffer();
                    end2_status = 1;
                    mangaHeight = 0;
                    mangaTauntPos = screenWidth << 1;
                }
                switch (mangaStatus) {
                    case 0: {
                        mangaWidth = screenWidth;
                        mangaHeight = 0;
                        mangaStatus = 1;
                        mangaPos = -n2 - 1;
                        mangaSpeed = 20;
                        mangaTauntPos = screenWidth;
                        for (n5 = 0; n5 < 5; ++n5) {
                            AquaCanvas.mangaParticlesType[n5] = AquaCanvas.RNDnext() % 2;
                            mangaParticles[n5].init(AquaCanvas.RNDnext() % screenWidth, AquaCanvas.RNDnext() % n3);
                            mangaParticlesSpeed[n5].init(-5 - AquaCanvas.RNDnext() % 10, 0);
                        }
                        break;
                    }
                    case 1: {
                        if (mangaHeight == n3 && mangaWidth == screenWidth) {
                            mangaStatus = 2;
                        }
                        mangaHeight += 10;
                        mangaWidth += 10;
                        break;
                    }
                    case 2: {
                        mangaPos += mangaSpeed;
                        mangaSpeed -= mangaSpeed >> 1;
                        if (mangaSpeed <= 0) {
                            mangaSpeed = 1;
                        }
                        if (mangaPos <= 0) break;
                        mangaPos = 0;
                        mangaTime = time_game;
                        if (gameStatus == 2048) {
                            mangaStatus = 5;
                            break;
                        }
                        mangaStatus = 3;
                        break;
                    }
                    case 5: {
                        n6 = FONT_NORMAL.stringWidth(mangaTaunt);
                        if ((mangaTauntPos -= 4) >= -n6) break;
                        mangaStatus = 4;
                        break;
                    }
                    case 3: {
                        if (time_game - mangaTime <= 1000) break;
                        mangaStatus = 4;
                        break;
                    }
                    case 4: {
                        if ((mangaHeight -= 10) >= 0) break;
                        mangaHeight = 0;
                        if (gameStatus != 2048) {
                            AquaCanvas.startLaunch();
                            return true;
                        }
                        end2_status = 1;
                    }
                }
                for (n5 = 0; n5 < 5; ++n5) {
                    bl = false;
                    mangaParticles[n5].addEqual(mangaParticlesSpeed[n5]);
                    if (mangaParticlesType[n5] == 0 && AquaCanvas.mangaParticles[n5].x < -rsc_line.getData().getWidth()) {
                        bl = true;
                    } else if (mangaParticlesType[n5] == 1 && AquaCanvas.mangaParticles[n5].x < -rsc_line2.getData().getWidth()) {
                        bl = true;
                    }
                    if (!bl) continue;
                    AquaCanvas.mangaParticlesType[n5] = AquaCanvas.RNDnext() % 2;
                    mangaParticles[n5].init(screenWidth, AquaCanvas.RNDnext() % n3);
                    mangaParticlesSpeed[n5].init(-5 - AquaCanvas.RNDnext() % 15, 0);
                }
                if (mangaWidth < 0) {
                    mangaWidth = 0;
                }
                if (mangaHeight < 0) {
                    mangaHeight = 0;
                }
                if (mangaHeight > n3) {
                    mangaHeight = n3;
                }
                if (mangaWidth > screenWidth) {
                    mangaWidth = screenWidth;
                }
            }
        }
        if (gameStatus == 128) {
            pe_explosions.updatePhysics();
            pe_explosions2.updatePhysics();
            Vector2D vector2D = tempV1.init(AquaCanvas.RNDnextSigned(), AquaCanvas.RNDnextSigned());
            vector2D.addEqual(projectileStartPoint);
            Vector2D vector2D2 = tempV2.init(AquaCanvas.RNDnext(), AquaCanvas.RNDnext());
            vector2D2.normalize();
            vector2D2.mulEqual(5 + AquaCanvas.RNDnext() % 3 << 10);
            pe_explosions.addParticle(vector2D, vector2D2);
            if (time_game - launchTime > 150) {
                AquaLevel.cam_setFocusedObject(AquaLevel.projectile.pos);
                AquaLevel.cam_recenter = false;
                SoundManager.play(131075);
                gameStatus = 256;
                return true;
            }
        }
        time_game += 50;
        if (gameStatus == 16) {
            pickupVisible = false;
            int n7 = player_speed * 10 / player_maxSpeed;
            player_angle += angleDir * ++n7;
            player_angle += AquaCanvas.RNDnext() % 2;
            AquaCanvas.checkAngle();
            if (time_game - lastAngleTime < 500) {
                AquaCanvas.freeKeyBuffer();
            } else if ((n4 & 0x10) != 0) {
                player_angle += AquaCanvas.RNDnext256() % AquaPlayer.angleDiff - (AquaPlayer.angleDiff >> 1);
                AquaCanvas.checkAngle();
                AquaCanvas.freeKeyBuffer();
                mangaStatus = 0;
                mangaLayerVisible = true;
                mangaNewText = AquaCanvas.RNDnext256() % 6;
                if (player_speed * 100 / AquaPlayer.maxSpeed > 80) {
                    gameStatus = 32;
                } else {
                    AquaCanvas.startLaunch();
                }
            }
            return true;
        }
        if (gameStatus == 8 || gameStatus == 64 || gameStatus == 256) {
            if (!AquaPlayer.tick()) {
                return false;
            }
            AquaCanvas.freeKeyBuffer();
        }
        if (gameStatus == 8 || gameStatus == 256 || gameStatus == 64 || gameStatus == 2048) {
            pe_smoke.updatePhysics();
            pe_psmoke.updatePhysics();
            pe_extra_0.updatePhysics();
            pe_extra_1.updatePhysics();
            pe_extra_2.updatePhysics();
        }
        if (gameStatus == 256 || gameStatus == 2048) {
            if ((gameStatus == 256 || gameStatus == 2048 && !simuShouldStop) && !PhysicsEngine.simulate(200)) {
                return false;
            }
            projectile_distance = AquaLevel.projectile.pos.x - AquaCanvas.projectileStartPoint.x >> 3;
            if (projectile_distance < 0) {
                projectile_distance = 0;
            }
            if (gameStatus == 256 && time_game - lastSmokeTime > 400 && AquaLevel.projectile.vel.lengthSqr() > 4000000) {
                lastSmokeTime = time_game;
                Vector2D vector2D = tempV1.init(AquaLevel.projectile.vel);
                vector2D.x >>= 11;
                vector2D.y >>= 11;
                pe_psmoke.addParticle(AquaLevel.projectile.pos, vector2D);
            }
            pe_particles.updatePhysics();
            pe_explosions.updatePhysics();
            pe_explosions2.updatePhysics();
            for (int i = 0; i < numAquaObjects; ++i) {
                vGfx[i].tick();
            }
            if (AquaLevel.projectile.visible && AquaLevel.projectile.pos.y < 3000 && AquaLevel.projectile.vel.lengthSqr() < 1024) {
                if (gameStatus != 2048) {
                    AquaCanvas.freeKeyBuffer();
                    gameStatus = 1024;
                }
                simuShouldStop = true;
            }
        }
        return AquaLevel.cam_tick();
    }

    public static void startLaunch() {
        impactSpeed = player_speed;
        AquaPlayer.speed = 0;
        AquaPlayer.setToAttack();
        AquaPlayer.lastAnimeTime = time_game + 50;
        gameStatus = 64;
    }

    public static void drawManga(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        Image image = rsc_manga.getData();
        int n5 = screenHalfWidth;
        int n6 = screenHeight - (screenHeight >> 1) >> 1;
        if (n6 >> 1 < (image.getHeight() >> 1) + 10) {
            n6 = 10 + (image.getHeight() >> 1) << 1;
        }
        graphics.setClip(n5 - (mangaWidth >> 1), (n6 += 0) - (mangaHeight >> 1), mangaWidth, mangaHeight);
        int n7 = n6 - (image.getHeight() >> 1);
        int n8 = image.getWidth();
        for (int i = 0; i < screenWidth; i += n8) {
            graphics.drawImage(image, i, n7, 20);
        }
        Image image2 = rsc_line.getData();
        Image image3 = rsc_line2.getData();
        if (mangaLayerVisible) {
            int n9;
            for (n9 = 0; n9 < 5; ++n9) {
                if (mangaParticlesType[n9] != 0) {
                    graphics.drawImage(image3, AquaCanvas.mangaParticles[n9].x, n7 + AquaCanvas.mangaParticles[n9].y, 20);
                    continue;
                }
                graphics.drawImage(image2, AquaCanvas.mangaParticles[n9].x, n7 + AquaCanvas.mangaParticles[n9].y, 20);
            }
            if (mangaStatus == 3) {
                graphics.setFont(FONT_NORMAL);
                graphics.setColor(0);
                n9 = FONT_NORMAL.getHeight();
                String string = GameData.get(114 + mangaNewText);
                graphics.drawString(string, mangaImage.getData().getWidth() + 5, n7 + (image.getHeight() - n9 >> 1) + 0, 20);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(string, mangaImage.getData().getWidth() + 5 - 1, n7 + (image.getHeight() - n9 >> 1) - 1 + 0, 20);
            }
        } else {
            graphics.setFont(FONT_NORMAL);
            graphics.setColor(0xFFFFFF);
            int n10 = FONT_NORMAL.getHeight();
            graphics.drawString(mangaTaunt, mangaTauntPos, n7 + (image.getHeight() - n10 >> 1) + 0, 20);
        }
        graphics.drawImage(mangaImage.getData(), mangaPos, n7, 20);
        graphics.setClip(n, n2, n3, n4);
    }

    public static void checkAngle() {
        int n = 90 - player_angle;
        if (n <= 0) {
            player_angle += n;
            angleDir = -1;
        }
        if (player_angle <= 0) {
            player_angle = -player_angle;
            angleDir = 1;
        }
    }

    public static void triggerLaunch() {
        gameStatus = 128;
        launchTime = time_game;
        projectileStartPoint.init(AquaLevel.projectile.pos);
        Vector2D vector2D = tempV1;
        PMaths.pInitUnitVector(vector2D, player_angle);
        vector2D.mulEqual(impactSpeed * (AquaPlayer.force + 5) * 100 / (AquaLevel.projectile.mass >> 10));
        AquaLevel.projectile.vel.init(vector2D);
        AquaLevel.projectile.damage(vector2D.lengthSqr());
        for (int i = 10; i > 0; --i) {
            Vector2D vector2D2 = tempV1.init(AquaCanvas.RNDnextSigned(), AquaCanvas.RNDnextSigned());
            vector2D2.addEqual(projectileStartPoint);
            Vector2D vector2D3 = tempV2.init(AquaCanvas.RNDnext(), AquaCanvas.RNDnext());
            vector2D3.normalize();
            vector2D3.mulEqual(5 + AquaCanvas.RNDnext() % 3 << 10);
            pe_explosions.addParticle(vector2D2, vector2D3);
        }
    }

    public static void pe_reset() {
        pe_explosions2.removeAllParticles();
        pe_explosions.removeAllParticles();
        pe_particles.removeAllParticles();
        pe_smoke.removeAllParticles();
        pe_psmoke.removeAllParticles();
        pe_extra_0.removeAllParticles();
        pe_extra_1.removeAllParticles();
        pe_extra_2.removeAllParticles();
    }

    public static void paintSoftkeys(Graphics graphics) {
        int n = screenWidth;
        int n2 = screenHeightMenu + 1;
        int n3 = FONT_NORMAL.getHeight() + 4;
        if (status == 16 || status == 32 || status == 64) {
            if (fadeDownY > 20) {
                n2 += fadeDownY - 20;
            }
            if (n2 > screenHeight) {
                return;
            }
            ++fadeDownY;
            forceRepaintHUD = true;
        }
        graphics.setClip(0, n2, n, n3);
        if (status != 16 && status != 32 && status != 64) {
            graphics.setColor(0);
            graphics.fillRect(0, n2, n, 2);
        }
        graphics.setColor(31681);
        graphics.fillRect(0, n2 += 2, n, n3);
        String string = null;
        String string2 = null;
        if (cmdLeft != null) {
            string = cmdLeft.getLabel();
        }
        if (cmdRight != null) {
            string2 = cmdRight.getLabel();
        }
        graphics.setFont(FONT_NORMAL);
        graphics.setColor(0xFFFFFF);
        if (string != null) {
            graphics.drawString(string, 2, n2 + 1, 20);
        }
        if (string2 != null) {
            graphics.drawString(string2, screenWidth - 2, n2 + 1, 24);
        }
    }

    public void addCommand(Command command) {
        if (command != null) {
            int n = command.getPriority();
            if (n == 1) {
                cmdLeft = command;
            } else if (n == 2) {
                cmdRight = command;
            }
        }
    }

    public void removeCommand(Command command) {
        if (cmdLeft == command) {
            cmdLeft = null;
        }
        if (cmdRight == command) {
            cmdRight = null;
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        listener = commandListener;
    }

    private static boolean handleSoftkeys(int n, Displayable displayable) {
        Command command = null;
        switch (n) {
            case -202: 
            case -20: 
            case -6: 
            case 20: {
                command = cmdLeft;
                break;
            }
            case -203: 
            case -21: 
            case -7: 
            case 21: {
                command = cmdRight;
            }
        }
        if (command != null) {
            listener.commandAction(command, displayable);
            return true;
        }
        return false;
    }

    public static void initCommands() {
        m_positivePriority = GameMIDletAQUA.m_invertSoftkeys ? 2 : 1;
        m_negativePriority = GameMIDletAQUA.m_invertSoftkeys ? 1 : 2;
    }

    public void commandAction(Command command, Displayable displayable) {
        int n = command.getPriority();
        int n2 = 0;
        if (n == m_positivePriority) {
            n2 = 131072;
        } else if (n == m_negativePriority) {
            n2 = 262144;
        }
        m_keyPressed |= n2;
    }

    public static void menu_gfree() {
        AMenu.tmp = null;
        AMenu.about = null;
        AMenu.instructions2 = null;
        AMenu.instructions1 = null;
    }

    public static boolean menu_ginit() {
        byte[] byArray = new byte[14];
        int n = 0;
        if (GameMIDletAQUA.ms_demoMode == 1) {
            jad_demo_1 = true;
        } else if (GameMIDletAQUA.ms_demoMode == 2) {
            jad_demo_2 = true;
        }
        if (GameMIDletAQUA.ms_upSell == 1) {
            jad_upsell_1 = true;
        } else if (GameMIDletAQUA.ms_upSell == 2) {
            jad_upsell_2 = true;
        }
        if (jad_demo_1 || jad_demo_2) {
            if (jad_demo_2) {
                DEMO_MODE = true;
                byArray[n] = 127;
                byArray[++n] = 126;
            } else {
                DEMO_MODE = true;
                if (jad_upsell_1 || jad_upsell_2) {
                    byArray[n] = 124;
                    byArray[++n] = 126;
                } else {
                    byArray[n] = 126;
                }
            }
        } else if (jad_upsell_1 || jad_upsell_2) {
            byArray[n] = 124;
            byArray[++n] = 25;
        } else if (!(jad_demo_1 || jad_demo_2 || jad_upsell_1 || jad_upsell_2)) {
            byArray[n] = 25;
        }
        byArray[++n] = 34;
        byArray[++n] = 29;
        byArray[++n] = 26;
        if (GameMIDletAQUA.m_enableCheats) {
            byArray[++n] = 120;
        }
        byArray[++n] = 17;
        byArray[++n] = 16;
        byArray[++n] = 32;
        byArray[++n] = -1;
        i_main = new byte[n + 1];
        System.arraycopy(byArray, 0, i_main, 0, n + 1);
        n = 0;
        byArray[n] = 35;
        byArray[++n] = 31;
        byArray[++n] = jad_demo_1 || jad_demo_2 ? 126 : 25;
        byArray[++n] = 34;
        byArray[++n] = 29;
        if (GameMIDletAQUA.m_enableCheats) {
            byArray[++n] = 120;
        }
        byArray[++n] = 26;
        byArray[++n] = 17;
        byArray[++n] = 16;
        byArray[++n] = 32;
        byArray[++n] = -1;
        i_mainingame = new byte[n + 1];
        System.arraycopy(byArray, 0, i_mainingame, 0, n + 1);
        AMenu.lineWidth = screenWidth - 20;
        AMenu.fh = FONT_NORMAL.getHeight() + 2;
        AMenu.topBorder = AMenu.fh + 8 + rsc_up.getData().getHeight();
        int n2 = screenHeightMenu - AMenu.topBorder - rsc_down.getData().getHeight();
        AMenu.linesPerPage = n2 / (AMenu.fh + 2 + 8);
        if (AMenu.linesPerPage <= 0) {
            AMenu.linesPerPage = 1;
        }
        String[] stringArray = new String[]{GameMIDletAQUA.getMIDletVersion(), "\u00a9", "\u00a9", "$Name:  $", String.valueOf(GameMIDletAQUA.m_deviceId)};
        AMenu.instructions1 = AquaCanvas.wrapText(GameData.get(7), AMenu.lineWidth, FONT_NORMAL);
        GameData.text[7] = null;
        AMenu.instructions2 = AquaCanvas.wrapText(GameData.get(8), AMenu.lineWidth, FONT_NORMAL);
        GameData.text[8] = null;
        AMenu.about = AquaCanvas.wrapText(GameData.get(12, stringArray), AMenu.lineWidth, FONT_NORMAL);
        GameData.text[12] = null;
        AMenu.areyousure = AquaCanvas.wrapText(GameData.get(123), AMenu.lineWidth, FONT_NORMAL);
        GameData.text[123] = null;
        AMenu.upsell_1_text = AquaCanvas.wrapText(GameData.get(125, stringArray), AMenu.lineWidth, FONT_NORMAL);
        GameData.text[125] = null;
        AMenu.demo_1_text = AquaCanvas.wrapText(GameData.get(125, stringArray), AMenu.lineWidth, FONT_NORMAL);
        GameData.text[125] = null;
        AMenu.upsell_2_text = AquaCanvas.wrapText(GameData.get(125, stringArray), AMenu.lineWidth, FONT_NORMAL);
        GameData.text[125] = null;
        AMenu.demo_2_text = AquaCanvas.wrapText(GameData.get(132, stringArray), AMenu.lineWidth, FONT_NORMAL);
        GameData.text[132] = null;
        AMenu.get_the_game_text = AquaCanvas.wrapText(GameData.get(112, stringArray), AMenu.lineWidth, FONT_NORMAL);
        GameData.text[112] = null;
        return true;
    }

    public static boolean menu_init(int n) {
        int n2;
        m_keyPressed = 0;
        fadeDownY = 0;
        if (!GameMIDletAQUA.multiLang) {
            if (!AMenu.initialized) {
                if (!AquaCanvas.menu_ginit()) {
                    // empty if block
                }
                AMenu.initialized = true;
            }
        } else {
            AMenu.lineWidth = screenWidth - 20;
            AMenu.fh = FONT_NORMAL.getHeight() + 2;
            AMenu.topBorder = AMenu.fh + 8 + rsc_up.getData().getHeight();
            n2 = screenHeightMenu - AMenu.topBorder - rsc_down.getData().getHeight();
            AMenu.linesPerPage = n2 / (AMenu.fh + 2 + 8);
            if (AMenu.linesPerPage <= 0) {
                AMenu.linesPerPage = 1;
            }
        }
        AMenu.gotBack = true;
        AMenu.currentIndex = 0;
        AMenu.curList = null;
        AMenu.items = null;
        if (n != AMenu.currentMenu) {
            AMenu.lastMenu = AMenu.currentMenu;
            AMenu.currentMenu = n;
        }
        n2 = 0;
        int n3 = -1;
        int n4 = -1;
        switch (n) {
            case 15: {
                AMenu.title = 0;
                AMenu.items = i_language;
                AMenu.lastMenu = -1;
                break;
            }
            case 0: {
                AMenu.title = 13;
                AMenu.items = i_main;
                AMenu.lastMenu = -1;
                n3 = 5;
                break;
            }
            case 1: {
                AMenu.title = 13;
                AMenu.items = i_mainingame;
                AMenu.lastMenu = -1;
                n3 = 5;
                break;
            }
            case 2: {
                AMenu.lastMenu = 0;
                AMenu.title = 14;
                AMenu.items = i_selplayer;
                n3 = 5;
                n4 = 33;
                break;
            }
            case 3: {
                AMenu.lastMenu = 2;
                AMenu.title = 15;
                int n5 = maxLevel;
                AMenu.tmpItemsForLevel = null;
                AMenu.tmpItemsForLevel = new byte[n5 + 2];
                for (n2 = 0; n2 <= n5; ++n2) {
                    AMenu.tmpItemsForLevel[n2] = (byte)(76 + n2);
                }
                AMenu.items = AMenu.tmpItemsForLevel;
                n3 = 5;
                n4 = 33;
                break;
            }
            case 4: {
                AMenu.title = 16;
                AMenu.gotBack = false;
                AMenu.curList = AMenu.about;
                n4 = 33;
                break;
            }
            case 16: {
                try {
                    GameMIDletAQUA.m_instance.platformRequest(GameMIDletAQUA.ms_demoUrl);
                }
                catch (Exception exception) {
                }
                GameMIDletAQUA.m_instance.quitApp();
                break;
            }
            case 17: {
                AMenu.title = 132;
                AMenu.gotBack = false;
                AMenu.curList = AMenu.get_the_game_text;
                n3 = 5;
                n4 = 33;
                break;
            }
            case 18: {
                if (jad_upsell_1) {
                    AMenu.title = 124;
                    AMenu.gotBack = false;
                    AMenu.curList = AMenu.upsell_1_text;
                    n4 = 33;
                    break;
                }
                if (!jad_upsell_2) break;
                try {
                    GameMIDletAQUA.m_instance.platformRequest(GameMIDletAQUA.ms_upSellUrl);
                }
                catch (Exception exception) {
                }
                GameMIDletAQUA.m_instance.quitApp();
                break;
            }
            case 19: {
                AMenu.title = 125;
                AMenu.gotBack = false;
                AMenu.curList = AMenu.demo_2_text;
                AMenu.lastMenu = 0;
                n4 = 33;
                break;
            }
            case 14: {
                AMenu.title = 32;
                AMenu.gotBack = false;
                AMenu.curList = AMenu.areyousure;
                n3 = 5;
                n4 = 33;
                break;
            }
            case 6: {
                AMenu.title = 10;
                AMenu.gotBack = false;
                AMenu.curList = AMenu.instructions1;
                n4 = 33;
                break;
            }
            case 7: {
                AMenu.title = 11;
                AMenu.gotBack = false;
                AMenu.curList = AMenu.instructions2;
                n4 = 33;
                break;
            }
            case 5: {
                AMenu.lastMenu = 0;
                AMenu.title = 17;
                AMenu.items = i_help;
                n3 = 5;
                n4 = 33;
                break;
            }
            case 8: {
                AMenu.title = 26;
                AMenu.items = soundEnabled ? i_settings_on : i_settings_off;
                n3 = 5;
                n4 = 33;
                break;
            }
            case 10: {
                AMenu.title = 120;
                AMenu.items = cheatsEnabled ? i_cheats_on : i_cheats_off;
                n3 = 5;
                n4 = 33;
                break;
            }
            case 9: {
                AMenu.title = 29;
                AMenu.gotBack = false;
                AMenu.tmp = null;
                String string = GameData.get(30) + separator2 + separator1 + m_totalScore + separator2;
                for (n2 = 0; n2 < 16; ++n2) {
                    string = string + GameData.get(76 + n2) + separator2 + separator1 + scores[n2] + separator2;
                }
                AMenu.tmp = AquaCanvas.wrapText(string, AMenu.lineWidth, FONT_NORMAL);
                AMenu.curList = AMenu.tmp;
                n4 = 33;
            }
        }
        AquaCanvas.set_commands(n3, n4);
        AMenu.maxIndex = AMenu.curList != null ? AMenu.curList.length : AMenu.items.length - 1;
        if (!AMenu.gotBack) {
            AMenu.curLinesPerPage = AMenu.linesPerPage - 1;
            if (AMenu.curLinesPerPage <= 0) {
                AMenu.curLinesPerPage = 1;
            }
        } else {
            AMenu.curLinesPerPage = AMenu.linesPerPage;
        }
        if (AMenu.lastMenu == 0 && paused) {
            AMenu.lastMenu = 1;
        }
        return true;
    }

    public static void set_commands(int n, int n2) {
        if (m_instance != null) {
            if (m_cmdPositive != null) {
                m_instance.removeCommand(m_cmdPositive);
            }
            String string = n >= 0 ? GameData.get(n) : (AMenu.currentMenu == 15 ? "Ok" : " ");
            m_cmdPositive = new Command(string, 1, m_positivePriority);
            m_instance.addCommand(m_cmdPositive);
            if (m_cmdNegative != null) {
                m_instance.removeCommand(m_cmdNegative);
            }
            string = n2 >= 0 ? GameData.get(n2) : " ";
            m_cmdNegative = new Command(string, 1, m_negativePriority);
            m_instance.addCommand(m_cmdNegative);
        }
    }

    public static boolean menu_tick() {
        if (AMenu.currentMenu == -1) {
            return AquaCanvas.menu_init(0);
        }
        int n = m_keyPressed;
        m_keyPressed = 0;
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 = -1;
        } else if ((n & 2) != 0) {
            n2 = 1;
        }
        AMenu.currentIndex += n2;
        if (AMenu.currentMenu == 6 || AMenu.currentMenu == 7 || AMenu.currentMenu == 5 || AMenu.currentMenu == 9 || AMenu.currentMenu == 4 || AMenu.currentMenu == 2 || AMenu.currentMenu == 18 || AMenu.currentMenu == 19) {
            if (AMenu.currentIndex < 0) {
                AMenu.currentIndex = 0;
            }
            if (AMenu.currentIndex >= AMenu.maxIndex) {
                AMenu.currentIndex = AMenu.maxIndex - 1;
            }
        } else {
            if (AMenu.currentIndex < 0) {
                AMenu.currentIndex = AMenu.maxIndex - 1;
            }
            if (AMenu.currentIndex >= AMenu.maxIndex) {
                AMenu.currentIndex = 0;
            }
        }
        if (AMenu.currentMenu != 15 && (n & 0x40000) != 0 && AMenu.lastMenu != -1) {
            if (AMenu.currentMenu == 11 || AMenu.currentMenu == 13) {
                if (paused) {
                    return AquaCanvas.menu_init(1);
                }
                return AquaCanvas.menu_init(0);
            }
            if (AMenu.currentMenu == 12) {
                GameMIDletAQUA.m_bFetchHiScoresCancelled = true;
            }
            return AquaCanvas.menu_init(AMenu.lastMenu);
        }
        if ((n & 0x20010) != 0) {
            if (AMenu.items != null) {
                byte by = AMenu.items[AMenu.currentIndex];
                if (AMenu.currentMenu == 15) {
                    GameMIDletAQUA.initLanguage(GameMIDletAQUA.LANGUAGE_FILES[by]);
                    AquaCanvas.init();
                    AquaCanvas.initNeededTexts();
                    if (!AMenu.initialized) {
                        if (!AquaCanvas.menu_ginit()) {
                            // empty if block
                        }
                        AMenu.initialized = true;
                    }
                    total_time = 0;
                    AMenu.currentMenu = -1;
                    AquaCanvas.gotoSplash();
                    return true;
                }
                switch (by) {
                    case 34: {
                        paused = false;
                        playerType = AquaCanvas.RNDnext() % 3;
                        AquaCanvas.setStatus(16);
                        selectedLevel = maxLevel != 0 ? AquaCanvas.RNDnext() % (maxLevel + 1) : 0;
                        return true;
                    }
                    case 31: {
                        paused = false;
                        AquaCanvas.setStatus(16);
                        return true;
                    }
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: {
                        paused = false;
                        AquaCanvas.setStatus(16);
                        selectedLevel = by - 76;
                        return true;
                    }
                    case 25: {
                        return AquaCanvas.menu_init(2);
                    }
                    case 126: {
                        return AquaCanvas.menu_init(17);
                    }
                    case 127: {
                        return AquaCanvas.menu_init(16);
                    }
                    case 124: {
                        return AquaCanvas.menu_init(18);
                    }
                    case 17: {
                        return AquaCanvas.menu_init(5);
                    }
                    case 10: {
                        return AquaCanvas.menu_init(6);
                    }
                    case 11: {
                        return AquaCanvas.menu_init(7);
                    }
                    case 26: {
                        return AquaCanvas.menu_init(8);
                    }
                    case 27: 
                    case 28: {
                        soundEnabled = !soundEnabled;
                        SoundManager.setSound(soundEnabled);
                        if (soundEnabled) {
                            SoundManager.play(131075);
                        } else {
                            SoundManager.stop();
                        }
                        if (!AquaCanvas.writePrefs()) {
                            return false;
                        }
                        return AquaCanvas.menu_init(8);
                    }
                    case 121: 
                    case 122: {
                        boolean bl = cheatsEnabled = !cheatsEnabled;
                        if (!AquaCanvas.menu_init(AMenu.lastMenu)) {
                            return false;
                        }
                        return AquaCanvas.menu_init(10);
                    }
                    case 120: {
                        return AquaCanvas.menu_init(10);
                    }
                    case 29: {
                        return AquaCanvas.menu_init(9);
                    }
                    case 16: {
                        return AquaCanvas.menu_init(4);
                    }
                    case 32: {
                        return AquaCanvas.menu_init(14);
                    }
                    case 19: {
                        return AquaCanvas.menu_init(14);
                    }
                    case 35: {
                        paused = false;
                        SoundManager.stop();
                        AquaCanvas.setStatus(32);
                        return true;
                    }
                    case 37: {
                        playerType = 0;
                        return AquaCanvas.menu_init(3);
                    }
                    case 38: {
                        playerType = 1;
                        return AquaCanvas.menu_init(3);
                    }
                    case 39: {
                        playerType = 2;
                        return AquaCanvas.menu_init(3);
                    }
                    case 33: {
                        return AquaCanvas.menu_init(AMenu.lastMenu);
                    }
                }
                return true;
            }
            if (AMenu.currentMenu == 14) {
                GameMIDletAQUA.quitApp();
                return false;
            }
            if (AMenu.currentMenu == 17) {
                return AquaCanvas.menu_init(2);
            }
        }
        if ((n & 0x20) != 0 && AMenu.items == null) {
            AquaCanvas.menu_init(AMenu.lastMenu);
            return true;
        }
        return true;
    }

    public static void menu_draw(Graphics graphics) {
        boolean bl;
        int n;
        int n2;
        int n3;
        graphics.setFont(FONT_NORMAL);
        AquaCanvas.drawBlocks(graphics);
        if (AMenu.currentMenu != 15 && !AMenu.initialized) {
            return;
        }
        Image image = rsc_up.getData();
        int n4 = AMenu.topBorder - image.getHeight() - 5;
        graphics.setColor(31681);
        graphics.fillRect(0, 0, screenWidth, n4);
        graphics.setColor(0x323232);
        graphics.fillRect(0, n4, screenWidth, 2);
        graphics.setColor(0xFFFFFF);
        if (AMenu.currentMenu != 15) {
            graphics.drawString(GameData.get(AMenu.title), screenHalfWidth, (n4 - AMenu.fh >> 1) + 2, 17);
        }
        int n5 = 2;
        int n6 = AMenu.curLinesPerPage - (AMenu.items == null ? 0 : 1);
        switch (AMenu.currentMenu) {
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 17: 
            case 18: 
            case 19: {
                int n7 = n6 >> 1;
                int n8 = AMenu.currentIndex;
                n3 = AMenu.maxIndex - 1;
                n2 = n8;
                if (n8 >= n3 - n6) {
                    AMenu.currentIndex = n2 = n3 - n6;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if ((n = n2 + n6) <= n3) break;
                n = n3;
                break;
            }
            default: {
                int n7 = n6 >> 1;
                int n8 = AMenu.currentIndex;
                n3 = AMenu.maxIndex - 1;
                n2 = n8 - n7;
                if (n3 - n8 <= n7) {
                    n2 = n3 - n6;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if ((n = n2 + n6) <= n3) break;
                n = n3;
            }
        }
        int n9 = screenHeightMenu - AMenu.topBorder - image.getHeight();
        int n10 = AMenu.topBorder + n9 / 2 - AMenu.linesPerPage * (AMenu.fh + 8 + n5) / 2 + -2;
        int n11 = 8 + AMenu.fh + n5;
        int n12 = 4;
        int n13 = 0;
        int n14 = 5;
        int n15 = screenWidth - 10;
        int n16 = AMenu.fh + n5;
        boolean bl2 = n2 > 0;
        boolean bl3 = bl = n != n3;
        if (AMenu.currentMenu == 2) {
            int n17 = AMenu.currentIndex;
            String string = AMenu.items == null ? AMenu.curList[n17] : GameData.get(AMenu.items[n17]);
            int n18 = screenHeightMenu >> 1;
            if (n17 == 3) {
                graphics.setColor(0x323232);
                graphics.fillRect(n14, n18, n15 + 2, n16 + 2);
                graphics.setColor(16114176);
                graphics.fillRect(n14, n18 - n5 / 2, n15, n16);
                graphics.setColor(0xFFFFFF);
                graphics.drawRect(n14, n18 - n5 / 2, n15 - 1, n16);
                graphics.drawRect(n14 + 1, n18 - (n5 / 2 - 1), n15 - 3, n16 - 2);
                graphics.setColor(0);
                graphics.drawString(string, screenHalfWidth, n18 + 2, 17);
            } else {
                Image image2 = n17 == 0 ? rsc_smaster.getData() : (n17 == 1 ? rsc_sfry.getData() : rsc_smeat.getData());
                int n19 = image2.getHeight() + 3;
                graphics.setColor(0x323232);
                graphics.fillRect(n14, n18 -= n12 + n19 >> 1, n15 + 2, n16 + 2);
                graphics.setColor(16114176);
                graphics.fillRect(n14, n18 - n5 / 2, n15, n16);
                graphics.setColor(0xFFFFFF);
                graphics.drawRect(n14, n18 - n5 / 2, n15 - 1, n16);
                graphics.drawRect(n14 + 1, n18 - (n5 / 2 - 1), n15 - 3, n16 - 2);
                graphics.setColor(0);
                graphics.drawString(string, screenHalfWidth, n18 + 2, 17);
                int n20 = screenWidth - 10;
                graphics.setColor(39384);
                graphics.fillRect(screenWidth - n20 >> 1, n18 += 5 + n12 + n16, n20, image2.getHeight());
                graphics.drawImage(image2, screenWidth - image2.getWidth() >> 1, n18, 20);
                graphics.setColor(0);
                graphics.drawRect(screenWidth - n20 >> 1, n18, n20, image2.getHeight());
            }
            bl2 = AMenu.currentIndex != 0;
            bl = AMenu.currentIndex != n3;
        } else {
            int n21 = n2;
            while (n21 <= n) {
                String string;
                if (AMenu.currentMenu == 15) {
                    string = GameData.STR_MENU_LANGUAGE[n21];
                } else {
                    String string2 = string = AMenu.items == null ? AMenu.curList[n21] : GameData.get(AMenu.items[n21]);
                }
                if (AMenu.items == null) {
                    AquaCanvas.drawTextCenterShadow(graphics, string, n10 + n12, FONT_NORMAL);
                } else if (n21 == AMenu.currentIndex) {
                    graphics.setColor(0x323232);
                    graphics.fillRect(n14, n10 + n12, n15 + 2, n16 + 2);
                    graphics.setColor(16114176);
                    graphics.fillRect(n14, n10 + n12 - n5 / 2, n15, n16);
                    graphics.setColor(0xFFFFFF);
                    graphics.drawRect(n14, n10 + n12 - n5 / 2, n15 - 1, n16);
                    graphics.drawRect(n14 + 1, n10 + n12 - (n5 / 2 - 1), n15 - 3, n16 - 2);
                    graphics.setColor(0);
                    graphics.drawString(string, screenHalfWidth, n10 + n12 + 2, 17);
                } else {
                    graphics.setColor(0x323232);
                    graphics.fillRect(n14, n10 + n12, n15 + 2, n16 + 2);
                    graphics.setColor(16114176);
                    graphics.fillRect(n14, n10 + n12 - n5 / 2, n15, n16);
                    graphics.setColor(0);
                    graphics.drawString(string, screenHalfWidth, n10 + n12 + 2, 17);
                }
                n10 += n11;
                ++n21;
                ++n13;
            }
        }
        if (AMenu.items == null) {
            if (bl2) {
                graphics.drawImage(image, screenWidth - image.getWidth() - 1, n4 + 3, 20);
            }
            image = rsc_down.getData();
            if (bl) {
                graphics.drawImage(image, screenWidth - image.getWidth() - 1, screenHeightMenu - image.getHeight(), 20);
            }
        } else {
            if (bl2) {
                graphics.drawImage(image, screenWidth - image.getWidth() >> 1, n4 + 3, 20);
            }
            image = rsc_down.getData();
            if (bl) {
                graphics.drawImage(image, screenWidth - image.getWidth() >> 1, screenHeightMenu - image.getHeight(), 20);
            }
        }
    }

    public static String[] wrapText(String string, int n, Font font) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        Vector<String> vector = new Vector<String>(font.charWidth('b') * n4 / n, 4);
        while (n3 < n4) {
            int n5;
            for (n5 = 0; n5 < n && n3 < n4 && string.charAt(n3) != '\n'; n5 += font.charWidth(string.charAt(n3)), ++n3) {
            }
            int n6 = n3;
            if (n3 < n4) {
                if (n5 > n || string.charAt(n3) != '\n') {
                    while (n3 >= n2 && string.charAt(n3) != ' ') {
                        --n3;
                    }
                }
                if (n3 >= n2) {
                    n6 = n3 + 1;
                } else {
                    n3 = n6;
                }
            }
            vector.addElement(string.substring(n2, n3));
            n2 = n3 = n6;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static {
        soundEnabled = true;
        scores = new int[16];
        status = 2;
        rndGen = new Random(System.currentTimeMillis());
        vGfx = new AquaObject[60];
        levelUnlocked = false;
        paused = false;
        projectileStartPoint = new Vector2D();
        initialized = false;
        mangaParticles = new Vector2D[5];
        mangaParticlesSpeed = new Vector2D[5];
        mangaParticlesType = new int[5];
        target_cam = new Vector2D();
        tempV1 = new Vector2D();
        tempV2 = new Vector2D();
        resProgressTotal = 1;
        m_keyPressed = 0;
        cheatsEnabled = false;
        forceRepaintHUD = true;
        fadeDownY = 0;
        for (int i = 4; i >= 0; --i) {
            AquaCanvas.mangaParticles[i] = new Vector2D();
            AquaCanvas.mangaParticlesSpeed[i] = new Vector2D();
        }
        i_help = new byte[]{10, 11, -1};
        i_selplayer = new byte[]{37, 38, 39, -1};
        i_settings_on = new byte[]{27, -1};
        i_settings_off = new byte[]{28, -1};
        i_cheats_on = new byte[]{121, 33, -1};
        i_cheats_off = new byte[]{122, 33, -1};
        i_language = new byte[]{0, 1, 2, 3, 4, 5, 6};
        i_topScoreNames = new String[10];
        i_topScores = new int[10];
    }
}

