/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.util;

import com.sorrent.util.CRC32;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Image;

public class PNGManip {
    private static final int CHUNK_IHDR = 1229472850;
    private static final int CHUNK_PLTE = 1347179589;
    private static final int CHUNK_IDAT = 1229209940;
    private static final int CHUNK_tRNS = 1951551059;
    private static final int CHUNK_IEND = 1229278788;
    private static int m_parsedWidth;
    private static int m_parsedHeight;
    private static int m_parsedTrans;
    private static int m_parsedPLTEOffset;
    private static int m_parsedPLTELength;
    private static int m_parsedIDATOffset;
    private static byte[] m_stored;
    private static int m_storedWidth;
    private static int m_storedHeight;
    private static int m_storedPLTEOffset;
    private static int m_storedPLTELength;
    private static int m_storedIDATOffset;
    private static byte[] m_buffer;
    private static int m_bufOffset;
    private static boolean m_idatModified;

    private static void parse(byte[] byArray, int n, int n2) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n += 8, n2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            m_parsedIDATOffset = 0;
            m_parsedTrans = -1;
            while (m_parsedIDATOffset == 0) {
                int n3 = dataInputStream.readInt();
                int n4 = dataInputStream.readInt();
                switch (n4) {
                    case 1229472850: {
                        m_parsedWidth = dataInputStream.readInt();
                        m_parsedHeight = dataInputStream.readInt();
                        dataInputStream.skip(n3 - 8);
                        break;
                    }
                    case 1951551059: {
                        m_parsedTrans = n3 - 1;
                        dataInputStream.skip(n3);
                        break;
                    }
                    case 1229209940: {
                        m_parsedIDATOffset = n;
                        break;
                    }
                    case 1347179589: {
                        m_parsedPLTEOffset = n;
                        m_parsedPLTELength = n3;
                        dataInputStream.skip(n3);
                        break;
                    }
                    default: {
                        dataInputStream.skip(n3);
                    }
                }
                dataInputStream.skip(4L);
                n += n3 + 12;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void init(int n, int n2, byte[] byArray, int n3, int n4) {
        PNGManip.parse(byArray, n3, n4);
        byte[] byArray2 = new byte[n4 - (m_parsedWidth + 1) * m_parsedHeight + (n + 1) * n2];
        System.arraycopy(byArray, 0, byArray2, 0, m_parsedIDATOffset + 15);
        int n5 = 23 + (m_parsedWidth + 1) * m_parsedHeight;
        if (m_parsedTrans > 0) {
            int n6 = m_parsedIDATOffset + 16;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    byArray2[n6++] = (byte)m_parsedTrans;
                }
                ++n6;
            }
        }
        System.arraycopy(byArray, m_parsedIDATOffset + n5, byArray2, byArray2.length - (n4 - m_parsedIDATOffset - n5), n4 - m_parsedIDATOffset - n5);
        m_buffer = byArray2;
        m_bufOffset = 16;
        PNGManip.writeInt(n);
        PNGManip.writeInt(n2);
        m_bufOffset += 5;
        PNGManip.writeInt(CRC32.crc32(m_buffer, 12, 17));
        m_buffer = null;
        m_stored = byArray2;
        m_storedWidth = n;
        m_storedHeight = n2;
        m_storedPLTEOffset = m_parsedPLTEOffset;
        m_storedPLTELength = m_parsedPLTELength;
        m_storedIDATOffset = m_parsedIDATOffset;
        m_idatModified = true;
    }

    public static void init(byte[] byArray) {
        PNGManip.parse(byArray, 0, byArray.length);
        m_stored = byArray;
        m_storedWidth = m_parsedWidth;
        m_storedHeight = m_parsedHeight;
        m_storedPLTEOffset = m_parsedPLTEOffset;
        m_storedPLTELength = m_parsedPLTELength;
        m_storedIDATOffset = m_parsedIDATOffset;
        m_idatModified = false;
    }

    public static byte[] getPalette() {
        byte[] byArray = new byte[m_storedPLTELength];
        System.arraycopy(m_stored, m_storedPLTEOffset + 8, byArray, 0, m_storedPLTELength);
        return byArray;
    }

    public static void applyPalette(byte[] byArray) {
        System.arraycopy(byArray, 0, m_stored, m_storedPLTEOffset + 8, Math.min(m_storedPLTELength, byArray.length));
        m_buffer = m_stored;
        m_bufOffset = m_storedPLTEOffset + 8 + m_storedPLTELength;
        PNGManip.writeInt(CRC32.crc32(m_stored, m_storedPLTEOffset + 4, m_storedPLTELength + 4));
        m_buffer = null;
    }

    public static byte[] generate(boolean bl) {
        byte[] byArray = m_stored;
        if (!bl) {
            m_stored = null;
        }
        if (m_idatModified) {
            int n = (m_storedWidth + 1) * m_storedHeight;
            int n2 = 11 + n;
            m_buffer = byArray;
            m_bufOffset = m_storedIDATOffset;
            PNGManip.writeInt(n2);
            m_bufOffset += 7;
            PNGManip.writeReverseShort(n);
            PNGManip.writeReverseShort(~n);
            PNGManip.writeInt(CRC32.adler32(m_buffer, (m_bufOffset += n) - n, n));
            PNGManip.writeInt(CRC32.crc32(m_buffer, m_storedIDATOffset + 4, n2 + 4));
            m_buffer = null;
            m_idatModified = false;
        }
        return byArray;
    }

    public static Image createImage(boolean bl) {
        byte[] byArray = PNGManip.generate(bl);
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        return image;
    }

    public static void free() {
        m_stored = null;
    }

    public static void drawImage(int n, int n2, byte[] byArray, int n3, int n4, int n5, int n6) {
        PNGManip.parse(byArray, 0, byArray.length);
        int n7 = m_parsedIDATOffset + 16 + n4 * (m_parsedWidth + 1) + n3;
        int n8 = m_storedIDATOffset + 16 + n2 * (m_storedWidth + 1) + n;
        while (n6-- > 0) {
            for (int i = 0; i < n5; ++i) {
                byte by = byArray[n7 + i];
                if (by == m_parsedTrans) continue;
                PNGManip.m_stored[n8 + i] = by;
            }
            n7 += m_parsedWidth + 1;
            n8 += m_storedWidth + 1;
        }
        m_idatModified = true;
    }

    private static void writeInt(int n) {
        PNGManip.m_buffer[PNGManip.m_bufOffset++] = (byte)(n >> 24);
        PNGManip.m_buffer[PNGManip.m_bufOffset++] = (byte)(n >> 16);
        PNGManip.m_buffer[PNGManip.m_bufOffset++] = (byte)(n >> 8);
        PNGManip.m_buffer[PNGManip.m_bufOffset++] = (byte)n;
    }

    private static void writeShort(int n) {
        PNGManip.m_buffer[PNGManip.m_bufOffset++] = (byte)(n >> 8);
        PNGManip.m_buffer[PNGManip.m_bufOffset++] = (byte)n;
    }

    private static void writeReverseShort(int n) {
        PNGManip.m_buffer[PNGManip.m_bufOffset++] = (byte)n;
        PNGManip.m_buffer[PNGManip.m_bufOffset++] = (byte)(n >> 8);
    }

    private static void write(int n) {
        PNGManip.m_buffer[PNGManip.m_bufOffset++] = (byte)n;
    }

    private static void write(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, m_buffer, m_bufOffset, n2);
        m_bufOffset += n2;
    }

    private static void write(byte[] byArray) {
        PNGManip.write(byArray, 0, byArray.length);
    }
}

