/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.sound;

import com.sorrent.resource.ResourceMgr;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SoundManager
implements PlayerListener {
    private static Hashtable players;
    private static Class sclass;
    private static SoundManager instance;
    private static final String MIME_XWAV = "audio/x-wav";
    private static final String MIME_MIDI = "audio/midi";
    private static final String MIME_MPEG = "audio/mpeg";
    private static boolean isSoundOn;
    private static boolean isVibrationOn;
    private static Player active;
    private static Display display;

    public static void setSound(boolean bl) {
        isSoundOn = bl;
    }

    public static void setVibration(boolean bl) {
        isVibrationOn = bl;
    }

    public static boolean isSoundOn() {
        return isSoundOn;
    }

    public static boolean isVibrationOn() {
        return isVibrationOn;
    }

    public static void setDisplay(Display display) {
        SoundManager.display = display;
    }

    private SoundManager() {
        sclass = this.getClass();
    }

    private static int getId(int n) {
        return n & 0xFFFF;
    }

    private static int getType(int n) {
        return n >> 16;
    }

    public static void prefetch(int n) {
        Player player;
        if (n == -1) {
            return;
        }
        int n2 = SoundManager.getId(n);
        int n3 = SoundManager.getType(n);
        Integer n4 = new Integer(n);
        if (players == null) {
            players = new Hashtable();
        }
        if (players.get(n4) == null && (player = SoundManager.createPlayer(n3, n2)) != null) {
            players.put(n4, player);
        }
    }

    public static void prefetch(String string) {
        Player player;
        if (players == null) {
            players = new Hashtable();
        }
        if (players.get(string) == null && (player = SoundManager.createPlayer(string)) != null) {
            players.put(string, player);
        }
    }

    private static String getMimeType(int n) {
        switch (n) {
            case 10: {
                return MIME_XWAV;
            }
            case 2: {
                return MIME_MIDI;
            }
            case 9: {
                return MIME_MPEG;
            }
        }
        return "";
    }

    private static Player createPlayer(int n, int n2) {
        Player player;
        try {
            DataInputStream dataInputStream = ResourceMgr.getResourceStream(n, n2);
            player = Manager.createPlayer((InputStream)dataInputStream, (String)SoundManager.getMimeType(n));
            player.addPlayerListener((PlayerListener)instance);
        }
        catch (Exception exception) {
            player = null;
        }
        return player;
    }

    private static Player createPlayer(String string) {
        Player player = null;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        try {
            InputStream inputStream = sclass.getResourceAsStream(string);
            if (string.endsWith(".mid")) {
                player = Manager.createPlayer((InputStream)inputStream, (String)MIME_MIDI);
            } else if (string.endsWith(".wav")) {
                player = Manager.createPlayer((InputStream)inputStream, (String)MIME_XWAV);
            } else if (string.endsWith(".mp3")) {
                player = Manager.createPlayer((InputStream)inputStream, (String)MIME_MPEG);
            }
            player.addPlayerListener((PlayerListener)instance);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return player;
    }

    public static void play(String string) {
        SoundManager.play(string, 0);
    }

    public static void play(int n) {
        SoundManager.play(n, 0);
    }

    public static void play(String string, int n) {
        block10: {
            if (!isSoundOn) {
                return;
            }
            boolean bl = true;
            Player player = players != null ? (Player)players.get(string) : null;
            if (player == null) {
                bl = false;
                player = SoundManager.createPlayer(string);
            }
            try {
                Player player2 = active;
                if (player2 == player) {
                    return;
                }
                if (player2 != null) {
                    player2.stop();
                }
                if (player != null) {
                    if (n != 0) {
                        player.setLoopCount(n);
                    }
                    player.prefetch();
                    player.start();
                    active = player;
                }
            }
            catch (Exception exception) {
                active = null;
                try {
                    player.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (!bl) break block10;
                players.remove(string);
                SoundManager.prefetch(string);
            }
        }
    }

    public static void play(int n, int n2) {
        block11: {
            if (!isSoundOn) {
                return;
            }
            if (n == -1) {
                return;
            }
            boolean bl = true;
            int n3 = SoundManager.getId(n);
            int n4 = SoundManager.getType(n);
            Integer n5 = new Integer(n);
            Player player = players != null ? (Player)players.get(n5) : null;
            if (player == null) {
                bl = false;
                player = SoundManager.createPlayer(n4, n3);
            }
            try {
                Player player2 = active;
                if (player2 == player) {
                    return;
                }
                if (player2 != null) {
                    player2.stop();
                }
                if (player != null) {
                    if (n2 != 0) {
                        player.setLoopCount(n2);
                    }
                    player.prefetch();
                    player.start();
                    active = player;
                }
            }
            catch (Exception exception) {
                active = null;
                try {
                    player.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (!bl) break block11;
                players.remove(n5);
                SoundManager.prefetch(n5);
            }
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string == "stopped" || string == "stoppedAtTime" || string == "endOfMedia" || string == "error") {
            if (active != null) {
                active = null;
            }
            try {
                if (string == "error") {
                    player.close();
                } else {
                    player.deallocate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void free(String string) {
        if (players != null) {
            players.remove(String.valueOf(string));
        }
    }

    public static void free(int n) {
        if (n == -1) {
            return;
        }
        int n2 = SoundManager.getId(n);
        int n3 = SoundManager.getType(n);
        ResourceMgr.free(n3, n2);
        if (players != null) {
            players.remove(new Integer(n));
        }
    }

    public static void free() {
        active = null;
        if (players != null) {
            Enumeration enumeration = players.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (!(v instanceof Integer)) continue;
                SoundManager.free((Integer)v);
            }
            players = null;
        }
    }

    public static void vibrate(Display display, int n) {
        if (isVibrationOn) {
            try {
                display.vibrate(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void vibrate(int n) {
        Player player;
        if (isVibrationOn && (player = active) == null) {
            try {
                display.vibrate(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void stop() {
        if (active != null) {
            try {
                active.stop();
                active.deallocate();
                active.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            active = null;
        }
    }

    static {
        instance = new SoundManager();
        isSoundOn = true;
        isVibrationOn = true;
    }
}

