/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game;

import com.sorrent.game.AquaCanvas;
import com.sorrent.game.AquaLevel;
import com.sorrent.game.AquaResourceAnimatedSprite;
import com.sorrent.game.physics.Body;
import com.sorrent.game.physics.CollisionContact;
import com.sorrent.game.physics.PMaths;
import com.sorrent.game.physics.Vector2D;
import com.sorrent.sound.SoundManager;
import javax.microedition.lcdui.Graphics;

public class AquaObject
extends Body {
    public int width;
    public int height;
    public int colDistance;
    public int col_x1;
    public int col_x2;
    public int col_y1;
    public int col_y2;
    public static final int BODY_TYPE_FIRE = 3;
    public static final int BODY_TYPE_SPRING = 4;
    public int life;
    public int totalDamage;
    public static final int AO_OBJECT = 2;
    public static final int AO_SQUARE = 4;
    public static final int AO_SQUARE2 = 8;
    public static final int AO_PUPPET = 16;
    public static final int AO_DYNA = 32;
    public static final int AO_POOL = 64;
    public static final int AO_SPHERE = 128;
    public static final int AO_FIRE = 256;
    public static final int AO_INI = 512;
    public static final int AO_ERR = 1024;
    public static final int AO_FARGATE = 2048;
    public static final int AO_CAR = 4096;
    public static final int AO_BROWN = 8192;
    public static final int AO_CUBE = 16384;
    public static final int AO_EXTRA = 32768;
    public static final int AO_APPLE = 65536;
    public static final int AO_BRAIN = 131072;
    public static final int AO_SPRING = 262144;
    public static final int AO_TV = 524288;
    public static final int AO_RADIO = 0x100000;
    public static final int AO_SHIP = 0x200000;
    public static final int AO_BOMB = 0x400000;
    public static final int AO_BOULE = 0x800000;
    public static final int AO_PARENT = 14;
    public static final int AO_CHILD = -15;
    private int aoType;
    private int nfA;
    private int nfB;
    private int nfC;
    private int nfD;
    protected AquaResourceAnimatedSprite deadFrames;
    protected int addY;
    protected byte[] nextFrames;
    protected int nextFrameMax;
    protected boolean isDead;
    private AquaResourceAnimatedSprite as2;
    private boolean done;
    public int givenDamage;
    private Vector2D fixedPos;
    private int lastFireTime;
    private boolean activated;
    private boolean fixed;
    private boolean blocked;
    protected Vector2D dest;
    private int lastHitTime;
    protected int addBoucingCoef;
    private boolean hasCollided;
    protected int model;
    public boolean deleting;
    public boolean initialized;
    public boolean visible;
    protected AquaResourceAnimatedSprite rsc;
    protected AquaResourceAnimatedSprite drawnRsc;
    protected int animeDelay;
    protected int lastAnimeTime;
    protected int frameIndex;
    protected int maxFrames;
    protected byte[] curFrames;
    protected static final byte[] defFrames = new byte[]{0};
    protected static final byte[] frames4 = new byte[]{0, 1, 2, 3};
    protected static final byte[] brownFrames = frames4;
    protected static final byte[] aofire_frames = new byte[]{0, 1, 2};
    protected static final byte[] aosquare_frames = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
    protected static final byte[] aosquare_frames2 = new byte[]{8, 9};
    protected static final byte[] frames_0_to_7 = aosquare_frames;
    private static final byte[] scores_for_stars = new byte[]{5, 15, 25};
    private static Vector2D tempV1 = new Vector2D();
    private static Vector2D tempV2 = new Vector2D();
    private static Vector2D tempV3 = new Vector2D();
    private static Vector2D tempV4 = new Vector2D();

    public AquaObject(int n, int n2, int n3, int n4, int n5, AquaResourceAnimatedSprite aquaResourceAnimatedSprite, AquaResourceAnimatedSprite aquaResourceAnimatedSprite2, int n6, int n7, byte[] byArray, int n8) {
        super(1, n2);
        this.colDistance = n5;
        this.width = n3;
        this.height = n4;
        this.aoType = n;
        this.life = n6;
        this.totalDamage = 0;
        this.deleting = false;
        this.visible = true;
        this.rsc = aquaResourceAnimatedSprite;
        this.frameIndex = 0;
        this.curFrames = defFrames;
        this.lastAnimeTime = 0;
        this.maxFrames = 1;
        this.rsc.obtainResource();
        this.initialized = true;
        this.drawnRsc = this.rsc;
        this.nfA = 0;
        this.nfB = 4;
        this.nfC = 0;
        this.nfD = 4;
        if ((this.aoType & 0xC) != 0) {
            this.curFrames = aosquare_frames;
            this.maxFrames = 8;
            this.addY = n7;
            if (aquaResourceAnimatedSprite2 != null) {
                this.deadFrames = aquaResourceAnimatedSprite2;
                this.deadFrames.obtainResource();
            }
        }
        if ((this.aoType & 8) != 0) {
            this.nextFrames = byArray;
            this.nextFrameMax = n8;
        }
        this.isDead = false;
        switch (this.aoType & 0xFFFFFFF1) {
            case 0x100000: {
                this.animeDelay = 100;
                break;
            }
            case 0x800000: {
                this.animeDelay = 100;
                this.curFrames = frames4;
                this.maxFrames = 1;
                break;
            }
            case 131072: {
                this.animeDelay = 100;
                break;
            }
            case 512: 
            case 1024: {
                this.animeDelay = 100;
                this.curFrames = frames4;
                this.maxFrames = 4;
                this.nfA = 1;
                this.nfB = 3;
                this.nfC = 1;
                this.nfD = 4;
                break;
            }
            case 16384: {
                this.animeDelay = 100;
                break;
            }
            case 524288: {
                this.animeDelay = 100;
                break;
            }
            case 65536: {
                this.animeDelay = 100;
                this.nfA = 2;
                this.nfB = 6;
                this.nfC = 2;
                this.nfD = 6;
                break;
            }
            case 0x400000: {
                this.animeDelay = 100;
                this.curFrames = frames4;
                this.maxFrames = 1;
                break;
            }
            case 8192: {
                this.animeDelay = 100;
                this.curFrames = frames4;
                this.maxFrames = 1;
                this.as2 = AquaCanvas.rsc_bair;
                this.as2.obtainResource();
                this.done = false;
                break;
            }
            case 32: {
                this.animeDelay = 100;
                this.nfA = 2;
                this.nfB = 6;
                this.nfC = 2;
                this.nfD = 6;
                break;
            }
            case 64: {
                this.curFrames = frames_0_to_7;
                this.maxFrames = 1;
                this.animeDelay = 0;
                this.type = 4;
                this.canMove = false;
                break;
            }
            case 256: {
                this.curFrames = aofire_frames;
                this.maxFrames = 3;
                this.animeDelay = 150;
                this.type = 3;
                this.canMove = false;
                break;
            }
            case 16: {
                this.animeDelay = 100;
                this.curFrames = frames4;
                this.maxFrames = 4;
                this.done = false;
                break;
            }
            case 0x200000: {
                this.curFrames = frames_0_to_7;
                this.maxFrames = 1;
                this.animeDelay = 0;
                this.type = 4;
                this.canMove = false;
                this.activated = false;
                this.fixedPos = new Vector2D();
                break;
            }
            case 2048: {
                this.curFrames = frames_0_to_7;
                this.maxFrames = 2;
                this.animeDelay = 0;
                this.type = 4;
                this.canMove = false;
                this.blocked = false;
                break;
            }
            case 262144: {
                this.curFrames = frames_0_to_7;
                this.maxFrames = 2;
                this.animeDelay = 0;
                this.type = 4;
                this.hasCollided = false;
                this.canMove = false;
                break;
            }
            case 128: {
                this.curFrames = frames_0_to_7;
                this.maxFrames = 2;
                this.animeDelay = 0;
                this.type = 4;
                this.canMove = false;
                this.blocked = false;
                this.lastHitTime = 0;
                break;
            }
            case 32768: {
                this.curFrames = frames_0_to_7;
                this.maxFrames = 1;
                this.animeDelay = 0;
                this.type = 4;
                this.canMove = false;
                break;
            }
            case 4096: {
                this.curFrames = frames_0_to_7;
                this.maxFrames = 1;
                this.animeDelay = 0;
                this.type = 4;
                this.canMove = false;
            }
        }
    }

    public void delete() {
        if (this.deadFrames != null) {
            this.deadFrames.releaseResource();
            this.deadFrames = null;
        }
        this.rsc.releaseResource();
    }

    public void animate(Vector2D vector2D) {
        if ((this.aoType & 0x10) != 0) {
            int n = PMaths.ABS(vector2D.x);
            int n2 = PMaths.ABS(vector2D.y);
            int n3 = 8000;
            if (!this.done) {
                if (n != 0 || n2 != 0) {
                    this.done = true;
                }
                this.frameIndex = 0;
            }
            if (this.done) {
                this.frameIndex = n2 < n3 ? 1 : (vector2D.y > 0 ? 2 : 3);
            }
            return;
        }
        if (AquaCanvas.time_game - this.lastAnimeTime > this.animeDelay) {
            this.lastAnimeTime = AquaCanvas.time_game;
            if ((this.aoType & 0x60C) != 0) {
                int n = this.frameIndex;
                if (vector2D.x > 17048) {
                    ++n;
                } else if (vector2D.x < -17048) {
                    --n;
                } else if ((this.aoType & 0x2000) == 0 && !this.isDead) {
                    if (vector2D.x >= 0) {
                        if (n != this.nfA && n != this.nfB) {
                            ++n;
                        }
                    } else if (n != this.nfC && n != this.nfD) {
                        --n;
                    }
                }
                if (n == this.maxFrames) {
                    n = 0;
                }
                if (n == -1) {
                    n = this.maxFrames - 1;
                }
                this.frameIndex = n;
            } else {
                this.frameIndex = (this.frameIndex + 1) % this.maxFrames;
            }
        }
    }

    public boolean tick() {
        if ((this.aoType & 0x80) != 0) {
            if (this.blocked) {
                if (AquaCanvas.time_game - this.lastHitTime > 50) {
                    this.frameIndex = 0;
                }
                if (AquaCanvas.time_game - this.lastHitTime > 350) {
                    this.blocked = false;
                }
            }
            return true;
        }
        if ((this.aoType & 0x2000) != 0) {
            if (this.done) {
                this.animate(this.vel);
            } else if (this.vel.x != 0 || this.vel.y != 0) {
                this.done = true;
                this.drawnRsc = this.as2;
                this.maxFrames = 4;
                this.frameIndex = 0;
                this.curFrames = brownFrames;
                this.height = 20480;
                this.width = 20480;
            }
            return true;
        }
        if ((this.aoType & 0x200000) != 0) {
            if (this.activated) {
                if (this.pos.y < 1945600) {
                    this.pos.y += 4096;
                    if (AquaCanvas.time_game - this.lastFireTime > 100) {
                        this.lastFireTime = AquaCanvas.time_game;
                        Vector2D vector2D = tempV1.init(this.pos.x, this.pos.y - 15000);
                        Vector2D vector2D2 = tempV2.init(AquaCanvas.RNDnextSigned() % 32 << 6, -2048);
                        AquaCanvas.pe_explosions.addParticle(vector2D, vector2D2);
                        vector2D2.init(AquaCanvas.RNDnextSigned() % 32 << 6, -3048);
                        AquaCanvas.pe_smoke.addParticle(vector2D, vector2D2);
                    }
                }
                if (this.pos.y > 921600) {
                    if (!this.fixed) {
                        this.fixed = true;
                        this.fixedPos.init(this.pos);
                        AquaLevel.cam_setFocusedObject(this.fixedPos);
                        AquaLevel.cam_recenter = false;
                    }
                    if (AquaCanvas.gameStatus == 256) {
                        AquaCanvas.gameStatus = 1024;
                    }
                }
            }
            return true;
        }
        if ((this.aoType & 0x400020) != 0) {
            if ((this.aoType & 0x20) != 0) {
                this.animate(this.vel);
            }
            if (AquaLevel.obj_canDestroyCar && this.visible) {
                Vector2D vector2D = tempV1.init(this.vel);
                vector2D.x >>= 4;
                vector2D.y >>= 4;
                Vector2D vector2D3 = tempV2.init(this.pos);
                vector2D3.x += AquaCanvas.RNDnextSigned() % 5 << 10;
                vector2D3.y += AquaCanvas.RNDnextSigned() % 5 << 10;
                vector2D.x += AquaCanvas.RNDnextSigned() % 5 << 10;
                vector2D.y += AquaCanvas.RNDnextSigned() % 5 << 10;
                AquaCanvas.pe_explosions2.addParticle(vector2D3, vector2D);
                if (AquaCanvas.gameStatus == 2048 && this.visible && AquaLevel.obj_canDestroyCar) {
                    for (int i = 0; i < 10; ++i) {
                        vector2D3 = this.width >> 11 != 0 && this.height >> 10 != 0 ? tempV2.init(this.pos.x + (AquaCanvas.RNDnextSigned() % (this.width >> 11) << 10), this.pos.y + (AquaCanvas.RNDnextSigned() % (this.height >> 10) << 10)) : tempV2.init(this.pos.x, this.pos.y);
                        vector2D = tempV1.init(AquaCanvas.RNDnextSigned() % 10 << 10, AquaCanvas.RNDnextSigned() % 10 << 10);
                        if (vector2D.x == 0) {
                            vector2D.x = this.vel.x;
                        }
                        if (vector2D.y == 0) {
                            vector2D.y = this.vel.x;
                        }
                        AquaCanvas.pe_explosions.addParticle(vector2D3, vector2D);
                    }
                    this.visible = false;
                }
            }
            return true;
        }
        if ((this.aoType & 0x71C) != 0) {
            this.animate(this.vel);
        }
        return true;
    }

    public void draw(Graphics graphics, int n, int n2) {
        int n3;
        switch (this.aoType & 0xFFFFFFF1) {
            case 16384: {
                if ((this.frameIndex & 1) == 0) break;
                n2 += this.addY;
                break;
            }
            case 524288: {
                if ((this.frameIndex & 1) != 0 && !this.isDead) {
                    n2 += this.addY;
                }
                if (!this.isDead) break;
                n2 += 5000;
                break;
            }
            case 65536: {
                if (this.pos.y >= 10240 || this.drawnRsc != this.deadFrames) break;
                if (this.frameIndex == 2 || this.frameIndex == 6) {
                    n2 += 6144;
                    break;
                }
                if (this.frameIndex == 0) break;
                n2 += 4096;
                break;
            }
            case 32: {
                if (this.pos.y >= 10240) break;
                if (this.frameIndex == 2 || this.frameIndex == 6) {
                    n2 += 6144;
                    break;
                }
                if (this.frameIndex == 0) break;
                n2 += 4096;
                break;
            }
            case 2048: {
                this.drawObject(graphics, n, n2);
                Vector2D vector2D = this.pos;
                this.pos = this.dest;
                this.frameIndex = 1;
                this.drawObject(graphics, n, n2);
                this.pos = vector2D;
                this.frameIndex = 0;
                return;
            }
        }
        if ((this.aoType & 0xC) != 0) {
            if (this.isDead) {
                n2 += this.addY;
            }
            if (this.frameIndex != 0 && this.frameIndex != 4) {
                n2 += this.addY;
            }
        }
        if ((n3 = this.pos.x - n >> 10) < -this.drawnRsc.frameWidth || n3 > AquaCanvas.screenWidth + this.drawnRsc.frameWidth) {
            return;
        }
        int n4 = -this.pos.y + n2 >> 10;
        if (n4 < -this.drawnRsc.frameHeight || n4 > AquaCanvas.screenHeight) {
            return;
        }
        this.drawnRsc.draw(graphics, this.curFrames[this.frameIndex], n3, n4);
    }

    private void drawObject(Graphics graphics, int n, int n2) {
        int n3;
        if ((this.aoType & 0xC) != 0) {
            if (this.isDead) {
                n2 += this.addY;
            }
            if (this.frameIndex != 0 && this.frameIndex != 4) {
                n2 += this.addY;
            }
        }
        if ((n3 = this.pos.x - n >> 10) < -this.drawnRsc.frameWidth || n3 > AquaCanvas.screenWidth + this.drawnRsc.frameWidth) {
            return;
        }
        int n4 = -this.pos.y + n2 >> 10;
        if (n4 < -this.drawnRsc.frameHeight || n4 > AquaCanvas.screenHeight) {
            return;
        }
        this.drawnRsc.draw(graphics, this.curFrames[this.frameIndex], n3, n4);
    }

    public boolean damage(int n) {
        this.totalDamage += n;
        if (this.life != 0) {
            this.life -= n;
            AquaLevel.score_damage += n / 1000000 / 2;
            if (this.life <= 0) {
                this.life = 0;
                this.destroy();
            }
        }
        return true;
    }

    public boolean destroy() {
        if ((this.aoType & 0x400000) != 0) {
            for (int i = 0; i < 5; ++i) {
                Vector2D vector2D = tempV1.init(this.pos.x + (this.width >> 1), this.pos.y + (this.height >> 1));
                Vector2D vector2D2 = tempV2.init(AquaCanvas.RNDnextSigned() % 20 << 10, AquaCanvas.RNDnextSigned() % 20 << 10);
                AquaCanvas.pe_explosions.addParticle(vector2D, vector2D2);
            }
            this.visible = false;
            AquaCanvas.gameStatus = 1024;
            this.canCollide = false;
            this.canMove = false;
            return true;
        }
        if ((this.aoType & 8) != 0) {
            this.isDead = true;
            this.frameIndex = 0;
            this.curFrames = this.nextFrames;
            this.maxFrames = this.nextFrameMax;
            for (int i = 0; i < 10; ++i) {
                Vector2D vector2D = tempV1.init(this.pos.x + (this.width >> 1), this.pos.y + (this.height >> 1));
                Vector2D vector2D3 = tempV2.init(AquaCanvas.RNDnextSigned() % 10 << 10, AquaCanvas.RNDnextSigned() % 10 << 10);
                AquaCanvas.pe_explosions.addParticle(vector2D, vector2D3);
            }
        }
        if (this.deadFrames != null) {
            this.drawnRsc = this.deadFrames;
        }
        return true;
    }

    public void resolveCollision(CollisionContact collisionContact) {
        AquaObject aquaObject = (AquaObject)collisionContact.collisionableObject;
        switch (this.aoType & 0xFFFFFFF1) {
            case 64: {
                aquaObject.visible = false;
                aquaObject.canCollide = false;
                aquaObject.canMove = false;
                AquaLevel.success = true;
                SoundManager.play(131079);
                AquaLevel.score_stars += 1000;
                AquaCanvas.gameStatus = 1024;
                return;
            }
            case 256: {
                if (AquaLevel.obj_isDyna) {
                    AquaLevel.obj_canDestroyCar = true;
                }
                return;
            }
            case 0x200000: {
                aquaObject.visible = false;
                aquaObject.canCollide = false;
                aquaObject.canMove = false;
                this.activated = true;
                AquaLevel.score_stars += 1000;
                this.lastFireTime = AquaCanvas.time_game;
                AquaLevel.success = true;
                AquaLevel.cam_setFocusedObject(this.pos);
                AquaLevel.cam_recenter = false;
                AquaCanvas.gameStatus = 1024;
                SoundManager.play(131075);
                return;
            }
            case 2048: {
                this.blocked = true;
                SoundManager.play(131078);
                int n = this.dest.x + (this.width >> 1);
                int n2 = this.dest.y + (this.height >> 1);
                aquaObject.pos.init(n, n2);
                aquaObject.predictedPos.init(n, n2);
                return;
            }
            case 262144: {
                SoundManager.play(131076);
                this.hasCollided = true;
                this.frameIndex = 1;
                int n = 1024 - (this.bouncingCoef + aquaObject.bouncingCoef);
                int n3 = 1024 + this.bouncingCoef - n >> 5;
                int n4 = PMaths.ABS(aquaObject.predictedVel.y) >> 5;
                aquaObject.predictedVel.y = n4 * n3;
                aquaObject.predictedVel.y += this.addBoucingCoef;
                aquaObject.vel = aquaObject.predictedVel;
                return;
            }
            case 128: {
                this.lastHitTime = AquaCanvas.time_game;
                this.blocked = true;
                this.frameIndex = 1;
                SoundManager.play(131076);
                this.bouncingCoef = 1600;
                int n = collisionContact.collisionNormal.dot(aquaObject.vel) >> 5;
                Vector2D vector2D = tempV1.init(collisionContact.collisionNormal);
                vector2D.mulEqual(-(n *= this.bouncingCoef >> 5));
                aquaObject.predictedVel.addEqual(vector2D);
                return;
            }
            case 32768: {
                SoundManager.play(131076);
                this.visible = false;
                AquaLevel.score_stars += scores_for_stars[this.model];
                for (int i = 0; i < 10; ++i) {
                    Vector2D vector2D = tempV1;
                    PMaths.pInitUnitVector(vector2D, i * 360 / 10 % 360);
                    vector2D.mulEqual(7168);
                    if (this.model == 0) {
                        AquaCanvas.pe_extra_0.addParticle(this.pos, vector2D);
                        continue;
                    }
                    if (this.model == 1) {
                        AquaCanvas.pe_extra_1.addParticle(this.pos, vector2D);
                        continue;
                    }
                    if (this.model != 2) continue;
                    AquaCanvas.pe_extra_2.addParticle(this.pos, vector2D);
                }
                return;
            }
            case 4096: {
                aquaObject.visible = false;
                aquaObject.canCollide = false;
                aquaObject.canMove = false;
                AquaLevel.score_stars += 1000;
                AquaLevel.cam_setFocusedObject(this.pos);
                AquaLevel.cam_recenter = false;
                for (int i = 0; i < 5; ++i) {
                    Vector2D vector2D = tempV1.init(aquaObject.predictedPos);
                    Vector2D vector2D2 = tempV2.init(AquaCanvas.RNDnextSigned() % 10 << 10, AquaCanvas.RNDnextSigned() % 10 << 10);
                    AquaCanvas.pe_explosions.addParticle(vector2D, vector2D2);
                }
                AquaCanvas.gameStatus = 1024;
                return;
            }
        }
    }

    public int checkForCollision(Body body, CollisionContact collisionContact) {
        if ((this.aoType & 0x100) != 0) {
            AquaObject aquaObject = (AquaObject)body;
            if (aquaObject.col_x1 >= this.pos.x + this.width || aquaObject.col_x2 <= this.pos.x || aquaObject.col_y1 >= this.pos.y + this.height || aquaObject.col_y2 <= this.pos.y) {
                return 0;
            }
            collisionContact.collisionHandler = this;
            collisionContact.collisionableObject = body;
            collisionContact.collisionNormal.init(0, 1024);
            return 2;
        }
        if ((this.aoType & 0x2498C0) != 0) {
            if ((this.aoType & 0x40000) != 0 && this.hasCollided) {
                return 0;
            }
            AquaObject aquaObject = (AquaObject)body;
            if (aquaObject.col_x1 >= this.pos.x + this.width + aquaObject.colDistance || aquaObject.col_x2 <= this.pos.x - aquaObject.colDistance || aquaObject.col_y1 >= this.pos.y + this.height + aquaObject.colDistance || aquaObject.col_y2 <= this.pos.y - aquaObject.colDistance) {
                return 0;
            }
            collisionContact.collisionHandler = this;
            collisionContact.collisionableObject = body;
            if ((this.aoType & 0x40000) != 0) {
                collisionContact.collisionNormal.init(0, 1024);
            }
            if ((this.aoType & 0x80) != 0) {
                Vector2D vector2D = tempV1.init(-this.pos.x + aquaObject.pos.x, -(this.pos.y + (this.height >> 1)) + (aquaObject.pos.y + (aquaObject.height >> 1)));
                vector2D.normalize();
                collisionContact.collisionNormal.init(vector2D);
            }
            return 2;
        }
        return 0;
    }

    public boolean supportCollision(Body body) {
        if ((this.aoType & 0x2499C0) != 0) {
            if ((this.aoType & 0x880) != 0 ? this.blocked : (this.aoType & 0x8000) != 0 && !this.visible) {
                return false;
            }
            return body.type == 1;
        }
        return false;
    }

    public void computeForces(Body body) {
        this.force.init();
        this.buildBoundingBox();
        if (body != null && body.type == 2) {
            body.addForce(this);
        }
    }

    public void buildBoundingBox() {
        int n = this.width >> 1;
        this.col_x1 = this.predictedPos.x - n;
        this.col_x2 = this.predictedPos.x + n;
        this.col_y1 = this.predictedPos.y;
        this.col_y2 = this.col_y1 + this.height;
    }

    public boolean collisionNotify(CollisionContact collisionContact) {
        if ((this.aoType & 0x248840) != 0) {
            return true;
        }
        if ((this.aoType & 0x80) != 0) {
            AquaObject aquaObject = (AquaObject)collisionContact.collisionableObject;
            Vector2D vector2D = tempV1.init(aquaObject.predictedVel);
            int n = (vector2D.x >> 5) * (vector2D.x >> 5) + ((vector2D.y >> 5) * (vector2D.y >> 5) << 1);
            return aquaObject.damage(n);
        }
        if ((this.aoType & 0x100) != 0) {
            AquaObject aquaObject = (AquaObject)collisionContact.collisionableObject;
            return aquaObject.damage(this.givenDamage);
        }
        if ((this.aoType & 0x1000) != 0) {
            AquaObject aquaObject = (AquaObject)collisionContact.collisionableObject;
            Vector2D vector2D = tempV1.init(aquaObject.predictedVel);
            int n = (vector2D.x >> 5) * (vector2D.x >> 5) + ((vector2D.y >> 5) * (vector2D.y >> 5) << 1);
            if (!this.damage(n + aquaObject.life)) {
                return false;
            }
            SoundManager.play(131075);
            if (AquaLevel.obj_canDestroyCar) {
                this.visible = false;
                AquaLevel.success = true;
                AquaCanvas.pe_explosions.removeAllParticles();
                for (int i = 0; i < 10; ++i) {
                    Vector2D vector2D2 = tempV1;
                    if (this.width >> 11 != 0 && this.height >> 10 != 0) {
                        vector2D2.init(this.pos.x + (AquaCanvas.RNDnextSigned() % (this.width >> 11) << 10), this.pos.y + (AquaCanvas.RNDnextSigned() % (this.height >> 10) << 10));
                    } else {
                        vector2D2.init(this.pos.x, this.pos.y);
                    }
                    Vector2D vector2D3 = tempV2.init(AquaCanvas.RNDnextSigned() % 10 << 10, AquaCanvas.RNDnextSigned() % 10 << 10);
                    if (vector2D3.x == 0) {
                        vector2D3.x = collisionContact.collisionableObject.vel.x;
                    }
                    if (vector2D3.y == 0) {
                        vector2D3.y = collisionContact.collisionableObject.vel.x;
                    }
                    AquaCanvas.pe_explosions.addParticle(vector2D2, vector2D3);
                }
            }
            return true;
        }
        if (collisionContact.collisionableObject == this && collisionContact.collisionHandler.type == 2) {
            Vector2D vector2D;
            int n;
            int n2;
            int n3 = -this.vel.x >> 1;
            int n4 = -this.vel.y >> 1;
            if (n3 == 0) {
                n3 = 2;
            }
            if (n4 == 0) {
                n4 = 2;
            }
            int n5 = this.vel.lengthSqr();
            int n6 = (this.vel.x >> 5) * (this.vel.x >> 5) + ((this.vel.y >> 5) * (this.vel.y >> 5) << 1);
            if (!this.damage(n6)) {
                return false;
            }
            if (n5 > 8192) {
                n2 = n3 < 0 ? -1 : 1;
                n = n4 < 0 ? -1 : 1;
                for (int i = 0; i < 3; ++i) {
                    vector2D = tempV1.init(n2 * (AquaCanvas.RNDnext() % (n3 >= 0 ? n3 : -n3)), n * (AquaCanvas.RNDnext() % (n4 >= 0 ? n4 : -n4)));
                    AquaCanvas.pe_particles.addParticle(this.pos, vector2D);
                }
            }
            if (n5 > 1000000) {
                n2 = this.pos.x - (this.width >> 1);
                n = this.pos.x + (this.width >> 1);
                Vector2D vector2D4 = tempV1.init(n2, this.pos.y);
                vector2D = tempV2.init(n, this.pos.y);
                for (int i = 0; i < 3; ++i) {
                    Vector2D vector2D5 = tempV3.init(-(AquaCanvas.RNDnext() % 1000), AquaCanvas.RNDnext() % 15000);
                    AquaCanvas.pe_explosions.addParticle(vector2D4, vector2D5);
                    Vector2D vector2D6 = tempV4.init(AquaCanvas.RNDnext() % 1000, AquaCanvas.RNDnext() % 15000);
                    AquaCanvas.pe_explosions.addParticle(vector2D, vector2D6);
                    AquaCanvas.pe_smoke.addParticle(vector2D4, vector2D6);
                    AquaCanvas.pe_smoke.addParticle(vector2D, vector2D5);
                }
            }
        }
        return true;
    }
}

