/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.resource;

import com.sorrent.game.GameMIDletAQUA;
import com.sorrent.game.Resources;
import com.sorrent.resource.ResourceMgrThread;
import com.sorrent.wnet.WNet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;

public final class ResourceMgr {
    private static final boolean CLASSDEBUG = false;
    private static final boolean VISUALDEBUG = false;
    public static final String[] FILE_EXT_ARRAY = new String[]{null, ".png", ".mid", null, null, ".dat", ".plt", ".gtf", ".mmf", ".mp3", ".wav", ".qcp", ".ott"};
    public static final int SUCCESS = 0;
    public static final int DENIED = 1;
    public static final int NETWORK_ERROR = 2;
    public static final int RMS_ERROR = 3;
    public static final int RMS_FULL_ERROR = 4;
    public static final int EXPIRED = 5;
    public static final int DOWNLOAD_ERROR = 6;
    public static final int OTHER_ERROR = 7;
    private static final int RM_ERROR_DOWNLOAD = -1;
    private static final int RM_TYPE_MISMATCH = -2;
    private static final int RM_DATA_ERROR = -3;
    public static final byte RES_IN_JAR = 2;
    public static final byte RES_PRELOAD = 4;
    public static final byte RES_LOADED = 8;
    public static final byte RES_IN_RMS = 16;
    public static final byte RES_KEEP_RAW = 32;
    public static final byte RES_IN_RPK = 64;
    public static final int RES_PHASE_INIT = 1;
    public static final int RES_PHASE_LOADING = 2;
    private static final int LOADING_NUM_TRIES = 3;
    private static Object[][] m_res;
    private static RecordStore[] m_rs;
    private static int[] m_resCount;
    private static byte[] m_resAttr;
    private static int[][] resOffset;
    private static byte[][] rpkFileId;
    private static InputStream rpk_is;
    private static DataInputStream rpk_ds;
    private static int currentRpkId;
    private static int lastRpkPos;
    private static boolean initState;
    private static int[] m_offsets;
    private static int m_progress;
    private static int m_errorCount;
    private static Object pauseLock;
    private static boolean paused;
    private static GameMIDletAQUA m_midlet;
    private static WNet m_wnet;
    private static final byte[] nullByte;
    private static Class m_class;

    public static void init(GameMIDletAQUA gameMIDletAQUA, WNet wNet) {
        m_midlet = gameMIDletAQUA;
        m_wnet = wNet;
        m_class = ((Object)((Object)gameMIDletAQUA)).getClass();
        m_resCount = Resources.RES_COUNT;
        m_resAttr = Resources.RES_ATTR;
        int n = m_resCount.length;
        int n2 = 0;
        m_res = new Object[n][];
        m_offsets = new int[n];
        for (int i = 1; i < n; ++i) {
            int n3 = m_resCount[i];
            if (n3 > 0) {
                ResourceMgr.m_res[i] = new Object[n3];
            }
            ResourceMgr.m_offsets[i] = n2;
            n2 += n3;
        }
        ResourceMgr.m_offsets[0] = n2;
    }

    public static void clear() {
        m_res = null;
    }

    public static void run() {
        new ResourceMgrThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int initResources() throws IOException, RecordStoreException {
        GameMIDletAQUA.resourceProgress(1);
        try {
            int n = 0;
            m_errorCount = 0;
            int n2 = m_resCount.length;
            for (int i = 1; i < n2; ++i) {
                int n3 = m_resCount[i];
                if (n3 < 1) continue;
                for (int j = 0; j < n3; ++j) {
                    ResourceMgr.checkPaused();
                    byte by = m_resAttr[n + j];
                    if (by != 0 && (by & 8) == 0) {
                        if ((by & 4) != 0) {
                            if ((by & 2) != 0) {
                                ResourceMgr.load(i, j);
                            } else if ((by & 0x40) != 0) {
                                ResourceMgr.loadFromRPK(i, j);
                            }
                        }
                        GameMIDletAQUA.resourceProgress(++m_progress, m_offsets[0]);
                        Thread.yield();
                        continue;
                    }
                    ++m_progress;
                }
                n += n3;
            }
        }
        finally {
            ResourceMgr.cleanUp(null);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkPaused() {
        while (true) {
            Object object = pauseLock;
            synchronized (object) {
                if (!paused) {
                    return;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private static void cleanUp(OutputStream outputStream) {
        try {
            if (rpk_is != null) {
                rpk_is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        rpk_is = null;
        rpk_ds = null;
        initState = false;
    }

    public static Object[] getResources(Object[] objectArray, int n, int n2, int n3, boolean bl) {
        Object[] objectArray2 = objectArray;
        if (objectArray2 == null) {
            objectArray2 = new Object[n3];
        }
        initState = true;
        for (int i = 0; i < n3; ++i) {
            ResourceMgr.checkPaused();
            if (i == n3 - 1) {
                initState = false;
            }
            objectArray2[i] = null;
            objectArray2[i] = ResourceMgr.getResource(n, n2);
            if (bl) {
                ResourceMgr.free(n, n2);
            }
            ++n2;
            Thread.yield();
            GameMIDletAQUA.resourceProgress(i, n3);
        }
        return objectArray2;
    }

    public static Image[] getImages(Image[] imageArray, int n, int n2, int n3, boolean bl) {
        Image[] imageArray2 = imageArray;
        if (imageArray2 == null) {
            imageArray2 = new Image[n2];
        }
        initState = true;
        for (int i = 0; i < n2; ++i) {
            ResourceMgr.checkPaused();
            if (i == n2 - 1) {
                initState = false;
            }
            imageArray2[i] = null;
            imageArray2[i] = ResourceMgr.getImage(n, n3);
            if (bl) {
                ResourceMgr.free(1, n);
            }
            ++n;
            Thread.yield();
            GameMIDletAQUA.resourceProgress(i, n2);
        }
        return imageArray2;
    }

    public static Image getImage(int n) {
        if (n == -1) {
            return null;
        }
        return ResourceMgr.getImage(n & 0xFFFF, n >> 16);
    }

    public static Image getImage(int n, int n2) {
        Image image = null;
        if (n == -1) {
            return null;
        }
        if (m_res[1][n] == null) {
            ResourceMgr.load(1, n);
        }
        image = (Image)m_res[1][n];
        return image;
    }

    public static byte[] getResource(int n, int n2) {
        if (m_res[n][n2] == null) {
            ResourceMgr.load(n, n2);
        }
        return (byte[])m_res[n][n2];
    }

    public static DataInputStream getResourceStream(int n, int n2) {
        InputStream inputStream = ResourceMgr.getResourceStreamPlain(n, n2);
        return new DataInputStream(inputStream);
    }

    public static InputStream getResourceStreamPlain(int n, int n2) {
        InputStream inputStream;
        byte by = m_resAttr[m_offsets[n] + n2];
        if ((by & 8) == 0 && (by & 2) != 0) {
            inputStream = m_class.getResourceAsStream("/" + n2 + FILE_EXT_ARRAY[n]);
        } else if ((by & 8) == 0 && (by & 0x40) != 0) {
            inputStream = m_class.getResourceAsStream("/" + rpkFileId[n][n2] + ".rpk");
            try {
                if (resOffset[n][n2] > 0) {
                    inputStream.skip(resOffset[n][n2]);
                }
            }
            catch (Exception exception) {}
        } else {
            inputStream = new ByteArrayInputStream(ResourceMgr.getResource(n, n2));
        }
        return inputStream;
    }

    public static void initializeRPKTables() throws IOException {
        InputStream inputStream = m_class.getResourceAsStream("/1.rpk");
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        resOffset = new int[m_resCount.length][];
        rpkFileId = new byte[m_resCount.length][];
        for (int i = 1; i < m_resCount.length; ++i) {
            int n = dataInputStream.readInt();
            ResourceMgr.resOffset[i] = new int[n + 1];
            ResourceMgr.rpkFileId[i] = new byte[n + 1];
            for (int j = 1; j <= n; ++j) {
                ResourceMgr.resOffset[i][j] = dataInputStream.readInt();
                ResourceMgr.rpkFileId[i][j] = dataInputStream.readByte();
            }
        }
        dataInputStream.close();
    }

    public static void loadFromRPK(int n, int n2) {
        block14: {
            try {
                int n3 = m_offsets[n];
                byte by = m_resAttr[n3 + n2];
                if ((by & 8) != 0) break block14;
                if ((by & 0x40) != 0) {
                    int n4;
                    if (resOffset == null) {
                        ResourceMgr.initializeRPKTables();
                    }
                    int n5 = (n4 = resOffset[n][n2]) < 0 ? 0 : n4;
                    int n6 = resOffset[n][n2 + 1];
                    if (rpk_is == null || currentRpkId != rpkFileId[n][n2] || lastRpkPos > n5) {
                        if (rpk_is != null) {
                            rpk_is.close();
                            rpk_is = null;
                        }
                        rpk_is = m_class.getResourceAsStream("/" + rpkFileId[n][n2] + ".rpk");
                        rpk_ds = new DataInputStream(rpk_is);
                        lastRpkPos = rpk_ds.skipBytes(n5);
                    } else {
                        lastRpkPos += rpk_ds.skipBytes(n5 - lastRpkPos);
                    }
                    currentRpkId = rpkFileId[n][n2];
                    int n7 = n6 < 0 ? -n6 : (n4 < 0 ? n6 : n6 - n4);
                    byte[] byArray = new byte[n7];
                    lastRpkPos += rpk_ds.read(byArray, 0, n7);
                    if (!initState) {
                        try {
                            rpk_is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        rpk_ds = null;
                        rpk_is = null;
                    }
                    int n8 = n;
                    if ((by & 0x20) != 0) {
                        n = 0;
                    }
                    switch (n) {
                        case 1: {
                            ResourceMgr.m_res[n][n2] = Image.createImage((byte[])byArray, (int)0, (int)n7);
                            break;
                        }
                        default: {
                            n = n8;
                            ResourceMgr.m_res[n][n2] = byArray;
                        }
                    }
                }
                int n9 = n3 + n2;
                m_resAttr[n9] = (byte)(m_resAttr[n9] | 8);
            }
            catch (Exception exception) {
                String string = null;
                throw new RuntimeException(string);
            }
        }
    }

    public static void load(int n, int n2) {
        try {
            int n3 = m_offsets[n];
            byte by = m_resAttr[n3 + n2];
            if ((by & 8) == 0) {
                if ((by & 2) != 0) {
                    StringBuffer stringBuffer = new StringBuffer(8);
                    stringBuffer.append("/");
                    stringBuffer.append(n2);
                    stringBuffer.append(FILE_EXT_ARRAY[n]);
                    int n4 = n;
                    if ((by & 0x20) != 0) {
                        n = 0;
                    }
                    switch (n) {
                        case 1: {
                            ResourceMgr.m_res[1][n2] = Image.createImage((String)stringBuffer.toString());
                            break;
                        }
                        default: {
                            n = n4;
                            ResourceMgr.m_res[n][n2] = ResourceMgr.readRawData(stringBuffer.toString());
                            break;
                        }
                    }
                } else if ((by & 0x40) != 0) {
                    ResourceMgr.loadFromRPK(n, n2);
                }
                int n5 = n3 + n2;
                m_resAttr[n5] = (byte)(m_resAttr[n5] | 8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void add(int n, int n2, Object object) {
        ResourceMgr.m_res[n][n2] = object;
        int n3 = m_offsets[n] + n2;
        m_resAttr[n3] = (byte)(m_resAttr[n3] | 8);
    }

    public static byte[] readRawData(String string) throws IOException {
        int n;
        byte[] byArray = new byte[5120];
        InputStream inputStream = m_class.getResourceAsStream(string);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = byArray.length;
        while ((n = dataInputStream.read(byArray, 0, n2)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        byArray = null;
        return byteArrayOutputStream.toByteArray();
    }

    public static void load(byte by) {
        int n = 0;
        for (int i = 1; i < m_resCount.length; ++i) {
            int n2 = m_resCount[i];
            for (int j = 0; j < n2; ++j) {
                byte by2;
                if (((by2 = m_resAttr[n++]) & by) == 0) continue;
                ResourceMgr.load(i, j);
            }
        }
    }

    public static boolean resourceLoaded(int n, int n2) {
        return m_res != null && m_res.length > n && m_res[n] != null && m_res[n].length > n2 && m_res[n][n2] != null;
    }

    public static boolean free(int n, int n2) {
        if (n2 == -1) {
            return false;
        }
        return false;
    }

    public static void free(int n, int n2, int n3) {
        for (int i = n3 - 1; i >= 0; --i) {
            ResourceMgr.free(n, n2);
            ++n2;
        }
    }

    public static boolean resInRPK(int n, int n2) {
        int n3 = m_offsets[n];
        return (m_resAttr[n3 + n2] & 0x40) != 0;
    }

    private static String getRmsName(int n) {
        return "res" + n;
    }

    public static void closeRms(RecordStore recordStore) {
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void runThread() {
        try {
            int n = 0;
            switch (n) {
                case 0: 
                case 5: {
                    n = ResourceMgr.initResources();
                }
            }
            GameMIDletAQUA.resourceDone(n, null);
        }
        catch (RecordStoreFullException recordStoreFullException) {
            GameMIDletAQUA.resourceDone(4, null);
        }
        catch (RecordStoreException recordStoreException) {
            GameMIDletAQUA.resourceDone(3, null);
        }
        catch (Throwable throwable) {
            GameMIDletAQUA.resourceDone(2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPaused(boolean bl) {
        Object object = pauseLock;
        synchronized (object) {
            paused = bl;
        }
    }

    static {
        boolean bl = true;
        resOffset = null;
        rpkFileId = null;
        currentRpkId = 2;
        lastRpkPos = 0;
        initState = true;
        m_progress = 0;
        m_errorCount = 0;
        pauseLock = new Object();
        paused = false;
        m_wnet = null;
        nullByte = new byte[]{0};
    }
}

