/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game.physics;

public class Vector2D {
    public int x;
    public int y;

    public Vector2D() {
        this.x = 0;
        this.y = 0;
    }

    public Vector2D(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Vector2D(Vector2D vector2D) {
        this.x = vector2D.x;
        this.y = vector2D.y;
    }

    public Vector2D init() {
        this.x = 0;
        this.y = 0;
        return this;
    }

    public Vector2D init(int n, int n2) {
        this.x = n;
        this.y = n2;
        return this;
    }

    public Vector2D init(Vector2D vector2D) {
        this.x = vector2D.x;
        this.y = vector2D.y;
        return this;
    }

    public Vector2D setEqual(Vector2D vector2D) {
        this.x = vector2D.x;
        this.y = vector2D.y;
        return this;
    }

    public Vector2D addEqual(Vector2D vector2D) {
        this.x += vector2D.x;
        this.y += vector2D.y;
        return this;
    }

    public Vector2D subEqual(Vector2D vector2D) {
        this.x -= vector2D.x;
        this.y -= vector2D.y;
        return this;
    }

    public Vector2D mulEqual(int n) {
        int n2 = n >> 5;
        this.x = (this.x >> 5) * n2;
        this.y = (this.y >> 5) * n2;
        return this;
    }

    public Vector2D divEqual(int n) {
        int n2 = n >> 5;
        this.x = (this.x << 5) / n2;
        this.y = (this.y << 5) / n2;
        return this;
    }

    public boolean equals(Vector2D vector2D) {
        return this.x == vector2D.x && this.y == vector2D.y;
    }

    public boolean notEquals(Vector2D vector2D) {
        return this.x != vector2D.x || this.y != vector2D.y;
    }

    public String toString() {
        return new String("[x=" + this.x + ",y=" + this.y + "]");
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public int length() {
        return Vector2D.vector2DDistanceApprox(this.x, this.y);
    }

    public int lengthSqr() {
        int n = this.x >> 5;
        int n2 = this.y >> 5;
        return n * n + n2 * n2;
    }

    public int distTo(Vector2D vector2D) {
        return Vector2D.vector2DDistanceApprox(this.x - vector2D.x, this.y - vector2D.y);
    }

    public int distToSqr(Vector2D vector2D) {
        int n = this.x - vector2D.x >> 5;
        int n2 = this.y - vector2D.y >> 5;
        return n * n + n2 * n2;
    }

    public void mulAdd(Vector2D vector2D, Vector2D vector2D2, int n) {
        int n2 = n >> 5;
        this.x = vector2D.x + (vector2D2.x >> 5) * n2;
        this.y = vector2D.y + (vector2D2.y >> 5) * n2;
    }

    public int dot(Vector2D vector2D) {
        return (this.x >> 5) * (vector2D.x >> 5) + (this.y >> 5) * (vector2D.y >> 5);
    }

    public void normalize() {
        int n = this.length() >> 5;
        if (n != 0) {
            this.x = (this.x << 5) / n;
            this.y = (this.y << 5) / n;
        }
    }

    public static void vector2DMA(Vector2D vector2D, int n, Vector2D vector2D2, Vector2D vector2D3) {
        int n2 = n >> 5;
        vector2D3.x = vector2D.x + (vector2D2.x >> 5) * n2;
        vector2D3.y = vector2D.y + (vector2D2.y >> 5) * n2;
    }

    public static void vector2DLerp(Vector2D vector2D, Vector2D vector2D2, int n, Vector2D vector2D3) {
        vector2D3.x = vector2D.x + ((vector2D2.x - vector2D.x) * n >> 10);
        vector2D3.y = vector2D.y + ((vector2D2.y - vector2D.y) * n >> 10);
    }

    public static int vector2DDistanceApprox(int n, int n2) {
        int n3;
        int n4;
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n < n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        int n5 = n3 * 1007 + n4 * 441;
        if (n3 < n4 << 4) {
            n5 -= n3 * 40;
        }
        return n5 + 512 >> 10;
    }
}

