/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game.physics;

import com.sorrent.game.AquaCanvas;
import com.sorrent.game.AquaLevel;
import com.sorrent.game.AquaObject;
import com.sorrent.game.physics.Body;
import com.sorrent.game.physics.CollisionContact;
import com.sorrent.game.physics.Vector2D;

public final class PhysicsEngine {
    public static final int COLLISION_NONE = 0;
    public static final int COLLISION_PENETRATING = 1;
    public static final int COLLISION_COLLIDING = 2;
    public static final int PHYSICS_EPSILON_DELTAT = 64;
    public static final int PHYSICS_MAX_CONTACT = 10;
    private static CollisionContact[] contacts = new CollisionContact[10];
    private static int contactsCnt;
    private static Body nodes;
    private static Body envBody;
    private static int nodesCount;
    private static boolean running;
    private static boolean gotNodeToDestroy;

    public static void reset() {
        while (nodes != null) {
            PhysicsEngine.removeBody(nodes);
        }
    }

    public static int getBodyCount() {
        return nodesCount;
    }

    public static void setEnvBody(Body body) {
        envBody = body;
    }

    public static void addBody(Body body) {
        PhysicsEngine.addBody(body, true);
    }

    public static void addBody(Body body, boolean bl) {
        if (nodes == null) {
            nodes = body;
        } else {
            PhysicsEngine.nodes.prev = body;
            body.next = nodes;
            body.prev = null;
            nodes = body;
        }
        body.canCollide = bl;
        ++nodesCount;
    }

    public static void removeBody(Body body) {
        body.toBeRemoved = true;
        body.canCollide = false;
        gotNodeToDestroy = true;
        PhysicsEngine.deleteUnusedNodes();
    }

    public static void deleteUnusedNodes() {
        if (running) {
            return;
        }
        if (!gotNodeToDestroy) {
            return;
        }
        Body body = nodes;
        while (body != null) {
            Body body2 = body.next;
            Body body3 = body.prev;
            if (body.toBeRemoved) {
                if (body == nodes) {
                    nodes = body2;
                } else {
                    body3.next = body2;
                }
                if (body2 != null) {
                    body2.prev = body3;
                }
                body.prev = null;
                body.next = null;
                body.destroyedNotify();
                if (body == envBody) {
                    envBody = null;
                }
                --nodesCount;
            }
            body = body2;
        }
        gotNodeToDestroy = false;
    }

    public static boolean simulate(int n) {
        PhysicsEngine.deleteUnusedNodes();
        running = true;
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n) {
            if (++n5 > 10) {
                Body body = nodes;
                while (body != null) {
                    body.vel.init(0, 0);
                    body.predictedVel.init(0, 0);
                    body = body.next;
                }
                running = false;
                return true;
            }
            PhysicsEngine.computeForces();
            PhysicsEngine.integrateSystem(n3 - n2);
            n4 = PhysicsEngine.checkForCollisions();
            if (n4 == 1) {
                if ((n3 = n2 + n3 >> 1) - n2 > 64) continue;
                contactsCnt = 1;
                PhysicsEngine.resolveCollisions();
                PhysicsEngine.contacts[0].collisionableObject.vel.init(PhysicsEngine.contacts[0].collisionableObject.predictedVel);
                continue;
            }
            boolean bl = false;
            if (n4 == 2) {
                bl = !PhysicsEngine.resolveCollisions();
            }
            n2 = n3;
            n3 = n;
            Body body = nodes;
            while (body != null) {
                body.predictedToCurrent();
                body = body.next;
            }
            if (!bl) continue;
            running = false;
            PhysicsEngine.deleteUnusedNodes();
            return false;
        }
        running = false;
        PhysicsEngine.deleteUnusedNodes();
        return true;
    }

    public static void computeForces() {
        Body body = nodes;
        while (body != null) {
            body.computeForces(envBody);
            body = body.next;
        }
    }

    public static int checkForCollisions() {
        int n = 0;
        contactsCnt = 0;
        AquaObject aquaObject = AquaLevel.projectile;
        Body body = nodes;
        while (body != null) {
            if (body.canCollide && body.supportCollision(aquaObject) && (n = body.checkForCollision(aquaObject, contacts[contactsCnt])) != 0) {
                if (n == 1) {
                    return 1;
                }
                if (n == 2) {
                    ++contactsCnt;
                }
            }
            body = body.next;
        }
        if (contactsCnt == 0) {
            return 0;
        }
        return 2;
    }

    public static boolean resolveCollisions() {
        for (int i = 0; i < contactsCnt; ++i) {
            CollisionContact collisionContact = contacts[i];
            if (!collisionContact.collisionableObject.collisionNotify(collisionContact)) {
                return false;
            }
            if (!collisionContact.collisionHandler.collisionNotify(collisionContact)) {
                return false;
            }
            collisionContact.collisionHandler.resolveCollision(collisionContact);
        }
        contactsCnt = 0;
        return true;
    }

    public static void integrateSystem(int n) {
        Body body = nodes;
        Vector2D vector2D = AquaCanvas.tempV1;
        while (body != null) {
            if (body.canMove) {
                vector2D.init(body.force);
                vector2D.mulEqual(n);
                vector2D.divEqual(body.mass);
                body.predictedVel.init(body.vel);
                body.predictedVel.addEqual(vector2D);
                body.predictedPos.mulAdd(body.pos, body.vel, n);
            }
            body.buildBoundingBox();
            body = body.next;
        }
    }

    static {
        for (int i = 9; i >= 0; --i) {
            PhysicsEngine.contacts[i] = new CollisionContact();
        }
        nodes = null;
        nodesCount = 0;
        running = false;
        gotNodeToDestroy = false;
    }
}

