/*
 * Decompiled with CFR 0.152.
 */
package com.sorrent.game;

import com.sorrent.game.AquaCanvas;
import com.sorrent.game.AquaObject;
import com.sorrent.game.AquaResourceImage;
import com.sorrent.game.GameData;
import com.sorrent.game.physics.BodyEnv;
import com.sorrent.game.physics.PhysicsEngine;
import com.sorrent.game.physics.Vector2D;
import com.sorrent.resource.ResourceMgr;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class AquaLevel {
    public static final int MAX_OBJECT_PROPERTIES = 10;
    public static final int MAX_OBJECTS = 25;
    public static final int LOAD_APPLE = 0;
    public static final int LOAD_DYNA = 1;
    public static final int LOAD_ERR = 2;
    public static final int LOAD_FIRE = 3;
    public static final int LOAD_INI = 4;
    public static final int LOAD_BRAIN = 5;
    public static final int LOAD_RADIO = 6;
    public static final int LOAD_SPRING = 7;
    public static final int LOAD_TV = 8;
    public static final int LOAD_CUBE = 9;
    public static final int LOAD_START = 10;
    public static final int LOAD_BARH = 11;
    public static final int LOAD_BARV = 12;
    public static final int LOAD_SPHERE = 13;
    public static final int LOAD_SHIP = 14;
    public static final int LOAD_CAR = 15;
    public static final int LOAD_POOL = 16;
    public static final int LOAD_FARGATE = 17;
    public static final int LOAD_EXTRA = 18;
    public static final int LOAD_BOULE = 19;
    public static final int LOAD_BOMB = 20;
    public static final int LOAD_BROWN = 21;
    public static final int LOAD_PUPPET = 22;
    public static boolean cam_recenter;
    public static BodyEnv environement;
    public static AquaObject projectile;
    public static AquaObject targetObject;
    public static boolean obj_isDyna;
    public static boolean obj_canDestroyCar;
    public static String objective_text;
    public static int score_stars;
    public static int score_damage;
    public static int score_distance;
    public static int score_total;
    public static int success_distance;
    public static boolean success;
    public static Object curLevelData;
    public static int index;
    public static Vector2D cam_focusedObject;
    private static int cam_centerX;
    private static int cam_centerY;
    private static int cam_oldCenterX;
    private static int cam_oldCenterY;
    private static int cam_currentStep;
    private static int halfViewWReal;
    private static int viewWReal;
    private static final int top_color = 10861722;
    private static final int bottom_color = 5134945;
    private static final int skyb_color = 2369061;
    private static final int line_color = 7500912;
    private static final int line_h = 8;
    private static final int topToMiddleVisible = 43;
    private static final int bottomAdditional = 10;
    private static AquaResourceImage back;
    private static AquaResourceImage front;
    private static int[] load_propertiesCount;
    private static int[] load_curObject;
    private static final short[] success_distances;
    private static byte[] levelMap;

    public static int load_convertDistance(int n) {
        return n * 10 << 10;
    }

    public static int load_convertLife(int n) {
        return n * 1000000;
    }

    public static int getCameraY() {
        return cam_centerY;
    }

    public static int getCameraStartX() {
        return cam_centerX - halfViewWReal >> 10;
    }

    public static int getCameraStartXReal() {
        return cam_centerX - halfViewWReal;
    }

    public static int getCameraEndX() {
        return cam_centerX + halfViewWReal >> 10;
    }

    public static int getCameraEndXReal() {
        return cam_centerX + halfViewWReal;
    }

    public static void init() {
        viewWReal = AquaCanvas.screenWidth << 10;
        halfViewWReal = viewWReal >> 1;
    }

    public static void delete() {
        AquaLevel.freeImages();
        AquaLevel.freePhysics();
    }

    public static boolean createLevel(int n) {
        AquaLevel.freeImages();
        AquaLevel.freePhysics();
        index = n;
        score_total = 0;
        score_distance = 0;
        score_damage = 0;
        score_stars = 0;
        objective_text = GameData.get(92 + index);
        try {
            DataInputStream dataInputStream = ResourceMgr.getResourceStream(5, index + 1);
            int n2 = dataInputStream.read(levelMap);
            dataInputStream.close();
            ResourceMgr.free(5, index + 1);
        }
        catch (Exception exception) {
            return false;
        }
        if (!AquaLevel.initImages()) {
            return false;
        }
        if (!AquaLevel.initPhysics()) {
            return false;
        }
        AquaLevel.cam_reinit();
        return true;
    }

    public static boolean initImages() {
        front = AquaCanvas.rsc_bg1;
        back = AquaCanvas.rsc_sky1;
        front.obtainResource();
        back.obtainResource();
        return true;
    }

    public static boolean MOTEST(AquaObject aquaObject) {
        if (aquaObject == null) {
            return false;
        }
        return aquaObject.initialized;
    }

    public static boolean initPhysics() {
        for (int i = 0; i < 60; ++i) {
            AquaCanvas.vGfx[i] = null;
        }
        obj_canDestroyCar = false;
        obj_isDyna = false;
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(levelMap));
            success = false;
            success_distance = success_distances[index];
            dataInputStream.skipBytes(4);
            int n2 = dataInputStream.readInt() << 10;
            int n3 = dataInputStream.readInt();
            for (n = 0; n < n3; ++n) {
                AquaLevel.load_propertiesCount[n] = dataInputStream.readInt();
            }
            int n4 = dataInputStream.readInt();
            AquaCanvas.numAquaObjects = n4 - 1;
            targetObject = null;
            for (n = 0; n < n4; ++n) {
                byte by = dataInputStream.readByte();
                for (int i = 0; i < load_propertiesCount[by]; ++i) {
                    AquaLevel.load_curObject[i] = dataInputStream.readShort();
                }
                if (by == 10) {
                    AquaCanvas.projectile_startPoint = load_curObject[3];
                    AquaCanvas.projectile_startPoint = AquaLevel.load_convertDistance(AquaCanvas.projectile_startPoint);
                    AquaLevel.environement.bouncingCoef = load_curObject[4];
                    AquaLevel.environement.frictionCoef = load_curObject[5];
                    continue;
                }
                int n5 = AquaLevel.load_convertDistance(load_curObject[0]);
                int n6 = load_curObject[1] << 10;
                AquaObject aquaObject = null;
                switch (by) {
                    case 0: {
                        aquaObject = new AquaObject(65540, load_curObject[4] << 10, 19456, 19456, 1000, AquaCanvas.rsc_apple, AquaCanvas.rsc_apple2, AquaLevel.load_convertLife(load_curObject[3]), 5120, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 1: {
                        aquaObject = new AquaObject(36, load_curObject[4] << 10, 21504, 21504, 1000, AquaCanvas.rsc_dyna, null, AquaLevel.load_convertLife(load_curObject[3]), 7168, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                        obj_isDyna = true;
                        break;
                    }
                    case 2: {
                        aquaObject = new AquaObject(1026, load_curObject[4] << 10, 17408, 17408, 1000, AquaCanvas.rsc_err, null, AquaLevel.load_convertLife(load_curObject[3]), 0, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 3: {
                        aquaObject = new AquaObject(258, 0, 11264, 17408, 0, AquaCanvas.rsc_fire, null, 0, 0, null, 0);
                        aquaObject.givenDamage = load_curObject[3];
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 4: {
                        aquaObject = new AquaObject(514, load_curObject[4] << 10, 27648, 27648, 1000, AquaCanvas.rsc_ini, null, AquaLevel.load_convertLife(load_curObject[3]), 0, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 5: {
                        aquaObject = new AquaObject(131076, load_curObject[4] << 10, 21504, 21504, 1000, AquaCanvas.rsc_brain, null, AquaLevel.load_convertLife(load_curObject[3]), 4096, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 6: {
                        aquaObject = new AquaObject(0x100008, load_curObject[4] << 10, 24576, 24576, 1000, AquaCanvas.rsc_radio, null, AquaLevel.load_convertLife(load_curObject[3]), 5120, AquaObject.aosquare_frames2, 2);
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 7: {
                        aquaObject = new AquaObject(262146, 0, 16384, 19456, 0, AquaCanvas.rsc_spring, null, 0, 0, null, 0);
                        aquaObject.addBoucingCoef = load_curObject[3] << 10;
                        break;
                    }
                    case 8: {
                        aquaObject = new AquaObject(524296, load_curObject[4] << 10, 29696, 29696, 1000, AquaCanvas.rsc_tv, null, AquaLevel.load_convertLife(load_curObject[3]), 3072, AquaObject.aosquare_frames2, 2);
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 9: {
                        aquaObject = new AquaObject(16388, load_curObject[4] << 10, 25600, 26624, 1000, AquaCanvas.rsc_cube, null, AquaLevel.load_convertLife(load_curObject[3]), 2048, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 13: {
                        aquaObject = new AquaObject(130, 0, 25600, 25600, 0, AquaCanvas.rsc_sphere, null, 0, 0, null, 0);
                        aquaObject.bouncingCoef = load_curObject[3];
                        break;
                    }
                    case 14: {
                        targetObject = aquaObject = new AquaObject(0x200002, 0, 43008, 58368, 0, AquaCanvas.rsc_ship, null, 0, 0, null, 0);
                        break;
                    }
                    case 15: {
                        targetObject = aquaObject = new AquaObject(4098, 0, 71680, 22528, 0, AquaCanvas.rsc_car, null, AquaLevel.load_convertLife(load_curObject[3]), 0, null, 0);
                        break;
                    }
                    case 16: {
                        targetObject = aquaObject = new AquaObject(66, 0, 69632, 26624, 0, AquaCanvas.rsc_pool, null, 0, 0, null, 0);
                        break;
                    }
                    case 17: {
                        aquaObject = new AquaObject(2050, 0, 23552, 52224, 0, AquaCanvas.rsc_fargate, null, 0, 0, null, 0);
                        aquaObject.dest = new Vector2D(AquaLevel.load_convertDistance(load_curObject[3]) + AquaCanvas.projectile_startPoint, AquaLevel.load_convertDistance(load_curObject[4]));
                        break;
                    }
                    case 18: {
                        aquaObject = new AquaObject(32770, 0, 21504, 21504, 0, AquaCanvas.rsc_extra, null, 0, 0, null, 0);
                        aquaObject.frameIndex = aquaObject.model = load_curObject[3];
                        break;
                    }
                    case 19: {
                        aquaObject = new AquaObject(0x800002, load_curObject[4] << 10, 16384, 16384, 1000, AquaCanvas.rsc_boule, null, AquaLevel.load_convertLife(load_curObject[3]), 0, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 20: {
                        aquaObject = new AquaObject(0x400002, load_curObject[4] << 10, 16384, 17408, 1000, AquaCanvas.rsc_bomb, null, AquaLevel.load_convertLife(load_curObject[3]), 0, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                        obj_isDyna = true;
                        break;
                    }
                    case 21: {
                        aquaObject = new AquaObject(8194, load_curObject[4] << 10, 34816, 31744, 1000, AquaCanvas.rsc_bidle, null, AquaLevel.load_convertLife(load_curObject[3]), 0, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                        break;
                    }
                    case 22: {
                        aquaObject = new AquaObject(18, load_curObject[4] << 10, 20480, 22528, 1000, AquaCanvas.rsc_puppet, null, AquaLevel.load_convertLife(load_curObject[3]), 0, null, 0);
                        aquaObject.bouncingCoef = load_curObject[5];
                    }
                }
                AquaCanvas.vGfx[n - 1] = aquaObject;
                aquaObject.pos.init(n5 + AquaCanvas.projectile_startPoint, n2 - n6 - aquaObject.height);
                n2 += 0;
                n6 += 0;
                PhysicsEngine.addBody(aquaObject);
                if (n != 1) continue;
                projectile = aquaObject;
                AquaLevel.projectile.pos.init(AquaCanvas.projectile_startPoint + (AquaCanvas.getRelDistance() << 10), 0);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PhysicsEngine.addBody(environement);
        PhysicsEngine.setEnvBody(environement);
        return true;
    }

    public static void freeImages() {
        AquaCanvas.rsc_radio.releaseResource();
        AquaCanvas.rsc_sphere.releaseResource();
        AquaCanvas.rsc_car.releaseResource();
        AquaCanvas.rsc_cube.releaseResource();
        AquaCanvas.rsc_tv.releaseResource();
        AquaCanvas.rsc_dyna.releaseResource();
        AquaCanvas.rsc_apple.releaseResource();
        AquaCanvas.rsc_apple2.releaseResource();
        AquaCanvas.rsc_brain.releaseResource();
        AquaCanvas.rsc_err.releaseResource();
        AquaCanvas.rsc_ini.releaseResource();
        AquaCanvas.rsc_ship.releaseResource();
        AquaCanvas.rsc_pool.releaseResource();
        AquaCanvas.rsc_fargate.releaseResource();
        AquaCanvas.rsc_boule.releaseResource();
        AquaCanvas.rsc_bomb.releaseResource();
        AquaCanvas.rsc_bair.releaseResource();
        AquaCanvas.rsc_bidle.releaseResource();
        AquaCanvas.rsc_puppet.releaseResource();
    }

    public static void freePhysics() {
        PhysicsEngine.removeBody(environement);
        PhysicsEngine.setEnvBody(null);
        projectile = null;
    }

    public static void cam_reinit() {
        cam_focusedObject = null;
        cam_currentStep = 0;
        cam_recenter = false;
        cam_oldCenterX = 0;
        cam_oldCenterY = 0;
    }

    public static void cam_setFocusedObject(Vector2D vector2D) {
        if (vector2D != null) {
            cam_recenter = true;
            cam_currentStep = 0;
        } else {
            cam_recenter = false;
        }
        cam_focusedObject = vector2D;
    }

    public static boolean cam_tick() {
        if (cam_recenter) {
            if (++cam_currentStep == 10) {
                cam_recenter = false;
            }
            int n = 10240 / cam_currentStep;
            Vector2D vector2D = AquaCanvas.tempV1.init(cam_oldCenterX, cam_oldCenterY);
            Vector2D vector2D2 = AquaCanvas.tempV2.init(cam_focusedObject);
            vector2D2.subEqual(vector2D);
            vector2D2.mulEqual(n);
            vector2D.addEqual(vector2D2);
            cam_centerX = vector2D.x;
            cam_centerY = vector2D.y;
        } else if (cam_focusedObject != null) {
            cam_centerX = AquaLevel.cam_focusedObject.x;
            cam_centerY = AquaLevel.cam_focusedObject.y;
            if (cam_centerX < AquaCanvas.projectile_startPoint && cam_focusedObject.equals(AquaLevel.projectile.pos)) {
                AquaLevel.cam_setFocusedObject(null);
                AquaCanvas.simuShouldStop = false;
                AquaCanvas.gameStatus = 1024;
            }
        }
        if (cam_centerX < AquaCanvas.screenWidth << 9) {
            cam_centerX = AquaCanvas.screenWidth << 9;
        }
        return true;
    }

    public static void drawBackground(Graphics graphics) {
        int n;
        int n2 = AquaCanvas.screenWidth;
        int n3 = AquaCanvas.screenHeight;
        int n4 = n3 - 25;
        int n5 = n4 >> 1;
        int n6 = cam_centerX >> 10;
        int n7 = cam_centerY >> 10;
        Image image = AquaLevel.front.img;
        Image image2 = AquaLevel.back.img;
        int n8 = n7 - n5;
        if (n8 < 0) {
            n8 = 0;
        }
        int n9 = image.getWidth();
        int n10 = -(n6 % n9);
        int n11 = n4 + n8 - image.getHeight() - 10;
        int n12 = n11 + 43;
        int n13 = n12 - n4 - 43;
        n12 = n4 + 10 - 43 + (n13 * 32 >> 8);
        int n14 = image2.getWidth();
        int n15 = -(n6 * 128 >> 8);
        n15 %= n14;
        n12 -= image2.getHeight();
        while (n15 < n2 && n12 < n4) {
            graphics.drawImage(image2, n15, n12, 20);
            n15 += n14;
        }
        if (n12 > 0) {
            graphics.setColor(10861722);
            graphics.fillRect(0, 0, n2, n12);
        }
        if ((n12 += image2.getHeight()) < n4) {
            graphics.setColor(2369061);
            graphics.fillRect(0, n12, n2, n4 - n12);
        }
        while (n10 < n2 && n11 < n4) {
            graphics.drawImage(image, n10, n11, 20);
            n10 += n9;
        }
        if ((n11 += image.getHeight()) < n4) {
            graphics.setColor(5134945);
            graphics.fillRect(0, n11, n2, 10);
        }
        if ((n = (AquaCanvas.projectile_startPoint >> 10) + AquaCanvas.getRelDistance()) >= AquaLevel.getCameraStartX() && n < AquaLevel.getCameraEndX()) {
            graphics.setColor(7500912);
            graphics.drawLine(n -= AquaLevel.getCameraStartX(), n11 - 8, n, n4);
        }
    }

    public static void drawBackground2(Graphics graphics) {
        int n = AquaCanvas.screenWidth;
        int n2 = AquaCanvas.screenHeight;
        int n3 = n2 - 25;
        graphics.setColor(0);
        graphics.fillRect(0, n3, n, 25);
        graphics.setColor(0xFFFF00);
        graphics.drawLine(0, n3, n, n3);
    }

    static {
        environement = new BodyEnv();
        load_propertiesCount = new int[25];
        load_curObject = new int[10];
        success_distances = new short[]{250, 0, 300, 0, 700, 0, 300, 0, 600, 0, 350, 0, 300, 0, 0, 0};
        levelMap = new byte[4096];
    }
}

