/*
 * Decompiled with CFR 0.152.
 */
public abstract class MathFP {
    private static int _fbits = 12;
    private static int _one;
    private static int _fmask;
    private static int _pi;
    public static int PI;

    public static int toInt(int n) {
        if (n < 0) {
            return -(MathFP.round(-n, 0) >> _fbits);
        }
        return MathFP.round(n, 0) >> _fbits;
    }

    public static int toFP(int n) {
        return n << _fbits;
    }

    private static int max(int n, int n2) {
        if (n >= n2) {
            return n;
        }
        return n2;
    }

    private static int round(int n, int n2) {
        n2 = MathFP.div(5 << _fbits, 10 << _fbits);
        if (n < 0) {
            n2 = -n2;
        }
        return n + n2;
    }

    public static int mul(int n, int n2) {
        boolean bl = false;
        int n3 = _fbits;
        int n4 = _fmask;
        if ((n & n4) == 0) {
            return (n >> n3) * n2;
        }
        if ((n2 & n4) == 0) {
            return n * (n2 >> n3);
        }
        if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            bl = true;
        }
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        while (MathFP.max(n, n2) >= 1 << 31 - n3) {
            n >>= 1;
            n2 >>= 1;
            n4 >>= 1;
            --n3;
        }
        int n5 = (n >> n3) * (n2 >> n3) << n3;
        int n6 = 0;
        n6 = ((n & n4) * (n2 & n4) >> n3) + ((n & ~n4) * (n2 & n4) >> n3);
        if ((n5 = n5 + n6 + ((n & n4) * (n2 & ~n4) >> n3) << _fbits - n3) < 0) {
            throw new ArithmeticException("Overflow");
        }
        if (bl) {
            return -n5;
        }
        return n5;
    }

    public static int div(int n, int n2) {
        boolean bl = false;
        int n3 = _fbits;
        if (n2 == _one) {
            return n;
        }
        if ((n2 & _fmask) == 0) {
            return n / (n2 >> n3);
        }
        if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            bl = true;
        }
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        while (MathFP.max(n, n2) >= 1 << 31 - n3) {
            n >>= 1;
            n2 >>= 1;
            --n3;
        }
        n = (n << n3) / n2 << _fbits - n3;
        if (bl) {
            return -n;
        }
        return n;
    }

    public static int add(int n, int n2) {
        return n + n2;
    }

    public static int sub(int n, int n2) {
        return n - n2;
    }

    private static int sqrt(int n) {
        if (n < 0) {
            throw new ArithmeticException("Bad Input");
        }
        if (n == 0) {
            return 0;
        }
        int n2 = n + _one >> 1;
        for (int i = 0; i < 16; ++i) {
            n2 = n2 + MathFP.div(n, n2) >> 1;
        }
        if (n2 < 0) {
            throw new ArithmeticException("Overflow");
        }
        return n2;
    }

    public static int sin(int n) {
        if ((n = MathFP.mul(n, MathFP.div(180 << _fbits, PI)) % (360 << _fbits)) < 0) {
            n = (360 << _fbits) + n;
        }
        int n2 = n;
        if (n >= 90 << _fbits && n < 270 << _fbits) {
            n2 = (180 << _fbits) - n;
        } else if (n >= 270 << _fbits && n < 360 << _fbits) {
            n2 = -((360 << _fbits) - n);
        }
        n = n2 / 90;
        n2 = MathFP.mul(n, n);
        return MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(-18, n2) + 326, n2) - 2646, n2) + 6434, n);
    }

    public static int cos(int n) {
        return MathFP.sin(PI / 2 - n);
    }

    public static int atan(int n) {
        int n2 = n = MathFP.div(n, MathFP.sqrt(_one + MathFP.mul(n, n)));
        if ((n < 0 ? -n2 : n2) > _one) {
            throw new ArithmeticException("Bad Input");
        }
        int n3 = n2 = n < 0 ? 1 : 0;
        if (n < 0) {
            n = -n;
        }
        int n4 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(35, n) - 146, n) + 347, n) - 877, n) + 6434;
        n = PI / 2 - MathFP.mul(MathFP.sqrt(_one - n), n4);
        if (n2 != 0) {
            return -n;
        }
        return n;
    }

    static {
        _fmask = 4095;
        _one = 4096;
        _pi = 12868;
        int[] nArray = new int[]{_one, 11134, 30266, 82270, 223636};
        PI = _pi;
    }
}

