/*
 * Decompiled with CFR 0.152.
 */
import com.capcomeuro.midp.CapcomCanvas;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Map
implements Game1942Constants {
    private Game1942Main m_game;
    private Image tileSet;
    private Image backBuffer;
    private byte[] map;
    private byte[] mapEvents;
    private byte[] mapMidLayer;
    private static int TILEMAP_HEIGHT = 100;
    private static int MAP_HEIGHT = 21;
    private static int TOTAL_MAP_TILES = 1600;

    Map(Game1942Main game1942Constants) {
        this.m_game = game1942Constants;
        game1942Constants = this;
        boolean bl = false;
        switch (Game1942Constants.g_levelDefintions[Game1942Main.m_level][0]) {
            case 1: 
            case 4: 
            case 6: {
                ((Map)game1942Constants).tileSet = CapcomCanvas.createImage("/Tilesets/" + super.getLevelString() + ".png");
                break;
            }
            case 2: {
                ((Map)game1942Constants).tileSet = CapcomCanvas.createImage("/Tilesets/ocean.png");
                break;
            }
            default: {
                ((Map)game1942Constants).tileSet = CapcomCanvas.createImage("/Tilesets/" + super.getLevelString() + ".png");
            }
        }
        game1942Constants = this;
        try {
            ((Map)game1942Constants).backBuffer = Image.createImage((int)240, (int)320);
        }
        catch (Exception exception) {
            System.out.println("Init map error: " + exception);
        }
        game1942Constants = this;
        String string = "/TileMetaData/Backgrounds/" + super.getLevelString() + "_back";
        ((Map)game1942Constants).map = super.ioLoadMap(string);
        game1942Constants = this;
        string = "/TileMetaData/Backgrounds/" + super.getLevelString() + "_mid";
        ((Map)game1942Constants).mapMidLayer = super.ioLoadMidLayer(string);
        this.mapEvents = this.ioLoadMapEvents("/TileMetaData/Events/codes" + Game1942Main.m_level);
        this.createBackground(0);
    }

    public final void createBossMap() {
        Map map = this;
        String string = "/TileMetaData/Backgrounds/" + map.getLevelString() + "_back_boss";
        map.map = map.ioLoadMapBoss(string);
        map = this;
        string = "/TileMetaData/Backgrounds/" + map.getLevelString() + "_mid_boss";
        map.mapMidLayer = map.ioLoadMidLayerBoss(string);
        this.createBossBackground(0);
    }

    public final void paintBackground$11c44857(Graphics graphics, int n) {
        CapcomCanvas.drawImage$1592e432(graphics, this.backBuffer, 0, n - 15 - 4);
    }

    public final Image createBossBackground(int n) {
        int n2;
        Graphics graphics = this.backBuffer.getGraphics();
        int n3 = 16;
        int n4 = MAP_HEIGHT;
        int n5 = n2 - 16 * (MAP_HEIGHT + 1);
        int n6 = 0;
        for (n2 = 415 - (n << 4); n2 > n5; --n2) {
            n6 = n2;
            if (n6 < 0) {
                n6 += 416;
            }
            CapcomCanvas.drawRegion$712e88cb(graphics, this.tileSet, (this.map[n6] & 0x3F) % 8 * 15, (this.map[n6] & 0x3F) / 8 * 15, 15, 15, Map.getTransform(this.map[n6]), n3 * 15 - 15, n4 * 15);
            if (--n3 != 0) continue;
            n3 = 16;
            --n4;
        }
        n3 = 16;
        n4 = MAP_HEIGHT;
        n5 = n2 - 16 * (MAP_HEIGHT + 1);
        for (n2 = 415 - (n << 4); n2 > n5; --n2) {
            n6 = n2;
            if (n6 < 0) {
                n6 += 416;
            }
            if ((this.mapMidLayer[n6] & 0x3F) != 0 && (this.mapMidLayer[n6] & 0x3F) != 63) {
                CapcomCanvas.drawRegion$712e88cb(graphics, this.tileSet, (this.mapMidLayer[n6] & 0x3F) % 8 * 15, (this.mapMidLayer[n6] & 0x3F) / 8 * 15, 15, 15, Map.getTransform(this.mapMidLayer[n6]), n3 * 15 - 15, n4 * 15);
            }
            if (--n3 != 0) continue;
            n3 = 16;
            --n4;
        }
        if (Game1942Main.m_startYTile >= 26) {
            Game1942Main.m_startYTile = 0;
        }
        return this.backBuffer;
    }

    public final Image createBackground(int n) {
        int n2;
        Graphics graphics = this.backBuffer.getGraphics();
        int n3 = 16;
        int n4 = MAP_HEIGHT;
        int n5 = n2 - 16 * (MAP_HEIGHT + 1);
        int n6 = 0;
        for (n2 = 16 * TILEMAP_HEIGHT - 1 - (n << 4); n2 > n5; --n2) {
            n6 = n2;
            if (n6 < 0) {
                n6 += TOTAL_MAP_TILES;
            }
            CapcomCanvas.drawRegion$712e88cb(graphics, this.tileSet, (this.map[n6] & 0x3F) % 8 * 15, (this.map[n6] & 0x3F) / 8 * 15, 15, 15, Map.getTransform(this.map[n6]), n3 * 15 - 15, n4 * 15);
            if (--n3 != 0) continue;
            n3 = 16;
            --n4;
        }
        n3 = 16;
        n4 = MAP_HEIGHT;
        n5 = n2 - 16 * (MAP_HEIGHT + 1);
        for (n2 = 16 * TILEMAP_HEIGHT - 1 - (n << 4); n2 > n5; --n2) {
            n6 = n2;
            if (n6 < 0) {
                n6 += TOTAL_MAP_TILES;
            }
            if ((this.mapMidLayer[n6] & 0x3F) != 0) {
                CapcomCanvas.drawRegion$712e88cb(graphics, this.tileSet, (this.mapMidLayer[n6] & 0x3F) % 8 * 15, (this.mapMidLayer[n6] & 0x3F) / 8 * 15, 15, 15, Map.getTransform(this.mapMidLayer[n6]), n3 * 15 - 15, n4 * 15);
            }
            if (--n3 != 0) continue;
            n3 = 16;
            --n4;
        }
        if (Game1942Main.m_startYTile >= 100) {
            Game1942Main.m_startYTile = 0;
        }
        return this.backBuffer;
    }

    public final void runEvents(int n) {
        int n2 = 0;
        byte[] byArray = new byte[4];
        for (int i = 0; i < this.mapEvents.length; i += 5) {
            byArray[0] = this.mapEvents[i];
            byArray[1] = this.mapEvents[i + 1];
            byArray[2] = this.mapEvents[i + 2];
            byArray[3] = this.mapEvents[i + 3];
            n2 = CapcomCanvas.byteArrayToInt(byArray);
            int n3 = n2 % 16 * 15;
            byte by = this.mapEvents[i + 4];
            if ((n2 /= 16) != 292 - n) continue;
            this.m_game.processEvents$4868d30e(n3, by);
        }
    }

    private static int getTransform(byte by) {
        int n = 0;
        if ((by & 0x40) != 0 && (by & 0x80) != 0) {
            n = 3;
        } else if ((by & 0x40) != 0) {
            n = 2;
        } else if ((by & 0x80) != 0) {
            n = 1;
        }
        return n;
    }

    private byte[] ioLoadMap(String string) {
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            inputStream = this.getClass().getResourceAsStream(string);
            byArray = new byte[TILEMAP_HEIGHT << 4];
            inputStream.read(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            System.out.println("ioLoadMap: " + exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                System.out.println("ioLoadMap - close: " + exception);
            }
        }
        return byArray;
    }

    private byte[] ioLoadMapBoss(String string) {
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            inputStream = this.getClass().getResourceAsStream(string);
            byArray = new byte[416];
            inputStream.read(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            System.out.println("ioLoadMap: " + exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                System.out.println("ioLoadMap - close: " + exception);
            }
        }
        return byArray;
    }

    private byte[] ioLoadMidLayer(String string) {
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            inputStream = this.getClass().getResourceAsStream(string);
            byArray = new byte[TILEMAP_HEIGHT << 4];
            inputStream.read(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            System.out.println("ioLoadMap: " + exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                System.out.println("ioLoadMap - close: " + exception);
            }
        }
        return byArray;
    }

    private byte[] ioLoadMidLayerBoss(String string) {
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            inputStream = this.getClass().getResourceAsStream(string);
            byArray = new byte[416];
            inputStream.read(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            System.out.println("ioLoadMap: " + exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                System.out.println("ioLoadMap - close: " + exception);
            }
        }
        return byArray;
    }

    /*
     * Loose catch block
     */
    private byte[] ioLoadMapEvents(String string) {
        block13: {
            InputStream inputStream = null;
            this.mapEvents = null;
            byte[] byArray = new byte[4];
            byte by = 0;
            int n = 0;
            inputStream = this.getClass().getResourceAsStream(string);
            by = (byte)inputStream.read();
            byArray[0] = (byte)inputStream.read();
            byArray[1] = (byte)inputStream.read();
            byArray[2] = (byte)inputStream.read();
            byArray[3] = (byte)inputStream.read();
            n = CapcomCanvas.byteArrayToInt(byArray);
            this.mapEvents = new byte[n * 5];
            inputStream.read(this.mapEvents, 0, this.mapEvents.length);
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block13;
            }
            catch (Exception exception) {}
            break block13;
            catch (Exception exception) {
                try {
                    String cfr_ignored_0 = "ioLoadMapEvents: " + exception;
                    String cfr_ignored_1 = "Screen Count: " + by;
                    String cfr_ignored_2 = "Num Codes: " + n;
                    String cfr_ignored_3 = "Size: " + this.mapEvents.length;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception3) {}
            }
        }
        return this.mapEvents;
    }

    private String getLevelString() {
        Object object = "";
        switch (Game1942Constants.g_levelDefintions[Game1942Main.m_level][0]) {
            case 0: 
            case 1: {
                object = "ocean";
                break;
            }
            case 3: 
            case 4: {
                object = "harbour_day";
                break;
            }
            case 5: 
            case 6: {
                object = "city_day";
                break;
            }
            case 2: {
                object = "river";
            }
        }
        return object;
    }
}

