/*
 * Decompiled with CFR 0.152.
 */
package com.capcomeuro.midp;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public final class CapcomMMSound
implements PlayerListener {
    private Player[] player;
    private static final String[] protocolNames = new String[]{"audio/midi", "audio/x-wav", "audio/amr", "audio/mp3"};
    private static final String[] extensions = new String[]{".mid", ".wav", ".amr", ".mp3"};
    private byte[] protocol;
    private byte[] loopCount;
    private String[] soundStringMap;
    private byte[] playerMap;
    private byte[] volume;
    private byte[] lastPlayedSound;
    private byte[] queue;
    private byte cueIndex;
    private byte interruptReturnFrames;
    private byte masterVolume;
    private boolean returnToCueOnError = true;
    private static int STATE_CHECK_ATTEMPTS = 10;

    public CapcomMMSound(int n, int n2, int n3) {
        this.player = new Player[n];
        this.lastPlayedSound = new byte[n];
        this.playerMap = new byte[n2];
        this.loopCount = new byte[n2];
        this.volume = new byte[n2];
        this.queue = new byte[n3];
        this.clearCue();
    }

    public final void addResources(byte[] byArray, String[] stringArray, byte[] byArray2, byte[] byArray3) {
        this.protocol = byArray;
        this.soundStringMap = stringArray;
        this.playerMap = byArray2;
        this.loopCount = byArray3;
    }

    public final void playCued() {
        this.interruptReturnFrames = (byte)(this.interruptReturnFrames - 1);
        if (this.interruptReturnFrames > 0) {
            return;
        }
        this.interruptReturnFrames = 0;
        if (this.cueIndex >= 0 && this.queue[0] == 63) {
            this.popSound();
            this.stopAll();
            return;
        }
        if (this.cueIndex >= 0 && this.queue[0] >= 64) {
            this.stopAssociatedPlayer((byte)(this.popSound() - 64));
            return;
        }
        if (this.cueIndex >= 0) {
            byte by = this.queue[0];
            CapcomMMSound capcomMMSound = this;
            if (!(capcomMMSound.player[capcomMMSound.playerMap[by]] != null && capcomMMSound.player[capcomMMSound.playerMap[by]].getState() == 400)) {
                byte by2 = this.popSound();
                try {
                    if (!this.preparePlayer(by2) && this.returnToCueOnError) {
                        this.cueSound(by2);
                        return;
                    }
                    byte by3 = by2;
                    CapcomMMSound capcomMMSound2 = this;
                    ((VolumeControl)capcomMMSound2.player[capcomMMSound2.playerMap[by3]].getControl("VolumeControl")).setLevel(capcomMMSound2.volume[by3] * capcomMMSound2.masterVolume / 100);
                    if (!this.startPlayer(by2) && this.returnToCueOnError) {
                        this.cueSound(by2);
                        return;
                    }
                    return;
                }
                catch (Exception exception) {}
            }
        }
    }

    public final void cueSound(byte by) {
        this.cueIndex = (byte)(this.cueIndex + 1 > this.queue.length - 1 ? this.queue.length - 1 : this.cueIndex + 1);
        this.queue[this.cueIndex] = by;
    }

    private void clearCue() {
        for (int i = 0; i < this.queue.length; ++i) {
            this.queue[i] = -1;
        }
        this.cueIndex = (byte)-1;
    }

    public final void stopAll() {
        for (int i = 0; i < this.player.length; ++i) {
            if (this.player[i] == null) continue;
            this.stopPlayer(i);
        }
        this.clearCue();
    }

    public final void stopAssociatedPlayer(byte by) {
        this.stopPlayer(this.playerMap[by]);
    }

    public final void preloadSound(byte by) {
        this.preparePlayer(by);
        this.lastPlayedSound[this.playerMap[by]] = by;
    }

    public final void setVolume(byte[] byArray) {
        this.volume = byArray;
    }

    public final void setMasterVolume(byte by) {
        this.masterVolume = by;
    }

    private void stopPlayer(int n) {
        try {
            if (this.player[n] != null && this.player[n].getState() != 0) {
                this.player[n].stop();
                for (int i = 0; i <= STATE_CHECK_ATTEMPTS && this.player[n].getState() == 400; ++i) {
                    Thread.sleep(1L);
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private byte popSound() {
        byte by = this.queue[0];
        for (int i = 0; i < this.queue.length - 1; ++i) {
            this.queue[i] = this.queue[i + 1];
        }
        this.queue[this.queue.length - 1] = -1;
        this.cueIndex = (byte)(this.cueIndex - 1 < -1 ? -1 : this.cueIndex - 1);
        return by;
    }

    private boolean preparePlayer(int n) {
        try {
            if (this.player[this.playerMap[n]] != null) {
                this.player[this.playerMap[n]].close();
            }
            this.player[this.playerMap[n]] = null;
            System.gc();
            Thread.sleep(1L);
            this.player[this.playerMap[n]] = this.createPlayer("/Sound/" + this.soundStringMap[n] + "" + extensions[this.protocol[n]], protocolNames[this.protocol[n]]);
            this.player[this.playerMap[n]].realize();
            for (int i = 0; i <= STATE_CHECK_ATTEMPTS && this.player[this.playerMap[n]].getState() != 200; ++i) {
                if (i == STATE_CHECK_ATTEMPTS) {
                    return false;
                }
                Thread.sleep(1L);
            }
            this.player[this.playerMap[n]].prefetch();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean startPlayer(byte by) {
        try {
            if (this.loopCount[by] != 1) {
                this.player[this.playerMap[by]].setLoopCount((int)this.loopCount[by]);
            }
            this.player[this.playerMap[by]].start();
            this.lastPlayedSound[this.playerMap[by]] = by;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private Player createPlayer(String string, String string2) {
        try {
            return Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(string), (String)string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final void playerUpdate(Player object, String string, Object object2) {
        try {
            if (string == "endOfMedia") {
                int n;
                int n2;
                block5: {
                    string = object;
                    object = this;
                    for (int n3 = 0; n3 < object.player.length; n3 = (int)((byte)(n3 + 1))) {
                        if (object.player[n3] != string) continue;
                        n2 = n3;
                        break block5;
                    }
                    n2 = n = -1;
                }
                if (n2 != -1) {
                    this.cueSound(this.lastPlayedSound[n]);
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

