/*
 * Decompiled with CFR 0.152.
 */
package com.capcomeuro.midp;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class CapcomFont {
    private static Image[] fontImage;
    private static byte[][] fonFillRectDef;
    private static String[] fontCharMap;
    private static byte[][] fontCharWidths;
    private static short[][] fontCharX;
    public static byte[] fontSpacing;
    private static byte[] fontSpace;
    public static byte[] fontHeight;
    private static short[] fontRowWidth;
    private static byte[] fontType;
    private static String[] buffer;

    public CapcomFont() {
        try {
            fontImage = new Image[3];
            fonFillRectDef = new byte[3][];
            fontCharMap = new String[3];
            fontCharWidths = new byte[3][];
            fontCharX = new short[3][];
            fontSpacing = new byte[3];
            fontSpace = new byte[3];
            fontHeight = new byte[3];
            fontRowWidth = new short[3];
            fontType = new byte[3];
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void addFont(int n, String string, byte by, byte by2, byte by3, short s, byte by4) {
        try {
            if (by4 == 0) {
                CapcomFont.fontImage[n] = Image.createImage((String)("/" + string + ".png"));
            } else if (by4 == 1) {
                CapcomFont.fonFillRectDef[n] = this.getFileAsBytes("/" + string + ".bin");
            }
            CapcomFont.fontSpacing[n] = by;
            CapcomFont.fontSpace[n] = by2;
            CapcomFont.fontHeight[n] = by3;
            CapcomFont.fontRowWidth[n] = s;
            CapcomFont.fontType[n] = by4;
            this.addBMF(n, string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void addBMF(int n, String string) {
        try {
            Object object = object.getClass().getResourceAsStream("/" + string + ".bmf");
            object = new DataInputStream((InputStream)object);
            CapcomFont.fontCharMap[n] = ((DataInputStream)object).readUTF();
            int n2 = fontCharMap[n].length();
            CapcomFont.fontCharWidths[n] = new byte[n2];
            CapcomFont.fontCharX[n] = new short[n2];
            short s = 0;
            for (int i = 0; i < n2; ++i) {
                CapcomFont.fontCharWidths[n][i] = ((DataInputStream)object).readByte();
                CapcomFont.fontCharX[n][i] = s;
                s = (short)(s + fontCharWidths[n][i]);
            }
            try {
                ((FilterInputStream)object).close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        try {
            if (n4 == 1 || n4 == 8) {
                n6 = this.stringWidth(string, n5);
                if (n4 == 1) {
                    n += n3 / 2 - n6 / 2;
                } else if (n4 == 8) {
                    n += n3 - n6;
                }
            }
            for (n3 = 0; n3 < string.length(); ++n3) {
                n4 = string.charAt(n3);
                if (fontType[n5] == 0) {
                    n += this.drawCharBitmap(graphics, (char)n4, n, n2, n5);
                    continue;
                }
                if (fontType[n5] != 1) continue;
                n += this.drawCharFillRect(graphics, (char)n4, n, n2, n5);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static int getVStringY(int n, int n2, int n3) {
        n += (n2 - fontHeight[n3]) / 2;
        if (fontHeight[n3] % 2 > 0) {
            ++n;
        }
        return n;
    }

    public final void drawVString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        n2 = CapcomFont.getVStringY(n2, n4, n6);
        try {
            n5 = this.stringWidth(string, n6);
            n += n3 / 2 - n5 / 2;
            for (n3 = 0; n3 < string.length(); ++n3) {
                n4 = string.charAt(n3);
                if (fontType[n6] == 0) {
                    n += this.drawCharBitmap(graphics, (char)n4, n, n2, n6);
                    continue;
                }
                if (fontType[n6] != 1) continue;
                n += this.drawCharFillRect(graphics, (char)n4, n, n2, n6);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void drawStringScrolled(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = this.stringWidth(string, n5);
        int n10 = graphics.getClipX();
        int n11 = graphics.getClipY();
        int n12 = graphics.getClipWidth();
        int n13 = graphics.getClipHeight();
        if (n9 >= n3) {
            graphics.setClip(n, n2, n3, (int)fontHeight[n5]);
            if (n6 > 0) {
                n4 = n9 + n7;
                for (n7 = 0; n7 < 2; ++n7) {
                    this.drawString(graphics, string, n + n8 - n6 % n4 + n7 * n4, n2, n3, 4, n5);
                }
            } else {
                this.drawString(graphics, string, n + n8, n2, n3, 4, n5);
            }
        } else {
            this.drawString(graphics, string, n, n2, n3, n4, n5);
        }
        graphics.setClip(n10, n11, n12, n13);
    }

    private int drawCharBitmap(Graphics graphics, char c, int n, int n2, int n3) throws Exception {
        if (CapcomFont.isSpace(c)) {
            return fontSpace[n3];
        }
        int n4 = fontCharMap[n3].indexOf(c);
        if (n4 >= 0) {
            graphics.drawRegion(fontImage[n3], fontCharX[n3][n4] % fontRowWidth[n3], 0 + fontCharX[n3][n4] / fontRowWidth[n3] * fontHeight[n3], (int)fontCharWidths[n3][n4], (int)fontHeight[n3], 0, n, n2, 20);
            return fontCharWidths[n3][n4] + fontSpacing[n3];
        }
        return 0;
    }

    private int drawCharFillRect(Graphics graphics, char c, int n, int n2, int n3) throws Exception {
        if (CapcomFont.isSpace(c)) {
            return fontSpace[n3];
        }
        int n4 = fontCharMap[n3].indexOf(c);
        if (n4 >= 0) {
            c = (char)(n4 << 1);
            c = (char)((fonFillRectDef[n3][c] << 7) + fonFillRectDef[n3][c + '\u0001']);
            for (int i = 0; i < fonFillRectDef[n3][c]; ++i) {
                int n5 = c + 2 + (i << 1);
                int n6 = fonFillRectDef[n3][n5] & 0xF;
                int n7 = fonFillRectDef[n3][n5 + 1] & 0xF;
                int n8 = (fonFillRectDef[n3][n5] >> 4 & 0xF) + n;
                n5 = (fonFillRectDef[n3][n5 + 1] >> 4 & 0xF) + n2;
                graphics.fillRect(n8, n5, n6, n7);
            }
            return fontCharWidths[n3][n4] + fontSpacing[n3];
        }
        return 0;
    }

    public static int getCharWidth(char c, int n) {
        return fontCharWidths[n][fontCharMap[n].indexOf(c)];
    }

    public final int stringWidth(String string, int n) {
        int n2 = 0;
        char c = '\u0000';
        try {
            for (int i = 0; i < string.length(); ++i) {
                c = string.charAt(i);
                if (CapcomFont.isSpace(c)) {
                    n2 += fontSpace[n];
                    continue;
                }
                n2 += fontCharWidths[n][fontCharMap[n].indexOf(c)] + fontSpacing[n];
            }
            n2 -= fontSpacing[n];
        }
        catch (Exception exception) {}
        return n2;
    }

    private String fixUnsplittableWords(String string, int n, int n2) {
        try {
            int n3 = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ' ' && string.charAt(i) != '\n') continue;
                if (((CapcomFont)((Object)string2)).stringWidth(string.substring(n3, i), n2) >= n) {
                    i = n3;
                    while (((CapcomFont)((Object)string2)).stringWidth(string.substring(n3, i) + "- ", n2) < n) {
                        ++i;
                    }
                    string = string.substring(0, --i) + "- " + string.substring(i);
                    i = n3;
                    continue;
                }
                n3 = i + 1;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string2 = "fixUnsplittableWords error:";
            System.out.println((String)string2 + " : " + exception2);
            String cfr_ignored_0 = (String)string2 + " : " + exception2;
            String cfr_ignored_1 = "String: " + string;
        }
        return string;
    }

    public final String[] splitString(String string, int n, int n2, int n3) {
        String[] stringArray = null;
        string = this.fixUnsplittableWords(string, n, n2);
        try {
            if (string == null || string.equals("")) {
                return null;
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            buffer = new String[n3];
            for (n3 = 0; n3 < string.length(); ++n3) {
                if (string.charAt(n3) != ' ' && string.charAt(n3) != '\n') continue;
                if (string.charAt(n3) == '\n') {
                    if (this.stringWidth(string.substring(n5, n3), n2) >= n) {
                        CapcomFont.buffer[n6++] = string.substring(n5, n4);
                        n5 = n4 + 1;
                    }
                    CapcomFont.buffer[n6++] = string.substring(n5, n3);
                    n5 = n3 + 1;
                } else if (this.stringWidth(string.substring(n5, n3), n2) >= n) {
                    CapcomFont.buffer[n6++] = string.substring(n5, n4);
                    n5 = n4 + 1;
                }
                n4 = n3;
            }
            if (this.stringWidth(string.substring(n5, string.length() - 1), n2) >= n) {
                CapcomFont.buffer[n6++] = string.substring(n5, n4);
                n5 = n4 + 1;
            }
            CapcomFont.buffer[n6++] = string.substring(n5);
            stringArray = new String[n6];
            System.arraycopy(buffer, 0, stringArray, 0, stringArray.length);
        }
        catch (Exception exception) {}
        return stringArray;
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\u00a0';
    }

    private byte[] getFileAsBytes(String object) {
        byte[] byArray = null;
        byte[] byArray2 = new byte[256];
        try {
            int n;
            object = byteArrayOutputStream.getClass().getResourceAsStream((String)object);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = ((InputStream)object).read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {}
        return byArray;
    }
}

