/*
 * Decompiled with CFR 0.152.
 */
import com.capcomeuro.midp.CapcomCanvas;
import com.capcomeuro.midp.CapcomFont;
import com.capcomeuro.midp.UIElement;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class HighEndMessageBox
extends UIElement {
    private boolean m_centreText = true;
    private int INNER_FRAME_COLOUR = 12693902;
    private int TEXT_RENDER_COLOUR = SpinnerLayout.SPINNER_SELECTED_COLOUR;
    private static int MESSAGE_BOX_START_X = 20;
    private static int MESSAGE_BOX_START_Y = 40;
    private static int MESSAGE_BOX_WIDTH = 200;
    private static int MESSAGE_BOX_HEIGHT = 106;
    private static int MESSAGE_BOX_TEXT_START_X = 30;
    private int MESSAGE_BOX_FRAME_WIDTH = 2;
    private static int MESSAGE_BOX_TEXT_SPAN = MESSAGE_BOX_WIDTH - 10;
    private int MESSAGE_BOX_FONT_HEIGHT = -1;
    private int MAX_DISPLAYABLE_LINES = 5;
    private int ARROW_HEIGHT = 8;
    private int UP_ARROW_POS_X = -1;
    private int UP_ARROW_POS_Y = MESSAGE_BOX_START_Y - this.ARROW_HEIGHT;
    private int DOWN_ARROW_POS_X = -1;
    private int DOWN_ARROW_POS_Y = MESSAGE_BOX_START_Y + MESSAGE_BOX_HEIGHT + 2;
    private boolean m_downKeyHasBeenPressed = false;
    private boolean m_upKeyHasBeenPressed = false;
    private int m_textTimer = 0;
    private int m_textTimerEnd = 0;
    private int BOX_SCROLL_DISTANCE = 0;
    private int BOX_SCROLL_RATE = 5;
    private int MAX_SCROLL_DISTANCE = 0;
    private byte m_numPages = 0;
    private String[] m_messageBuffer = null;
    private int m_messageBufferLength = -1;
    private Image m_arrowUp = null;
    private Image m_arrowDown = null;

    public HighEndMessageBox() {
    }

    public HighEndMessageBox(CapcomFont capcomFont, byte by) {
        this.m_font = capcomFont;
        int n = this.m_uiFontID = (int)by;
        this.MESSAGE_BOX_FONT_HEIGHT = CapcomFont.fontHeight[n];
        this.loadResources();
    }

    public final void init(String string, boolean bl) {
        MESSAGE_BOX_TEXT_SPAN = 240 - (MESSAGE_BOX_TEXT_START_X << 1);
        this.m_messageBuffer = this.m_font.splitString(string, MESSAGE_BOX_TEXT_SPAN, this.m_uiFontID, 200);
        this.m_messageBufferLength = this.m_messageBuffer.length;
        this.m_centreText = bl;
        int n = this.m_uiFontID;
        this.BOX_SCROLL_DISTANCE = this.MAX_DISPLAYABLE_LINES * (this.MESSAGE_BOX_FONT_HEIGHT + CapcomFont.fontSpacing[n]);
        this.m_numPages = (byte)((this.m_messageBufferLength - 1) / this.MAX_DISPLAYABLE_LINES);
        this.MAX_SCROLL_DISTANCE = this.m_numPages * this.BOX_SCROLL_DISTANCE;
        this.m_downKeyHasBeenPressed = false;
        this.m_upKeyHasBeenPressed = false;
        this.m_textTimer = 0;
        this.m_textTimerEnd = 0;
        this.m_runCounter = 0;
    }

    public final void reset() {
    }

    public final void update() {
        block7: {
            block8: {
                block5: {
                    block6: {
                        this.m_runCounter = Game1942Main.m_runCounter;
                        if (!this.m_downKeyHasBeenPressed) break block5;
                        if (this.m_textTimer >= this.m_textTimerEnd) break block6;
                        this.m_textTimer += this.BOX_SCROLL_RATE;
                        if (this.m_textTimer >= this.m_textTimerEnd) {
                            this.m_textTimer = this.m_textTimerEnd;
                            this.m_downKeyHasBeenPressed = false;
                            return;
                        }
                        break block7;
                    }
                    this.m_downKeyHasBeenPressed = false;
                    return;
                }
                if (!this.m_upKeyHasBeenPressed) break block7;
                if (this.m_textTimer <= this.m_textTimerEnd) break block8;
                this.m_textTimer -= this.BOX_SCROLL_RATE;
                if (this.m_textTimer > this.m_textTimerEnd) break block7;
                this.m_textTimer = this.m_textTimerEnd;
            }
            this.m_upKeyHasBeenPressed = false;
        }
    }

    public final void loadResources() {
        this.m_arrowUp = CapcomCanvas.createImage("/CommonInterface/arrow_up.png");
        this.m_arrowDown = CapcomCanvas.createImage("/CommonInterface/arrow_down.png");
        this.UP_ARROW_POS_X = (240 - this.m_arrowUp.getWidth()) / 2;
        this.DOWN_ARROW_POS_X = (240 - this.m_arrowDown.getWidth()) / 2;
    }

    public final void draw(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setColor(0);
        graphics.fillRect(MESSAGE_BOX_START_X, MESSAGE_BOX_START_Y, MESSAGE_BOX_WIDTH, MESSAGE_BOX_HEIGHT);
        graphics.setClip(MESSAGE_BOX_START_X, MESSAGE_BOX_START_Y + this.MESSAGE_BOX_FRAME_WIDTH, MESSAGE_BOX_WIDTH, MESSAGE_BOX_HEIGHT - (this.MESSAGE_BOX_FRAME_WIDTH << 1));
        graphics.setColor(this.INNER_FRAME_COLOUR);
        graphics.fillRect(MESSAGE_BOX_START_X + this.MESSAGE_BOX_FRAME_WIDTH, MESSAGE_BOX_START_Y + this.MESSAGE_BOX_FRAME_WIDTH, MESSAGE_BOX_WIDTH - (this.MESSAGE_BOX_FRAME_WIDTH << 1), MESSAGE_BOX_HEIGHT - (this.MESSAGE_BOX_FRAME_WIDTH << 1));
        graphics.setColor(this.TEXT_RENDER_COLOUR);
        int n5 = this.m_uiFontID;
        int n6 = this.m_messageBufferLength * (this.MESSAGE_BOX_FONT_HEIGHT + CapcomFont.fontSpacing[n5]);
        n6 = (this.MESSAGE_BOX_FRAME_WIDTH << 1) + MESSAGE_BOX_START_Y + (MESSAGE_BOX_HEIGHT - n6) / 2;
        if (this.m_messageBufferLength >= this.MAX_DISPLAYABLE_LINES) {
            n5 = this.m_uiFontID;
            n6 = MESSAGE_BOX_START_Y + this.MESSAGE_BOX_FRAME_WIDTH + CapcomFont.fontSpacing[n5] + 1;
        }
        for (int i = 0; i < this.m_messageBufferLength; ++i) {
            if (this.m_centreText) {
                n5 = this.m_uiFontID;
                this.m_font.drawString(graphics, this.m_messageBuffer[i], MESSAGE_BOX_START_X, n6 + (this.MESSAGE_BOX_FONT_HEIGHT + CapcomFont.fontSpacing[n5]) * i - this.m_textTimer, MESSAGE_BOX_WIDTH, 1, this.m_uiFontID);
                continue;
            }
            n5 = this.m_uiFontID;
            this.m_font.drawString(graphics, this.m_messageBuffer[i], MESSAGE_BOX_TEXT_START_X, n6 + (this.MESSAGE_BOX_FONT_HEIGHT + CapcomFont.fontSpacing[n5]) * i - this.m_textTimer, MESSAGE_BOX_WIDTH, 4, this.m_uiFontID);
        }
        graphics.setClip(n, n2, n3, n4);
        if (this.m_runCounter % 10 != 0) {
            if (this.m_textTimerEnd > 0) {
                graphics.drawImage(this.m_arrowUp, this.UP_ARROW_POS_X, this.UP_ARROW_POS_Y, 20);
            }
            if (this.m_textTimerEnd < this.MAX_SCROLL_DISTANCE) {
                graphics.drawImage(this.m_arrowDown, this.DOWN_ARROW_POS_X, this.DOWN_ARROW_POS_Y, 20);
            }
        }
    }

    public final void keyPressed(int n) {
        if (n == -1 || n == 50) {
            if (this.m_upKeyHasBeenPressed) {
                return;
            }
            if (this.m_textTimer - 1 <= 0) {
                return;
            }
            this.m_upKeyHasBeenPressed = true;
            this.m_downKeyHasBeenPressed = false;
            this.m_textTimerEnd = this.m_textTimer - this.BOX_SCROLL_DISTANCE;
            if (this.m_textTimerEnd < 0) {
                this.m_textTimerEnd = 0;
            }
        }
        if (n == -2 || n == 56) {
            if (this.m_downKeyHasBeenPressed) {
                return;
            }
            this.m_downKeyHasBeenPressed = true;
            this.m_upKeyHasBeenPressed = false;
            this.m_textTimerEnd = this.m_textTimer + this.BOX_SCROLL_DISTANCE;
            if (this.m_textTimerEnd > this.MAX_SCROLL_DISTANCE) {
                this.m_textTimerEnd = this.MAX_SCROLL_DISTANCE;
            }
        }
    }

    public static void setWidth$13462e() {
        MESSAGE_BOX_WIDTH = 200;
    }

    public final void setStartX$13462e() {
        MESSAGE_BOX_START_X = 20;
        switch (this.m_uiFontID) {
            case 0: {
                MESSAGE_BOX_TEXT_START_X = MESSAGE_BOX_START_X + this.MESSAGE_BOX_FRAME_WIDTH + 2;
                break;
            }
            case 1: {
                MESSAGE_BOX_TEXT_START_X = MESSAGE_BOX_START_X + this.MESSAGE_BOX_FRAME_WIDTH + 2;
                break;
            }
            case 2: {
                MESSAGE_BOX_TEXT_START_X = MESSAGE_BOX_START_X + this.MESSAGE_BOX_FRAME_WIDTH + 2;
            }
        }
        MESSAGE_BOX_WIDTH = 240 - (MESSAGE_BOX_START_X << 1);
        MESSAGE_BOX_TEXT_SPAN = MESSAGE_BOX_WIDTH - 10;
    }

    public final void setStartY(int n) {
        MESSAGE_BOX_START_Y = n;
        this.UP_ARROW_POS_Y = MESSAGE_BOX_START_Y - this.ARROW_HEIGHT;
        this.DOWN_ARROW_POS_Y = MESSAGE_BOX_START_Y + MESSAGE_BOX_HEIGHT + 2;
    }

    public final void setMaxLines(int n) {
        this.MAX_DISPLAYABLE_LINES = n;
        n = this.m_uiFontID;
        byte by = CapcomFont.fontHeight[n];
        n = this.m_uiFontID;
        MESSAGE_BOX_HEIGHT = (by + CapcomFont.fontSpacing[n]) * this.MAX_DISPLAYABLE_LINES;
        n = this.m_uiFontID;
        this.DOWN_ARROW_POS_Y = MESSAGE_BOX_START_Y + (MESSAGE_BOX_HEIGHT += (CapcomFont.fontSpacing[n] << 1) + (this.MESSAGE_BOX_FRAME_WIDTH << 1));
    }
}

