/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

class DDLUtility {
    private static MIDlet m_Parent;
    private static long randseed;
    private static byte[] m_atanTab;
    public static int[] m_sintab;
    public static int m_vibrateOn;
    static int G_traceDepth;

    public DDLUtility(MIDlet mIDlet) {
        m_Parent = mIDlet;
    }

    private static void ReadBytes(InputStream inputStream, byte[] byArray, int n, int n2) throws Exception {
        try {
            int n3;
            while (n2 > 0 && (n3 = inputStream.read(byArray, n, n2)) >= 0) {
                n += n3;
                n2 -= n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] ReadByteArray(String string, int n) {
        byte[] byArray;
        try {
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            byArray = new byte[n];
            DDLUtility.ReadBytes(inputStream, byArray, 0, n);
            inputStream.close();
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    public static short[] ReadShortArray(String string, int n) {
        short[] sArray = null;
        byte[] byArray = new byte[]{0, 0};
        try {
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            sArray = new short[n >> 1];
            for (int i = 0; i < n >> 1; ++i) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
                sArray[i] = (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            sArray = null;
        }
        return sArray;
    }

    public static int[] ReadIntArray(String string, int n) {
        int[] nArray = null;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        try {
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            nArray = new int[n >> 2];
            for (int i = 0; i < n >> 2; ++i) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 4);
                nArray[i] = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            nArray = null;
        }
        return nArray;
    }

    public static byte[] ReadCATByteArray(int n) {
        byte[] byArray;
        byte[] byArray2 = new byte[]{0, 0};
        try {
            int n2;
            String string = "/files.bin";
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            DDLUtility.ReadBytes(inputStream, byArray2, 0, 2);
            if ((byArray2[0] & 0xFF) == 68 || (byArray2[1] & 0xFF) != 32) {
                // empty if block
            }
            DDLUtility.ReadBytes(inputStream, byArray2, 0, 2);
            int n3 = byArray2[0] & 0xFF | (byArray2[1] & 0xFF) << 8;
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                DDLUtility.ReadBytes(inputStream, byArray2, 0, 2);
                if (n2 > n) continue;
                n5 += n4;
                n4 = byArray2[0] & 0xFF | (byArray2[1] & 0xFF) << 8;
            }
            for (n3 = n5; n3 > 0 && (n2 = (int)inputStream.skip(n3)) >= 0; n3 -= n2) {
            }
            byArray = new byte[n4];
            DDLUtility.ReadBytes(inputStream, byArray, 0, n4);
            inputStream.close();
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    public static Image ReadCATImage(int n) {
        byte[] byArray = DDLUtility.ReadCATByteArray(n);
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        byArray = null;
        System.gc();
        return image;
    }

    public static short[] ReadCATShortArray(int n) {
        short[] sArray;
        byte[] byArray = new byte[]{0, 0};
        try {
            int n2;
            String string = "/files.bin";
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
            if ((byArray[0] & 0xFF) == 68 || (byArray[1] & 0xFF) != 32) {
                // empty if block
            }
            DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
            int n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
                if (n2 > n) continue;
                n5 += n4;
                n4 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
            }
            for (n3 = n5; n3 > 0 && (n2 = (int)inputStream.skip(n3)) >= 0; n3 -= n2) {
            }
            sArray = new short[n4 >> 1];
            for (n2 = 0; n2 < n4 >> 1; ++n2) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
                sArray[n2] = (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            sArray = null;
        }
        return sArray;
    }

    public static void ReadShortArrayInto(String string, int n, short[] sArray) {
        byte[] byArray = new byte[]{0, 0};
        try {
            InputStream inputStream = m_Parent.getClass().getResourceAsStream(string);
            for (int i = 0; i < n >> 1; ++i) {
                DDLUtility.ReadBytes(inputStream, byArray, 0, 2);
                sArray[i] = (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initRandom() {
        randseed = -739132197L;
        for (int i = (int)System.currentTimeMillis() & 0xFF; i > 0; --i) {
            DDLUtility.getRandom();
        }
    }

    public static int getRandom() {
        randseed = 1103515245L * randseed + 12345L;
        return (int)(randseed >> 16);
    }

    public static int sqrtRout(int n) {
        int n2;
        if (n <= 0) {
            return 1;
        }
        int n3 = n;
        while ((n3 = (n2 = n3) + n / n2 >> 1) < n2 && n3 > 0) {
        }
        return n3;
    }

    public static void DoBuildAtanTab() {
        m_atanTab = new byte[520];
        byte[] byArray = DDLUtility.ReadByteArray("/atan.bin", 32);
        System.arraycopy(byArray, 24, m_atanTab, 512, 8);
        int n = 0;
        int n2 = 0;
        while (n < 16) {
            DDLUtility.BuildAtanTab(byArray, byArray[n], n2, byArray[n + 1]);
            n += 2;
            n2 += 64;
        }
        byArray = null;
        System.gc();
    }

    private static void BuildAtanTab(byte[] byArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = 16;
        int n6 = 7;
        for (int i = 0; i < 64; ++i) {
            DDLUtility.m_atanTab[i + n2] = (byte)n4;
            if ((byArray[n5] & 1 << n6) != 0) {
                n4 += n3;
            }
            if (--n6 >= 0) continue;
            n6 = 7;
            ++n5;
        }
    }

    public static int atanRout(int n, int n2) {
        int n3 = 0;
        try {
            int n4 = 0;
            if (n < 0) {
                n4 |= 0x100;
                n = -n;
            }
            if (n2 < 0) {
                n4 |= 0x80;
                n2 = -n2;
            }
            if (n == n2) {
                n3 = m_atanTab[512 + (n4 >> 6)] & 0xFF;
            } else {
                if (n2 < n) {
                    n4 |= 0x40;
                    int n5 = n;
                    n = n2;
                    n2 = n5;
                }
                n3 = n2 == 0 ? m_atanTab[n4] & 0xFF : m_atanTab[(n << 6) / n2 + n4] & 0xFF;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3;
    }

    private static int[] ReadSinTab() {
        m_sintab = new int[256];
        byte[] byArray = DDLUtility.ReadByteArray("/sintab.bin", 128);
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = 2;
            int n3 = 0;
            int n4 = 0;
            while (n3 < 128) {
                int n5;
                if (n3 == 64) {
                    n5 = 65536;
                    n2 = -n2;
                } else {
                    n5 = byArray[n4 + 0] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8;
                }
                if (i == 1) {
                    n5 = -n5;
                }
                DDLUtility.m_sintab[n] = n5;
                ++n;
                ++n3;
                n4 += n2;
            }
        }
        byArray = null;
        System.gc();
        return m_sintab;
    }

    public static boolean intersection(int[][] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = 1;
        int n5 = 2;
        int n6 = 3;
        int n7 = (nArray[n6][n] - nArray[n5][n]) * (nArray[n3][n2] - nArray[n5][n2]) - (nArray[n6][n2] - nArray[n5][n2]) * (nArray[n3][n] - nArray[n5][n]);
        int n8 = (nArray[n6][n2] - nArray[n5][n2]) * (nArray[n4][n] - nArray[n3][n]) - (nArray[n6][n] - nArray[n5][n]) * (nArray[n4][n2] - nArray[n3][n2]);
        if (n8 == 0) {
            return false;
        }
        int n9 = (n7 << 8) / n8;
        nArray2[n] = nArray[n3][n] + (n9 * (nArray[n4][n] - nArray[n3][n]) >> 8);
        nArray2[n2] = nArray[n3][n2] + (n9 * (nArray[n4][n2] - nArray[n3][n2]) >> 8);
        return true;
    }

    public static boolean intersectRects(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return (n <= n5 && n + n3 >= n5 || n <= n5 + n7 && n + n3 >= n5 + n7 || n5 < n && n5 + n7 > n + n3) && (n2 <= n6 && n2 + n4 >= n6 || n2 <= n6 + n8 && n2 + n4 >= n6 + n8 || n6 < n2 && n6 + n8 > n2 + n4);
    }

    public static int PNG_CalcCRC(byte[] byArray, int n, int n2) {
        int n3 = n2 - (n -= 4);
        int n4 = -1;
        for (int i = 0; i < n3; ++i) {
            int n5 = (n4 ^ (byte)(byArray[i + n] & 0xFF)) & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((n5 & 1) != 0) {
                    n5 = 0xEDB88320 ^ n5 >>> 1;
                    continue;
                }
                n5 >>>= 1;
            }
            n4 = n5 ^ n4 >>> 8;
        }
        return ~n4;
    }

    public static Image PNG_SetPlayerPalette(byte[] byArray, int n, int[][] nArray) {
        int n2;
        Object var3_3 = null;
        int n3 = -1;
        while ((byArray[n3 = (int)((byte)(n3 + 1))] != 80 || byArray[n3 + 1] != 76 || byArray[n3 + 2] != 84 || byArray[n3 + 3] != 69) && n3 + 3 < byArray.length) {
        }
        n3 = (byte)(n3 - 4);
        int n4 = (byArray[n3] & 0xFF) << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
        int n5 = n3 + 8;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            for (int i = 0; i < 3; ++i) {
                byArray[n5 + (nArray[n2][0] * 3 + i)] = (byte)(nArray[n2][i + 1] & 0xFF);
            }
        }
        n2 = DDLUtility.PNG_CalcCRC(byArray, n5, n5 + n4);
        byArray[n5 + n4 + 0] = (byte)(n2 >> 24 & 0xFF);
        byArray[n5 + n4 + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n5 + n4 + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n5 + n4 + 3] = (byte)(n2 >> 0 & 0xFF);
        try {
            return Image.createImage((byte[])byArray, (int)0, (int)n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image PNG_SwitchPalette(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = byArray2[4] & 0xFF | (byArray2[5] & 0xFF) << 8;
        System.arraycopy(byArray2, 8 + n3 * n2, byArray, byArray2[0] & 0xFF | (byArray2[1] & 0xFF) << 8, n3);
        return Image.createImage((byte[])byArray, (int)0, (int)n);
    }

    public static void SwitchNokiaPal(short[] sArray, byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n3 * n2 * 2;
        for (n4 = 0; n4 < n; ++n4) {
            int n6 = byArray[n4] << 1;
            sArray[n4] = (short)(byArray2[n5 + n6 + 0] & 0xFF | (byArray2[n5 + n6 + 1] & 0xFF) << 8);
        }
    }

    public static void InsertionSort(int n, int[] nArray, int[] nArray2) {
        for (int i = 2; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = nArray2[i];
            for (int j = i - 1; j > 0 && nArray[j] > n2; --j) {
                nArray[j + 1] = nArray[j];
                nArray2[j + 1] = nArray2[j];
            }
            nArray[j + 1] = n2;
            nArray2[j + 1] = n3;
        }
    }

    public static Image loadImage(String string, int n) {
        try {
            return Image.createImage((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void DrawPNGProSprite(Graphics graphics, Image image, byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        n *= n4;
        if (n4 == 6) {
            n2 -= byArray[n + 4] & 0xFF;
            n3 -= byArray[n + 5] & 0xFF;
        }
        graphics.setClip(n2, n3, byArray[n + 0] & 0xFF, byArray[n + 1] & 0xFF);
        graphics.drawImage(image, n2 - (byArray[n + 2] & 0xFF), n3 - (byArray[n + 3] & 0xFF), 20);
        graphics.setClip(n5, n6, n7, n8);
    }

    public static void DrawPNGProSprite(Graphics graphics, Image image, short[] sArray, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        n *= n4;
        if (n4 == 6) {
            n2 -= sArray[n + 4];
            n3 -= sArray[n + 5];
        }
        graphics.setClip(n2, n3, (int)sArray[n + 0], (int)sArray[n + 1]);
        graphics.drawImage(image, n2 - sArray[n + 2], n3 - sArray[n + 3], 20);
        graphics.setClip(n5, n6, n7, n8);
    }

    public static void drawRegularSprite(Graphics graphics, Image image, int n, int n2, int n3) {
        graphics.setClip(0, 0, 240, 304);
        graphics.drawImage(image, n, n2, n3);
    }

    public static void drawTileSprite(Graphics graphics, Image image, int n, int n2, boolean bl, int n3, int n4) {
        if (bl) {
            // empty if block
        }
        graphics.setClip(n, n2, 1 << n3, 1 << n3);
        graphics.drawImage(image, n, n2 - (1 << n3) * n4, 20);
    }

    public static void DrawMultiBoxFrame(Graphics graphics, Image[] imageArray, byte[] byArray, int n, int n2, int n3, boolean bl) {
        if (byArray[0] == 6) {
            DDLUtility.DrawMultiBoxFrame2(graphics, imageArray, byArray, n, n2, n3, bl);
            return;
        }
        int n4 = 4 + n * 3;
        int n5 = byArray[n4 + 0];
        n4 = (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF;
        for (int i = 0; i < n5; ++i) {
            int n6 = byArray[n4 + 1] & 0xFF;
            int n7 = byArray[n4 + 2] & 0xFF;
            int n8 = byArray[n4 + 3] & 0xFF;
            int n9 = byArray[n4 + 4] & 0xFF;
            byte by = byArray[n4 + 5];
            byte by2 = byArray[n4 + 6];
            byte by3 = byArray[n4 + 0];
            graphics.setClip(n2 + by, n3 + by2, n8, n9);
            graphics.drawImage(imageArray[by3], n2 - n6 + by, n3 - n7 + by2, 0);
            n4 += 7;
        }
    }

    public static byte[] LoadAndUnpackMultiboxFile(String string, int n) {
        byte[] byArray;
        byte[] byArray2 = byArray = DDLUtility.ReadByteArray(string, n);
        int n2 = (byArray[1] & 0xFF) << 0 | (byArray[2] & 0xFF) << 8;
        int n3 = n2 << 1;
        int n4 = 4 + n3;
        for (int i = 0; i < n2; ++i) {
            if ((byArray[0 + n4] & 0x80) != 0) {
                byArray2[4 + (i << 1) + 0] = (byte)(n4 & 0xFF);
                byArray2[4 + (i << 1) + 1] = (byte)(n4 >> 8 & 0xFF);
                n4 += 4;
                continue;
            }
            byArray2[4 + (i << 1) + 0] = (byte)(n4 & 0xFF);
            byArray2[4 + (i << 1) + 1] = (byte)(n4 >> 8 & 0xFF);
            n4 += 2 + (byArray[0 + n4] & 0x3F) * 6;
        }
        byArray = null;
        return byArray2;
    }

    public static void DrawMultiBoxFrame2(Graphics graphics, Image[] imageArray, byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        if (bl) {
            n4 = graphics.getClipX();
            n5 = graphics.getClipY();
            n6 = graphics.getClipWidth();
            n7 = graphics.getClipHeight();
        }
        int n8 = 4 + n * 2;
        n8 = (byArray[n8 + 1] & 0xFF) << 8 | (byArray[n8 + 0] & 0xFF) << 0;
        byte by = byArray[n8 + 0];
        boolean bl2 = false;
        byte by2 = byArray[n8 + 1];
        if ((by & 0x80) != 0) {
            if ((by & 0x40) != 0) {
                bl2 = true;
            }
            n8 = (byArray[n8 + 3] & 0xFF) << 8 | byArray[n8 + 2] & 0xFF;
            by = byArray[n8 + 0];
        }
        n8 += 2;
        for (int i = 0; i < (by & 0x3F); ++i) {
            int n9 = byArray[n8 + 0] & 0xFF;
            int n10 = byArray[n8 + 1] & 0xFF;
            int n11 = byArray[n8 + 2] & 0x7F;
            int n12 = byArray[n8 + 3] & 0x7F;
            byte by3 = byArray[n8 + 4];
            byte by4 = byArray[n8 + 5];
            int n13 = (byArray[n8 + 2] & 0x80) >> 6;
            n13 |= (byArray[n8 + 3] & 0x80) >> 7;
            if (bl2) {
                if (bl) {
                    graphics.setClip(n4, n5, n6, n7);
                } else {
                    graphics.setClip(0, 0, 240, 304);
                }
                graphics.drawRegion(imageArray[n13], n9, n10, n11, n12, 2, n2 - n11 - by3 + by2, n3 + by4, 20);
            } else {
                if (bl) {
                    graphics.setClip(n4, n5, n6, n7);
                    graphics.clipRect(n2 + by3 - by2, n3 + by4, n11, n12);
                } else {
                    graphics.setClip(n2 + by3 - by2, n3 + by4, n11, n12);
                }
                graphics.drawImage(imageArray[n13], n2 - n9 + by3 - by2, n3 - n10 + by4, 20);
            }
            n8 += 6;
        }
        graphics.setClip(n4, n5, n6, n7);
    }

    static void trace_in(String string, String string2, int n) {
        String string3 = "TRACE: +";
        ++G_traceDepth;
        for (int i = 0; i < G_traceDepth; ++i) {
            string3 = string3 + "-";
        }
        string3 = string3 + "> " + string;
        System.out.println(string3);
    }

    static void trace_out(String string, String string2, int n) {
        String string3 = "TRACE: +";
        for (int i = 0; i < G_traceDepth; ++i) {
            string3 = string3 + "-";
        }
        --G_traceDepth;
        string3 = string3 + "< " + string;
        System.out.println(string3);
    }

    public static void init() {
        DDLUtility.DoBuildAtanTab();
        DDLUtility.ReadSinTab();
        DDLUtility.initRandom();
    }

    public static void playVibrate(int n) {
        if (m_vibrateOn == 0) {
            return;
        }
        try {
            Display.getDisplay((MIDlet)m_Parent).vibrate(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] getStringBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)(string.charAt(i) & 0xFF);
        }
        return byArray;
    }

    public static int getFreeMemory() {
        int n;
        int n2 = 65536;
        int n3 = 0;
        Object object = new byte[512][];
        System.gc();
        for (n = 0; n < 512; ++n) {
            try {
                object[n] = new byte[n2];
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                n3 = n * n2;
                break;
            }
        }
        while (n >= 0) {
            object[n--] = null;
        }
        object = null;
        System.gc();
        return n3;
    }

    public static void printFreeHolesOnConsole() {
        int[] nArray = new int[10];
        int n = DDLUtility.getFreeMemoryHoles(10, nArray);
        System.gc();
        for (int i = 0; i < n; ++i) {
        }
        nArray = null;
        System.gc();
    }

    public static int getFreeMemoryHoles(int n, int[] nArray) {
        int n2 = 0x400000;
        int n3 = 8192;
        int n4 = 0;
        Object object = new byte[n][];
        System.gc();
        while (n4 < n) {
            try {
                System.gc();
                byte[] byArray = new byte[n2];
                nArray[n4] = n2;
                object[n4] = byArray;
                byArray = null;
                ++n4;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if ((n2 -= n3) > 65536) continue;
                nArray[n4++] = -65536;
                break;
            }
        }
        int n5 = n4;
        while (n5 > 0) {
            object[--n5] = null;
        }
        object = null;
        System.gc();
        return n4;
    }

    static {
        G_traceDepth = 0;
    }
}

