/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.midlet.MIDlet;

class DDLSound {
    private static MIDlet m_Parent;
    private static boolean m_SoundOn;
    private static int m_numSound;
    private static int m_numMusic;
    private static int m_prevSound;
    private static Player[] m_soundFx;
    private static int[] m_soundQueue;
    private static int m_soundQueueLength;
    private static final int MAX_SOUNDS_IN_QUEUE = 4;

    public DDLSound(MIDlet mIDlet) {
        m_Parent = mIDlet;
        m_prevSound = -1;
        m_numSound = 0;
        m_numMusic = 0;
        m_SoundOn = true;
    }

    public static void setSoundOnOff(boolean bl) {
        m_SoundOn = bl;
    }

    public static boolean soundIsEnabled() {
        return m_SoundOn;
    }

    public static void loadSound(String[] stringArray, int n, String[] stringArray2, int n2) {
        try {
            int n3;
            m_soundFx = new Player[n + n2];
            m_soundQueue = new int[4];
            m_soundQueueLength = 0;
            for (n3 = 0; n3 < n; ++n3) {
                DDLSound.m_soundFx[n3] = Manager.createPlayer((InputStream)m_Parent.getClass().getResourceAsStream("/" + stringArray[n3] + ".amr"), (String)"audio/amr");
                m_soundFx[n3].addPlayerListener((PlayerListener)new StopListener());
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    DDLSound.m_soundFx[n + n3] = Manager.createPlayer((InputStream)m_Parent.getClass().getResourceAsStream("/" + stringArray2[n3] + ".mid"), (String)"audio/midi");
                    m_soundFx[n + n3].addPlayerListener((PlayerListener)new StopListener());
                }
            }
            catch (Exception exception) {
                n2 = 0;
            }
            m_numSound = n;
            m_numMusic = n2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean musicAvailable() {
        return m_numMusic > 0;
    }

    public static void playSound(int n, boolean bl) {
        if (n >= 0 && n < m_numSound) {
            DDLSound.playIt(n, bl);
        }
    }

    public static boolean isSoundEffectAvailable(int n, boolean bl) {
        return n >= 0 && n < m_numSound;
    }

    public static void playMusic(int n, boolean bl) {
        if (n >= 0 && n < m_numMusic) {
            DDLSound.playIt(n + m_numSound, bl);
        }
    }

    public static void stopAllSound() {
        try {
            if (m_prevSound >= 0) {
                m_soundFx[m_prevSound].stop();
                m_soundFx[m_prevSound].deallocate();
            }
            m_prevSound = -1;
            m_soundQueueLength = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopAndClose() {
        try {
            for (int i = 0; i < m_numSound + m_numMusic; ++i) {
                m_soundFx[i].stop();
                m_soundFx[i].close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSoundPlaying() {
        return false;
    }

    private static void playIt(int n, boolean bl) {
        if (!m_SoundOn) {
            return;
        }
        if (m_soundFx[n] != null) {
            try {
                if (m_prevSound >= 0 && m_soundFx[m_prevSound].getState() == 400) {
                    if (m_soundQueueLength < 3 && n != m_prevSound) {
                        DDLSound.m_soundQueue[DDLSound.m_soundQueueLength] = n;
                        ++m_soundQueueLength;
                    }
                } else {
                    if (m_prevSound >= 0) {
                        m_soundFx[m_prevSound].deallocate();
                    }
                    m_soundFx[n].prefetch();
                    if (bl) {
                        m_soundFx[n].setLoopCount(-1);
                    } else {
                        m_soundFx[n].setLoopCount(1);
                    }
                    m_soundFx[n].start();
                    m_prevSound = n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class StopListener
    implements PlayerListener {
        public void playerUpdate(Player player, String string, Object object) {
            try {
                if (string.equals("endOfMedia") && m_soundQueueLength > 0) {
                    DDLSound.playIt(m_soundQueue[0], false);
                    if (m_soundQueueLength > 1) {
                        for (int i = 1; i < m_soundQueueLength; ++i) {
                            m_soundQueue[i - 1] = m_soundQueue[i];
                        }
                    }
                    m_soundQueueLength--;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

