/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.Random;
import kernel.KFileBuffer;
import kernel.KRes;
import kernel.KResource;

public final class KMath {
    public static final Random randomGenerator = new Random();
    public static short[] s_sin_table;
    private static int[] s_crc_table;

    public static int crc32(int n, byte[] byArray, int n2, int n3) {
        if (s_crc_table == null) {
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = -306674912;
            s_crc_table = new int[256];
            for (int i = 0; i < 256; ++i) {
                int n4 = i;
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
                KMath.s_crc_table[i] = n4 = nArray2[n4 & 1] ^ (n4 >> 1 | Integer.MIN_VALUE);
            }
        }
        n3 += n2;
        while (n2 < n3) {
            n = s_crc_table[(n ^ byArray[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        return n;
    }

    public static int getRandom() {
        return randomGenerator.nextInt();
    }

    public static int getRandom(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        return n + (randomGenerator.nextInt() & Integer.MAX_VALUE) % (n2 - n + 1);
    }

    public static void loadSinTable(short s) {
        if (s_sin_table == null) {
            s_sin_table = new short[91];
            KRes kRes = KResource.load(s, 125);
            KFileBuffer kFileBuffer = (KFileBuffer)kRes.ro_ref;
            for (int i = 0; i < 91; ++i) {
                KMath.s_sin_table[i] = kFileBuffer.readShort();
            }
            KResource.releaseRes(kRes.ro_hHandle);
        }
    }

    public static int sin(int n) {
        if ((n %= 360) < 0) {
            n += 360;
        }
        if (n < 90) {
            return s_sin_table[n];
        }
        if (n < 180) {
            return s_sin_table[180 - n];
        }
        if (n < 270) {
            return -s_sin_table[n - 180];
        }
        return -s_sin_table[360 - n];
    }

    public static int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static final int getVectorComponentPercentage(int n, int n2, int n3, int n4) {
        short s = (short)(n3 - n);
        short s2 = (short)(n4 - n2);
        short s3 = (short)((s < 0 ? -s : s) + (s2 < 0 ? -s2 : s2));
        s = (short)((s << 8) / s3);
        s2 = (short)((s2 << 8) / s3);
        return (s & 0xFFFF) << 16 | s2 & 0xFFFF;
    }
}

