/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import kernel.KUtils;

public final class KFileBuffer {
    public final byte[] m_data;
    public int m_start;
    public int m_pos;
    int m_end;

    public KFileBuffer(byte[] byArray, int n, int n2) {
        this.m_data = byArray;
        this.m_start = n;
        this.m_end = n2;
        this.m_pos = this.m_start;
    }

    public KFileBuffer(KFileBuffer kFileBuffer, int n) {
        int n2 = kFileBuffer.m_pos;
        kFileBuffer.Seek(n2 - kFileBuffer.m_start + 2 + (n << 2));
        this.m_start = 0 + kFileBuffer.readInt();
        this.m_end = 0 + kFileBuffer.readInt();
        this.m_data = kFileBuffer.m_data;
        this.m_pos = this.m_start;
        kFileBuffer.m_pos = n2;
    }

    public final void skipBlockData() {
        int n = this.readUnsignedShort();
        this.Seek(this.m_pos - this.m_start + (n << 2));
        this.m_pos = this.readInt();
    }

    public final int getNumOfSubFiles() {
        int n = this.m_pos;
        int n2 = this.readUnsignedShort();
        this.m_pos = n;
        return n2;
    }

    public KFileBuffer(String string) {
        byte[] byArray = null;
        try {
            InputStream inputStream = KFileBuffer.getInputStream(string);
            byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            try {
                int n;
                while ((n = inputStream.read(byArray)) >= 1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {}
            byArray = byteArrayOutputStream.toByteArray();
            inputStream.close();
        }
        catch (Exception exception) {
            byArray = new byte[]{};
        }
        this.m_data = byArray;
        this.m_start = 0;
        this.m_end = this.m_data.length;
        System.gc();
    }

    public KFileBuffer(int n) {
        this.m_data = new byte[n];
        this.m_start = 0;
        this.m_end = this.m_data.length;
        this.m_pos = 0;
    }

    private KFileBuffer(byte[] byArray) {
        this.m_data = byArray;
        this.m_start = 0;
        this.m_end = byArray.length;
        this.m_pos = 0;
    }

    public KFileBuffer(KFileBuffer kFileBuffer, int n, int n2) {
        this.m_data = new byte[n2];
        this.m_start = 0;
        this.m_pos = 0;
        this.m_end = n2;
        System.arraycopy(kFileBuffer.m_data, kFileBuffer.m_start + n, this.m_data, 0, n2);
    }

    public final ByteArrayInputStream getInputStream() {
        return new ByteArrayInputStream(this.m_data, this.m_pos, this.m_end - this.m_pos);
    }

    public final byte[] getByteArray() {
        if (this.m_pos == 0 && this.m_end == this.m_data.length) {
            return this.m_data;
        }
        byte[] byArray = new byte[this.m_end - this.m_pos];
        System.arraycopy(this.m_data, this.m_pos, byArray, 0, this.m_end - this.m_pos);
        return byArray;
    }

    public final int getLength() {
        return this.m_end - this.m_start;
    }

    public final void Seek(int n) {
        this.m_pos = this.m_start + n;
        if (this.m_pos < this.m_start) {
            this.m_pos = this.m_start;
        }
        if (this.m_pos > this.m_end) {
            this.m_pos = this.m_end;
        }
    }

    public final int Tell() {
        return this.m_pos - this.m_start;
    }

    public final boolean EOF() {
        return this.m_pos == this.m_end;
    }

    public final void writeByte(int n) {
        this.m_data[this.m_pos++] = (byte)n;
    }

    public final void writeShort(short s) {
        this.writeByte(s >> 8);
        this.writeByte(s);
    }

    public final void writeArray(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.m_data, this.m_pos, n2);
        this.m_pos += n2;
    }

    public final byte readByte() {
        return this.m_data[this.m_pos++];
    }

    public final short readShortLE() {
        return (short)(this.readByte() & 0xFF | this.readByte() << 8);
    }

    public final short readShort() {
        return (short)(this.readByte() << 8 | this.readByte() & 0xFF);
    }

    public final int readUnsignedShort() {
        return this.readByte() << 8 | this.readByte() & 0xFF;
    }

    public final int readInt() {
        return this.readByte() << 24 | this.readByte() << 16 & 0xFF0000 | this.readByte() << 8 & 0xFF00 | this.readByte() & 0xFF;
    }

    public final boolean readBoolean() {
        byte by;
        if (this.m_pos >= this.m_end) {
            return false;
        }
        return (by = this.m_data[this.m_pos++]) != 0;
    }

    public final void readFully$1cf967a4(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.readByte();
        }
    }

    public final byte[] readBytes(int n, int n2) {
        if (n2 == 0) {
            n2 = this.m_end - this.m_start;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_data, n + this.m_start, byArray, 0, n2);
        return byArray;
    }

    public final void skip(long l) {
        this.m_pos = (int)((long)this.m_pos + l);
        if (this.m_pos > this.m_end) {
            this.m_pos = this.m_end;
        }
    }

    private static InputStream getInputStream(String string) {
        InputStream inputStream = null;
        inputStream = KUtils.s_midletApp.getClass().getResourceAsStream("/" + string);
        return inputStream;
    }

    private byte calculateSaveFileCRC(byte by) {
        for (int i = this.m_end - 2; i >= 0; --i) {
            by = (byte)(by + this.m_data[i]);
        }
        return by;
    }

    public final void appendSaveFileCRC(byte by) {
        this.m_data[this.m_end - 1] = this.calculateSaveFileCRC(by);
    }

    public final boolean writeRMS(String string) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        }
        catch (Exception exception) {
            return false;
        }
        try {
            if (recordStore.getNextRecordID() > 1) {
                recordStore.setRecord(1, this.m_data, 0, this.m_end);
            } else {
                recordStore.addRecord(this.m_data, 0, this.m_end);
            }
        }
        catch (Exception exception) {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (Exception exception2) {}
            return false;
        }
        try {
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static KFileBuffer readRMS(String string, int n, byte by) {
        RecordStore recordStore = null;
        KFileBuffer kFileBuffer = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            byte[] byArray = null;
            try {
                byArray = recordStore.getRecord(1);
            }
            catch (InvalidRecordIDException invalidRecordIDException) {}
            recordStore.closeRecordStore();
            if (byArray == null || n > 0 && byArray.length != n) {
                return null;
            }
            kFileBuffer = new KFileBuffer(byArray);
            if (kFileBuffer.m_data[kFileBuffer.m_end - 1] != kFileBuffer.calculateSaveFileCRC(by)) {
                return null;
            }
        }
        catch (Exception exception) {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception2) {}
            }
            return null;
        }
        return kFileBuffer;
    }
}

