/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Game;
import kernel.KFileBuffer;
import kernel.KMath;

public final class Goal {
    public static final byte[] OlymposModificationRatios = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    public static boolean promotionExam;
    public static boolean dynamicGoals;
    public static short[] goalFileOffsets;
    public static byte nPotentialGoals;
    public static byte[] potentialGoalTypes;
    public static byte[] potentialGoalProb;
    public static byte[] potentialGoalData;
    public static byte[] potentialGoalDataOffsets;
    public static byte nCurrentGoals;
    public static Goal[] currentGoals;
    public static short[] names;
    public static short[] baseLP;
    public static short[] baseOP;
    public static short[] goalClassData;
    public static byte[] goalClassDataOffsets;
    public static byte dateCounter;
    public byte activityCounter = 0;
    public byte type;
    public short lp;
    public short olympos;
    public boolean goalAccomplished;
    public short name;
    public byte student1;
    public byte student2;
    public int value1;
    public byte stat;
    public byte grade1;
    public byte intensity;
    public byte activity;
    public static byte[] minOfIter;
    public static byte[] rangeOfIter;
    public static byte[] countOfIter;
    public static int[] offsetOfIter;
    public static byte currentIter;
    public static StringBuffer sb;

    public static final void init(KFileBuffer kFileBuffer) {
        goalFileOffsets = new short[9];
        for (int i = 0; i <= 8; ++i) {
            Goal.goalFileOffsets[i] = kFileBuffer.readShort();
        }
        kFileBuffer.Seek(goalFileOffsets[0]);
        Goal.loadGoalClassData(kFileBuffer);
    }

    private static void loadGoalClassData(KFileBuffer kFileBuffer) {
        int n = kFileBuffer.readByte();
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            byte by2 = kFileBuffer.readByte();
            Goal.names[by2] = kFileBuffer.readShort();
            Goal.baseLP[by2] = kFileBuffer.readShort();
            Goal.baseOP[by2] = kFileBuffer.readShort();
            Goal.goalClassDataOffsets[by2] = by;
            switch (by2) {
                case 0: 
                case 3: 
                case 6: 
                case 11: 
                case 12: 
                case 13: {
                    byte by3 = by;
                    by = (byte)(by + 1);
                    Goal.goalClassData[by3] = kFileBuffer.readShort();
                    byte by4 = by;
                    by = (byte)(by + 1);
                    Goal.goalClassData[by4] = kFileBuffer.readShort();
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 21: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 28: 
                case 30: {
                    byte by5 = by;
                    by = (byte)(by + 1);
                    Goal.goalClassData[by5] = kFileBuffer.readShort();
                    byte by6 = by;
                    by = (byte)(by + 1);
                    Goal.goalClassData[by6] = kFileBuffer.readShort();
                }
            }
        }
    }

    public static final void loadChapterGoals(int n) {
        KFileBuffer kFileBuffer = Game.loadSimFile();
        kFileBuffer.Seek(goalFileOffsets[1 + n]);
        nPotentialGoals = kFileBuffer.readByte();
        potentialGoalTypes = new byte[nPotentialGoals];
        potentialGoalProb = new byte[nPotentialGoals];
        potentialGoalDataOffsets = new byte[nPotentialGoals];
        potentialGoalData = new byte[nPotentialGoals * 3];
        byte by = 0;
        for (int i = 0; i < nPotentialGoals; ++i) {
            Goal.potentialGoalTypes[i] = kFileBuffer.readByte();
            Goal.potentialGoalProb[i] = kFileBuffer.readByte();
            Goal.potentialGoalDataOffsets[i] = by;
            switch (potentialGoalTypes[i]) {
                case 0: 
                case 3: 
                case 6: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    byte by2 = by;
                    by = (byte)(by + 1);
                    Goal.potentialGoalData[by2] = kFileBuffer.readByte();
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 21: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 28: 
                case 30: {
                    byte by3 = by;
                    by = (byte)(by + 1);
                    Goal.potentialGoalData[by3] = kFileBuffer.readByte();
                }
                case 15: {
                    byte by4 = by;
                    by = (byte)(by + 1);
                    Goal.potentialGoalData[by4] = kFileBuffer.readByte();
                }
            }
        }
        Game.releaseSimFile();
    }

    public Goal(KFileBuffer kFileBuffer, boolean bl, boolean bl2) {
        this.student2 = (byte)-1;
        this.student1 = (byte)-1;
        this.loadGoal(kFileBuffer);
        if (!bl) {
            return;
        }
        this.registerGoal(bl2);
    }

    public final void staticGoalCheck() {
        switch (this.type) {
            case 0: 
            case 3: 
            case 6: {
                if (Game.Student_Stats[this.student1][this.stat] < this.value1 << 16) break;
                this.markAsAccomplished();
                return;
            }
            case 2: 
            case 5: 
            case 8: {
                for (int i = 0; i < 8; ++i) {
                    if (!Game.Student_IsActive[i] || Game.Student_Stats[i][this.stat] < this.value1 << 16) continue;
                    this.markAsAccomplished();
                    return;
                }
                break;
            }
        }
    }

    private Goal(byte by, short s, short s2) {
        this.type = by;
        this.name = names[this.type];
        this.lp = s;
        this.olympos = (short)(s2 + (s2 * ((OlymposModificationRatios[Game.cupidRank] << 16) / 100) >> 16));
        this.student2 = (byte)-1;
        this.student1 = (byte)-1;
        this.registerGoal(true);
    }

    public static final void load(KFileBuffer kFileBuffer) {
        int n = kFileBuffer.readByte();
        for (int i = 0; i < n; ++i) {
            Goal goal = new Goal(kFileBuffer, true, false);
            new Goal(kFileBuffer, true, false).goalAccomplished = kFileBuffer.readBoolean();
        }
    }

    public static final void save(KFileBuffer kFileBuffer) {
        kFileBuffer.writeByte(nCurrentGoals);
        for (int i = 0; i < nCurrentGoals; ++i) {
            currentGoals[i].saveGoal(kFileBuffer);
            kFileBuffer.writeByte(Goal.currentGoals[i].goalAccomplished ? 1 : 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void saveGoal(KFileBuffer var1_1) {
        var1_1.writeByte(this.type);
        var1_1.writeShort(this.name);
        var1_1.writeShort(this.lp);
        var1_1.writeShort(this.olympos);
        switch (this.type) {
            case 33: {
                return;
            }
            case 0: 
            case 3: {
                var1_1.writeByte(this.student1);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                v0 = var1_1;
                ** GOTO lbl84
            }
            case 6: {
                var1_1.writeByte(this.student1);
            }
            case 7: 
            case 8: {
                v1 = var1_1;
                v2 = this.stat;
                ** GOTO lbl82
            }
            case 9: {
                v1 = var1_1;
                v2 = this.student1;
                ** GOTO lbl82
            }
            case 17: 
            case 18: {
                v0 = var1_1;
                v3 = this.student1;
                ** GOTO lbl85
            }
            case 19: {
                var1_1.writeByte(this.student1);
                v0 = var1_1;
                v3 = this.intensity;
                ** GOTO lbl85
            }
            case 34: {
                var1_1.writeByte(this.student1);
                v1 = var1_1;
                v2 = this.activity;
                ** GOTO lbl82
            }
            case 10: {
                v0 = var1_1;
                v3 = this.student1;
                ** GOTO lbl85
            }
            case 11: {
                var1_1.writeByte(this.student1);
            }
            case 12: 
            case 13: 
            case 14: {
                v1 = var1_1;
                v2 = this.intensity;
                ** GOTO lbl82
            }
            case 15: {
                var1_1.writeByte(this.student1);
                v0 = var1_1;
                v3 = this.activity;
                ** GOTO lbl85
            }
            case 21: {
                v0 = var1_1;
                ** GOTO lbl84
            }
            case 22: 
            case 23: {
                v0 = var1_1;
                v3 = this.grade1;
                ** GOTO lbl85
            }
            case 26: {
                var1_1.writeByte(this.student1);
                v0 = var1_1;
                v3 = this.grade1;
                ** GOTO lbl85
            }
            case 27: {
                v0 = var1_1;
                v3 = this.student1;
                ** GOTO lbl85
            }
            case 25: 
            case 28: {
                var1_1.writeByte(this.student1);
                var1_1.writeByte(this.student2);
                v0 = var1_1;
                v3 = this.grade1;
                ** GOTO lbl85
            }
            case 29: {
                v0 = var1_1;
                v3 = this.student1;
                ** GOTO lbl85
            }
            case 30: {
                var1_1.writeByte(this.student1);
                v1 = var1_1;
                v2 = this.student2;
lbl82:
                // 5 sources

                v1.writeByte(v2);
                v0 = var1_1;
lbl84:
                // 3 sources

                v3 = this.value1;
lbl85:
                // 10 sources

                v0.writeByte(v3);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadGoal(KFileBuffer var1_1) {
        this.type = var1_1.readByte();
        this.name = var1_1.readShort();
        this.lp = var1_1.readShort();
        this.olympos = var1_1.readShort();
        switch (this.type) {
            case 33: {
                return;
            }
            case 0: 
            case 3: {
                this.student1 = var1_1.readByte();
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (this.type == 2 || this.type == 1 || this.type == 0) {
                    v0 = this;
                    v1 = 5;
                } else {
                    v0 = this;
                    v1 = 4;
                }
                v0.stat = (byte)v1;
                v2 = this;
                ** GOTO lbl86
            }
            case 6: {
                this.student1 = var1_1.readByte();
            }
            case 7: 
            case 8: {
                this.stat = var1_1.readByte();
                ** GOTO lbl85
            }
            case 9: {
                this.student1 = var1_1.readByte();
                ** GOTO lbl85
            }
            case 17: 
            case 18: {
                this.student1 = var1_1.readByte();
                return;
            }
            case 19: {
                this.student1 = var1_1.readByte();
                this.intensity = var1_1.readByte();
                return;
            }
            case 34: {
                this.student1 = var1_1.readByte();
                this.activity = var1_1.readByte();
                ** GOTO lbl85
            }
            case 10: {
                this.student1 = var1_1.readByte();
                return;
            }
            case 11: {
                this.student1 = var1_1.readByte();
            }
            case 12: 
            case 13: 
            case 14: {
                this.intensity = var1_1.readByte();
                ** GOTO lbl85
            }
            case 15: {
                this.student1 = var1_1.readByte();
                this.activity = var1_1.readByte();
                return;
            }
            case 21: {
                v2 = this;
                ** GOTO lbl86
            }
            case 22: 
            case 23: {
                this.grade1 = var1_1.readByte();
                this.student2 = (byte)-1;
                this.student1 = (byte)-1;
                return;
            }
            case 26: {
                this.student1 = var1_1.readByte();
                this.student2 = (byte)-1;
                this.grade1 = var1_1.readByte();
                return;
            }
            case 27: {
                this.student1 = var1_1.readByte();
                this.student2 = (byte)-1;
                this.grade1 = (byte)9;
                return;
            }
            case 24: {
                this.student1 = (byte)-1;
                this.student2 = (byte)-1;
                this.grade1 = (byte)9;
                return;
            }
            case 25: 
            case 28: {
                this.student1 = var1_1.readByte();
                this.student2 = var1_1.readByte();
                this.grade1 = var1_1.readByte();
                return;
            }
            case 29: {
                this.student1 = var1_1.readByte();
                return;
            }
            case 30: {
                this.student1 = var1_1.readByte();
                this.student2 = var1_1.readByte();
lbl85:
                // 5 sources

                v2 = this;
lbl86:
                // 3 sources

                v2.value1 = var1_1.readByte();
            }
        }
    }

    protected static byte getNumGoals() {
        byte by = nCurrentGoals;
        for (int i = 0; i < nCurrentGoals; ++i) {
            if (Goal.currentGoals[i].type != 33) continue;
            by = (byte)(by - 2);
        }
        return by;
    }

    protected static Goal getGoal(byte n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            if (Goal.currentGoals[n2].type == 33) {
                n4 = n2;
                n3 = 3;
            } else {
                n4 = n2;
                n3 = 1;
            }
            n2 = (byte)(n4 + n3);
        }
        return currentGoals[n2];
    }

    private static byte numGoalWithStat(byte by, byte by2) {
        byte by3 = 0;
        for (int i = 0; i < nCurrentGoals; ++i) {
            if (Goal.currentGoals[i].type != by || Goal.currentGoals[i].stat != by2) continue;
            by3 = (byte)(by3 + 1);
        }
        return by3;
    }

    private static boolean studentHasLittleGoals(int n) {
        int n2 = 0;
        for (int i = 0; i < nCurrentGoals; ++i) {
            if (Goal.currentGoals[i].student1 != n && Goal.currentGoals[i].student2 != n) continue;
            ++n2;
        }
        return n2 < 2 || Game.nUnlockedStudent <= 1;
    }

    private static boolean goalWithStudentAndStatExists(byte by, int n, int n2) {
        for (int i = 0; i < nCurrentGoals; ++i) {
            if (Goal.currentGoals[i].type != by || Goal.currentGoals[i].student1 != n || Goal.currentGoals[i].stat != n2) continue;
            return true;
        }
        return false;
    }

    private static boolean dateGoalWithStudentExists(int n) {
        for (int i = 0; i < nCurrentGoals; ++i) {
            Goal goal = currentGoals[i];
            if (goal.type < 25 || goal.type > 28 || goal.student1 != n && goal.student2 != n) continue;
            return true;
        }
        return false;
    }

    private static boolean goalWithStudentExists(byte by, int n) {
        for (int i = 0; i < nCurrentGoals; ++i) {
            if (Goal.currentGoals[i].type != by || Goal.currentGoals[i].student1 != n && Goal.currentGoals[i].student2 != n) continue;
            return true;
        }
        return false;
    }

    private static boolean goalExists(byte by) {
        for (int i = 0; i < nCurrentGoals; ++i) {
            if (Goal.currentGoals[i].type != by) continue;
            return true;
        }
        return false;
    }

    private static void generateNewGoal() {
        byte by;
        currentIter = (byte)-1;
        int n = KMath.getRandom(0, 100);
        byte by2 = by = 0;
        while (by2 < nPotentialGoals && n > potentialGoalProb[by]) {
            by2 = (byte)(by + 1);
        }
        block14: for (int i = 0; i < nPotentialGoals; ++i) {
            byte by3 = (byte)((by + i) % nPotentialGoals);
            byte by4 = potentialGoalTypes[by3];
            byte by5 = potentialGoalDataOffsets[by3];
            byte by6 = goalClassDataOffsets[by4];
            short s = goalClassData[by6];
            short s2 = goalClassData[by6 + 1];
            switch (by4) {
                case 0: 
                case 3: 
                case 6: {
                    byte by7 = potentialGoalData[by5];
                    byte by8 = potentialGoalData[by5 + 1];
                    byte by9 = potentialGoalData[by5 + 2];
                    if (!Goal.generateBuildStatSpecific(by4, by7, by8, by9, s, s2)) continue block14;
                    return;
                }
                case 9: {
                    byte by10 = potentialGoalData[by5];
                    byte by11 = potentialGoalData[by5 + 1];
                    if (!Goal.generateBuildStatSpecific(by4, (byte)0, by10, by11, (short)0, (short)0)) continue block14;
                    return;
                }
                case 7: 
                case 8: {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    byte by10 = potentialGoalData[by5];
                    byte by11 = potentialGoalData[by5 + 1];
                    short s3 = s;
                    short s4 = s2;
                    int n9 = 1 + (by11 - by10) / 10;
                    int n10 = KMath.getRandom(0, 3);
                    for (n8 = 0; n8 < 4; ++n8) {
                        n7 = (byte)((n10 + n8) % 4);
                        if (Goal.numGoalWithStat(by4, (byte)n7) != 0) continue;
                        n6 = KMath.getRandom(0, n9 - 1);
                        for (n5 = 0; n5 < n9; ++n5) {
                            n4 = by10 + (n6 + n5) % n9 * 10;
                            n3 = n4 << 16;
                            int n11 = 0;
                            int n12 = 8;
                            for (n2 = 0; n2 < 8; ++n2) {
                                if (!Game.Student_IsActive[n2]) {
                                    --n12;
                                    continue;
                                }
                                if (Game.Student_Stats[n2][n7] < n3) continue;
                                ++n11;
                            }
                            if (by4 == 8 ? n11 != 0 : n11 == n12) continue;
                            int n13 = n4 / 20;
                            Goal goal = new Goal(by4, (short)(baseLP[by4] + s3 * n13), (short)(baseOP[by4] + s4 * n13));
                            new Goal(by4, (short)(baseLP[by4] + s3 * n13), (short)(baseOP[by4] + s4 * n13)).stat = (byte)n7;
                            goal.value1 = n4;
                            return;
                        }
                    }
                    continue block14;
                }
                case 5: {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    byte by10 = potentialGoalData[by5];
                    byte by11 = potentialGoalData[by5 + 1];
                    short s3 = s;
                    short s4 = s2;
                    int n9 = 1 + (by11 - by10) / 10;
                    if (Goal.numGoalWithStat(by4, (byte)4) != 0) continue block14;
                    int n8 = KMath.getRandom(0, n9 - 1);
                    for (n7 = 0; n7 < n9; ++n7) {
                        n6 = by10 + (n8 + n7) % n9 * 10;
                        n5 = 0;
                        for (n4 = 0; n4 < 8 && n5 == 0; ++n4) {
                            if (!Game.Student_IsActive[n4] || Game.Student_Stats[n4][4] < n6 << 16) continue;
                            n5 = 1;
                        }
                        if (n5 != 0) continue;
                        n4 = n6 / 20;
                        Goal goal = new Goal(by4, (short)(baseLP[by4] + s3 * n4), (short)(baseOP[by4] + s4 * n4));
                        new Goal(by4, (short)(baseLP[by4] + s3 * n4), (short)(baseOP[by4] + s4 * n4)).stat = (byte)4;
                        goal.value1 = n6;
                        return;
                    }
                    continue block14;
                }
                case 13: 
                case 14: {
                    byte by12 = potentialGoalData[by5];
                    byte by10 = potentialGoalData[by5 + 1];
                    byte by11 = potentialGoalData[by5 + 2];
                    if (!Goal.generateScheduleIntensity(by4, by12, by10, by11)) continue block14;
                    return;
                }
                case 21: {
                    if (Goal.goalExists(by4)) continue block14;
                    byte by10 = potentialGoalData[by5];
                    byte by11 = potentialGoalData[by5 + 1];
                    int n7 = KMath.getRandom(by10, by11);
                    Goal goal = new Goal(by4, (short)(baseLP[by4] + n7 * s), (short)(baseOP[by4] + n7 * s2));
                    new Goal(by4, (short)(baseLP[by4] + n7 * s), (short)(baseOP[by4] + n7 * s2)).value1 = n7;
                    return;
                }
                case 22: 
                case 23: {
                    byte by10 = potentialGoalData[by5];
                    byte by11 = potentialGoalData[by5 + 1];
                    if (!Goal.generateDateAnyGoal(by4, by10, by11, s, s2)) continue block14;
                    return;
                }
                case 24: {
                    if (!Goal.generateDateAnyGoal(by4, (byte)9, (byte)9, (short)10, (short)10)) continue block14;
                    return;
                }
                case 25: 
                case 26: 
                case 28: {
                    byte by10 = potentialGoalData[by5];
                    byte by11 = potentialGoalData[by5 + 1];
                    if (!Goal.generateDateSpecificGoal(by4, by10, by11, s, s2)) continue block14;
                    return;
                }
                case 27: {
                    if (!Goal.generateDateSpecificGoal(by4, (byte)9, (byte)9, (short)15, (short)15)) continue block14;
                    return;
                }
                case 30: {
                    int n3;
                    int n4;
                    int n14 = n4 = Goal.initRandomIter(0, 3);
                    while (!(n14 == -1 || Game.Student_IsActive[n4] && !Goal.hasCoupleKeepTogetherGoal(n4) && Game.Student_CoupleIdx[n4] == -1 && Goal.studentHasLittleGoals(n4))) {
                        n14 = Goal.iterateIter();
                    }
                    if (n4 == -1) continue block14;
                    int n15 = n3 = Goal.initRandomIter(4, 7);
                    while (!(n15 == -1 || Game.Student_IsActive[n3] && !Goal.hasCoupleKeepTogetherGoal(n3) && Game.Student_CoupleIdx[n3] == -1 && Goal.studentHasLittleGoals(n3))) {
                        n15 = Goal.iterateIter();
                    }
                    if (n3 == -1) continue block14;
                    byte by10 = potentialGoalData[by5];
                    byte by11 = potentialGoalData[by5 + 1];
                    int n2 = KMath.getRandom(by10, by11);
                    Goal goal = new Goal(by4, (short)(baseLP[by4] + n2 * s), (short)(baseOP[by4] + n2 * s2));
                    new Goal(by4, (short)(baseLP[by4] + n2 * s), (short)(baseOP[by4] + n2 * s2)).student1 = (byte)n4;
                    goal.student2 = (byte)n3;
                    goal.value1 = n2;
                    return;
                }
            }
        }
    }

    private static boolean hasCoupleKeepTogetherGoal(int n) {
        for (int i = 0; i < nCurrentGoals; ++i) {
            if (Goal.currentGoals[i].type != 30 || Goal.currentGoals[i].student1 != n && Goal.currentGoals[i].student2 != n) continue;
            return true;
        }
        return false;
    }

    private static int initIter(int n, int n2, int n3) {
        currentIter = (byte)(currentIter + 1);
        Goal.minOfIter[Goal.currentIter] = (byte)n2;
        Goal.countOfIter[Goal.currentIter] = (byte)(n3 - n2 + 1);
        Goal.rangeOfIter[Goal.currentIter] = countOfIter[currentIter];
        Goal.offsetOfIter[Goal.currentIter] = n - n2 - 1;
        return Goal.iterateIter();
    }

    private static int initRandomIter(int n, int n2) {
        currentIter = (byte)(currentIter + 1);
        Goal.minOfIter[Goal.currentIter] = (byte)n;
        Goal.countOfIter[Goal.currentIter] = (byte)(n2 - n + 1);
        Goal.rangeOfIter[Goal.currentIter] = countOfIter[currentIter];
        Goal.offsetOfIter[Goal.currentIter] = KMath.getRandom(0, 1000);
        return Goal.iterateIter();
    }

    private static byte iterateIter() {
        byte by = currentIter;
        countOfIter[by] = (byte)(countOfIter[by] - 1);
        if (countOfIter[by] < 0) {
            currentIter = (byte)(currentIter - 1);
            return -1;
        }
        byte by2 = currentIter;
        int n = offsetOfIter[by2] + 1;
        offsetOfIter[by2] = n;
        return (byte)(minOfIter[currentIter] + n % rangeOfIter[currentIter]);
    }

    private static void popIter() {
        currentIter = (byte)(currentIter - 1);
    }

    private static int findStudentForDateGoal(int n, int n2) {
        int n3;
        int n4 = n3 = Goal.initRandomIter(n, n2);
        while (n4 != -1) {
            if (Game.Student_IsActive[n3] && Game.Student_CoupleIdx[n3] == -1 && !Goal.dateGoalWithStudentExists(n3) && Goal.studentHasLittleGoals(n3)) {
                return n3;
            }
            n4 = Goal.iterateIter();
        }
        return -1;
    }

    private static boolean generateDateSpecificGoal(byte by, byte by2, byte by3, short s, short s2) {
        Goal goal;
        int n;
        int n2;
        int n3;
        if (by == 27) {
            n3 = Goal.findStudentForDateGoal(0, 7);
            if (n3 == -1) {
                return false;
            }
            n2 = -1;
        } else {
            n3 = Goal.findStudentForDateGoal(0, 3);
            if (n3 == -1) {
                return false;
            }
            n2 = Goal.findStudentForDateGoal(4, 7);
            if (n2 == -1) {
                return false;
            }
        }
        for (n = 0; n < nCurrentGoals; ++n) {
            goal = currentGoals[n];
            if (goal.type < 22 || goal.type > 24 || by3 < goal.grade1 || by2 <= (by3 = (byte)(goal.grade1 - 1))) continue;
            return false;
        }
        n = KMath.getRandom(by2, by3);
        goal = new Goal(by, (short)(baseLP[by] + n * s), (short)(baseOP[by] + n * s2));
        new Goal(by, (short)(baseLP[by] + n * s), (short)(baseOP[by] + n * s2)).grade1 = (byte)n;
        goal.student1 = (byte)n3;
        goal.student2 = (byte)n2;
        return true;
    }

    private static boolean generateDateAnyGoal(byte by, byte by2, byte by3, short s, short s2) {
        Goal goal;
        int n;
        if (Goal.goalExists(by)) {
            return false;
        }
        for (n = 0; n < nCurrentGoals; ++n) {
            goal = currentGoals[n];
            if (goal.type < 25 || goal.type > 28 || by2 > goal.grade1 || (by2 = (byte)(goal.grade1 + 1)) <= by3) continue;
            return false;
        }
        n = KMath.getRandom(by2, by3);
        goal = new Goal(by, (short)(baseLP[by] + n * s), (short)(baseOP[by] + n * s2));
        new Goal(by, (short)(baseLP[by] + n * s), (short)(baseOP[by] + n * s2)).grade1 = (byte)n;
        goal.student2 = (byte)-1;
        goal.student1 = (byte)-1;
        return true;
    }

    private static boolean generateBuildStatSpecific(byte by, byte by2, byte by3, byte by4, short s, short s2) {
        int n;
        int n2 = 0;
        int n3 = 3;
        if (by == 3) {
            n3 = 4;
            n2 = 4;
        }
        if (by == 0) {
            n3 = 5;
            n2 = 5;
        }
        int n4 = n = Goal.initRandomIter(0, 7);
        while (n4 != -1) {
            int n5;
            if (!Game.Student_IsActive[n] || !Goal.studentHasLittleGoals(n) || Goal.goalWithStudentExists(by, n) && by == 9) {
                n4 = Goal.iterateIter();
                continue;
            }
            int n6 = n5 = Goal.initRandomIter(n2, n3);
            while (n6 != -1) {
                int n7;
                int n8 = ((Game.Student_Stats[n][n5] >> 16) + 5) / 10 * 10;
                if (n8 < by2 || Goal.goalWithStudentAndStatExists(by, n, n5) || Goal.numGoalWithStat(by, (byte)n5) >= 2) {
                    n6 = Goal.iterateIter();
                    continue;
                }
                int n9 = n8;
                if (by == 9) {
                    n9 = 0;
                }
                int n10 = n7 = Goal.initRandomIter(by3 / 10, by4 / 10);
                while (n10 != -1) {
                    int n11 = n7 * 10 + n9;
                    if (n11 <= 100 && n11 > n8) {
                        Goal goal = new Goal(by, (short)(baseLP[by] + s * n7), (short)(baseOP[by] + s2 * n7));
                        if (by != 9) {
                            goal.stat = (byte)n5;
                        }
                        goal.student1 = (byte)n;
                        goal.value1 = n11;
                        return true;
                    }
                    n10 = Goal.iterateIter();
                }
                n6 = Goal.iterateIter();
            }
            n4 = Goal.iterateIter();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean generateScheduleIntensity(byte var0, byte var1_1, byte var2_2, byte var3_3) {
        if (var0 != 11 && Goal.goalExists(var0)) {
            return false;
        }
        Goal.currentIter = (byte)-1;
        var4_4 = Goal.goalClassDataOffsets[var0];
        var5_5 = Goal.goalClassData[var4_4];
        var6_6 = Goal.goalClassData[var4_4 + 1];
        var7_7 = Goal.goalClassData[var4_4 + 2];
        var8_8 = Goal.goalClassData[var4_4 + 3];
        v0 = var12_9 = Goal.initRandomIter(0, var1_1);
        while (v0 != -1) {
            v1 = var13_10 = Goal.initRandomIter(var2_2, var3_3);
            while (v1 != -1) {
                block17: {
                    if (var0 != 13) break block17;
                    v2 = 4;
                    ** GOTO lbl22
                }
                if (var0 == 14) {
                    v2 = 0;
                    v3 = 3;
                } else {
                    v2 = 0;
lbl22:
                    // 2 sources

                    v3 = 7;
                }
                v4 = var14_11 = Goal.initRandomIter(v2, v3);
                while (v4 != -1) {
                    if (!Game.Student_IsActive[var14_11] || Goal.goalWithStudentExists(var0, (byte)var14_11) || !Goal.studentHasLittleGoals(var14_11) && var0 == 11) {
                        v4 = Goal.iterateIter();
                        continue;
                    }
                    var15_12 = 0;
                    for (var16_14 = 0; var16_14 < Game.Student_Schedule[var14_11].length; ++var16_14) {
                        var17_16 = Game.Student_Schedule[var14_11][var16_14];
                        if (var17_16 % 3 == var12_9 && var17_16 < 12) {
                            ++var15_12;
                        }
                        if (var15_12 == var13_10) break;
                    }
                    if (var15_12 >= var13_10) {
                        if (var0 != 11) {
                            break;
                        }
                    } else if (var0 == 11) {
                        var10_17 = (short)(Goal.baseLP[var0] + var5_5 * var12_9 + var7_7 * var13_10);
                        var11_19 = (short)(Goal.baseOP[var0] + var6_6 * var12_9 + var8_8 * var13_10);
                        var16_15 = new Goal(var0, var10_17, var11_19);
                        new Goal(var0, var10_17, var11_19).student1 = (byte)var14_11;
                        var16_15.intensity = (byte)var12_9;
                        var16_15.value1 = var13_10;
                        return true;
                    }
                    v4 = Goal.iterateIter();
                }
                if (var14_11 == -1) {
                    if (var0 != 11) {
                        var10_18 = 0;
                        var11_20 = 0;
                        if (var0 == 12) {
                            // empty if block
                        }
                        var10_18 = (short)(Goal.baseLP[var0] + var5_5 * var12_9 + var7_7 * var13_10);
                        var11_20 = (short)(Goal.baseOP[var0] + var6_6 * var12_9 + var8_8 * var13_10);
                        var15_13 = new Goal(var0, var10_18, var11_20);
                        new Goal(var0, var10_18, var11_20).intensity = (byte)var12_9;
                        var15_13.value1 = var13_10;
                        return true;
                    }
                } else {
                    Goal.popIter();
                }
                v1 = Goal.iterateIter();
            }
            v0 = Goal.iterateIter();
        }
        return false;
    }

    public static void removeGoal(Goal goal) {
        int n = 0;
        byte by = (byte)n;
        while (by < nCurrentGoals && currentGoals[n] != goal) {
            by = (byte)(n + 1);
        }
        if (Goal.currentGoals[n].type == 33) {
            Goal.removeGoal(currentGoals[n + 1]);
            Goal.removeGoal(currentGoals[n + 1]);
        }
        Goal.currentGoals[n] = null;
        nCurrentGoals = (byte)(nCurrentGoals - 1);
        for (int i = n; i < nCurrentGoals; ++i) {
            Goal.currentGoals[i] = currentGoals[i + 1];
        }
        if (nCurrentGoals <= 0) {
            Goal.updateGoalList();
        }
    }

    public static boolean isGoalAccomplished(short s) {
        int n = Goal.findGoalIndex(s);
        return promotionExam ? n == -1 || Goal.currentGoals[n].goalAccomplished : n == -1;
    }

    private boolean markAsAccomplished() {
        byte by;
        if (this.goalAccomplished) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        byte by2 = by = 0;
        while (by2 < nCurrentGoals) {
            if (currentGoals[by] == this) {
                n = by;
                break;
            }
            if (!Goal.currentGoals[by].goalAccomplished) {
                bl = true;
            }
            by2 = (byte)(by + 1);
        }
        if (promotionExam && bl) {
            return false;
        }
        by = (byte)(n - 1);
        if (by >= 0) {
            if (Goal.currentGoals[by].type == 33) {
                Game.CheckForNewGoalsToNotify(-1);
                this.goalAccomplished = true;
                return true;
            }
            if ((by = (byte)(by - 1)) >= 0 && Goal.currentGoals[by].type == 33 && Goal.currentGoals[by + 1].goalAccomplished) {
                this.goalAccomplished = true;
                Goal goal = currentGoals[by];
                currentGoals[by].goalAccomplished = true;
                Game.potentialGoalsFinished = true;
                return true;
            }
        }
        this.goalAccomplished = true;
        Game.potentialGoalsFinished = true;
        return true;
    }

    public final void giveGoalRewards() {
        if (!promotionExam) {
            Game.lovePoints = (short)(Game.lovePoints + this.lp);
        }
        Game.Money = (short)(Game.Money + this.olympos);
        Game.startOfDayOlympos = (short)(Game.startOfDayOlympos + this.olympos);
    }

    private void registerGoal(boolean bl) {
        byte by = nCurrentGoals;
        nCurrentGoals = (byte)(by + 1);
        Goal.currentGoals[by] = this;
        this.goalAccomplished = false;
    }

    public static final void accomplishAllGoals() {
        for (int i = 0; i < nCurrentGoals; ++i) {
            currentGoals[i].markAsAccomplished();
        }
        Game.CheckForCompleteGoals();
    }

    public static final int findGoalIndex(short s) {
        for (int i = 0; i < nCurrentGoals; ++i) {
            if (Goal.currentGoals[i].name != s) continue;
            return i;
        }
        return -1;
    }

    public static final void clearGoals() {
        nCurrentGoals = 0;
    }

    public static final void updateGoalList() {
        if (!dynamicGoals || promotionExam) {
            return;
        }
        for (int i = nCurrentGoals; i < 4; ++i) {
            Goal.generateNewGoal();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean statChangeEvent(int var0, int var1_1) {
        var2_2 = false;
        block5: for (var3_3 = 0; var3_3 < Goal.nCurrentGoals; ++var3_3) {
            var4_4 = Goal.currentGoals[var3_3];
            switch (var4_4.type) {
                case 0: 
                case 3: 
                case 6: {
                    if (var0 != var4_4.student1) continue block5;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    if (var1_1 != var4_4.stat || Game.Student_Stats[var0][var1_1] < var4_4.value1 << 16) continue block5;
                    ** GOTO lbl17
                }
                case 9: {
                    if (var0 != var4_4.student1) continue block5;
                    var5_5 = var4_4.value1 << 16;
                    var6_6 = 4;
                    while (--var6_6 >= 0 && Game.Student_Stats[var0][var6_6] >= var5_5) {
                    }
                    if (var6_6 >= 0) continue block5;
lbl17:
                    // 2 sources

                    var2_2 = var4_4.markAsAccomplished();
                }
            }
        }
        return var2_2;
    }

    public static final void hangOutEvent(int n) {
        for (int i = 0; i < nCurrentGoals; ++i) {
            Goal goal = currentGoals[i];
            if (goal.type != 18 || goal.student1 != -1 && goal.student1 != n) continue;
            goal.markAsAccomplished();
        }
    }

    public static boolean crushDestroyedEvent() {
        boolean bl = false;
        for (int i = 0; i < nCurrentGoals; ++i) {
            int n;
            Goal goal = currentGoals[i];
            if (goal.type != 29) continue;
            if (goal.student1 == -1) {
                for (n = 0; !(n >= 8 || Game.Student_IsActive[n] && Game.Student_CrushIdx[n] != -1); ++n) {
                }
                if (n != 8) continue;
            } else {
                n = Game.Student_IsMale(goal.student1) ? 0 : 4;
                int n2 = 0;
                while (!(n2 >= 4 || Game.Student_IsActive[n] && Game.Student_CrushIdx[n] == goal.student1)) {
                    ++n2;
                    ++n;
                }
                if (n2 != 4) continue;
            }
            bl = goal.markAsAccomplished();
        }
        return bl;
    }

    public static void coupleDayEvent(int n, int n2) {
        for (int i = 0; i < nCurrentGoals; ++i) {
            Goal goal = currentGoals[i];
            if (goal.type != 30 || goal.student1 != n && goal.student1 != n2 || goal.student2 != n && goal.student2 != n2 || goal.value1 > Game.Student_CoupleNumDays[n]) continue;
            goal.markAsAccomplished();
        }
    }

    public static void dateEvent(int n, int n2, byte by) {
        dateCounter = (byte)(dateCounter + 1);
        for (int i = 0; i < nCurrentGoals; ++i) {
            Goal goal = currentGoals[i];
            if (goal.type == 21) {
                if (dateCounter < goal.value1) continue;
                goal.markAsAccomplished();
                continue;
            }
            if (goal.type == 22) {
                if (by < goal.grade1) continue;
                goal.markAsAccomplished();
                continue;
            }
            if (goal.type == 24) {
                if (by < goal.grade1 || Game.isCoupleDate) continue;
                goal.markAsAccomplished();
                continue;
            }
            if (goal.type == 25 || goal.type == 27) {
                if (goal.student1 != -1 && goal.student1 != n && goal.student1 != n2 || goal.student2 != -1 && goal.student2 != n && goal.student2 != n2 || by < goal.grade1) continue;
                goal.markAsAccomplished();
                continue;
            }
            if (goal.type == 28) {
                if (goal.student1 != -1 && goal.student1 != n && goal.student1 != n2 || goal.student2 != -1 && goal.student2 != n && goal.student2 != n2 || by != goal.grade1) continue;
                goal.markAsAccomplished();
                continue;
            }
            if (goal.type != 26 || goal.student1 != n && goal.student1 != n2 || by < goal.grade1) continue;
            goal.markAsAccomplished();
        }
    }

    public static void dayPassedEvent() {
        dateCounter = 0;
    }

    public static void postDateEvent() {
        block3: for (int i = 0; i < nCurrentGoals; ++i) {
            switch (Goal.currentGoals[i].type) {
                case 31: {
                    int n;
                    for (n = 0; !(n >= 8 || Game.Student_IsActive[n] && Game.Student_CoupleIdx[n] == -1); ++n) {
                    }
                    if (n != 8) continue block3;
                    currentGoals[i].markAsAccomplished();
                }
            }
        }
    }

    public static void scheduleChangeEvent(int n) {
        block6: for (int i = 0; i < nCurrentGoals; ++i) {
            Goal goal = currentGoals[i];
            if (goal.goalAccomplished) continue;
            switch (goal.type) {
                case 13: 
                case 14: {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    currentIter = (byte)-1;
                    if (goal.type == 13) {
                        if (n < 4) continue block6;
                        n8 = n;
                        n7 = 4;
                        n6 = 7;
                    } else {
                        if (n >= 4) continue block6;
                        n8 = n;
                        n7 = 0;
                        n6 = 3;
                    }
                    int n9 = n5 = Goal.initIter(n8, n7, n6);
                    while (n9 != -1) {
                        if (!Game.Student_IsActive[n5]) {
                            n9 = Goal.iterateIter();
                            continue;
                        }
                        n4 = 0;
                        n3 = 0;
                        for (n2 = 0; n2 < 6; ++n2) {
                            n3 = Game.Student_Schedule[n5][n2];
                            if (n3 >= 12 || n3 % 3 != goal.intensity) continue;
                            ++n4;
                        }
                        if (n4 < goal.value1) break;
                        n9 = Goal.iterateIter();
                    }
                    if (n5 != -1) continue block6;
                    goal.markAsAccomplished();
                    continue block6;
                }
                case 11: 
                case 12: {
                    int n2;
                    int n3;
                    if (goal.type == 11 && n != goal.student1) continue block6;
                    int n4 = 0;
                    for (n3 = 0; n3 < 6; ++n3) {
                        n2 = Game.Student_Schedule[n][n3];
                        if (n2 >= 12 || n2 % 3 != goal.intensity) continue;
                        ++n4;
                    }
                    if (n4 < goal.value1) continue block6;
                    goal.markAsAccomplished();
                    continue block6;
                }
                case 15: {
                    int n3;
                    if (goal.student1 != n) continue block6;
                    for (n3 = 0; n3 < 6 && Game.Student_Schedule[n][n3] == goal.activity; ++n3) {
                    }
                    if (n3 != 6) continue block6;
                    goal.markAsAccomplished();
                    continue block6;
                }
                case 10: {
                    if (goal.student1 != -1 && goal.student1 != n) continue block6;
                    goal.markAsAccomplished();
                }
            }
        }
    }

    public static final void activityEvent(int n, byte by) {
        block4: for (int i = 0; i < nCurrentGoals; ++i) {
            Goal goal = currentGoals[i];
            if (goal.goalAccomplished) continue;
            switch (goal.type) {
                case 19: {
                    if (goal.intensity != -1 && goal.intensity != by % 3 || goal.student1 != -1 && goal.student1 != n) continue block4;
                    goal.markAsAccomplished();
                    continue block4;
                }
                case 34: {
                    if (goal.student1 != n || goal.activity != by || (goal.activityCounter = (byte)(goal.activityCounter + 1)) != goal.value1) continue block4;
                    goal.markAsAccomplished();
                }
            }
        }
    }

    public static final boolean genericEvent(byte by, int n) {
        boolean bl = false;
        block3: for (int i = 0; i < nCurrentGoals; ++i) {
            Goal goal = currentGoals[i];
            if (goal.goalAccomplished || by != goal.type) continue;
            switch (by) {
                case 17: {
                    if (n != goal.student1 && goal.student1 != -1) continue block3;
                    bl = goal.markAsAccomplished();
                }
            }
        }
        return bl;
    }

    public final char[] getName() {
        if (this.type == 33) {
            for (int i = 0; i < nCurrentGoals; ++i) {
                if (currentGoals[i] != this) continue;
                if (Goal.currentGoals[i + 1].goalAccomplished) {
                    return (String.valueOf(currentGoals[i + 1].getName()) + ": " + String.valueOf(currentGoals[i + 2].getName())).toCharArray();
                }
                return currentGoals[i + 1].getName();
            }
        }
        sb.delete(0, sb.length());
        char[] cArray = Game.getWords(this.name).toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '$') {
                if (cArray[++i] == 'x') {
                    sb.append(Game.getWords(Game.Student_Names[this.student1]));
                    continue;
                }
                if (cArray[i] == 'y') {
                    sb.append(Game.getWords(Game.Student_Names[this.student2]));
                    continue;
                }
                if (cArray[i] == 's') {
                    sb.append(Game.getWords(Game.STR_STAT_NAMES_IDX[this.stat]).toLowerCase());
                    continue;
                }
                if (cArray[i] == 'v') {
                    sb.append("" + this.value1);
                    continue;
                }
                if (cArray[i] == 'i') {
                    sb.append(Game.getWords(Game.STR_ACTIVITY_INTENSITY_NAMES_IDX[this.intensity]));
                    continue;
                }
                if (cArray[i] == 'a') {
                    sb.append(Game.getWords(Game.STR_ACTIVITY_NAMES_IDX[this.activity]));
                    continue;
                }
                if (cArray[i] == 'g') {
                    Game.appendSpecialScoreCharacter$114623fc(sb, this.grade1, false);
                    continue;
                }
                if (cArray[i] < '0' || cArray[i] > '9') continue;
                Game.appendSpecialScoreCharacter$114623fc(sb, cArray[i] - 48, false);
                continue;
            }
            sb.append(cArray[i]);
        }
        return sb.toString().toCharArray();
    }

    public static void removeGoalsByExitCondition(short s) {
        int n = Goal.findGoalIndex(s);
        if (n != -1) {
            if (!promotionExam) {
                Goal.removeGoal(currentGoals[n]);
                return;
            }
            for (int i = 0; i <= n; ++i) {
                Goal.removeGoal(currentGoals[i]);
            }
        }
    }

    static {
        currentGoals = new Goal[24];
        names = new short[35];
        baseLP = new short[35];
        baseOP = new short[35];
        goalClassData = new short[140];
        goalClassDataOffsets = new byte[35];
        minOfIter = new byte[6];
        rangeOfIter = new byte[6];
        countOfIter = new byte[6];
        offsetOfIter = new int[6];
        sb = new StringBuffer(200);
    }
}

