/*
 * Decompiled with CFR 0.152.
 */
package core;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import kernel.KCanvas;
import kernel.KFileBuffer;
import kernel.KGraphics;
import kernel.KRes;
import kernel.KResource;
import kernel.KUtils;

public final class TileViewport {
    private short m_tilesetName;
    private KRes m_tileset;
    private int m_log_tileset_cols;
    private int m_log_tile_w;
    private int m_log_tile_h;
    private KRes m_buffer_image;
    private Graphics m_buffer_graphics;
    private int m_buffer_cols;
    private int m_buffer_rows;
    private boolean m_buffer_valid;
    private byte[] m_compactedBitmap_map;
    public int m_map_cols;
    public int m_map_rows;
    private int m_scroll_x;
    private int m_scroll_y;
    public int m_offset_x;
    public int m_offset_y;
    public int m_tileW;
    public int m_tileH;
    public static int s_mapTileWidth = 4;
    public static int s_mapTileHeight = 3;

    private TileViewport(short s, int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6, int n7, int n8) {
        try {
            this.m_tilesetName = s;
            this.m_tileset = KResource.load(this.m_tilesetName, 1);
            this.m_tileH = n2;
            this.m_tileW = n;
            this.m_log_tile_w = n3;
            this.m_log_tile_h = n4;
            this.m_log_tileset_cols = 0;
            for (int i = ((Image)this.m_tileset.ro_ref).getWidth() >> n3; i > 1; i >>= 1) {
                ++this.m_log_tileset_cols;
            }
            this.m_compactedBitmap_map = byArray;
            this.m_map_cols = n5;
            this.m_map_rows = n6;
            this.m_buffer_cols = n7 + (3 << n3) - 1 >> n3;
            this.m_buffer_rows = n8 + (3 << n4) - 1 >> n4;
            if (this.m_buffer_cols > this.m_map_cols) {
                this.m_buffer_cols = this.m_map_cols;
            }
            if (this.m_buffer_rows > this.m_map_rows) {
                this.m_buffer_rows = this.m_map_rows;
            }
            int n9 = this.m_buffer_cols << this.m_log_tile_w;
            int n10 = this.m_buffer_rows << this.m_log_tile_h;
            this.m_buffer_image = KResource.createImage(n9, n10);
            this.m_buffer_graphics = ((Image)this.m_buffer_image.ro_ref).getGraphics();
            if (n9 < n7) {
                this.m_offset_x = n7 - n9 >> 1;
            }
            if (n10 < n8) {
                this.m_offset_y = n8 - n10 >> 1;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static TileViewport loadViewport(KFileBuffer kFileBuffer, int n, int n2) {
        try {
            short s = kFileBuffer.readShort();
            short s2 = kFileBuffer.readShort();
            short s3 = kFileBuffer.readShort();
            short s4 = kFileBuffer.readShort();
            short s5 = kFileBuffer.readShort();
            int n3 = kFileBuffer.readInt();
            byte[] byArray = new byte[n3];
            kFileBuffer.readFully$1cf967a4(byArray, n3);
            TileViewport tileViewport = new TileViewport(s, s4, s5, s_mapTileWidth, s_mapTileHeight, byArray, s2, s3, n, n2);
            return tileViewport;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final TileViewport release() {
        if (this.m_tileset != null) {
            this.m_tileset = KResource.releaseRes(this.m_tileset.ro_hHandle);
        }
        if (this.m_buffer_image != null) {
            this.m_buffer_image = KResource.releaseRes(this.m_buffer_image.ro_hHandle);
        }
        return null;
    }

    public final void Draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 < 0) {
            n4 = 0;
        }
        int n7 = this.m_buffer_cols << this.m_log_tile_w;
        int n8 = this.m_buffer_rows << this.m_log_tile_h;
        graphics.setClip(n, n2, n3, n4);
        if (n3 > n7 || KCanvas.m_width > n7) {
            n += this.m_offset_x;
        }
        if (n4 > n8 || KCanvas.m_height > n8) {
            n2 += this.m_offset_y;
        }
        int n9 = n5 - this.m_scroll_x;
        int n10 = n6 - this.m_scroll_y;
        if (n9 < 0) {
            n9 = -n9;
        }
        if (n10 < 0) {
            n10 = -n10;
        }
        if (n9 >= n7 || n10 >= n8) {
            this.m_buffer_valid = false;
        }
        if (!this.m_buffer_valid) {
            int n11 = n5 >> this.m_log_tile_w;
            int n12 = n6 >> this.m_log_tile_h;
            this.m_scroll_x = n11 << this.m_log_tile_w;
            this.m_scroll_y = n12 << this.m_log_tile_h;
            --n11;
            --n12;
            for (int i = 0; i < this.m_buffer_rows; ++i) {
                for (int j = 0; j < this.m_buffer_cols; ++j) {
                    this.UpdateTile(j + n11, i + n12);
                }
            }
            this.m_buffer_valid = true;
        }
        while (n5 < this.m_scroll_x) {
            this.IncrementalScroll(-1, 0);
        }
        while (n5 > this.m_scroll_x) {
            this.IncrementalScroll(1, 0);
        }
        while (n6 < this.m_scroll_y) {
            this.IncrementalScroll(0, -1);
        }
        while (n6 > this.m_scroll_y) {
            this.IncrementalScroll(0, 1);
        }
        if ((n5 %= n7) < 0) {
            n5 += n7;
        }
        if ((n6 %= n8) < 0) {
            n6 += n8;
        }
        KGraphics.drawImage(this.m_buffer_image, n -= n5, n2 -= n6);
        KGraphics.drawImage(this.m_buffer_image, n + n7, n2);
        KGraphics.drawImage(this.m_buffer_image, n, n2 + n8);
        KGraphics.drawImage(this.m_buffer_image, n + n7, n2 + n8);
    }

    private void UpdateTile(int n, int n2) {
        int n3;
        int n4;
        int n5 = n % this.m_buffer_cols;
        if (n5 < 0) {
            n5 += this.m_buffer_cols;
        }
        if ((n4 = n2 % this.m_buffer_rows) < 0) {
            n4 += this.m_buffer_rows;
        }
        n5 <<= this.m_log_tile_w;
        n4 <<= this.m_log_tile_h;
        if ((n %= this.m_map_cols) < 0) {
            n += this.m_map_cols;
        }
        if ((n2 %= this.m_map_rows) < 0) {
            n2 += this.m_map_rows;
        }
        int n6 = ((n3 = KUtils.compactedBitmap_getValue(this.m_compactedBitmap_map, n2 * this.m_map_cols + n)) & 0x80) != 0 ? 2 : 0;
        int n7 = (n3 &= 0x7F) >> this.m_log_tileset_cols;
        this.m_buffer_graphics.drawRegion((Image)this.m_tileset.ro_ref, (n3 -= n7 << this.m_log_tileset_cols) << this.m_log_tile_w, n7 << this.m_log_tile_h, 1 << this.m_log_tile_w, 1 << this.m_log_tile_h, n6, n5, n4, 20);
    }

    private void IncrementalScroll(int n, int n2) {
        block14: {
            int n3;
            int n4;
            TileViewport tileViewport;
            block15: {
                boolean bl;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                block16: {
                    int n11;
                    int n12;
                    block12: {
                        boolean bl2;
                        int n13;
                        int n14;
                        int n15;
                        block13: {
                            if (n < 0) {
                                --this.m_scroll_x;
                            } else if (n2 < 0) {
                                --this.m_scroll_y;
                            }
                            n15 = this.m_scroll_x >> this.m_log_tile_w;
                            n10 = this.m_scroll_y >> this.m_log_tile_h;
                            int n16 = this.m_scroll_x - (n15 << this.m_log_tile_w);
                            n12 = this.m_scroll_y - (n10 << this.m_log_tile_h);
                            n9 = n15 - 1;
                            n8 = n9 + this.m_buffer_cols;
                            n7 = n10 - 1;
                            n11 = n7 + this.m_buffer_rows;
                            n14 = n15 + ((this.m_buffer_cols - 1) * n12 >> this.m_log_tile_h);
                            n6 = n15 + ((this.m_buffer_cols - 1) * (n12 + 1) >> this.m_log_tile_h);
                            n5 = n10 + ((this.m_buffer_rows - 1) * n16 >> this.m_log_tile_w);
                            n13 = n10 + ((this.m_buffer_rows - 1) * (n16 + 1) >> this.m_log_tile_w);
                            if (n == 0) break block12;
                            boolean bl3 = bl2 = n16 + 1 >> this.m_log_tile_w != 0;
                            if (n <= 0) break block13;
                            for (int i = n5; i < n13; ++i) {
                                this.UpdateTile(n8, i);
                            }
                            if (!bl2) break block14;
                            this.UpdateTile(n8, n7);
                            if (n14 <= n15) break block14;
                            tileViewport = this;
                            n4 = n14;
                            n3 = n11;
                            break block15;
                        }
                        for (int i = n5; i < n13; ++i) {
                            this.UpdateTile(n9, i);
                        }
                        if (!bl2) break block14;
                        this.UpdateTile(n14, n7);
                        if (n14 <= n15) break block14;
                        tileViewport = this;
                        n4 = n15;
                        n3 = n11;
                        break block15;
                    }
                    boolean bl4 = bl = n12 + 1 >> this.m_log_tile_h != 0;
                    if (n2 <= 0) break block16;
                    for (int i = n14; i < n6; ++i) {
                        this.UpdateTile(i, n11);
                    }
                    if (!bl) break block14;
                    this.UpdateTile(n9, n11);
                    if (n5 <= n10) break block14;
                    tileViewport = this;
                    n4 = n8;
                    n3 = n5;
                    break block15;
                }
                for (int i = n14; i < n6; ++i) {
                    this.UpdateTile(i, n7);
                }
                if (!bl) break block14;
                this.UpdateTile(n9, n5);
                if (n5 <= n10) break block14;
                tileViewport = this;
                n4 = n8;
                n3 = n10;
            }
            tileViewport.UpdateTile(n4, n3);
        }
        if (n > 0) {
            ++this.m_scroll_x;
            return;
        }
        if (n2 > 0) {
            ++this.m_scroll_y;
        }
    }
}

