/*
 * Decompiled with CFR 0.152.
 */
package animation;

import animation.Animation;
import kernel.KRes;
import kernel.KResource;

public final class AnimInstance {
    public KRes m_animRes;
    public Animation m_anim;
    public int m_currentActionID;
    public int m_nextActionID = -1;
    public int m_frameIndex;
    public int m_pageID;
    private int m_endPage;
    private int m_animDir;
    public byte m_frameTime;
    public boolean m_animLoop;
    public AnimInstance[] m_hotspotAnim;
    public boolean m_update_hotspot;
    public boolean m_hotspotAutoReleased;
    public int m_X;
    public int m_Y;
    public int m_vX;
    public boolean m_facingRight;
    public boolean m_facingUp;
    public boolean m_dirDependentX;
    public boolean m_dirDependentY;
    public byte[] m_imageStates;
    public boolean m_imageLoading;

    public AnimInstance(short s) {
        this.m_animRes = KResource.load(s, 4);
        this.m_anim = (Animation)this.m_animRes.ro_ref;
        this.m_imageStates = new byte[this.m_anim.m_images.length];
        this.m_dirDependentY = true;
        this.m_dirDependentX = true;
        this.m_facingRight = false;
        this.m_facingUp = true;
        this.m_currentActionID = -1;
        if (this.m_anim.m_numHotspot >= 0) {
            this.m_hotspotAnim = new AnimInstance[this.m_anim.m_numHotspot];
        }
        this.m_update_hotspot = false;
        this.m_hotspotAutoReleased = true;
        this.m_animDir = 1;
    }

    public final AnimInstance release() {
        if (this.m_animRes != null) {
            this.removeHotspots();
            this.releaseImages();
            KResource.releaseRes(this.m_animRes.ro_hHandle);
        }
        this.m_animRes = null;
        return null;
    }

    private int getFrameIndex(int n) {
        return this.m_anim.m_frames[n][this.m_pageID << 1] & 0xFF;
    }

    private void initMech(boolean bl) {
        byte by = this.m_anim.m_mechModelFlags[this.m_currentActionID];
        if ((by & 1) != 0) {
            this.m_vX = this.m_anim.m_mechModel[this.m_currentActionID << 2];
            if (bl) {
                this.m_vX = -this.m_vX;
            }
        }
    }

    public final void removeHotspots() {
        if (this.m_hotspotAnim != null) {
            for (int i = this.m_hotspotAnim.length - 1; i >= 0; --i) {
                if (this.m_hotspotAnim[i] != null && this.m_hotspotAnim[i].m_hotspotAutoReleased) {
                    this.m_hotspotAnim[i].release();
                }
                this.m_hotspotAnim[i] = null;
            }
        }
    }

    private void removeHotspot(int n) {
        if (this.m_hotspotAnim[n] != null && this.m_hotspotAnim[n].m_hotspotAutoReleased) {
            this.m_hotspotAnim[n].release();
        }
        this.m_hotspotAnim[n] = null;
    }

    public final void setHotspot(int n, AnimInstance animInstance) {
        this.removeHotspot(n);
        this.m_hotspotAnim[n] = animInstance;
    }

    public final void changeAction(int n, boolean bl, boolean bl2) {
        this.changeAction(n, bl, bl2, true);
    }

    private void changeAction(int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl3 && !this.m_facingUp && this.m_dirDependentY) {
            n |= 1;
        }
        if (n >= this.m_anim.m_nFrame.length) {
            n = this.m_anim.m_nFrame.length - 1;
        }
        this.m_animLoop = bl;
        if (n == this.m_currentActionID && !bl2) {
            this.initMech(this.m_facingRight);
            return;
        }
        this.m_nextActionID = n;
        this.m_imageLoading = false;
        if (this.m_anim.m_autoManageHeap) {
            this.updateImagesUsed(this.m_nextActionID);
            this.loadUsedImages();
        }
        if (this.m_imageLoading && this.m_currentActionID != -1) {
            return;
        }
        this.m_nextActionID = -1;
        this.m_currentActionID = n;
        this.resetFrameCounter();
        this.initMech(this.m_facingRight);
    }

    private void resetFrameCounter() {
        int n;
        AnimInstance animInstance;
        if (this.m_animDir == 1) {
            this.m_endPage = this.m_anim.m_nFrame[this.m_currentActionID] - 1;
            animInstance = this;
            n = 0;
        } else {
            this.m_endPage = 0;
            animInstance = this;
            n = this.m_anim.m_nFrame[this.m_currentActionID] - 1;
        }
        animInstance.m_pageID = n;
        this.m_frameIndex = this.getFrameIndex(this.m_currentActionID);
        this.m_frameTime = 0;
    }

    public final void updateAnimation() {
        if (!this.m_imageLoading) {
            this.m_frameTime = (byte)(this.m_frameTime + 1);
            if (this.m_frameTime >= this.m_anim.m_frames[this.m_currentActionID][(this.m_pageID << 1) + 1]) {
                if (this.m_pageID == this.m_endPage) {
                    if (this.m_animLoop) {
                        this.resetFrameCounter();
                    }
                } else {
                    this.m_pageID += this.m_animDir;
                    this.m_frameIndex = this.getFrameIndex(this.m_currentActionID);
                }
                this.m_frameTime = 0;
            }
        } else {
            this.m_imageLoading = false;
            if (!this.m_imageLoading) {
                if (this.m_nextActionID == -1) {
                    this.updateAnimation();
                    return;
                }
                this.releaseUnusedImages();
                System.gc();
                this.m_currentActionID = this.m_nextActionID;
                this.resetFrameCounter();
                this.initMech(this.m_facingRight);
                this.m_nextActionID = -1;
            }
        }
        if (this.m_update_hotspot) {
            for (int i = 0; i < this.m_hotspotAnim.length; ++i) {
                if (this.m_hotspotAnim[i] == null) continue;
                this.m_hotspotAnim[i].updateAnimation();
            }
        }
    }

    public final void draw(boolean bl) {
        boolean bl2 = this.m_dirDependentX ? this.m_facingRight : false;
        this.m_anim.draw(this.m_X, this.m_Y, bl2, bl, this.m_frameIndex, this.m_hotspotAnim);
    }

    public final void draw(int n, int n2, boolean bl, boolean bl2) {
        bl = this.m_dirDependentX ? bl : false;
        this.m_anim.draw(n, n2, bl, bl2, this.m_frameIndex, this.m_hotspotAnim);
    }

    private void releaseUnusedImages() {
        for (int i = this.m_imageStates.length - 1; i >= 0; --i) {
            if (this.m_imageStates[i] != 1) continue;
            KResource.releaseRes(this.m_anim.m_images[i].ro_hHandle);
            this.m_imageStates[i] = 0;
        }
    }

    private void loadUsedImages() {
        for (int i = this.m_imageStates.length - 1; i >= 0; --i) {
            if (this.m_imageStates[i] != 3) continue;
            this.m_imageStates[i] = 2;
            this.m_anim.m_images[i] = KResource.load(this.m_anim.m_imgLoadingList[i], 1);
            this.m_imageLoading = true;
        }
    }

    public final void reloadImages(boolean bl) {
        if (this.m_anim.m_autoManageHeap) {
            this.updateImagesUsed(this.m_currentActionID);
            this.loadUsedImages();
        } else {
            this.m_anim.reloadAllImages(bl);
        }
        for (int i = this.m_hotspotAnim.length - 1; i >= 0; --i) {
            if (this.m_hotspotAnim[i] == null || !this.m_hotspotAnim[i].m_hotspotAutoReleased) continue;
            this.m_hotspotAnim[i].reloadImages(bl);
        }
    }

    private void releaseImages() {
        int n;
        if (this.m_anim.m_autoManageHeap) {
            for (n = this.m_imageStates.length - 1; n >= 0; --n) {
                if (this.m_imageStates[n] != 2) continue;
                this.m_imageStates[n] = 1;
            }
            this.releaseUnusedImages();
        } else {
            this.m_anim.releaseAllImages();
        }
        for (n = this.m_hotspotAnim.length - 1; n >= 0; --n) {
            if (this.m_hotspotAnim[n] == null || !this.m_hotspotAnim[n].m_hotspotAutoReleased) continue;
            this.m_hotspotAnim[n].releaseImages();
        }
    }

    private void updateImagesUsed(int n) {
        int n2;
        if (n == -1) {
            return;
        }
        for (n2 = this.m_imageStates.length - 1; n2 >= 0; --n2) {
            if (this.m_imageStates[n2] != 2) continue;
            this.m_imageStates[n2] = 1;
        }
        n2 = this.m_pageID;
        AnimInstance animInstance = this;
        int n3 = this.m_anim.m_nFrame[n];
        while (true) {
            animInstance.m_pageID = n3 - 1;
            if (this.m_pageID < 0) break;
            int n4 = this.getFrameIndex(n);
            for (int i = this.m_anim.getModuleCountInFrame(n4) - 1; i >= 0; --i) {
                int n5;
                short s;
                byte[] byArray;
                int[] nArray = this.m_anim.getModuleInFrame(i, n4);
                if (nArray[3] == -1) continue;
                short s2 = this.m_anim.m_modules[nArray[3] + 0];
                if (this.m_imageStates[s2] == 1) {
                    byArray = this.m_imageStates;
                    s = s2;
                    n5 = 2;
                } else {
                    if (this.m_imageStates[s2] != 0) continue;
                    byArray = this.m_imageStates;
                    s = s2;
                    n5 = 3;
                }
                byArray[s] = n5;
            }
            AnimInstance animInstance2 = this;
            animInstance = animInstance2;
            n3 = animInstance2.m_pageID;
        }
        this.m_pageID = n2;
    }
}

