/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import animation.Animation;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import kernel.KFileBuffer;
import kernel.KFont;
import kernel.KGraphics;
import kernel.KRes;

public final class KResource {
    static KRes[] hashMap = new KRes[600];
    static int[] hashMapID = new int[600];
    private static short[] bucketEmptyList = new short[200];
    private static short bucketEmptyListStackTop;
    private static short bucketEmptyListStackBottom;
    public static byte loaderStatus;
    private static int nObjToLoad;
    private static int nLoadedObj;
    private static Vector resQueue;
    private static Vector LoadingLists;
    public static boolean persistentPalette;
    private static KFileBuffer pakCached;
    private static int pakCachedID;

    private static final void initHashTable() {
        bucketEmptyListStackTop = (short)199;
        bucketEmptyListStackBottom = 0;
        short s = 599;
        short s2 = s;
        while (s2 >= 0) {
            KResource.hashMap[s] = new KRes();
            KResource.hashMapID[s] = 65535;
            s2 = (short)(s - 1);
        }
        s = 199;
        short s3 = s;
        while (s3 >= 0) {
            KResource.bucketEmptyList[s] = (short)(600 - s - 1);
            s3 = (short)(s - 1);
        }
    }

    private static KRes addObject(Object object, int n) {
        short s = KResource.hashFormula(n);
        if (KResource.hashMap[s].ro_hHandle != -1 || n == 65534 || n == 65533) {
            s = (n & 0xFFFF) >= 65533 ? KResource.findBucketSpaceBottom() : KResource.findBucketSpaceTop();
        }
        KResource.hashMap[s].ro_hHandle = s;
        KResource.hashMap[s].ro_ref = object;
        KResource.hashMap[s].ro_count = 1;
        KResource.hashMapID[s] = n;
        return hashMap[s];
    }

    private static short findResById(int n) {
        short s = KResource.hashFormula(n);
        if (n != 65534) {
            short s2;
            if (hashMapID[s] == n) {
                return s;
            }
            short s3 = s2 = 599;
            while (s3 >= 400) {
                if (hashMapID[s2] == n) {
                    return s2;
                }
                s3 = (short)(s2 - 1);
            }
        }
        return -1;
    }

    private static final short hashFormula(int n) {
        return (short)(((n & 0x3FF) + (n >> 10 & 0x3F) + (n >> 16)) % 400);
    }

    private static final short findBucketSpaceTop() {
        short s = bucketEmptyListStackTop;
        bucketEmptyListStackTop = (short)(s - 1);
        return bucketEmptyList[s];
    }

    private static final short findBucketSpaceBottom() {
        short s = bucketEmptyListStackBottom;
        bucketEmptyListStackBottom = (short)(s + 1);
        return bucketEmptyList[s];
    }

    public static final KRes getResObject(int n) {
        if (n >= 600 || n < 0) {
            return null;
        }
        return hashMap[n];
    }

    public static final KRes releaseRes(int n) {
        int n2;
        KRes kRes = hashMap[n];
        if (kRes.ro_ref == null) {
            return null;
        }
        if (n > 400 && hashMapID[n] == 65534) {
            int[] nArray = (int[])kRes.ro_ref;
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                KResource.releaseRes(nArray[n2]);
            }
        }
        if ((kRes.ro_count = (short)(kRes.ro_count - 1)) <= 0) {
            n2 = hashMapID[n] & 0xFFFF;
            KResource.hashMapID[n] = 65535;
            kRes.ro_ref = null;
            kRes.ro_hHandle = (short)-1;
            if (n > 400) {
                short s;
                short[] sArray;
                if (n2 >= 65533) {
                    bucketEmptyListStackBottom = (short)(bucketEmptyListStackBottom - 1);
                    sArray = bucketEmptyList;
                    s = bucketEmptyListStackBottom;
                } else {
                    bucketEmptyListStackTop = (short)(bucketEmptyListStackTop + 1);
                    sArray = bucketEmptyList;
                    s = bucketEmptyListStackTop;
                }
                sArray[s] = (short)n;
            }
        }
        return null;
    }

    public static final void init() {
        nObjToLoad = 0;
        nLoadedObj = 0;
        KResource.initHashTable();
        KResource.clearCache();
    }

    private static final void loadListCore() {
        while (LoadingLists.size() != 0) {
            int[] nArray = (int[])LoadingLists.firstElement();
            LoadingLists.removeElementAt(0);
            LoadingLists.ensureCapacity(LoadingLists.size() + nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                KRes kRes = KResource.load(nArray[i], 126);
                resQueue.addElement(kRes);
                nArray[i] = kRes.ro_hHandle;
                loaderStatus = (byte)(++nLoadedObj * 100 / nObjToLoad);
            }
        }
        if (loaderStatus == 100) {
            nObjToLoad = 0;
        }
    }

    private static KRes registerLoadingList(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        KRes kRes = KResource.addObject(nArray2, 65534);
        return kRes;
    }

    public static final KRes dequeueRes$112eeda8() {
        KRes kRes = null;
        if (resQueue != null) {
            if (resQueue.size() == 0) {
                resQueue = null;
            }
            kRes = (KRes)resQueue.firstElement();
            resQueue.removeElementAt(0);
        }
        return kRes;
    }

    public static final KRes loadList$5d5df99b(int[] nArray) {
        KRes kRes = KResource.registerLoadingList(nArray);
        nObjToLoad += nArray.length;
        LoadingLists.addElement(kRes.ro_ref);
        KResource.loadListCore();
        return kRes;
    }

    public static final KRes load(String string, int n) {
        KRes kRes;
        KFont kFont = null;
        KFileBuffer kFileBuffer = new KFileBuffer(string);
        switch (n) {
            case 3: {
                kFont = new KFont(kFileBuffer);
                kRes = KResource.addUserResource(kFont);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 125: {
                kRes = KResource.addUserResource(kFileBuffer);
                break;
            }
            case 5: 
            case 126: 
            case 127: {
                kRes = KResource.addUserResource(kFileBuffer.getByteArray());
                break;
            }
            case 1: {
                kRes = KResource.addUserResource(Image.createImage((byte[])kFileBuffer.m_data, (int)kFileBuffer.m_start, (int)kFileBuffer.getLength()));
                break;
            }
            default: {
                return null;
            }
        }
        return kRes;
    }

    public static final KRes load(int n, int n2) {
        KRes kRes = null;
        KFileBuffer kFileBuffer = null;
        if ((n & 0xFFFF0000) == 0) {
            return KResource.load((short)(n & 0xFFFF), n2);
        }
        if (n2 == 127 || n2 == 126) {
            kFileBuffer = KResource.loadFileBufferFromPak((byte)((n & 0xFFFF) >> 10), (short)(n & 0x3FF));
            n2 = kFileBuffer.readByte();
        }
        switch (n2) {
            case 1: {
                kFileBuffer = KResource.loadPalettedImage(n & 0xFFFF, (n & 0xFFFF0000) >> 16);
            }
        }
        if (kFileBuffer == null) {
            return KResource.load((short)(n & 0xFFFF), n2);
        }
        short s = KResource.findResById(n);
        if (s == -1) {
            kRes = KResource.addObject(kFileBuffer, n);
        } else {
            kRes = KResource.getResObject(s);
            kRes.ro_count = (short)(kRes.ro_count + 1);
        }
        return kRes;
    }

    public static final KRes load(short s, int n) {
        KRes kRes = null;
        Object object = null;
        short s2 = KResource.findResById(s);
        if (s2 == -1) {
            object = KResource.loaderCore(s, n);
            kRes = KResource.addObject(object, s);
        } else {
            kRes = KResource.getResObject(s2);
            kRes.ro_count = (short)(kRes.ro_count + 1);
            switch (n) {
                case 4: {
                    ((Animation)kRes.ro_ref).incImageRefCount();
                }
            }
        }
        return kRes;
    }

    private static final Object loaderCore(short s, int n) {
        int n2;
        Object object;
        block13: {
            boolean bl;
            block15: {
                block16: {
                    block14: {
                        object = null;
                        byte by = (byte)(s >> 10);
                        short s2 = (short)(s & 0x3FF);
                        n2 = n;
                        bl = false;
                        if (n == 3) break block13;
                        object = KResource.loadFileBufferFromPak(by, s2);
                        if (n != 126) break block14;
                        n2 = ((KFileBuffer)object).readByte();
                        ++((KFileBuffer)object).m_start;
                        if (n2 != 9) break block15;
                        break block16;
                    }
                    n2 = ((KFileBuffer)object).readByte();
                    ++((KFileBuffer)object).m_start;
                    if (n2 == 127) {
                        n2 = 5;
                    }
                    if (n2 != 9) break block15;
                }
                n2 = ((KFileBuffer)object).readByte();
                bl = true;
            }
            if (bl) {
                s = ((KFileBuffer)object).readShort();
                ((KFileBuffer)object).m_start = 0;
                object = KResource.loadFileBufferFromPak((KFileBuffer)object, (short)(s & 0x3FF));
                ++((KFileBuffer)object).m_start;
                ((KFileBuffer)object).Seek(0);
            }
        }
        switch (n2) {
            case 3: {
                object = new KFont((KFileBuffer)object);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 125: {
                object = new KFileBuffer((KFileBuffer)object, 0, ((KFileBuffer)object).getLength());
                break;
            }
            case 5: 
            case 6: {
                return ((KFileBuffer)object).getByteArray();
            }
            case 1: {
                KFileBuffer kFileBuffer = object;
                object = Image.createImage((byte[])kFileBuffer.m_data, (int)kFileBuffer.m_pos, (int)kFileBuffer.getLength());
                break;
            }
            case 126: {
                object = ((KFileBuffer)object).m_data;
                break;
            }
            case 4: {
                object = new Animation((KFileBuffer)object, s);
                break;
            }
            default: {
                return null;
            }
        }
        return object;
    }

    private static Image loadPalettedImage(int n, int n2) {
        byte by = (byte)(n >> 10);
        short s = (byte)(n & 0x3FF);
        KFileBuffer kFileBuffer = KResource.loadFileBufferFromPak(by, s);
        KRes kRes = KResource.load((short)n2, 6);
        byte[] byArray = (byte[])kRes.ro_ref;
        ++kFileBuffer.m_start;
        kFileBuffer.Seek(0);
        byte[] byArray2 = kFileBuffer.readBytes(0, 0);
        System.arraycopy(byArray, 0, byArray2, 41, byArray.length);
        Image image = Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
        if (persistentPalette) {
            resQueue.addElement(kRes);
        } else {
            KResource.releaseRes(kRes.ro_hHandle);
        }
        return image;
    }

    public static final KRes addUserResource(Object object) {
        KRes kRes = KResource.addObject(object, 65533);
        return kRes;
    }

    public static final void clearCache() {
        pakCached = null;
        pakCachedID = -1;
    }

    private static final KFileBuffer loadPakFile(byte by) {
        KFileBuffer kFileBuffer = null;
        if (pakCachedID == by) {
            kFileBuffer = pakCached;
        } else {
            pakCached = null;
            kFileBuffer = pakCached = new KFileBuffer(by + ".pak");
            pakCachedID = by;
        }
        return kFileBuffer;
    }

    private static final KFileBuffer loadFileBufferFromPak(byte by, short s) {
        KFileBuffer kFileBuffer = KResource.loadPakFile(by);
        return KResource.loadFileBufferFromPak(kFileBuffer, s);
    }

    public static final KFileBuffer loadFileBufferFromPak(KFileBuffer kFileBuffer, short s) {
        kFileBuffer.Seek((s << 2) + 2);
        int n = kFileBuffer.readInt();
        int n2 = kFileBuffer.readInt();
        KFileBuffer kFileBuffer2 = new KFileBuffer(kFileBuffer.m_data, n, n2);
        return kFileBuffer2;
    }

    public static final int getNumberPakEntries(KFileBuffer kFileBuffer) {
        int n = kFileBuffer.Tell();
        short s = kFileBuffer.readShort();
        kFileBuffer.Seek(n);
        return s;
    }

    public static final KRes createImage(int n, int n2) {
        Image image = Image.createImage((int)n, (int)n2);
        KRes kRes = null;
        kRes = KResource.addUserResource(image);
        return kRes;
    }

    public static final KRes createImage(KFileBuffer kFileBuffer) {
        Image image;
        KRes kRes = null;
        int n = kFileBuffer.m_end - kFileBuffer.m_pos;
        try {
            image = Image.createImage((byte[])kFileBuffer.m_data, (int)kFileBuffer.m_pos, (int)n);
        }
        catch (Exception exception) {
            image = KGraphics.createImage(1, 1);
        }
        kFileBuffer.m_pos += n;
        kRes = KResource.addUserResource(image);
        return kRes;
    }

    static {
        loaderStatus = (byte)100;
        resQueue = new Vector();
        LoadingLists = new Vector();
        persistentPalette = false;
        pakCached = null;
        pakCachedID = -1;
    }
}

