/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import kernel.KFileBuffer;
import kernel.KRes;
import kernel.KResource;

public final class KSound {
    private static short s_song = (short)-1;
    private static boolean s_loop;
    public static boolean s_enabled;
    private static Player s_player;

    public static void PlaySong(short s, boolean bl) {
        if (s_song != s) {
            KSound.PrepareSong(s);
            if (s_enabled) {
                KSound.StopPlayer();
            }
            s_loop = bl;
            if (s_enabled) {
                KSound.StartPlayer();
                return;
            }
        } else if (!bl) {
            s_loop = bl;
            if (s_enabled) {
                KSound.StartPlayer();
            }
        }
    }

    public static void Stop() {
        if (s_loop) {
            if (s_enabled) {
                KSound.StopPlayer();
                KSound.ClosePlayer();
            }
        } else if (s_enabled) {
            KSound.StopPlayer();
        }
        s_loop = false;
        s_song = (short)-1;
    }

    public static void Disable() {
        if (s_enabled) {
            KSound.StopPlayer();
            KSound.ClosePlayer();
            s_enabled = false;
        }
    }

    public static boolean Enable() {
        boolean bl = true;
        if (!s_enabled) {
            s_enabled = true;
            if (s_loop) {
                bl = KSound.StartPlayer();
            }
        }
        s_enabled = bl;
        return bl;
    }

    private static String IdentifyContent(KFileBuffer kFileBuffer) {
        int n = kFileBuffer.Tell();
        kFileBuffer.Seek(0);
        short s = kFileBuffer.readShortLE();
        kFileBuffer.Seek(n);
        if (s == 0) {
            return "";
        }
        if (s == 21581) {
            return "audio/midi";
        }
        return "";
    }

    private static void PrepareSong(short s) {
        if (s_song != s) {
            if (s_enabled) {
                KSound.ClosePlayer();
            }
            s_song = s;
            if (s_enabled) {
                KSound.OpenPlayer();
            }
        }
        s_loop = false;
    }

    private static void OpenPlayer() {
        KSound.ClosePlayer();
        if (s_song < 0) {
            return;
        }
        String string = null;
        try {
            KRes kRes = KResource.load(s_song, 125);
            KFileBuffer kFileBuffer = (KFileBuffer)kRes.ro_ref;
            string = KSound.IdentifyContent(kFileBuffer);
            if (string.equals("")) {
                return;
            }
            s_player = Manager.createPlayer((InputStream)kFileBuffer.getInputStream(), (String)string);
            KResource.releaseRes(kRes.ro_hHandle);
            s_player.realize();
            s_player.prefetch();
            return;
        }
        catch (Exception exception) {
            s_player = null;
            return;
        }
    }

    private static void ClosePlayer() {
        if (s_player == null) {
            return;
        }
        try {
            s_player.stop();
        }
        catch (Exception exception) {}
        try {
            s_player.deallocate();
        }
        catch (Exception exception) {}
        try {
            s_player.close();
        }
        catch (Exception exception) {}
        s_player = null;
        System.gc();
    }

    private static boolean StartPlayer() {
        if (s_player == null) {
            KSound.OpenPlayer();
        }
        if (s_player == null) {
            return true;
        }
        try {
            s_player.prefetch();
        }
        catch (Exception exception) {}
        try {
            s_player.setMediaTime(0L);
        }
        catch (Exception exception) {}
        try {
            s_player.setLoopCount(s_loop ? -1 : 1);
        }
        catch (Exception exception) {}
        try {
            s_player.start();
        }
        catch (Exception exception) {}
        return true;
    }

    private static void StopPlayer() {
        if (s_player == null) {
            return;
        }
        try {
            s_player.stop();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

