/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.MapObjectInterface;
import Project.JDisplay;
import Project.JImage;
import StateManager.StateCommonData;
import java.io.DataInputStream;
import java.io.InputStream;

public class CAnim
implements MapObjectInterface {
    StateCommonData pCommonData;
    short noOfMapAnimations;
    MapObjectInterface.struct_MapAnimation[] pMapAnimation;
    MapObjectInterface.struct_ClippingInfo[][] pClippingInfo;
    byte iNOFBitmaps;

    public CAnim(StateCommonData pCommonData) {
        this.pCommonData = pCommonData;
    }

    public void readData(String mapFile) {
        try {
            int i;
            InputStream in = this.getClass().getResourceAsStream(mapFile);
            DataInputStream dis = new DataInputStream(in);
            this.iNOFBitmaps = this.pCommonData.jr.readByte(dis);
            this.pClippingInfo = new MapObjectInterface.struct_ClippingInfo[this.iNOFBitmaps][];
            for (i = 0; i < this.iNOFBitmaps; ++i) {
                int noOfLayers = this.pCommonData.jr.readShort(dis);
                this.pClippingInfo[i] = new MapObjectInterface.struct_ClippingInfo[noOfLayers];
                for (int j = 0; j < noOfLayers; ++j) {
                    this.pClippingInfo[i][j] = new MapObjectInterface.struct_ClippingInfo();
                    this.pClippingInfo[i][j].x = this.pCommonData.jr.readShort(dis);
                    this.pClippingInfo[i][j].y = this.pCommonData.jr.readShort(dis);
                    this.pClippingInfo[i][j].dx = this.pCommonData.jr.readShort(dis);
                    this.pClippingInfo[i][j].dy = this.pCommonData.jr.readShort(dis);
                }
            }
            this.noOfMapAnimations = this.pCommonData.jr.readShort(dis);
            this.pMapAnimation = new MapObjectInterface.struct_MapAnimation[this.noOfMapAnimations];
            for (i = 0; i < this.noOfMapAnimations; ++i) {
                int noOfFramesInAnimation = this.pCommonData.jr.readShort(dis);
                short animationWidth = this.pCommonData.jr.readShort(dis);
                short animationHeight = this.pCommonData.jr.readShort(dis);
                this.pMapAnimation[i] = new MapObjectInterface.struct_MapAnimation();
                this.pMapAnimation[i].NOFFrames = noOfFramesInAnimation;
                this.pMapAnimation[i].AnimationWidth = animationWidth;
                this.pMapAnimation[i].AnimationHeight = animationHeight;
                this.pMapAnimation[i].pMapAnimationFrame = new MapObjectInterface.struct_MapAnimationFrame[noOfFramesInAnimation];
                for (int j = 0; j < noOfFramesInAnimation; ++j) {
                    int noOfLayersInEachFrame = this.pCommonData.jr.readShort(dis);
                    short frameWidth = this.pCommonData.jr.readShort(dis);
                    short frameHeight = this.pCommonData.jr.readShort(dis);
                    short frameX = this.pCommonData.jr.readShort(dis);
                    short frameY = this.pCommonData.jr.readShort(dis);
                    this.pMapAnimation[i].pMapAnimationFrame[j] = new MapObjectInterface.struct_MapAnimationFrame();
                    this.pMapAnimation[i].pMapAnimationFrame[j].FrameWidth = frameWidth;
                    this.pMapAnimation[i].pMapAnimationFrame[j].FrameHeight = frameHeight;
                    this.pMapAnimation[i].pMapAnimationFrame[j].FrameX = frameX;
                    this.pMapAnimation[i].pMapAnimationFrame[j].FrameY = frameY;
                    this.pMapAnimation[i].pMapAnimationFrame[j].NOFLayers = noOfLayersInEachFrame;
                    this.pMapAnimation[i].pMapAnimationFrame[j].pMapAnimationLayer = new MapObjectInterface.struct_MapAnimationLayer[noOfLayersInEachFrame];
                    for (int k = 0; k < noOfLayersInEachFrame; ++k) {
                        this.pMapAnimation[i].pMapAnimationFrame[j].pMapAnimationLayer[k] = new MapObjectInterface.struct_MapAnimationLayer();
                        this.pMapAnimation[i].pMapAnimationFrame[j].pMapAnimationLayer[k].LayerX = this.pCommonData.jr.readShort(dis);
                        this.pMapAnimation[i].pMapAnimationFrame[j].pMapAnimationLayer[k].LayerY = this.pCommonData.jr.readShort(dis);
                        this.pMapAnimation[i].pMapAnimationFrame[j].pMapAnimationLayer[k].IndexOfSpriteArray = this.pCommonData.jr.readShort(dis);
                        this.pMapAnimation[i].pMapAnimationFrame[j].pMapAnimationLayer[k].IsFlipped = this.pCommonData.jr.readBoolean(dis);
                        this.pMapAnimation[i].pMapAnimationFrame[j].pMapAnimationLayer[k].BitmapIndex = this.pCommonData.jr.readByte(dis);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("readMap " + ex);
        }
    }

    public void releaseData() {
        int i = 0;
        int j = 0;
        if (this.pClippingInfo != null) {
            for (i = 0; i < this.iNOFBitmaps; ++i) {
                if (this.pClippingInfo[i] == null) continue;
                this.pClippingInfo[i] = null;
            }
            this.pClippingInfo = null;
        }
        if (this.pMapAnimation != null) {
            int noOFAnimatons = this.pMapAnimation.length;
            int noOfFrames = 0;
            for (i = 0; i < noOFAnimatons; ++i) {
                noOfFrames = this.pMapAnimation[i].NOFFrames;
                for (j = 0; j < noOfFrames; ++j) {
                    if (this.pMapAnimation[i].pMapAnimationFrame[j].pMapAnimationLayer == null) continue;
                    this.pMapAnimation[i].pMapAnimationFrame[j].pMapAnimationLayer = null;
                }
                this.pMapAnimation[i].NOFFrames = 0;
                if (this.pMapAnimation[i].pMapAnimationFrame == null) continue;
                this.pMapAnimation[i].pMapAnimationFrame = null;
            }
            this.pMapAnimation = null;
        }
    }

    public void drawFrame(JDisplay g, boolean isFlipped, int animationID, int animationFrameNumber, int drawFramX, int drawFrameY, int mapX, int mapY, int displayWidth, int displayHeight, JImage[] mapImages) {
        if (this.pMapAnimation == null) {
            return;
        }
        if (animationID < 0 || animationFrameNumber > this.pMapAnimation[animationID].NOFFrames) {
            return;
        }
        int noOfLayersInEachFrame = this.pMapAnimation[animationID].pMapAnimationFrame[animationFrameNumber].NOFLayers;
        boolean bLayerFlipped = false;
        for (int i = 0; i < noOfLayersInEachFrame; ++i) {
            short frameWidth = this.pMapAnimation[animationID].pMapAnimationFrame[animationFrameNumber].FrameWidth;
            short frameHeight = this.pMapAnimation[animationID].pMapAnimationFrame[animationFrameNumber].FrameHeight;
            if (drawFramX + frameWidth <= mapX || drawFramX >= mapX + displayWidth || drawFrameY + frameHeight <= mapY || drawFrameY >= mapY + displayHeight) continue;
            short layerX = this.pMapAnimation[animationID].pMapAnimationFrame[animationFrameNumber].pMapAnimationLayer[i].LayerX;
            short layerY = this.pMapAnimation[animationID].pMapAnimationFrame[animationFrameNumber].pMapAnimationLayer[i].LayerY;
            short layerIndexToBitmap = this.pMapAnimation[animationID].pMapAnimationFrame[animationFrameNumber].pMapAnimationLayer[i].IndexOfSpriteArray;
            byte bitMapIndex = this.pMapAnimation[animationID].pMapAnimationFrame[animationFrameNumber].pMapAnimationLayer[i].BitmapIndex;
            short layerWidth = this.pClippingInfo[bitMapIndex][layerIndexToBitmap].dx;
            short layerHeight = this.pClippingInfo[bitMapIndex][layerIndexToBitmap].dy;
            short clipY = this.pClippingInfo[bitMapIndex][layerIndexToBitmap].y;
            short clipX = this.pClippingInfo[bitMapIndex][layerIndexToBitmap].x;
            int renderY = layerY + drawFrameY;
            bLayerFlipped = isFlipped;
            int renderX = isFlipped ? drawFramX + (frameWidth - layerX - layerWidth) : layerX + drawFramX;
            if (this.pMapAnimation[animationID].pMapAnimationFrame[animationFrameNumber].pMapAnimationLayer[i].IsFlipped) {
                boolean bl = bLayerFlipped = !isFlipped;
            }
            if (renderX + layerWidth <= mapX || renderX >= mapX + displayWidth || renderY + layerHeight <= mapY || renderY >= mapY + displayHeight) continue;
            if (!bLayerFlipped) {
                g.drawImage(mapImages[bitMapIndex], renderX - mapX, renderY - mapY, clipX, clipY, layerWidth, layerHeight, 0, 1);
                continue;
            }
            g.drawImage(mapImages[bitMapIndex], renderX - mapX, renderY - mapY, clipX, clipY, layerWidth, layerHeight, 2, 1);
        }
    }
}

