/*
 * Decompiled with CFR 0.152.
 */
package Project;

import java.io.IOException;

public class JZip {
    private static final int BTYPE_NONE = 0;
    private static final int BTYPE_DYNAMIC = 2;
    private static final int MAX_BITS = 16;
    private static final int MAX_CODE_LITERALS = 287;
    private static final int MAX_CODE_DISTANCES = 31;
    private static final int MAX_CODE_LENGTHS = 18;
    private static final int EOB_CODE = 256;
    private static final int[] LENGTH_EXTRA_BITS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99};
    private static final int[] LENGTH_VALUES = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
    private static final int[] DISTANCE_EXTRA_BITS = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int[] DISTANCE_VALUES = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final int[] DYNAMIC_LENGTH_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static int gzipIndex;
    private static int gzipByte;
    private static int gzipBit;

    public static byte[] inflate(byte[] gzip, int uncompressedLen) throws IOException {
        gzipBit = 0;
        gzipByte = 0;
        gzipIndex = 0;
        JZip.readBits(gzip, 16);
        byte[] uncompressed = new byte[uncompressedLen];
        int uncompressedIndex = 0;
        int bfinal = 0;
        int btype = 0;
        do {
            int[] distanceTree;
            int[] literalTree;
            bfinal = JZip.readBits(gzip, 1);
            btype = JZip.readBits(gzip, 2);
            if (btype == 0) {
                gzipBit = 0;
                int len = JZip.readBits(gzip, 16);
                JZip.readBits(gzip, 16);
                System.arraycopy(gzip, gzipIndex, uncompressed, uncompressedIndex, len);
                gzipIndex += len;
                uncompressedIndex += len;
                continue;
            }
            if (btype == 2) {
                int hlit = JZip.readBits(gzip, 5) + 257;
                int hdist = JZip.readBits(gzip, 5) + 1;
                int hclen = JZip.readBits(gzip, 4) + 4;
                byte[] lengthBits = new byte[19];
                for (int i = 0; i < hclen; ++i) {
                    lengthBits[JZip.DYNAMIC_LENGTH_ORDER[i]] = (byte)JZip.readBits(gzip, 3);
                }
                int[] lengthTree = JZip.createHuffmanTree(lengthBits, 18);
                literalTree = JZip.createHuffmanTree(JZip.decodeCodeLengths(gzip, lengthTree, hlit), hlit - 1);
                distanceTree = JZip.createHuffmanTree(JZip.decodeCodeLengths(gzip, lengthTree, hdist), hdist - 1);
            } else {
                int i;
                byte[] literalBits = new byte[288];
                for (i = 0; i < 144; ++i) {
                    literalBits[i] = 8;
                }
                for (i = 144; i < 256; ++i) {
                    literalBits[i] = 9;
                }
                for (i = 256; i < 280; ++i) {
                    literalBits[i] = 7;
                }
                for (i = 280; i < 288; ++i) {
                    literalBits[i] = 8;
                }
                literalTree = JZip.createHuffmanTree(literalBits, 287);
                byte[] distanceBits = new byte[32];
                for (int i2 = 0; i2 < distanceBits.length; ++i2) {
                    distanceBits[i2] = 5;
                }
                distanceTree = JZip.createHuffmanTree(distanceBits, 31);
            }
            int code = 0;
            int leb = 0;
            int deb = 0;
            while ((code = JZip.readCode(gzip, literalTree)) != 256) {
                if (code > 256) {
                    int length = LENGTH_VALUES[code -= 257];
                    leb = LENGTH_EXTRA_BITS[code];
                    if (leb > 0) {
                        length += JZip.readBits(gzip, leb);
                    }
                    code = JZip.readCode(gzip, distanceTree);
                    int distance = DISTANCE_VALUES[code];
                    deb = DISTANCE_EXTRA_BITS[code];
                    if (deb > 0) {
                        distance += JZip.readBits(gzip, deb);
                    }
                    int offset = uncompressedIndex - distance;
                    while (distance < length) {
                        System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, distance);
                        uncompressedIndex += distance;
                        length -= distance;
                        distance <<= 1;
                    }
                    System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, length);
                    uncompressedIndex += length;
                    continue;
                }
                uncompressed[uncompressedIndex++] = (byte)code;
            }
        } while (bfinal == 0);
        return uncompressed;
    }

    private static int readBits(byte[] gzip, int n) {
        int data = gzipBit == 0 ? (gzipByte = gzip[gzipIndex++] & 0xFF) : gzipByte >> gzipBit;
        for (int i = 8 - gzipBit; i < n; i += 8) {
            gzipByte = gzip[gzipIndex++] & 0xFF;
            data |= gzipByte << i;
        }
        gzipBit = gzipBit + n & 7;
        return data & (1 << n) - 1;
    }

    private static int readCode(byte[] gzip, int[] tree) {
        int node = tree[0];
        while (node >= 0) {
            if (gzipBit == 0) {
                gzipByte = gzip[gzipIndex++] & 0xFF;
            }
            node = (gzipByte & 1 << gzipBit) == 0 ? tree[node >> 16] : tree[node & 0xFFFF];
            gzipBit = gzipBit + 1 & 7;
        }
        return node & 0xFFFF;
    }

    private static byte[] decodeCodeLengths(byte[] gzip, int[] lengthTree, int count) {
        byte[] bits = new byte[count];
        int i = 0;
        int code = 0;
        int last = 0;
        while (i < count) {
            code = JZip.readCode(gzip, lengthTree);
            if (code >= 16) {
                int repeat = 0;
                if (code == 16) {
                    repeat = 3 + JZip.readBits(gzip, 2);
                    code = last;
                } else {
                    repeat = code == 17 ? 3 + JZip.readBits(gzip, 3) : 11 + JZip.readBits(gzip, 7);
                    code = 0;
                }
                while (repeat-- > 0) {
                    bits[i++] = (byte)code;
                }
            } else {
                bits[i++] = (byte)code;
            }
            last = code;
        }
        return bits;
    }

    private static int[] createHuffmanTree(byte[] bits, int maxCode) {
        int[] bl_count = new int[17];
        for (int i = 0; i < bits.length; ++i) {
            byte by = bits[i];
            bl_count[by] = bl_count[by] + 1;
        }
        int code = 0;
        bl_count[0] = 0;
        int[] next_code = new int[17];
        for (int i = 1; i <= 16; ++i) {
            next_code[i] = code = code + bl_count[i - 1] << 1;
        }
        int[] tree = new int[(maxCode << 1) + 16];
        int treeInsert = 1;
        for (int i = 0; i <= maxCode; ++i) {
            byte len = bits[i];
            if (len == 0) continue;
            byte by = len;
            next_code[by] = next_code[by] + 1;
            int node = 0;
            for (int bit = len - 1; bit >= 0; --bit) {
                int value = code & 1 << bit;
                if (value == 0) {
                    int left = tree[node] >> 16;
                    if (left == 0) {
                        int n = node;
                        tree[n] = tree[n] | treeInsert << 16;
                        node = treeInsert++;
                        continue;
                    }
                    node = left;
                    continue;
                }
                int right = tree[node] & 0xFFFF;
                if (right == 0) {
                    int n = node;
                    tree[n] = tree[n] | treeInsert;
                    node = treeInsert++;
                    continue;
                }
                node = right;
            }
            tree[node] = Integer.MIN_VALUE | i;
        }
        return tree;
    }
}

