/*
 * Decompiled with CFR 0.152.
 */
package Game;

import StateManager.StateCommonData;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SoundPlayer
implements PlayerListener {
    public static final byte SND_MENU_THEME = 0;
    public static final byte SND_CONFIRM_TICK = 1;
    public static final byte SND_ATTACK = 2;
    public static final byte SND_DIE = 4;
    public static final byte SND_MAX = 5;
    public static boolean mIsSoundActive = false;
    public static int volumeLevel = 50;
    public static final byte INC_VOLUME_BY = 20;
    public static byte mActiveSoundType;
    Player vLocalPlayer;
    InputStream is = null;

    private static String guessContentType(String url) {
        String ctype = null;
        if (url.endsWith("wav")) {
            ctype = "audio/x-wav";
        } else if (url.endsWith("jts")) {
            ctype = "audio/x-tone-seq";
        } else if (url.endsWith("mid")) {
            ctype = "audio/midi";
        } else if (url.endsWith("amr")) {
            ctype = "audio/amr";
        } else {
            System.out.println("Cannot guess content type from URL: " + url);
        }
        return ctype;
    }

    public void SoundManager(String url, int type) {
        try {
            this.is = this.getClass().getResourceAsStream(url);
            String ctype = SoundPlayer.guessContentType(url);
            switch (type) {
                case 0: {
                    this.vLocalPlayer = Manager.createPlayer((InputStream)this.is, (String)ctype);
                    this.vLocalPlayer.realize();
                    this.vLocalPlayer.prefetch();
                    this.vLocalPlayer.setLoopCount(-1);
                    this.vLocalPlayer.start();
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    this.vLocalPlayer = Manager.createPlayer((InputStream)this.is, (String)ctype);
                    this.vLocalPlayer.realize();
                    this.vLocalPlayer.prefetch();
                    this.vLocalPlayer.setLoopCount(1);
                    this.vLocalPlayer.start();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in SoundManager " + e.toString());
        }
    }

    public synchronized void playSound(int type) {
        mActiveSoundType = (byte)type;
        this.stopSound();
        switch (type) {
            case 0: {
                this.SoundManager("/menuTheme.mid", type);
                break;
            }
            case 2: {
                this.SoundManager("/die.mid", type);
                break;
            }
            case 1: {
                this.SoundManager("/confirm.mid", type);
                break;
            }
            case 4: {
                this.SoundManager("/die.mid", type);
            }
        }
    }

    public void stopSound() {
        try {
            if (this.vLocalPlayer != null && this.vLocalPlayer.getState() != 0) {
                this.vLocalPlayer.deallocate();
                this.vLocalPlayer.stop();
                this.vLocalPlayer.close();
                this.vLocalPlayer = null;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in the stop sound" + e);
        }
    }

    public void releaseSoundData() {
        this.vLocalPlayer = null;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia") && mActiveSoundType != 0) {
            this.stopSound();
        }
        if (event.equals("error") || event.equals("deviceUnavailable")) {
            this.stopSound();
        }
        if (StateCommonData.bTapiActive) {
            this.stopSound();
        }
    }
}

