/*
 * Decompiled with CFR 0.152.
 */
package Project;

import Project.JDisplay;
import StateManager.StateCommonData;

public class JTimer {
    private int iInterval;
    private int iFrames;
    private long iStartTicks;
    private long iPrevTicks;
    private int iTicksPerSecond = 1000;
    private int dT;
    private int dTSec;
    private int fps;
    private long iRemainingTime;
    public boolean bIsTimerExceeded;
    public byte minutes;
    public byte seconds;

    public JTimer() {
        this.setInterval(1);
        this.reset();
    }

    public void reset() {
        this.iFrames = 0;
        this.iStartTicks = this.iPrevTicks = System.currentTimeMillis();
        this.bIsTimerExceeded = false;
        this.iRemainingTime = 0L;
    }

    public void setInterval(int aInterval) {
        this.iInterval = this.iTicksPerSecond * aInterval;
    }

    public long getInterval() {
        return this.iInterval / this.iTicksPerSecond;
    }

    public int getFPS() {
        return this.fps;
    }

    public int getDtSeconds() {
        return this.dTSec;
    }

    public int getDtMSeconds() {
        return this.dT;
    }

    public long getTimerCountValue() {
        long cticks = System.currentTimeMillis();
        return (cticks - this.iStartTicks) / (long)this.iTicksPerSecond;
    }

    public long adjustStartTimerOnPause() {
        long cticks = System.currentTimeMillis();
        return cticks - this.iRemainingTime;
    }

    public void setStartTimerValue(long aTime) {
        this.iStartTicks = aTime;
    }

    public void update() {
        long cticks = System.currentTimeMillis();
        ++this.iFrames;
        this.iRemainingTime = cticks - this.iStartTicks;
        if (this.iRemainingTime > (long)this.iInterval) {
            long diff = cticks - this.iStartTicks;
            if (diff > 0L) {
                this.fps = (int)((long)(this.iFrames * this.iTicksPerSecond) / diff);
            }
            this.iFrames = 0;
            this.iStartTicks = cticks;
            this.bIsTimerExceeded = true;
        }
        this.dTSec = this.dT = (int)(cticks - this.iPrevTicks);
        this.iPrevTicks = cticks;
    }

    public void drawFps(JDisplay graphics, StateCommonData pCommonData) {
        graphics.drawRect(10, 25, 50, 15, -16777216, true);
        pCommonData.mTextComponent.DrawString("fps " + this.getFPS(), 10, 27, 0, 1, pCommonData.mTextComponent.Defaultvalue, graphics, (byte)0);
    }

    public void getTimer() {
        this.minutes = (byte)((this.getInterval() - this.getTimerCountValue()) / 60L);
        this.seconds = (byte)((this.getInterval() - this.getTimerCountValue()) % 60L);
    }
}

