/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.BenGame;
import Game.JavaReader;
import Game.MapInterface;
import Game.Rectangle;
import Project.JDisplay;
import Project.JImage;
import StateManager.StateCommonData;
import java.io.DataInputStream;
import java.io.InputStream;

public class Map
implements MapInterface {
    int NofColumns;
    int NofRows;
    int NofLayers;
    public static MapInterface.struct_cmapstruct MapData;
    private JavaReader jr;
    private byte mIndexToScript;
    static short MAP_WID;
    static short MAP_HIG;
    short X_Tiles;
    short Y_Tiles;
    Rectangle Tile_X_Cordinate;
    Rectangle Tile_Y_Cordinate;
    Rectangle Tile_Scipt_Rect;
    short[] pathTest;
    short[][] pathXY;
    JImage map;
    BenGame mCanvas;
    int noOfbytes;

    public Map(BenGame aCanvas) {
        this.mCanvas = aCanvas;
        this.jr = new JavaReader();
        this.Tile_X_Cordinate = new Rectangle(0, 0, 0, 0);
        this.Tile_Y_Cordinate = new Rectangle(0, 0, 0, 0);
        this.Tile_Scipt_Rect = new Rectangle(0, 0, 0, 0);
        MapData = new MapInterface.struct_cmapstruct(this.mCanvas);
        this.X_Tiles = (short)(StateCommonData.screen_Width / 12 + 1);
        this.Y_Tiles = (short)(StateCommonData.screen_Height / 12 + 1);
    }

    public byte getScriptIndex() {
        return this.mIndexToScript;
    }

    public void realeaseMapResource() {
        if (this.Tile_X_Cordinate != null) {
            this.Tile_X_Cordinate = null;
        }
        if (this.Tile_Y_Cordinate != null) {
            this.Tile_Y_Cordinate = null;
        }
        if (this.Tile_Scipt_Rect != null) {
            this.Tile_Scipt_Rect = null;
        }
        if (this.jr != null) {
            this.jr = null;
        }
        if (Map.MapData.MapArray != null) {
            Map.MapData.MapArray = null;
        }
        if (Map.MapData.MapBoundArray != null) {
            Map.MapData.MapBoundArray = null;
        }
        if (MapData != null) {
            MapData = null;
        }
    }

    public void realeaseLevelMapData() {
        if (Map.MapData.MapArray != null) {
            Map.MapData.MapArray = null;
        }
        if (Map.MapData.MapBoundArray != null) {
            Map.MapData.MapBoundArray = null;
        }
    }

    public void ReadMap(String fileName) {
        try {
            int i;
            InputStream in = this.getClass().getResourceAsStream(fileName);
            DataInputStream dis = new DataInputStream(in);
            this.NofColumns = this.jr.readShort(dis);
            this.NofRows = this.jr.readShort(dis);
            this.NofLayers = this.jr.readInt(dis);
            Map.MapData.Width = this.NofColumns;
            Map.MapData.Height = this.NofRows;
            MAP_WID = (short)(Map.MapData.Width * 12);
            MAP_HIG = (short)(Map.MapData.Height * 12);
            Map.MapData.MapArray = new short[this.NofRows][this.NofColumns];
            Map.MapData.MapBoundArray = new short[this.NofRows][this.NofColumns];
            short Max_id = 0;
            int length = this.NofRows * this.NofColumns;
            int row = 0;
            int column = 0;
            int spl = 0;
            for (i = 0; i < length; ++i) {
                Map.MapData.MapArray[row][column] = this.jr.readShort(dis);
                if (Map.MapData.MapArray[row][column] > Max_id) {
                    Max_id = Map.MapData.MapArray[row][column];
                }
                if (++column < this.NofColumns) continue;
                ++row;
                column = 0;
            }
            spl = 0;
            column = 0;
            row = 0;
            for (i = 0; i < length; ++i) {
                Map.MapData.MapBoundArray[row][column] = this.jr.readShort(dis);
                if (++column < this.NofColumns) continue;
                ++row;
                column = 0;
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println("PROBLEM IN READING..." + e);
        }
    }

    public void DrawMap(JDisplay g) {
        boolean line = false;
        int rowStart = 0;
        int colStart = 0;
        int endTileY = 0;
        int endTileX = 0;
        int XDir = 0;
        int YDir = 0;
        int Tile = 0;
        int xScreen = 0;
        int yScreen = 0;
        int xOffset = 0;
        int yOffset = 0;
        int xtile = 0;
        int ytile = 0;
        int tileRange = 0;
        int nX = BenGame.mMap_X_off;
        int nY = BenGame.mMap_Y_off;
        if (nX > tileRange) {
            xOffset = tileRange;
            nX = 0;
        } else {
            xOffset = nX;
        }
        if (nY > tileRange) {
            yOffset = tileRange;
            nY = 0;
        } else {
            yOffset = nY;
        }
        colStart = Math.abs(nX) / 12 - 1;
        rowStart = Math.abs(nY) / 12 - 1;
        endTileX = (Math.abs(nX) + StateCommonData.screen_Width) / 12 + 1;
        endTileY = (Math.abs(nY) + StateCommonData.screen_Height) / 12 + 1;
        if (colStart < 0) {
            colStart = 0;
        }
        if (rowStart < 0) {
            rowStart = 0;
        }
        int aNOFColumns = BenGame.sTileImage.getWidth() / 12;
        for (XDir = colStart; XDir <= endTileX && XDir < Map.MapData.Width; ++XDir) {
            for (YDir = rowStart; YDir <= endTileY && YDir < Map.MapData.Height; ++YDir) {
                Tile = Map.MapData.MapArray[YDir][XDir] - 1;
                xtile = Tile % aNOFColumns * 12;
                ytile = Tile / aNOFColumns * 12;
                xScreen = XDir * 12 + xOffset;
                yScreen = YDir * 12 + yOffset;
                if (BenGame.mCurrentLevel != 5 && BenGame.mCurrentLevel != 6 && BenGame.mCurrentLevel != 7) {
                    g.drawImage(BenGame.sTileImage, xScreen, yScreen, xtile, ytile, 12, 12, 0, 1);
                    continue;
                }
                g.drawImage(BenGame.sTileImage, xScreen, yScreen, xtile, ytile, 12, 12, 0, 0);
            }
        }
    }

    public Rectangle GetTileXYFromTileIndex(int vTileIndex) {
        int vColumnID = vTileIndex % Map.MapData.Width;
        int vRowID = vTileIndex / Map.MapData.Width;
        Rectangle vCurrentTileXY = new Rectangle();
        vCurrentTileXY.x = vColumnID * 12;
        vCurrentTileXY.y = vRowID * 12;
        return vCurrentTileXY;
    }

    public void drawBoundRect(JDisplay g, Rectangle aTileXY, int aBoundValue) {
        if ((aBoundValue & 4) == 4) {
            aTileXY.y = aTileXY.y + aTileXY.dy - 12;
            aTileXY.dy = 12;
        }
        if ((aBoundValue & 1) == 1) {
            aTileXY.dy = 12;
        }
        if ((aBoundValue & 2) == 2) {
            aTileXY.dx = 12;
        }
        if ((aBoundValue & 8) == 8) {
            aTileXY.x = aTileXY.x + aTileXY.dx - 12;
            aTileXY.dx = 12;
        }
        if (aBoundValue > 0) {
            g.drawRect(aTileXY.x, aTileXY.y, aTileXY.dx, aTileXY.dy, 0xFFFFFF, false);
        }
    }

    public byte CheckCollision(Rectangle ObjRect, Rectangle NextFrame, boolean aIsFlipped, byte mCharacterType) {
        int ObjY;
        boolean mIsScriptCaught;
        boolean mIsCollided;
        byte scriptIndex;
        byte CollisionType = 0;
        byte bounds = 0;
        short i = 0;
        short j = 0;
        short BoundData = 0;
        short col = 0;
        short row = 0;
        short YDisp = 0;
        short XDisp = 0;
        XDisp = !aIsFlipped ? (short)(Math.abs(NextFrame.x) + NextFrame.dx) : (short)(Math.abs(NextFrame.x) + ObjRect.dx);
        if (ObjRect.y + NextFrame.y + NextFrame.dy - (ObjRect.y + ObjRect.dy) > 0) {
            YDisp = (short)(ObjRect.y + NextFrame.y + NextFrame.dy - (ObjRect.y + ObjRect.dy));
        } else if (ObjRect.y + NextFrame.y + NextFrame.dy - (ObjRect.y + ObjRect.dy) <= 0) {
            YDisp = ObjRect.y + NextFrame.y + NextFrame.dy < ObjRect.y ? (short)NextFrame.y : (short)NextFrame.dy;
        }
        short XTiles = (short)Math.abs(XDisp / 12);
        byte YTiles = (byte)Math.abs(YDisp / 12);
        short CharHeight = (short)(NextFrame.dy / 12);
        short CharWidth = (short)(NextFrame.dx / 12);
        int vCount = 0;
        this.mIndexToScript = 0;
        XTiles = (byte)(XTiles + (Math.abs(XDisp % 12) > 0 ? (byte)1 : 0));
        YTiles = (byte)(YTiles + (Math.abs(YDisp % 12) > 0 ? (byte)1 : 0));
        CharHeight = (short)(CharHeight + (NextFrame.dy % 12 != 0 ? (short)1 : 0));
        CharWidth = (short)(CharWidth + (NextFrame.dx % 12 != 0 ? (short)1 : 0));
        boolean mIsCollided2 = false;
        boolean mIsScriptCaught2 = false;
        if (aIsFlipped) {
            int ObjX = ObjRect.x + ObjRect.dx;
            i = 1;
            block0: for (i = 1; i <= XTiles; i = (short)(i + 1)) {
                col = (short)((ObjX - i * 12) / 12);
                for (j = 0; j < CharHeight; j = (short)(j + 1)) {
                    row = (short)((ObjRect.y + NextFrame.y + NextFrame.dy - 12 - j * 12) / 12);
                    if (col < Map.MapData.Width && row < Map.MapData.Height && col >= 0 && row >= 0) {
                        BoundData = Map.MapData.MapBoundArray[row][col];
                    }
                    if ((bounds = Map.getSecondByte(BoundData)) < 15 && !mIsCollided2 && (bounds & 8) == 8) {
                        CollisionType = (byte)(CollisionType | 8);
                        this.Tile_X_Cordinate.x = col * 12 + 12;
                        this.Tile_X_Cordinate.y = row * 12;
                        mIsCollided2 = true;
                    }
                    if (!mIsScriptCaught2 && this.mIndexToScript == 0 && Map.getFirstByte(BoundData) > 0) {
                        scriptIndex = Map.getFirstByte(BoundData);
                        if (mCharacterType == 0 && scriptIndex != 7 && scriptIndex != 2 && scriptIndex <= 11 || mCharacterType == 1) {
                            this.mIndexToScript = scriptIndex;
                        }
                        if (this.mIndexToScript > 0) {
                            this.Tile_Scipt_Rect.x = col * 12;
                            this.Tile_Scipt_Rect.y = row * 12;
                            this.Tile_Scipt_Rect.dx = 12;
                            this.Tile_Scipt_Rect.dy = 12;
                            mIsScriptCaught2 = true;
                        }
                    }
                    ++vCount;
                    if (mIsCollided2 && mIsScriptCaught2) break block0;
                }
            }
        }
        if (!aIsFlipped) {
            int ObjX = ObjRect.x;
            mIsCollided = false;
            mIsScriptCaught = false;
            i = 1;
            block2: for (i = 1; i <= XTiles; i = (short)(i + 1)) {
                col = (short)((ObjX + i * 12) / 12);
                for (j = 0; j < CharHeight; j = (short)(j + 1)) {
                    row = (short)((ObjRect.y + NextFrame.y + NextFrame.dy - 12 - j * 12) / 12);
                    if (col < Map.MapData.Width && row < Map.MapData.Height && col >= 0 && row >= 0) {
                        BoundData = Map.MapData.MapBoundArray[row][col];
                    }
                    if ((bounds = Map.getSecondByte(BoundData)) < 15 && !mIsCollided && (bounds & 2) == 2) {
                        CollisionType = (byte)(CollisionType | 2);
                        this.Tile_X_Cordinate.x = col * 12;
                        this.Tile_X_Cordinate.y = row * 12;
                        mIsCollided = true;
                    }
                    if (!mIsScriptCaught && this.mIndexToScript == 0 && Map.getFirstByte(BoundData) > 0) {
                        scriptIndex = Map.getFirstByte(BoundData);
                        if (mCharacterType == 0 && scriptIndex != 7 && scriptIndex != 2 && scriptIndex <= 11 || mCharacterType == 1) {
                            this.mIndexToScript = scriptIndex;
                        }
                        if (this.mIndexToScript > 0) {
                            this.Tile_Scipt_Rect.x = col * 12;
                            this.Tile_Scipt_Rect.y = row * 12;
                            this.Tile_Scipt_Rect.dx = 12;
                            this.Tile_Scipt_Rect.dy = 12;
                            mIsScriptCaught = true;
                        }
                    }
                    ++vCount;
                    if (mIsCollided && mIsScriptCaught) break block2;
                }
            }
        }
        if (ObjRect.y + NextFrame.y + NextFrame.dy - (ObjRect.y + ObjRect.dy) < 0) {
            ObjY = ObjRect.y;
            i = 0;
            mIsCollided = false;
            mIsScriptCaught = false;
            block4: for (i = 0; i <= YTiles; i = (short)(i + 1)) {
                row = (short)((ObjY - i * 12) / 12);
                for (j = 0; j < CharWidth; j = (short)(j + 1)) {
                    col = (short)((ObjRect.x + j * 12) / 12);
                    if (col < Map.MapData.Width && row < Map.MapData.Height && col >= 0 && row >= 0) {
                        BoundData = Map.MapData.MapBoundArray[row][col];
                    }
                    if ((bounds = Map.getSecondByte(BoundData)) < 15 && !mIsCollided && (bounds & 4) == 4) {
                        CollisionType = (byte)(CollisionType | 4);
                        this.Tile_Y_Cordinate.x = col * 12;
                        this.Tile_Y_Cordinate.y = row * 12 + 12;
                        mIsCollided = true;
                    }
                    if (!mIsScriptCaught && this.mIndexToScript == 0 && Map.getFirstByte(BoundData) > 0) {
                        scriptIndex = Map.getFirstByte(BoundData);
                        if (mCharacterType == 0 && scriptIndex != 7 && scriptIndex != 2 && scriptIndex <= 11 || mCharacterType == 1) {
                            this.mIndexToScript = scriptIndex;
                        }
                        if (this.mIndexToScript > 0) {
                            this.Tile_Scipt_Rect.x = col * 12;
                            this.Tile_Scipt_Rect.y = row * 12;
                            this.Tile_Scipt_Rect.dx = 12;
                            this.Tile_Scipt_Rect.dy = 12;
                            mIsScriptCaught = true;
                        }
                    }
                    ++vCount;
                    if (mIsCollided && mIsScriptCaught) break block4;
                }
            }
        }
        if (ObjRect.y + NextFrame.y + NextFrame.dy - (ObjRect.y + ObjRect.dy) >= 0) {
            ObjY = ObjRect.y + NextFrame.y + NextFrame.dy;
            mIsCollided = false;
            mIsScriptCaught = false;
            block6: for (i = 0; i <= YTiles; i = (short)(i + 1)) {
                row = (short)((ObjY - i * 12) / 12);
                for (j = 0; j < CharWidth; j = (short)(j + 1)) {
                    col = (short)((ObjRect.x + j * 12) / 12);
                    if (col < Map.MapData.Width && row < Map.MapData.Height && col >= 0 && row >= 0) {
                        BoundData = Map.MapData.MapBoundArray[row][col];
                    }
                    if ((bounds = Map.getSecondByte(BoundData)) < 15 && !mIsCollided && (bounds & 1) == 1) {
                        CollisionType = (byte)(CollisionType | 1);
                        this.Tile_Y_Cordinate.x = col * 12;
                        this.Tile_Y_Cordinate.y = row * 12;
                        mIsCollided = true;
                    }
                    if (!mIsScriptCaught && this.mIndexToScript == 0 && Map.getFirstByte(BoundData) > 0) {
                        scriptIndex = Map.getFirstByte(BoundData);
                        if (mCharacterType == 0 && scriptIndex != 7 && scriptIndex != 2 && scriptIndex <= 11 || mCharacterType == 1) {
                            this.mIndexToScript = scriptIndex;
                        }
                        if (this.mIndexToScript > 0) {
                            this.Tile_Scipt_Rect.x = col * 12;
                            this.Tile_Scipt_Rect.y = row * 12;
                            this.Tile_Scipt_Rect.dx = 12;
                            this.Tile_Scipt_Rect.dy = 12;
                            mIsScriptCaught = true;
                        }
                    }
                    ++vCount;
                    if (mIsCollided && mIsScriptCaught) break block6;
                }
            }
        }
        return CollisionType;
    }

    public static byte getFirstByte(short value) {
        value = (short)(value >> 8);
        return (byte)value;
    }

    public static byte getSecondByte(short value) {
        value = (short)(value << 8);
        value = (short)(value >> 8);
        return (byte)value;
    }
}

