/*
 * Decompiled with CFR 0.152.
 */
package StateManager;

import Game.DeviceConstants;
import Game.JavaReader;
import Game.SoundPlayer;
import Localisation.DrawGText;
import Localisation.TextComponent;
import Menu.CLanguageSelection;
import Menu.CMenu;
import Project.BenMIDlet;
import Project.JDisplay;
import Project.JImage;
import Project.JTimer;
import Project.Prefs;
import java.util.Random;

public class StateCommonData
extends JTimer
implements DeviceConstants {
    public boolean playsoundFirstTime = true;
    public long TimeDuration = 0L;
    public long TimeDuration1 = 0L;
    public long TimeElapsed = 0L;
    public static boolean mPaintLoadingScreen;
    public int mloadingCounter = 0;
    public byte mStateCounter = 0;
    public boolean mSaveSoundState;
    public JavaReader jr;
    public JDisplay mJDisplay;
    public TextComponent mTextComponent;
    public int mNoOfLines;
    public static String[] mHintText;
    public SoundPlayer mSoundPlayer;
    public static Random mRand;
    public static final byte X = 0;
    public static final byte Y = 1;
    public static final byte W = 2;
    public static final byte H = 3;
    public JTimer mTimer;
    public Prefs mPrefs;
    public byte mMenuState;
    public byte mPreviousMenuState;
    public byte mSelectedMeuIndex;
    public byte[] mPreviousMenuIndex;
    public static byte mTextIndex;
    public static byte mPreviousTextIndex;
    public static byte mPreviousLeftSoftkey;
    public static byte mPreviousRightSoftkey;
    public static byte mLeftSoftKey;
    public static byte mRightSoftKey;
    public static byte mTitleIndex;
    public static byte mStartMenuIndex;
    public static byte mEndMenuIndex;
    public static boolean mIsMenuScrollable;
    public static boolean mIsMenuScrollUp;
    public static byte mNoOfOnScreenMenuOptions;
    public static byte mGameMode;
    public static boolean bTapiActive;
    public static final String APPLICATION_DESCRIPTOR_LANGUAGE_NAME = "Language";
    public static final byte MAX_NO_OF_LEVELS = 7;
    public static final int NARATOR_HEIGHT = 44;
    public static final byte MENU_INDEX = 0;
    public static final byte SUB_MENU_INDEX = 1;
    public byte mMenuType;
    byte mLoadCounter;
    byte mDelayFactor;
    StringBuffer mLoadingTextString = new StringBuffer();
    public static final byte LaodingDelayIndex = 3;
    public static int mYpos;
    public static final byte mMenuSelectionYOffset = 3;
    public DrawGText mMenuTextDisplayRect;
    public String midletName;
    public String midletVersion;
    public String midletVender;
    public static int screen_Width;
    public static int screen_Height;
    public boolean mIsLoadingOn;
    public static boolean mIsMenuSoundStartForcefully;
    public DrawGText mAleDrawGText;

    public StateCommonData() {
        this.mTextComponent = new TextComponent();
        this.jr = new JavaReader();
        this.mTimer = new JTimer();
    }

    public void initStateCommonData() {
        this.mSoundPlayer = new SoundPlayer();
        this.mTextComponent.loadFontImages();
        this.mJDisplay = new JDisplay(screen_Width, screen_Height);
        this.mMenuTextDisplayRect = new DrawGText();
        this.loaddata();
    }

    public void loaddata() {
        String vSelectedLanguage = "en";
        if (BenMIDlet.get_myMidlet().getAppProperty(APPLICATION_DESCRIPTOR_LANGUAGE_NAME) != null) {
            vSelectedLanguage = BenMIDlet.get_myMidlet().getAppProperty(APPLICATION_DESCRIPTOR_LANGUAGE_NAME);
        }
        if (vSelectedLanguage.equals("en")) {
            CLanguageSelection.mIndexLanguage = 0;
        } else if (vSelectedLanguage.equals("ita")) {
            CLanguageSelection.mIndexLanguage = 1;
        } else if (vSelectedLanguage.equals("esp")) {
            CLanguageSelection.mIndexLanguage = (byte)2;
        } else if (vSelectedLanguage.equals("dut")) {
            CLanguageSelection.mIndexLanguage = (byte)3;
        } else if (vSelectedLanguage.equals("fra")) {
            CLanguageSelection.mIndexLanguage = (byte)4;
        }
        this.selectLanguage(CLanguageSelection.mIndexLanguage);
    }

    public void storePreviousMenuIndex() {
        for (int i = 0; i < this.mPreviousMenuIndex.length; ++i) {
            if (this.mPreviousMenuIndex[i] != -1) continue;
            this.mPreviousMenuIndex[i] = this.mSelectedMeuIndex;
            break;
        }
    }

    public void paintLoadingScreen(JDisplay aGraphics) {
        this.mIsLoadingOn = true;
        if (SoundPlayer.mIsSoundActive) {
            this.mSoundPlayer.stopSound();
        }
        aGraphics.drawRect(0, 0, screen_Width, screen_Height, 0, true);
        this.mTextComponent.DrawString(mHintText[27], 0, (screen_Height >> 1) - this.mTextComponent.GetHeightOffset(), 1, 4, this.mTextComponent.Defaultvalue, aGraphics, (byte)0);
    }

    public void paintLevelSelectionScreen(JDisplay aGraphics, byte aState) {
        int yDisp = 0;
        byte MAX_UNLOCKED = this.mPrefs.Max_LevelUnLocked;
        if (mGameMode == 0) {
            MAX_UNLOCKED = this.mPrefs.Max_AttackLevelUnLocked;
        }
        aGraphics.drawRect(0, 0, screen_Width, screen_Height, 0, true);
        if (CMenu.menuBG == null) {
            CMenu.menuBG = new JImage();
            CMenu.menuBG.load("/menu_effects.png", null);
        }
        yDisp = CMenu.menuBG.getHeight();
        aGraphics.drawImage(CMenu.menuBG, 0, 0, 0, 0, CMenu.menuBG.getWidth(), yDisp, 0, 1);
        this.mTextComponent.DrawString(mHintText[54], screen_Width - this.mTextComponent.GetTextWidth(mHintText[54].toCharArray(), 1) >> 1, (this.mTextComponent.GetNormalFontHeight(1) >> 1) + yDisp, 1, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        aGraphics.drawRect(0, (this.mTextComponent.GetNormalFontHeight(1) << 1) + yDisp, screen_Width, this.mTextComponent.GetNormalFontHeight(1) >> 3, 65280, true);
        aGraphics.drawRect(0, screen_Height - (this.mTextComponent.GetNormalFontHeight(1) << 1), screen_Width, this.mTextComponent.GetNormalFontHeight(1) >> 3, 65280, true);
        int vMaxWidth = this.mTextComponent.GetTextWidth((mHintText[37] + " " + 10).toCharArray(), 1);
        String vLevelSelectionText = mHintText[37] + " " + (this.mSelectedMeuIndex + 1);
        this.mTextComponent.DrawString(vLevelSelectionText, (screen_Width - vMaxWidth >> 1) + (this.mTextComponent.GetTextWidth("W".toCharArray(), 1) >> 1), (screen_Height >> 1) - (this.mTextComponent.GetNormalFontHeight(1) >> 1) + yDisp / 2, 1, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)1);
        aGraphics.drawRect((screen_Width - vMaxWidth >> 1) - 4, (screen_Height >> 1) - (this.mTextComponent.GetNormalFontHeight(1) >> 1) - 2 + yDisp / 2, vMaxWidth + 8, this.mTextComponent.GetNormalFontHeight(1) + 4, 65280, false);
        if (this.mSelectedMeuIndex > 0) {
            this.mTextComponent.DrawString("<", (screen_Width - vMaxWidth >> 1) - 4 - 2 - this.mTextComponent.GetTextWidth("W".toCharArray(), 1), (screen_Height >> 1) - (this.mTextComponent.GetNormalFontHeight(1) >> 1) + yDisp / 2, 1, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)1);
        }
        if (this.mSelectedMeuIndex < MAX_UNLOCKED - 1) {
            this.mTextComponent.DrawString(">", (screen_Width - vMaxWidth >> 1) - 4 + vMaxWidth + 8 + 2 + this.mTextComponent.GetTextWidth("W".toCharArray(), 1), (screen_Height >> 1) - (this.mTextComponent.GetNormalFontHeight(1) >> 1) + yDisp / 2, 1, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)1);
        }
        this.setSoftKeys(aGraphics, mLeftSoftKey, mRightSoftKey);
    }

    public void paintMenuScreens(JDisplay aGraphics, byte aStartMenuIndex, byte aEndMenuIndex, byte aSoftKey1, byte aSoftKey2, byte aMenuType) {
        byte vStartMenuIndex = aStartMenuIndex;
        byte vEndMenuIndex = 0;
        int vDistanceBetweenTwoMenuLables = TextComponent.FontNormalArray_HEIGHT[1] + (TextComponent.FontNormalArray_HEIGHT[1] >> 1);
        vStartMenuIndex = aStartMenuIndex;
        vEndMenuIndex = aEndMenuIndex;
        if (aMenuType == 0) {
            mYpos = this.mMenuTextDisplayRect.TextBox_Y + (this.mMenuTextDisplayRect.TextBox_H >> 1) - (vDistanceBetweenTwoMenuLables * (aEndMenuIndex - aStartMenuIndex + 1) >> 1);
            if (CMenu.menuBG == null) {
                CMenu.menuBG = new JImage();
                CMenu.menuBG.load("/menu_effects.png", null);
            }
            mYpos += CMenu.menuBG.getHeight() / 2;
        } else if (aMenuType == 1) {
            mYpos = (screen_Height >> 1) - (vDistanceBetweenTwoMenuLables * (aEndMenuIndex - aStartMenuIndex + 1) >> 1) + vDistanceBetweenTwoMenuLables;
        }
        for (byte i = vStartMenuIndex; i <= vEndMenuIndex; i = (byte)(i + 1)) {
            int vStringWidth;
            byte menuIndex = (byte)(i - vStartMenuIndex);
            String vMenuText = mHintText[i];
            if (i == 24 || i == 34) {
                vMenuText = SoundPlayer.mIsSoundActive ? vMenuText.concat(" " + mHintText[42]) : vMenuText.concat(" " + mHintText[43]);
            }
            if (i - aStartMenuIndex == this.mSelectedMeuIndex) {
                if (aMenuType == 1) {
                    int vRectWidth = screen_Width - 30 - 4;
                    aGraphics.drawRect((screen_Width >> 1) - (vRectWidth >> 1), mYpos + menuIndex * vDistanceBetweenTwoMenuLables, vRectWidth, TextComponent.FontNormalArray_HEIGHT[1], 0x212202, true);
                } else {
                    aGraphics.drawRect(0, mYpos + menuIndex * vDistanceBetweenTwoMenuLables, screen_Width, TextComponent.FontNormalArray_HEIGHT[1], 0x212202, true);
                }
                vStringWidth = this.mTextComponent.GetTextWidth(vMenuText.toCharArray(), 1);
                int xpos = screen_Width - vStringWidth >> 1;
                this.mTextComponent.DrawString("" + vMenuText, xpos, mYpos + menuIndex * vDistanceBetweenTwoMenuLables, 1, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)0);
                continue;
            }
            vStringWidth = this.mTextComponent.GetTextWidth(vMenuText.toCharArray(), 1);
            int vXpos = screen_Width - vStringWidth >> 1;
            if (this.mMenuState == 7 && !this.mPrefs.AttackmodeUnLocked && this.mSelectedMeuIndex == 0 || this.mMenuState == 6 && this.mPrefs.Max_LevelUnLocked == 1 && this.mSelectedMeuIndex == 0) {
                this.mTextComponent.DrawString("" + vMenuText, vXpos, mYpos + menuIndex * vDistanceBetweenTwoMenuLables, 1, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)2);
                continue;
            }
            this.mTextComponent.DrawString("" + vMenuText, vXpos, mYpos + menuIndex * vDistanceBetweenTwoMenuLables, 1, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)1);
        }
        this.setSoftKeys(aGraphics, aSoftKey1, aSoftKey2);
    }

    public void drawMenuArrows(JDisplay aGraphics, byte aFontType, byte aStartIndex) {
        int vArrowPosY = mYpos + this.mSelectedMeuIndex * (TextComponent.FontNormalArray_HEIGHT[aFontType] + this.mTextComponent.SpaceBetweenMenuOptions());
        int vArrowPosX = 0;
        vArrowPosX = ((screen_Width >> 1) - this.mTextComponent.GetTextWidth(mHintText[this.mSelectedMeuIndex + aStartIndex].toCharArray(), aFontType) >> 1) - this.mTextComponent.GetFontWidth(aFontType);
        this.mTextComponent.DrawString("<", vArrowPosX, vArrowPosY, aFontType, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)1);
        vArrowPosX = ((screen_Width >> 1) + this.mTextComponent.GetTextWidth(mHintText[this.mSelectedMeuIndex + aStartIndex].toCharArray(), aFontType) >> 1) + this.mTextComponent.GetFontWidth(aFontType);
        this.mTextComponent.DrawString(">", vArrowPosX, vArrowPosY, aFontType, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)1);
    }

    public void paintAlertMessageScreen(JDisplay aGraphics, byte aTextIndex, byte aSoftkey1, byte aSoftkey2, byte aMenuType) {
        int vAlertTextY = 0;
        if (aMenuType == 1) {
            vAlertTextY = screen_Height - this.mTextComponent.GetNormalFontHeight(1) >> 1;
        } else if (aMenuType == 0) {
            vAlertTextY = (screen_Height >> 1) + (screen_Height >> 2) - TextComponent.FontNormalArray_HEIGHT[0];
        }
        this.mTextComponent.DrawString("" + mHintText[aTextIndex], 0, vAlertTextY, 1, 4, this.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        this.setSoftKeys(aGraphics, aSoftkey1, aSoftkey2);
    }

    public void paintTextOnScreen(JDisplay aGraphics, byte aTextTitle, String aText, DrawGText aTextRect, byte aSoftkey1, byte aSoftkey2, int aAlignment) {
        int y_disp = 0;
        this.mTextComponent.DrawString(aText, 0, 0, 0, aAlignment, aTextRect, aGraphics, (byte)0);
        this.mTextComponent.DrawString("" + mHintText[aTextTitle], 0, aTextRect.TextBox_Y - this.mTextComponent.GetNormalFontHeight(1) - (this.mTextComponent.GetNormalFontHeight(1) >> 1) + y_disp, 1, aAlignment, this.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        this.setSoftKeys(aGraphics, aSoftkey1, aSoftkey2);
    }

    public void paintTextScreen(JDisplay aGraphics, byte aTextTitle, byte aTextIndex, DrawGText aTextRect, byte aSoftkey1, byte aSoftkey2, int aAlignment) {
        this.mTextComponent.DrawString("" + mHintText[aTextIndex], 0, 0, 0, aAlignment, aTextRect, aGraphics, (byte)0);
        this.mTextComponent.DrawString("" + mHintText[aTextTitle], 0, aTextRect.TextBox_Y - this.mTextComponent.GetNormalFontHeight(1) - (this.mTextComponent.GetNormalFontHeight(1) >> 1), 1, 4, this.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        this.setSoftKeys(aGraphics, aSoftkey1, aSoftkey2);
    }

    public void setSoftKeys(JDisplay aGraphics, int aLeftSoftKey, int aRightSoftkey) {
        if (aLeftSoftKey != 10) {
            aGraphics.drawRect(0, screen_Height - TextComponent.FontNormalArray_HEIGHT[0], this.mTextComponent.GetTextWidth(mHintText[aLeftSoftKey].toCharArray(), 0) + 4, TextComponent.FontNormalArray_HEIGHT[0] - 0, 0, true);
        }
        if (aRightSoftkey != 10) {
            aGraphics.drawRect(screen_Width - this.mTextComponent.GetTextWidth(mHintText[aRightSoftkey].toCharArray(), 0) - 4, screen_Height - TextComponent.FontNormalArray_HEIGHT[0], this.mTextComponent.GetTextWidth(mHintText[aRightSoftkey].toCharArray(), 0) + 4, TextComponent.FontNormalArray_HEIGHT[0] - 0, 0, true);
        }
        this.mTextComponent.DrawString("" + mHintText[aLeftSoftKey], 2, screen_Height - TextComponent.FontNormalArray_HEIGHT[0] - 0, 0, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)0);
        this.mTextComponent.DrawString("" + mHintText[aRightSoftkey], screen_Width - this.mTextComponent.GetTextWidth(mHintText[aRightSoftkey].toCharArray(), 0) - 2, screen_Height - TextComponent.FontNormalArray_HEIGHT[0] - 0, 0, 1, this.mTextComponent.Defaultvalue, aGraphics, (byte)0);
    }

    public void selectLanguage(byte mIndexLanguage) {
        mHintText = null;
        switch (mIndexLanguage) {
            case 0: {
                this.mNoOfLines = this.mTextComponent.GetNoOfLines("/text_english.txt");
                mHintText = new String[this.mNoOfLines];
                this.mTextComponent.ReadStringArray("/text_english.txt", mHintText);
                break;
            }
            case 1: {
                this.mNoOfLines = this.mTextComponent.GetNoOfLines("/text_italian.txt");
                mHintText = new String[this.mNoOfLines];
                this.mTextComponent.ReadStringArray("/text_italian.txt", mHintText);
                break;
            }
            case 2: {
                this.mNoOfLines = this.mTextComponent.GetNoOfLines("/text_spanish.txt");
                mHintText = new String[this.mNoOfLines];
                this.mTextComponent.ReadStringArray("/text_spanish.txt", mHintText);
                break;
            }
            case 3: {
                this.mNoOfLines = this.mTextComponent.GetNoOfLines("/text_german.txt");
                mHintText = new String[this.mNoOfLines];
                this.mTextComponent.ReadStringArray("/text_german.txt", mHintText);
                break;
            }
            case 4: {
                this.mNoOfLines = this.mTextComponent.GetNoOfLines("/text_french.txt");
                mHintText = new String[this.mNoOfLines];
                this.mTextComponent.ReadStringArray("/text_french.txt", mHintText);
            }
        }
    }

    static {
        mRand = new Random();
        mIsMenuScrollable = false;
        mNoOfOnScreenMenuOptions = (byte)3;
    }

    public static interface CONSTANTS {
        public static final byte T_Select = 0;
        public static final byte T_Back = 1;
        public static final byte T_Yes = 2;
        public static final byte T_No = 3;
        public static final byte T_Submit = 4;
        public static final byte T_Clear = 5;
        public static final byte T_Skip = 6;
        public static final byte T_Cancel = 7;
        public static final byte T_Ok = 8;
        public static final byte T_Next = 9;
        public static final byte T_Blank = 10;
        public static final byte T_Activate_sound = 11;
        public static final byte T_Do_you_want_to_exit = 12;
        public static final byte T_Press_any_key_to_continue = 13;
        public static final byte T_Retry_Alert = 14;
        public static final byte T_Press_5 = 15;
        public static final byte T_Quit_Confirmation = 16;
        public static final byte T_Play = 17;
        public static final byte T_Options = 18;
        public static final byte T_High_Scores = 19;
        public static final byte T_Help = 20;
        public static final byte T_About = 21;
        public static final byte T_Exit = 22;
        public static final byte T_Instructions = 23;
        public static final byte T_Sound = 24;
        public static final byte T_Erase_Save_Data = 25;
        public static final byte T_Select_Volume_Level_Upper = 26;
        public static final byte T_Loading = 27;
        public static final byte T_Final_Scores = 28;
        public static final byte T_Earase_Confirm = 29;
        public static final byte T_Instructions_Text = 30;
        public static final byte T_Game_Over_Text = 31;
        public static final byte T_Sub_Menu_Resume = 32;
        public static final byte T_Sub_Menu_Restart = 33;
        public static final byte T_Sub_Menu_Sound = 34;
        public static final byte T_Sub_Menu_Instructions = 35;
        public static final byte T_Sub_Menu_Main_Menu = 36;
        public static final byte T_Level = 37;
        public static final byte T_Game_Over = 38;
        public static final byte T_Total = 39;
        public static final byte T_Point_Attack = 40;
        public static final byte T_Time_Attack = 41;
        public static final byte T_On = 42;
        public static final byte T_Off = 43;
        public static final byte T_Select_Volume_Level_Lower = 44;
        public static final byte T_Menu = 49;
        public static final byte T_You_Lose = 50;
        public static final byte T_You_Win = 51;
        public static final byte T_High_Score_Achieved_Alert = 52;
        public static final byte T_Warewolf_Stunned_Alert = 53;
        public static final byte T_Select_Level = 54;
        public static final byte T_ABOUT_BASE = 55;
        public static final byte T_ABOUT_TEXT_PART1 = 55;
        public static final byte T_ABOUT_TEXT_PART2 = 56;
        public static final byte T_ABOUT_TEXT_PART3 = 57;
        public static final byte T_ABOUT_TEXT_PART4 = 58;
        public static final byte T_Level_Complete = 59;
        public static final byte T_Health_Bonus = 60;
        public static final byte T_Coins_Bonus = 61;
        public static final byte T_Enemy_Bonus = 62;
        public static final byte T_Lifes_Remaining_Alert = 63;
        public static final byte T_Sure_Alert = 64;
        public static final byte T_Mission_Failed = 65;
        public static final byte T_TimeMode_Alerts = 66;
        public static final byte T_Portrait_Alert1 = 73;
        public static final byte T_Portrait_Alert2 = 74;
        public static final byte T_Time = 75;
        public static final byte T_Pause_Menu = 76;
        public static final byte T_Congratulation_After_Time_Mode = 77;
        public static final byte T_Attack_Modes_Title = 78;
        public static final byte T_Congratulation_After_Each_Level1 = 79;
        public static final byte T_Congratulation_After_Each_Level2 = 80;
        public static final byte T_Level_Labels = 81;
        public static final byte T_Time_Attack_Level_Unlock_Alert = 88;
        public static final byte T_Cutscene_Base = 89;
        public static final byte T_Narartor_Base = 94;
        public static final byte T_Narartor_Level1_Start_Text1 = 94;
        public static final byte T_Narartor_Level1_Start_Text2 = 95;
        public static final byte T_Narartor_Level2_Start_Text1 = 96;
        public static final byte T_Narartor_Level2_Start_Text2 = 97;
        public static final byte T_Narartor_Level2_Start_Text3 = 98;
        public static final byte T_Narartor_Level3_Start_Text1 = 99;
        public static final byte T_Narartor_Level4_Start_Text1 = 100;
        public static final byte T_Narartor_Level4_End_Text2 = 101;
        public static final byte T_Narartor_Level4_End_Text3 = 102;
        public static final byte T_Narartor_Level5_Start_Text1 = 103;
        public static final byte T_Narartor_Level5_Start_Text2 = 104;
        public static final byte T_Narartor_Level5_Start_Text3 = 105;
        public static final byte T_Narartor_Level5_Start_Text4 = 106;
        public static final byte T_Narartor_Level6_Start_Text1 = 107;
        public static final byte T_Narartor_Level7_Start_Text1 = 108;
        public static final byte T_Narartor_Level7_Start_Text2 = 109;
        public static final byte T_Narartor_Level7_Start_Text3 = 110;
        public static final byte T_Narartor_Level7_End_Text3 = 111;
        public static final byte T_Narartor_Level7_End_Text4 = 112;
        public static final byte T_Narartor_Level7_End_Text5 = 113;
        public static final byte T_Cutscene_Level1_Start_Text1 = 89;
        public static final byte T_Cutscene_Level3_End_Text1 = 90;
        public static final byte T_Cutscene_Level4_End_Text1 = 91;
        public static final byte T_Cutscene_Level6_End_Text1 = 92;
        public static final byte T_Cutscene_Level7_End_Text1 = 93;
        public static final byte LOAD_LEVEL_SELECTION_MENU = 100;
        public static final byte LOAD_LEVEL_SELECTION_GAME = 101;
        public static final byte LOAD_SUB_MENU_RESTART = 102;
        public static final byte LOAD_SUB_MENU_INGAME = 103;
        public static final byte LOAD_LEVEL_RETRY = 104;
    }

    public static interface LANGUAGESELECTION {
        public static final byte ENGLISH = 0;
        public static final byte ITALIAN = 1;
        public static final byte SPANISH = 2;
        public static final byte GERMAN = 3;
        public static final byte FRENCH = 4;
        public static final String ENGLISH_NOTATION = "en";
        public static final String ITALIAN_NOTATION = "ita";
        public static final String SPANISH_NOTATION = "esp";
        public static final String GERMAN_NOTATION = "dut";
        public static final String FRENCH_NOTATION = "fra";
        public static final String ALL_LANGUAGE_NOTATION = "all";
    }

    public static interface KEYCODES {
        public static final byte KEY_UP = -1;
        public static final byte KEY_DOWN = -2;
        public static final byte KEY_LEFT = -3;
        public static final byte KEY_RIGHT = -4;
        public static final byte KEY_SELECT = -5;
        public static final byte KEY_SOFTLEFT = -6;
        public static final byte KEY_SOFTRIGHT = -7;
        public static final byte KEY_END = -11;
        public static final byte KEY_CLEAR = -8;
        public static final byte KEY_CALL = -10;
        public static final byte KEY_STAR = 42;
        public static final byte KEY_HASH = 35;
        public static final byte KEY_0 = 48;
        public static final byte KEY_1 = 49;
        public static final byte KEY_2 = 50;
        public static final byte KEY_3 = 51;
        public static final byte KEY_4 = 52;
        public static final byte KEY_5 = 53;
        public static final byte KEY_6 = 54;
        public static final byte KEY_7 = 55;
        public static final byte KEY_8 = 56;
        public static final byte KEY_9 = 57;
        public static final byte MAX_KEYS = 21;
    }

    public static interface MENUS {
        public static final byte MAIN_MENU = 0;
        public static final byte HIGH_SCORE_MENU = 1;
        public static final byte SOUND_MENU = 2;
        public static final byte ABOUT_MENU = 3;
        public static final byte HELP_MENU = 4;
        public static final byte EXIT_MENU = 5;
        public static final byte OPTIONS_SUB_MENU = 6;
        public static final byte ATTACK_MODE_SUB_MENU = 7;
        public static final byte LEVEL_SELECTION_MENU = 8;
        public static final byte ERASE_CONFIRMATION_SCREEN = 9;
        public static final byte MAX_NO_OF_MENUS = 10;
    }

    public static interface MENU_STATES {
        public static final byte PLAY = 0;
        public static final byte OPTIONS = 1;
        public static final byte HIGH_SCORE = 2;
        public static final byte HELP = 3;
        public static final byte ABOUT = 4;
        public static final byte EXIT = 5;
        public static final byte SOUND = 0;
        public static final byte ERASE_SAVE_DATA = 1;
        public static final byte POINT_ATTACK = 0;
        public static final byte TIME_ATTACK = 1;
        public static final byte SUB_MENU_RESUME = 0;
        public static final byte SUB_MENU_RESTART = 1;
        public static final byte SUB_MENU_SOUND = 2;
        public static final byte SUB_MENU_INSTRUCTIONS = 3;
        public static final byte SUB_MENU_MAIN_MENU = 4;
    }

    public static interface GAME_MODES {
        public static final byte GAME_TIME_ATTACK = 0;
        public static final byte GAME_POINT_ATTACK = 1;
        public static final byte GAME_MODE_COUNT = 2;
    }

    public static interface SPECIAL_EFFECTS {
        public static final byte HEATBLAST_JUMP_EFFECT = 0;
        public static final byte MENU_EFFECT = 1;
        public static final byte CUTSCENE_EFFECT = 2;
        public static final byte NARATOR_EFFECT = 3;
    }

    public static interface STATES {
        public static final byte STATE_JUMP_LOGO = 0;
        public static final byte STATE_CN_LOGO = 1;
        public static final byte STATE_LANGUAGE_SELECTION = 2;
        public static final byte STATE_SOUND_ACTIVATE = 3;
        public static final byte STATE_SUBMENU = 4;
        public static final byte STATE_SPLASH = 5;
        public static final byte STATE_MENU = 6;
        public static final byte STATE_INGAME = 7;
        public static final byte STATE_PLAY = 8;
        public static final byte STATE_LEADER_BOARD = 9;
        public static final byte STATE_SIZE = 10;
    }
}

