/*
 * Decompiled with CFR 0.152.
 */
package StateManager;

import StateManager.CState;
import StateManager.StateConfig;

public class CStateManager {
    private CState[] pListStates = null;
    private int activeStateIndex = -1;
    private int pendingStateIndex = -1;
    private boolean bPendingStateTimer;
    private long timerVal;

    public void destroy() {
        if (this.pListStates != null) {
            for (int i = 0; i < this.pListStates.length; ++i) {
                this.pListStates[i].destroy();
                this.pListStates[i] = null;
            }
            this.pListStates = null;
        }
        this.activeStateIndex = -1;
        this.pendingStateIndex = -1;
    }

    public void initStateManager(int size, Object pCommonData) {
        if (this.pListStates == null) {
            CState.pStateManager = this;
            CState.pCommonData = pCommonData;
            this.pListStates = new CState[size];
        }
    }

    public void initState(int index, CState pState, StateConfig pConfig) {
        if (this.pListStates != null && pState != null && index >= 0 && index < this.pListStates.length && !pState.equals(this.pListStates[index])) {
            pState.myIndex = index;
            if (this.pListStates[index] != null) {
                this.pListStates[index].destroy();
                this.pListStates[index] = null;
            }
            this.pListStates[index] = pState;
            if (pConfig != null) {
                pState.config.set(pConfig);
            }
        }
    }

    public void setActiveState(int index, boolean bSetTimer) {
        this.pendingStateIndex = index;
        this.bPendingStateTimer = bSetTimer;
    }

    public CState getActiveState() {
        CState retVal = this.pListStates == null || this.activeStateIndex < 0 ? null : this.pListStates[this.activeStateIndex];
        return retVal;
    }

    public int getActiveStateIndex() {
        if (this.pListStates == null || this.activeStateIndex < 0) {
            return -1;
        }
        return this.activeStateIndex;
    }

    CState getStateObject(int index) {
        CState retVal = this.pListStates == null || index < 0 || index >= this.pListStates.length ? null : this.pListStates[index];
        return retVal;
    }

    void switchToState(int index, boolean bSetTimer) {
        this.pendingStateIndex = index;
        this.bPendingStateTimer = bSetTimer;
    }

    void switchToPrevState(boolean bSetTimer) {
        this.pendingStateIndex = this.pListStates[this.activeStateIndex].prevStateIndex;
        this.bPendingStateTimer = bSetTimer;
    }

    public void keyPressed(int keyCode) {
        if (this.pListStates != null && this.pendingStateIndex < 0 && this.activeStateIndex >= 0 && this.pListStates[this.activeStateIndex] != null) {
            this.pListStates[this.activeStateIndex].keyStatus |= 1 << keyCode - 48;
            this.pListStates[this.activeStateIndex].keyPressed(keyCode);
        }
    }

    public void keyHit(int keyCode) {
        if (this.pListStates != null && this.pendingStateIndex < 0 && this.activeStateIndex >= 0 && this.pListStates[this.activeStateIndex] != null) {
            this.pListStates[this.activeStateIndex].keyHit(keyCode);
        }
    }

    public void keyReleased(int keyCode) {
        if (this.pListStates != null && this.pendingStateIndex < 0 && this.activeStateIndex >= 0 && this.pListStates[this.activeStateIndex] != null) {
            this.pListStates[this.activeStateIndex].keyStatus &= ~(1 << keyCode - 48);
            this.pListStates[this.activeStateIndex].keyReleased(keyCode);
        }
    }

    public void suspend() {
        if (this.pListStates != null && this.pendingStateIndex < 0 && this.activeStateIndex >= 0 && this.pListStates[this.activeStateIndex] != null) {
            this.cancelTimer();
            this.pListStates[this.activeStateIndex].suspend(true);
        }
    }

    public void resume() {
        if (this.pListStates != null && this.pendingStateIndex < 0 && this.activeStateIndex >= 0 && this.pListStates[this.activeStateIndex] != null) {
            this.pListStates[this.activeStateIndex].resume(true);
            if (this.pListStates[this.activeStateIndex].config.bResetKeys) {
                this.pListStates[this.activeStateIndex].keyStatus = 0;
                this.pListStates[this.activeStateIndex].isKeyActive = true;
            }
            if (this.pListStates[this.activeStateIndex].config.bSetTimerOnResume) {
                this.pListStates[this.activeStateIndex].onTimerStart();
                this.setTimer();
            }
        }
    }

    public void update() {
        if (this.pListStates != null) {
            long currentTime;
            if (this.pendingStateIndex >= 0) {
                this.cancelTimer();
                if (this.activeStateIndex >= 0 && this.pListStates[this.activeStateIndex] != null) {
                    if (this.pListStates[this.activeStateIndex].config.bSuspendActive) {
                        this.pListStates[this.activeStateIndex].suspend(false);
                    }
                    if (this.pListStates[this.activeStateIndex].config.bKillOnStateChange) {
                        this.pListStates[this.activeStateIndex].destroy();
                        this.pListStates[this.activeStateIndex] = null;
                    }
                }
                if (this.pendingStateIndex < this.pListStates.length && this.pListStates[this.pendingStateIndex] != null) {
                    this.pListStates[this.pendingStateIndex].prevStateIndex = this.activeStateIndex;
                    this.activeStateIndex = this.pendingStateIndex;
                    if (this.pListStates[this.pendingStateIndex].config.bResetKeys) {
                        this.pListStates[this.pendingStateIndex].keyStatus = 0;
                        this.pListStates[this.pendingStateIndex].isKeyActive = true;
                    }
                    if (this.pListStates[this.pendingStateIndex].config.bSuspendActive) {
                        this.pListStates[this.pendingStateIndex].resume(false);
                    }
                    if (this.bPendingStateTimer) {
                        this.pListStates[this.pendingStateIndex].onTimerStart();
                        this.setTimer();
                    }
                }
                this.pendingStateIndex = -1;
            } else if (this.activeStateIndex >= 0 && this.timerVal >= 0L && this.timerVal - (currentTime = System.currentTimeMillis()) < 0L) {
                this.pListStates[this.activeStateIndex].onTimerEnd();
                if (this.pListStates[this.activeStateIndex].config.bLoopTimer) {
                    this.pListStates[this.activeStateIndex].onTimerStart();
                    this.setTimer();
                } else {
                    this.cancelTimer();
                }
                if (this.pListStates[this.activeStateIndex].isKeyActive) {
                    this.pListStates[this.activeStateIndex].handleKeys();
                }
            }
        }
    }

    private void setTimer() {
        this.timerVal = System.currentTimeMillis() + this.pListStates[this.activeStateIndex].config.timerVal;
    }

    private void cancelTimer() {
        this.timerVal = -1L;
    }
}

