/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Animation;
import Game.BenGame;
import Game.Character;
import Game.Enemy;
import Game.Player;
import Game.Rectangle;
import StateManager.StateCommonData;

public class Weapons
extends Character {
    public static final byte STATE_SMALL_FIREBALL_MOVE = 0;
    public static final byte STATE_SMALL_FIREBALL_BLAST = 1;
    public static final byte STATE_BIG_FIREBALL_MOVE = 2;
    public static final byte STATE_BIG_FIREBALL_BLAST = 3;
    private Player player;
    private Enemy enemy;
    public byte mCollisionIndex;
    public byte weaponType;
    public static final byte HERO_WEAPON = 0;
    public static final byte ENEMY_WEAPON = 1;
    Character.Struct_Character[] struct_Weapon;
    public Rectangle mTempNextRect;

    public Weapons(Player player) {
        this.player = player;
        this.struct_Weapon = new Character.Struct_Character[3];
        for (int i = 0; i < 3; ++i) {
            this.struct_Weapon[i] = new Character.Struct_Character();
        }
        this.initWeapons();
        this.weaponType = 0;
        this.mTempNextRect = new Rectangle();
    }

    public Weapons(Enemy enemy) {
        this.enemy = enemy;
        this.struct_Weapon = new Character.Struct_Character[enemy.noOfEnemies];
        for (int i = 0; i < enemy.noOfEnemies; ++i) {
            this.struct_Weapon[i] = new Character.Struct_Character();
        }
        this.initWeapons();
        this.weaponType = 1;
    }

    public void releaseWeaponStructure() {
        block3: {
            block2: {
                if (this.weaponType != 0) break block2;
                for (int i = 0; i < 3; ++i) {
                    this.releaseAniStructure(this.struct_Weapon[i]);
                }
                break block3;
            }
            if (this.weaponType != 1) break block3;
            for (int i = 0; i < this.enemy.noOfEnemies; ++i) {
                this.releaseAniStructure(this.struct_Weapon[i]);
            }
        }
    }

    public void realeaseWeaponResource() {
        this.releaseAniReasourse();
    }

    public void unloadWeaponReasource() {
        this.releaseWeaponStructure();
        this.realeaseWeaponResource();
    }

    public void initWeapons() {
        for (int i = 0; i < this.struct_Weapon.length; ++i) {
            this.struct_Weapon[i].state = 0;
            this.struct_Weapon[i].iCharFrameNumber = 0;
        }
    }

    public void loadWeaponResource(String aImage, String aAni) {
        this.charAnimation = new Animation();
        this.charAnimation.loadAnimImages(aImage);
        this.charAnimation.LoadAnimation(aAni);
    }

    public void updateWeaponState(int aWeaponCount) {
        switch (this.struct_Weapon[aWeaponCount].state) {
            case 0: {
                ++this.struct_Weapon[aWeaponCount].iCharFrameNumber;
                if (this.struct_Weapon[aWeaponCount].iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Weapon[aWeaponCount].state].NOFFrames) break;
                this.struct_Weapon[aWeaponCount].state = 0;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 1;
                break;
            }
            case 1: {
                ++this.struct_Weapon[aWeaponCount].iCharFrameNumber;
                if (this.struct_Weapon[aWeaponCount].iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Weapon[aWeaponCount].state].NOFFrames) break;
                this.struct_Weapon[aWeaponCount].state = 0;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 0;
                this.struct_Weapon[aWeaponCount].mIsActive = false;
                this.struct_Weapon[aWeaponCount].collided = false;
                break;
            }
            case 2: {
                ++this.struct_Weapon[aWeaponCount].iCharFrameNumber;
                if (this.struct_Weapon[aWeaponCount].iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Weapon[aWeaponCount].state].NOFFrames) break;
                this.struct_Weapon[aWeaponCount].state = (byte)2;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 1;
                break;
            }
            case 3: {
                ++this.struct_Weapon[aWeaponCount].iCharFrameNumber;
                if (this.struct_Weapon[aWeaponCount].iCharFrameNumber < this.charAnimation.mObjAnimationsArray[this.struct_Weapon[aWeaponCount].state].NOFFrames) break;
                this.struct_Weapon[aWeaponCount].state = 0;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 0;
                this.struct_Weapon[aWeaponCount].mIsActive = false;
                this.struct_Weapon[aWeaponCount].collided = false;
            }
        }
        this.mTempNextRect = this.charAnimation.GetNextFrame(this.struct_Weapon[aWeaponCount].state, (short)this.struct_Weapon[aWeaponCount].iCharFrameNumber);
        this.struct_Weapon[aWeaponCount].NextAnimFrameRect.x = this.mTempNextRect.x;
        this.struct_Weapon[aWeaponCount].NextAnimFrameRect.y = this.mTempNextRect.y;
        this.struct_Weapon[aWeaponCount].NextAnimFrameRect.dx = this.mTempNextRect.dx;
        this.struct_Weapon[aWeaponCount].NextAnimFrameRect.dy = this.mTempNextRect.dy;
        if (this.struct_Weapon[aWeaponCount].mIsCharacterFlipped) {
            this.struct_Weapon[aWeaponCount].NextAnimFrameRect.x = -this.struct_Weapon[aWeaponCount].NextAnimFrameRect.x;
        }
        if (this.struct_Weapon[aWeaponCount].state == 1 || this.struct_Weapon[aWeaponCount].state == 3) {
            this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.y += this.struct_Weapon[aWeaponCount].NextAnimFrameRect.y;
            if (!this.struct_Weapon[aWeaponCount].mIsCharacterFlipped) {
                this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x += this.struct_Weapon[aWeaponCount].NextAnimFrameRect.x;
            }
        }
    }

    public boolean checkEnemyWeaponCollisionWdHero(int aWeaponCount) {
        if (this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.checkCollide(this.enemy.canvas.mBen.struct_Player.CurrentAnimFrameRect)) {
            this.struct_Weapon[aWeaponCount].collided = false;
            this.struct_Weapon[aWeaponCount].state = 1;
            this.struct_Weapon[aWeaponCount].iCharFrameNumber = 1;
            return true;
        }
        return false;
    }

    public byte checkHeroWeaponCollisionWdEnemy(int aWeaponCount) {
        for (byte i = 0; i < this.player.mCanvas.mEnemy.noOfEnemies; i = (byte)((byte)(i + 1))) {
            boolean tocheck = true;
            tocheck = true;
            if (!tocheck || this.player.mCanvas.mEnemy.struct_enemy[i].Health <= 0 || this.player.mCanvas.mEnemy.struct_enemy[i].bDied || this.player.mCanvas.IsVisible(this.player.mCanvas.mEnemy.struct_enemy[i].eCurrentFrameRect, (short)(-BenGame.mMap_X_off), (short)(-BenGame.mMap_Y_off)) <= 0 || !this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.checkCollide(this.player.mCanvas.mEnemy.struct_enemy[i].eCurrentFrameRect)) continue;
            if (this.struct_Weapon[aWeaponCount].state == 0) {
                this.struct_Weapon[aWeaponCount].state = 1;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 1;
            } else if (this.struct_Weapon[aWeaponCount].state == 2) {
                this.struct_Weapon[aWeaponCount].state = (byte)3;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 1;
            }
            this.updateAnimPosition(this.struct_Weapon[aWeaponCount]);
            this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x = !this.struct_Weapon[aWeaponCount].mIsCharacterFlipped ? this.player.mCanvas.mEnemy.struct_enemy[i].eCurrentFrameRect.x + this.player.mCanvas.mEnemy.struct_enemy[i].eCurrentFrameRect.dx - (this.player.mCanvas.mEnemy.struct_enemy[i].eCurrentFrameRect.dx >> 1) - this.getCharacterWidth(this.struct_Weapon[aWeaponCount].state, this.struct_Weapon[aWeaponCount].iCharFrameNumber) : this.player.mCanvas.mEnemy.struct_enemy[i].eCurrentFrameRect.x + (this.player.mCanvas.mEnemy.struct_enemy[i].eCurrentFrameRect.dx >> 1);
            this.setCharacterXOnCanvas(this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x, this.struct_Weapon[aWeaponCount]);
            return i;
        }
        return -1;
    }

    public void checkCollision(int aWeaponCount) {
        this.mCollisionIndex = this.weaponType == 1 ? this.enemy.canvas.mMap.CheckCollision(this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect, this.struct_Weapon[aWeaponCount].NextAnimFrameRect, this.struct_Weapon[aWeaponCount].mIsCharacterFlipped, (byte)2) : this.player.mCanvas.mMap.CheckCollision(this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect, this.struct_Weapon[aWeaponCount].NextAnimFrameRect, this.struct_Weapon[aWeaponCount].mIsCharacterFlipped, (byte)2);
        this.updateAnimPosition(this.struct_Weapon[aWeaponCount]);
        if ((this.mCollisionIndex & 2) == 2 && !this.struct_Weapon[aWeaponCount].mIsCharacterFlipped) {
            if (this.struct_Weapon[aWeaponCount].state == 0) {
                this.struct_Weapon[aWeaponCount].state = 1;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 1;
            } else if (this.struct_Weapon[aWeaponCount].state == 2) {
                this.struct_Weapon[aWeaponCount].state = (byte)3;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 1;
            }
            this.updateAnimPosition(this.struct_Weapon[aWeaponCount]);
            if (this.weaponType == 1) {
                this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x = this.enemy.canvas.mMap.Tile_X_Cordinate.x - this.getCharacterWidth(this.struct_Weapon[aWeaponCount].state, this.struct_Weapon[aWeaponCount].iCharFrameNumber);
            } else {
                this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x = this.player.mCanvas.mMap.Tile_X_Cordinate.x - this.getCharacterWidth(this.struct_Weapon[aWeaponCount].state, this.struct_Weapon[aWeaponCount].iCharFrameNumber);
                if (this.struct_Weapon[aWeaponCount].state == 1 && this.struct_Weapon[aWeaponCount].iCharFrameNumber == 1) {
                    this.player.mBulletBlastX = (short)this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x;
                }
            }
        } else if ((this.mCollisionIndex & 8) == 8 && this.struct_Weapon[aWeaponCount].mIsCharacterFlipped) {
            if (this.struct_Weapon[aWeaponCount].state == 0) {
                this.struct_Weapon[aWeaponCount].state = 1;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 1;
            } else if (this.struct_Weapon[aWeaponCount].state == 2) {
                this.struct_Weapon[aWeaponCount].state = (byte)3;
                this.struct_Weapon[aWeaponCount].iCharFrameNumber = 1;
            }
            this.updateAnimPosition(this.struct_Weapon[aWeaponCount]);
            if (this.weaponType == 1) {
                this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x = this.enemy.canvas.mMap.Tile_X_Cordinate.x;
            } else {
                this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x = this.player.mCanvas.mMap.Tile_X_Cordinate.x;
                if (this.struct_Weapon[aWeaponCount].state == 1 && this.struct_Weapon[aWeaponCount].iCharFrameNumber == 1) {
                    this.player.mBulletBlastX = (short)this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x;
                }
            }
        }
    }

    public void updateWeaponPosition(int aWeaponCount) {
        if (this.struct_Weapon[aWeaponCount].state != 1 && this.struct_Weapon[aWeaponCount].state != 3) {
            this.checkCollision(aWeaponCount);
        }
        if (StateCommonData.screen_Width < this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x - BenGame.getMapXPosition() || 0 > this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x + this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.dx - BenGame.getMapXPosition()) {
            this.struct_Weapon[aWeaponCount].mIsActive = false;
            this.struct_Weapon[aWeaponCount].collided = false;
            this.struct_Weapon[aWeaponCount].state = 0;
            this.struct_Weapon[aWeaponCount].iCharFrameNumber = 0;
        }
        if (this.struct_Weapon[aWeaponCount].mIsActive) {
            this.setCharacterXOnCanvas(this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.x, this.struct_Weapon[aWeaponCount]);
            this.setCharacterYOnCanvas(this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.y, this.struct_Weapon[aWeaponCount]);
            this.setCharacterWidth(this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.dx, this.struct_Weapon[aWeaponCount]);
            this.setCharacterHeight(this.struct_Weapon[aWeaponCount].CurrentAnimFrameRect.dy, this.struct_Weapon[aWeaponCount]);
        }
        this.struct_Weapon[aWeaponCount].mIsAnimPosUpdated = false;
    }
}

