/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.BenGame;
import Game.CAnim;
import Game.JavaReader;
import Game.Map;
import Game.MapObjectInterface;
import Game.Player;
import Game.Rectangle;
import Project.JDisplay;
import Project.JImage;
import StateManager.StateCommonData;
import java.io.DataInputStream;
import java.io.InputStream;

public class MapObject
implements MapObjectInterface {
    private int[] mXpos;
    private int[] mYpos;
    private int[] mAnimationID;
    int mapWidth;
    int mapHeight;
    byte noOfMapLayers;
    short noOfMapAnimations;
    short noOfFramesInEachMapLayer;
    byte iNOFBitmaps;
    JImage[] mapImage;
    int animationFrameNumber;
    MapObjectInterface.struct_MapLayerInfo[][] pMapLayerInfo;
    JavaReader jr;
    Rectangle Frame;
    public BenGame mCanvas;
    public static int levelScore;
    Rectangle MapObjectRectangle;
    Rectangle PlayerRect;
    public static boolean mLeverPressed;
    int mNoOfLayers;
    short mNoOfFrames;
    short mNoOfLayersInEachFrame;
    public short[][] mapObjectXYforScoreTable;
    StateCommonData pCommonData;
    CAnim pAnim;
    public boolean[] TutorialObjectActivate = new boolean[]{false, false, false, false, false};
    public boolean[] PermanentlyObjectDeActivate = new boolean[]{false, false, false, false, false};
    public boolean Playerclimb;

    public MapObject(BenGame aCanvas, StateCommonData pCommonData, CAnim pAnim) {
        this.pCommonData = pCommonData;
        this.pAnim = pAnim;
        this.mCanvas = aCanvas;
        this.jr = new JavaReader();
        this.mapObjectXYforScoreTable = new short[4][3];
        this.Frame = new Rectangle(0, 0, 0, 0);
        this.PlayerRect = new Rectangle(0, 0, 0, 0);
        this.MapObjectRectangle = new Rectangle();
    }

    public void loadImages(String[] imagepath) {
        if (this.mapImage == null) {
            this.mapImage = new JImage[imagepath.length];
            for (int i = 0; i < imagepath.length; ++i) {
                this.mapImage[i] = new JImage();
                this.mapImage[i].load(imagepath[i], null);
            }
        }
    }

    public void readMap(String mapFile) {
        try {
            int i;
            InputStream in = this.getClass().getResourceAsStream(mapFile);
            DataInputStream dis = new DataInputStream(in);
            this.mapWidth = this.jr.readShort(dis);
            this.mapHeight = this.jr.readShort(dis);
            this.noOfMapLayers = this.jr.readByte(dis);
            this.pMapLayerInfo = new MapObjectInterface.struct_MapLayerInfo[this.noOfMapLayers][];
            for (i = 0; i < this.noOfMapLayers; ++i) {
                this.noOfFramesInEachMapLayer = this.jr.readShort(dis);
                this.pMapLayerInfo[i] = new MapObjectInterface.struct_MapLayerInfo[this.noOfFramesInEachMapLayer];
                for (int j = 0; j < this.noOfFramesInEachMapLayer; ++j) {
                    this.pMapLayerInfo[i][j] = new MapObjectInterface.struct_MapLayerInfo();
                    this.pMapLayerInfo[i][j].tile_Id = this.jr.readShort(dis);
                    this.pMapLayerInfo[i][j].animId = this.jr.readByte(dis);
                    this.pMapLayerInfo[i][j].tileX = this.jr.readInt(dis);
                    this.pMapLayerInfo[i][j].tileY = this.jr.readInt(dis);
                    this.pMapLayerInfo[i][j].isActive = true;
                }
            }
            if (BenGame.mCurrentLevel == 1) {
                this.pMapLayerInfo[0][0].isActive = false;
                this.pMapLayerInfo[0][1].isActive = false;
                this.pMapLayerInfo[0][2].isActive = false;
                this.pMapLayerInfo[0][3].isActive = false;
                this.pMapLayerInfo[0][4].isActive = false;
                this.pMapLayerInfo[0][5].isActive = false;
                this.pMapLayerInfo[0][6].isActive = false;
            }
            if (StateCommonData.mGameMode == 1) {
                if (BenGame.mCurrentLevel == 1) {
                    for (i = 4; i >= 0; --i) {
                        this.PermanentlyObjectDeActivate[i] = false;
                        this.TutorialObjectActivate[i] = false;
                    }
                }
            } else if (StateCommonData.mGameMode == 0 && BenGame.mCurrentLevel == 1) {
                for (i = 4; i >= 0; --i) {
                    this.PermanentlyObjectDeActivate[i] = true;
                }
            }
            this.evaluateInitials();
            this.mapObjectXYforScoreTable[0][1] = 500;
            this.mapObjectXYforScoreTable[0][0] = 0;
            this.mapObjectXYforScoreTable[1][1] = 1000;
            this.mapObjectXYforScoreTable[1][0] = 0;
            this.mapObjectXYforScoreTable[2][1] = 50;
            this.mapObjectXYforScoreTable[2][0] = 0;
            this.mapObjectXYforScoreTable[3][1] = 1000;
            this.mapObjectXYforScoreTable[3][0] = 0;
        }
        catch (Exception ex) {
            System.out.println(" readMap " + ex);
        }
    }

    public void realeaseMapObjectsData() {
        int i = 0;
        boolean j = false;
        int noOflayers = this.pMapLayerInfo.length;
        if (this.pMapLayerInfo != null) {
            for (i = 0; i < noOflayers; ++i) {
                if (this.pMapLayerInfo[i] == null) continue;
                this.pMapLayerInfo[i] = null;
            }
            this.pMapLayerInfo = null;
        }
    }

    public void unloadMapObjectResourse() {
        for (int i = 0; i < this.mapImage.length; i = (int)((byte)(i + 1))) {
            if (this.mapImage[i] == null) continue;
            this.mapImage[i].destroy();
            this.mapImage[i] = null;
        }
        if (this.mapImage != null) {
            this.mapImage = null;
        }
        if (this.jr != null) {
            this.jr = null;
        }
        if (this.MapObjectRectangle != null) {
            this.MapObjectRectangle = null;
        }
        if (this.PlayerRect != null) {
            this.PlayerRect = null;
        }
        if (this.Frame != null) {
            this.Frame = null;
        }
        this.realeaseMapObjectsData();
    }

    public void evaluateInitials() {
        int p = 0;
        int q = 0;
        int r = 0;
        for (int i = 0; i < this.noOfMapLayers; ++i) {
            int noofFramesinEachMapLayer = this.pMapLayerInfo[i].length;
            this.mXpos = new int[noofFramesinEachMapLayer];
            this.mYpos = new int[noofFramesinEachMapLayer];
            this.mAnimationID = new int[noofFramesinEachMapLayer];
            for (int j = noofFramesinEachMapLayer; j > 0; --j) {
                if (p >= this.mYpos.length) continue;
                this.mXpos[p++] = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileX;
                this.mYpos[q++] = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileY;
                this.mAnimationID[r++] = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId;
            }
        }
    }

    public void renderMapObjects(JDisplay g, int mapX, int mapY, int displayWidth, int displayHeight) {
        if (mapX < 0) {
            mapX = 0;
        }
        if (mapY < 0) {
            mapY = 0;
        }
        for (int i = 0; i < this.noOfMapLayers; ++i) {
            int noofFramesinEachMapLayer;
            for (int j = noofFramesinEachMapLayer = this.pMapLayerInfo[i].length; j > 0; --j) {
                short tile_id = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tile_Id;
                byte animationID = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId;
                int renderX = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileX;
                int renderY = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileY;
                if (tile_id > 0) {
                    short clipX = this.pAnim.pClippingInfo[i][tile_id].x;
                    short clipY = this.pAnim.pClippingInfo[i][tile_id].y;
                    short clipWidth = this.pAnim.pClippingInfo[i][tile_id].dx;
                    short clipHeight = this.pAnim.pClippingInfo[i][tile_id].dy;
                    if (renderX + clipWidth <= mapX || renderX >= mapX + displayWidth || renderY + clipHeight <= mapY || renderY >= mapY + displayHeight) continue;
                    g.drawImage(this.mapImage[i], renderX - mapX, renderY - mapY, clipX, clipY, clipWidth, clipHeight, 0, 1);
                    continue;
                }
                this.drawBodyPartMapObjects(g, animationID, i, noofFramesinEachMapLayer - j, renderX, renderY, mapX, mapY, displayWidth, displayHeight);
            }
        }
    }

    public void drawBodyPartMapObjects(JDisplay g, int animationID, int aFirstIndex, int aSecondIndex, int renderX, int renderY, int mapX, int mapY, int displayWidth, int displayHeight) {
        int aCurrentFrame;
        int noOfFramesInAnimation = this.pAnim.pMapAnimation[animationID].NOFFrames;
        if ((aCurrentFrame = this.pMapLayerInfo[aFirstIndex][aSecondIndex].current_frame++) >= noOfFramesInAnimation) {
            aCurrentFrame = 0;
            this.pMapLayerInfo[aFirstIndex][aSecondIndex].current_frame = 0;
            if (animationID == 2 || animationID == 27 || animationID == 29 || animationID == 14 || animationID == 33 || animationID == 12 || animationID == 41 || animationID == 15 || animationID == 1) {
                this.pMapLayerInfo[aFirstIndex][aSecondIndex].isActive = false;
                if (animationID == 27 || animationID == 29) {
                    this.mCanvas.mIsDynPanPaused = false;
                }
            }
            if (animationID == 25) {
                this.pMapLayerInfo[aFirstIndex][aSecondIndex].animId = (byte)24;
            } else if (animationID == 35) {
                this.pMapLayerInfo[aFirstIndex][aSecondIndex].animId = (byte)34;
            } else if (animationID == 37) {
                this.pMapLayerInfo[aFirstIndex][aSecondIndex].animId = (byte)36;
            } else if (animationID == 39) {
                this.pMapLayerInfo[aFirstIndex][aSecondIndex].animId = (byte)38;
            }
        } else if (!BenGame.mPause) {
            if (!BenGame.mIsScoreBoardDisplayed) {
                if (!BenGame.mIsAlertOn && this.pMapLayerInfo[aFirstIndex][aSecondIndex].current_frame < this.pAnim.pMapAnimation[animationID].NOFFrames) {
                    this.pMapLayerInfo[aFirstIndex][aSecondIndex].tileX += this.pAnim.pMapAnimation[animationID].pMapAnimationFrame[this.pMapLayerInfo[aFirstIndex][aSecondIndex].current_frame].FrameX;
                    this.pMapLayerInfo[aFirstIndex][aSecondIndex].tileY += this.pAnim.pMapAnimation[animationID].pMapAnimationFrame[this.pMapLayerInfo[aFirstIndex][aSecondIndex].current_frame].FrameY;
                }
            }
        }
        if (this.pMapLayerInfo[aFirstIndex][aSecondIndex].isActive) {
            this.pAnim.drawFrame(g, false, animationID, aCurrentFrame, renderX, renderY, mapX, mapY, displayWidth, displayHeight, this.mapImage);
        }
    }

    public void updateHealthAndScore(int aAnimID) {
        switch (aAnimID) {
            case 11: {
                if (BenGame.mPlayerLifes < 2) {
                    BenGame.mPlayerLifes = (byte)(BenGame.mPlayerLifes + 1);
                    break;
                }
                short[] sArray = this.mapObjectXYforScoreTable[1];
                sArray[0] = (short)(sArray[0] + 1);
                levelScore += 1000;
                break;
            }
            case 5: {
                levelScore += 50;
                short[] sArray = this.mapObjectXYforScoreTable[2];
                sArray[0] = (short)(sArray[0] + 1);
                break;
            }
            case 6: {
                levelScore += 1000;
                short[] sArray = this.mapObjectXYforScoreTable[3];
                sArray[0] = (short)(sArray[0] + 1);
                break;
            }
            case 7: {
                if (this.mCanvas.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp >= this.mCanvas.mDpsInfo.mPlayerMaxHealth) {
                    short[] sArray = this.mapObjectXYforScoreTable[0];
                    sArray[0] = (short)(sArray[0] + 1);
                    levelScore += 500;
                    break;
                }
                this.mCanvas.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp = (short)(this.mCanvas.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp + 20);
                break;
            }
            case 8: {
                if (this.mCanvas.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp >= this.mCanvas.mDpsInfo.mPlayerMaxHealth) {
                    short[] sArray = this.mapObjectXYforScoreTable[1];
                    sArray[0] = (short)(sArray[0] + 1);
                    levelScore += 1000;
                    break;
                }
                this.mCanvas.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp = this.mCanvas.mDpsInfo.mPlayerMaxHealth;
                break;
            }
            case 30: {
                this.mCanvas.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp = (short)(this.mCanvas.mDpsInfo.struct_DPSInfo[Player.mHeroType].iHp - 20);
            }
        }
    }

    public Rectangle getRectangles(int x, int y, int dx, int dy) {
        this.Frame.x = x;
        this.Frame.y = y;
        this.Frame.dx = dx;
        this.Frame.dy = dy;
        return this.Frame;
    }

    public void setRectangleforPlayer(Rectangle mPlayerRect) {
        this.PlayerRect = mPlayerRect;
    }

    public void mapObjectCollision() {
        if (BenGame.mCurrentLevel == 5 && this.pMapLayerInfo[0][2].animId == 22) {
            int vLevel3_Lever1X = this.pMapLayerInfo[0][2].tileX;
            int vLevel3_Lever1Y = this.pMapLayerInfo[0][2].tileY;
            if (Math.abs(vLevel3_Lever1X - (this.mCanvas.mBen.getCharacterXOnCanvas(this.mCanvas.mBen.struct_Player) + (this.mCanvas.mBen.getCharacterWidth(this.mCanvas.mBen.struct_Player) >> 1))) < this.mCanvas.mBen.getCharacterWidth(this.mCanvas.mBen.struct_Player) && Math.abs(vLevel3_Lever1Y - (this.mCanvas.mBen.getCharacterYOnCanvas(this.mCanvas.mBen.struct_Player) + (this.mCanvas.mBen.getCharacterHeight(this.mCanvas.mBen.struct_Player) >> 1))) < this.mCanvas.mBen.getCharacterHeight(this.mCanvas.mBen.struct_Player)) {
                BenGame.mStatusOfLevel = (byte)4;
            }
        }
        for (int i = 0; i < this.noOfMapLayers; ++i) {
            int noofFramesinEachMapLayer;
            for (int j = noofFramesinEachMapLayer = this.pMapLayerInfo[i].length; j > 0; --j) {
                if (!this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].isActive) continue;
                short tile_id = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tile_Id;
                byte animationID = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId;
                int renderX = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileX;
                int renderY = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileY;
                int current_frame = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame >= this.pAnim.pMapAnimation[animationID].NOFFrames ? 0 : this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame;
                this.MapObjectRectangle = this.getRectangles(renderX, renderY, this.pAnim.pMapAnimation[animationID].pMapAnimationFrame[current_frame].FrameWidth, this.pAnim.pMapAnimation[animationID].pMapAnimationFrame[current_frame].FrameHeight);
                if (this.mCanvas.mDpsInfo.getPlayerHealth() > 0 && this.mapObjectCollisionDetection(this.MapObjectRectangle, this.PlayerRect)) {
                    switch (animationID) {
                        case 10: {
                            break;
                        }
                        case 13: {
                            break;
                        }
                        case 30: {
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].isActive = false;
                            this.updateHealthAndScore(animationID);
                            break;
                        }
                        case 14: {
                            if (this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame >= this.pAnim.pMapAnimation[animationID].NOFFrames) {
                                this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                            }
                            short prevwidth = this.pAnim.pMapAnimation[animationID].pMapAnimationFrame[this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame].FrameWidth;
                            short prevheight = this.pAnim.pMapAnimation[animationID].pMapAnimationFrame[this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame].FrameHeight;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)15;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                            short currwidth = this.pAnim.pMapAnimation[animationID].pMapAnimationFrame[this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame].FrameWidth;
                            short currheight = this.pAnim.pMapAnimation[animationID].pMapAnimationFrame[this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame].FrameHeight;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileX += currwidth - prevwidth >> 1;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileY += currheight - prevheight >> 1;
                            this.mCanvas.mBen.misInvincible = true;
                            this.mCanvas.mBen.mInvincibleTimer = 8000L;
                            break;
                        }
                        case 11: {
                            this.updateHealthAndScore(animationID);
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)12;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                            break;
                        }
                        case 5: 
                        case 6: {
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)2;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                            this.updateHealthAndScore(animationID);
                            break;
                        }
                        case 7: 
                        case 8: {
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)2;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                            this.updateHealthAndScore(animationID);
                            break;
                        }
                        case 32: {
                            if (this.mCanvas.mBen.struct_Player.state == 28) {
                                this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)33;
                                this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                                break;
                            }
                            if (this.mCanvas.mBen.struct_Player.state != 29) break;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)33;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                            break;
                        }
                        case 34: {
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)35;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                            this.mCanvas.mBen.struct_Player.state = (byte)29;
                            this.mCanvas.mBen.struct_Player.iCharFrameNumber = 1;
                            break;
                        }
                        case 24: {
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)25;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                            this.mCanvas.mBen.struct_Player.jumpState = (byte)28;
                            this.mCanvas.mBen.struct_Player.state = (byte)16;
                            this.mCanvas.mBen.struct_Player.iCharFrameNumber = 1;
                            if (Player.mHeroType != 2 && Player.mHeroType != 1) break;
                            this.mCanvas.mBen.struct_Player.CurrentAnimFrameRect.x = this.MapObjectRectangle.x + ((this.MapObjectRectangle.dx >> 1) - (this.mCanvas.mBen.struct_Player.CurrentAnimFrameRect.dx >> 1));
                            this.mCanvas.mBen.struct_Player.CurrentAnimFrameRect.y = this.MapObjectRectangle.y + (this.MapObjectRectangle.dy - this.mCanvas.mBen.struct_Player.CurrentAnimFrameRect.dy);
                            break;
                        }
                        case 16: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 22: {
                            int k;
                            int tileRowId;
                            int tileColId;
                            if (animationID == 17) {
                                if (this.mCanvas.mDynPanActivated) break;
                                if (BenGame.mCurrentLevel == 5) {
                                    this.pMapLayerInfo[i][2].animId = (byte)23;
                                    this.pMapLayerInfo[i][3].animId = (byte)23;
                                } else if (BenGame.mCurrentLevel == 6) {
                                    if (noofFramesinEachMapLayer - j == 11) {
                                        this.pMapLayerInfo[i][12].animId = (byte)23;
                                        this.pMapLayerInfo[i][13].animId = (byte)23;
                                    } else if (noofFramesinEachMapLayer - j == 1) {
                                        this.pMapLayerInfo[i][2].animId = (byte)23;
                                        this.pMapLayerInfo[i][3].animId = (byte)23;
                                        this.pMapLayerInfo[i][4].animId = (byte)27;
                                        this.pMapLayerInfo[i][4].current_frame = 0;
                                        tileColId = this.pMapLayerInfo[i][4].tileX / 12;
                                        tileRowId = this.pMapLayerInfo[i][4].tileY / 12;
                                        for (k = 0; k < 6; ++k) {
                                            short[] sArray = Map.MapData.MapBoundArray[tileRowId + k];
                                            int n = tileColId;
                                            sArray[n] = (short)(sArray[n] & 0xFF00);
                                        }
                                    }
                                }
                                this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                                if (BenGame.mCurrentLevel == 5) {
                                    this.mCanvas.mDynPanActivated = true;
                                    this.mCanvas.setDynPanningParameters(BenGame.getMapXPosition(), BenGame.getMapYPosition(), this.pMapLayerInfo[i][4].tileX - (StateCommonData.screen_Width >> 1) + (this.pAnim.pMapAnimation[13].AnimationWidth >> 1), this.pMapLayerInfo[i][4].tileY + this.pAnim.pMapAnimation[13].AnimationHeight + 12 - StateCommonData.screen_Height, (short)4);
                                } else if (BenGame.mCurrentLevel == 6 && noofFramesinEachMapLayer - j == 11) {
                                    mLeverPressed = true;
                                    this.mCanvas.mDynPanActivated = true;
                                    this.mCanvas.setDynPanningParameters(BenGame.getMapXPosition(), BenGame.getMapYPosition(), this.pMapLayerInfo[i][14].tileX - (StateCommonData.screen_Width >> 1) + (this.pAnim.pMapAnimation[28].AnimationWidth >> 1), this.pMapLayerInfo[i][14].tileY - (StateCommonData.screen_Height >> 1) + (this.pAnim.pMapAnimation[28].AnimationHeight >> 1), (short)14);
                                }
                                this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)18;
                                break;
                            }
                            if (animationID != 20 || this.mCanvas.mDynPanActivated) break;
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = (byte)21;
                            if (BenGame.mCurrentLevel == 5) {
                                this.pMapLayerInfo[i][6].animId = (byte)23;
                                this.pMapLayerInfo[i][7].animId = (byte)23;
                            } else if (BenGame.mCurrentLevel == 6) {
                                this.pMapLayerInfo[i][6].animId = (byte)23;
                                this.pMapLayerInfo[i][7].animId = (byte)23;
                                this.pMapLayerInfo[i][9].animId = (byte)27;
                                this.pMapLayerInfo[i][9].current_frame = 0;
                                tileColId = this.pMapLayerInfo[i][9].tileX / 12;
                                tileRowId = this.pMapLayerInfo[i][9].tileY / 12;
                                for (k = 0; k < 6; ++k) {
                                    short[] sArray = Map.MapData.MapBoundArray[tileRowId + k];
                                    int n = tileColId;
                                    sArray[n] = (short)(sArray[n] & 0xFF00);
                                }
                            } else if (BenGame.mCurrentLevel == 7) {
                                if (noofFramesinEachMapLayer - j == 3 || noofFramesinEachMapLayer - j == 0) {
                                    this.pMapLayerInfo[i][1].animId = (byte)23;
                                    this.pMapLayerInfo[i][2].animId = (byte)23;
                                    this.mCanvas.mDynPanActivated = true;
                                    this.mCanvas.setDynPanningParameters(BenGame.getMapXPosition(), BenGame.getMapYPosition(), this.pMapLayerInfo[i][8].tileX - (StateCommonData.screen_Width >> 1) + (this.pAnim.pMapAnimation[13].AnimationWidth >> 1), this.pMapLayerInfo[i][8].tileY - (StateCommonData.screen_Height >> 1) + (this.pAnim.pMapAnimation[13].AnimationHeight >> 1), (short)8);
                                    tileColId = this.pMapLayerInfo[i][8].tileX / 12;
                                    tileRowId = this.pMapLayerInfo[i][8].tileY / 12;
                                    for (k = 0; k < 6; ++k) {
                                        short[] sArray = Map.MapData.MapBoundArray[tileRowId + k];
                                        int n = tileColId;
                                        sArray[n] = (short)(sArray[n] & 0xFF00);
                                    }
                                } else if (noofFramesinEachMapLayer - j == 7 || noofFramesinEachMapLayer - j == 4) {
                                    this.pMapLayerInfo[i][5].animId = (byte)23;
                                    this.pMapLayerInfo[i][6].animId = (byte)23;
                                    this.mCanvas.mDynPanActivated = true;
                                    this.mCanvas.setDynPanningParameters(BenGame.getMapXPosition(), BenGame.getMapYPosition(), this.pMapLayerInfo[i][9].tileX - (StateCommonData.screen_Width >> 1) + (this.pAnim.pMapAnimation[13].AnimationWidth >> 1), this.pMapLayerInfo[i][9].tileY - (StateCommonData.screen_Height >> 1) + (this.pAnim.pMapAnimation[13].AnimationHeight >> 1), (short)9);
                                    tileColId = this.pMapLayerInfo[i][9].tileX / 12;
                                    tileRowId = this.pMapLayerInfo[i][9].tileY / 12;
                                    for (k = 0; k < 6; ++k) {
                                        short[] sArray = Map.MapData.MapBoundArray[tileRowId + k];
                                        int n = tileColId;
                                        sArray[n] = (short)(sArray[n] & 0xFF00);
                                    }
                                }
                            }
                            this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                            if (BenGame.mCurrentLevel != 5) break;
                            this.mCanvas.mDynPanActivated = true;
                            this.mCanvas.setDynPanningParameters(BenGame.getMapXPosition(), BenGame.getMapYPosition(), this.pMapLayerInfo[i][9].tileX - (StateCommonData.screen_Width >> 1) + (this.pAnim.pMapAnimation[13].AnimationWidth >> 1), this.pMapLayerInfo[i][9].tileY - (StateCommonData.screen_Height >> 1) + (this.pAnim.pMapAnimation[13].AnimationHeight >> 1), (short)9);
                        }
                    }
                }
                if (animationID != 0 || Player.mHeroType != 0 && Player.mHeroType != 3 || this.mCanvas.IsVisible(this.MapObjectRectangle, BenGame.mMap_X_off, BenGame.mMap_Y_off) <= 0) continue;
                for (int k = 0; k < 3; ++k) {
                    if (!this.mapObjectCollisionDetection(this.MapObjectRectangle, this.mCanvas.mBen.pWeapon.struct_Weapon[k].CurrentAnimFrameRect) || this.mCanvas.mBen.pWeapon.struct_Weapon[k].collided || !this.mCanvas.mBen.pWeapon.struct_Weapon[k].mIsActive) continue;
                    this.mCanvas.mBen.pWeapon.struct_Weapon[k].collided = true;
                    this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].animId = 1;
                    this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].current_frame = 0;
                    int tileColId = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileX / 12;
                    int tileRowId = this.pMapLayerInfo[i][noofFramesinEachMapLayer - j].tileY / 12;
                    for (int l = 0; l < 4; ++l) {
                        short[] sArray = Map.MapData.MapBoundArray[tileRowId + l];
                        int n = tileColId;
                        sArray[n] = (short)(sArray[n] & 0xFF00);
                    }
                    if (this.mCanvas.mBen.pWeapon.struct_Weapon[k].state == 0) {
                        this.mCanvas.mBen.pWeapon.struct_Weapon[k].state = 1;
                    } else if (this.mCanvas.mBen.pWeapon.struct_Weapon[k].state == 2) {
                        this.mCanvas.mBen.pWeapon.struct_Weapon[k].state = (byte)3;
                    }
                    this.mCanvas.mBen.pWeapon.struct_Weapon[k].iCharFrameNumber = 1;
                    this.mCanvas.mBen.pWeapon.struct_Weapon[k].CurrentAnimFrameRect.x = this.MapObjectRectangle.x + (this.MapObjectRectangle.dx >> 1) + (!this.mCanvas.mBen.pWeapon.struct_Weapon[k].mIsCharacterFlipped ? -this.mCanvas.mBen.pWeapon.getCharacterWidth(this.mCanvas.mBen.pWeapon.struct_Weapon[k].state, this.mCanvas.mBen.pWeapon.struct_Weapon[k].iCharFrameNumber) : 0);
                }
            }
        }
    }

    public boolean mapObjectCollisionDetection(Rectangle aMapObjectRectangle, Rectangle aBenRect) {
        return aMapObjectRectangle != null && aBenRect != null && aBenRect.checkCollide(aMapObjectRectangle);
    }

    public void TutorialPointsDisappear() {
        if (BenGame.mCurrentLevel == 1) {
            if (this.PlayerRect.x >= 96 && !this.PermanentlyObjectDeActivate[0]) {
                this.pMapLayerInfo[0][3].isActive = false;
                this.pMapLayerInfo[0][6].isActive = false;
                this.PermanentlyObjectDeActivate[0] = true;
                this.TutorialObjectActivate[1] = true;
            }
            if (this.pMapLayerInfo[0][7].animId == 1 && !this.PermanentlyObjectDeActivate[1]) {
                this.pMapLayerInfo[0][4].isActive = false;
                this.PermanentlyObjectDeActivate[1] = true;
                this.TutorialObjectActivate[2] = true;
            }
            if (this.Playerclimb && !this.PermanentlyObjectDeActivate[2] && !this.mCanvas.mBen.struct_Player.mIsCharacterFlipped) {
                this.pMapLayerInfo[0][1].isActive = false;
                this.pMapLayerInfo[0][2].isActive = false;
                this.PermanentlyObjectDeActivate[2] = true;
                this.Playerclimb = false;
            }
            if (this.Playerclimb && !this.PermanentlyObjectDeActivate[4] && this.mCanvas.mBen.struct_Player.mIsCharacterFlipped) {
                this.pMapLayerInfo[0][5].isActive = false;
                this.pMapLayerInfo[0][0].isActive = false;
                this.PermanentlyObjectDeActivate[4] = true;
                this.PermanentlyObjectDeActivate[3] = true;
                this.Playerclimb = false;
            }
            if (!this.PermanentlyObjectDeActivate[3] && this.mCanvas.mEnemy.struct_enemy[7].bDied) {
                this.pMapLayerInfo[0][5].isActive = false;
                this.PermanentlyObjectDeActivate[3] = true;
                this.Playerclimb = false;
            }
        }
    }

    public void TutorialPointsAppear() {
        if (BenGame.mCurrentLevel == 1) {
            if (this.TutorialObjectActivate[0] && !this.PermanentlyObjectDeActivate[0]) {
                this.pMapLayerInfo[0][3].isActive = true;
                this.pMapLayerInfo[0][6].isActive = true;
            }
            if (this.TutorialObjectActivate[1] && !this.PermanentlyObjectDeActivate[1]) {
                this.pMapLayerInfo[0][4].isActive = true;
            }
            if (this.TutorialObjectActivate[2] && !this.PermanentlyObjectDeActivate[2]) {
                this.pMapLayerInfo[0][1].isActive = true;
                this.pMapLayerInfo[0][2].isActive = true;
            }
            if (!this.PermanentlyObjectDeActivate[3] && !this.PermanentlyObjectDeActivate[4] && this.Playerclimb && this.PlayerRect.x >= 264 && this.PlayerRect.x < 384) {
                this.pMapLayerInfo[0][5].isActive = true;
                this.pMapLayerInfo[0][0].isActive = true;
                this.Playerclimb = false;
            }
        }
    }
}

