/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Animation;
import Game.BenGame;
import Game.Interface_Enemy;
import Game.JavaReader;
import Game.MapObject;
import Game.Player;
import Game.Rectangle;
import Game.SoundPlayer;
import Game.Weapons;
import Project.JDisplay;
import StateManager.StateCommonData;
import java.io.DataInputStream;
import java.io.InputStream;

public class Enemy
implements Interface_Enemy {
    StateCommonData pCommonData;
    BenGame canvas;
    int noOfEnemies;
    Interface_Enemy.struct_Game_Enemy[] struct_enemy;
    JavaReader jr = new JavaReader();
    Animation[] enemyAnimation;
    Weapons eWeapons;
    public boolean b_CutHealth = false;
    public static long iEnemySpawnCounter = 0L;
    public static long Popup_timer_1 = 0L;
    public static long Popup_timer_2 = 0L;
    private long attackDelayTimer;
    int enemyStopperX;

    public Enemy(BenGame canvas, StateCommonData pCommonData) {
        this.pCommonData = pCommonData;
        this.canvas = canvas;
        this.enemyAnimation = new Animation[8];
    }

    public void readEnemyData(String mapFile) {
        try {
            InputStream in = this.getClass().getResourceAsStream(mapFile);
            DataInputStream dis = new DataInputStream(in);
            this.noOfEnemies = this.jr.readShort(dis);
            this.struct_enemy = new Interface_Enemy.struct_Game_Enemy[this.noOfEnemies];
            for (int i = 0; i < this.noOfEnemies; i = (int)((short)(i + 1))) {
                this.struct_enemy[i] = new Interface_Enemy.struct_Game_Enemy();
                this.struct_enemy[i].eCurrentFrameRect.x = this.jr.readShort(dis);
                this.struct_enemy[i].eCurrentFrameRect.y = this.jr.readShort(dis);
                this.struct_enemy[i].eCurrentFrameRect.dx = this.jr.readShort(dis);
                this.struct_enemy[i].eCurrentFrameRect.dy = this.jr.readShort(dis);
                this.struct_enemy[i].bType = this.jr.readByte(dis);
                this.struct_enemy[i].bBehaviour = this.jr.readByte(dis);
                this.struct_enemy[i].state = this.jr.readByte(dis);
                this.struct_enemy[i].nextState = this.jr.readByte(dis);
                byte tempByte = this.jr.readByte(dis);
                this.struct_enemy[i].bFlipped = tempByte == 1;
                this.struct_enemy[i].iCharFrameNumber = this.jr.readByte(dis);
                tempByte = this.jr.readByte(dis);
                this.struct_enemy[i].bDied = tempByte == 1;
                this.struct_enemy[i].Health = this.jr.readByte(dis);
                this.jr.skip(4L, dis);
                this.struct_enemy[i].rangeRect.dx = this.jr.readShort(dis);
                this.struct_enemy[i].rangeRect.dy = this.jr.readShort(dis);
                tempByte = this.jr.readByte(dis);
                this.struct_enemy[i].Active = tempByte == 1;
                this.struct_enemy[i].attackDelayCounter = this.jr.readByte(dis);
                this.struct_enemy[i].Health = (byte)this.canvas.mDpsInfo.struct_DPSInfo[4 + this.struct_enemy[i].bType].iHp;
                this.struct_enemy[i].DelayTime = this.struct_enemy[i].bType == 6 || this.struct_enemy[i].bType == 7 ? new long[2] : new long[1];
            }
        }
        catch (Exception ex) {
            System.out.println("readEnemyData  " + ex);
        }
    }

    public void releaseAniReasourse() {
        for (int i = 0; i < 8; ++i) {
            if (this.enemyAnimation[i] == null) continue;
            this.enemyAnimation[i].releaseAnimationImages();
            this.enemyAnimation[i].releaseAnimationData();
            this.enemyAnimation[i] = null;
        }
    }

    public void releaseEnemyStructure() {
        for (int i = 0; i < this.noOfEnemies; i = (int)((short)(i + 1))) {
            if (this.struct_enemy[i].eCurrentFrameRect != null) {
                this.struct_enemy[i].eCurrentFrameRect = null;
            }
            if (this.struct_enemy[i].rangeRect != null) {
                this.struct_enemy[i].rangeRect = null;
            }
            if (this.struct_enemy[i].eNextFrameRect != null) {
                this.struct_enemy[i].eNextFrameRect = null;
            }
            if (this.struct_enemy[i] == null) continue;
            this.struct_enemy[i] = null;
        }
        if (this.struct_enemy != null) {
            this.struct_enemy = null;
        }
    }

    public void unloadEnemyresourse() {
        this.releaseAniReasourse();
        this.releaseEnemyStructure();
        if (this.jr != null) {
            this.jr = null;
        }
    }

    public void resetEnemy() {
        iEnemySpawnCounter = 0L;
    }

    public void loadEnemyWeapons(byte aLevel) {
        switch (aLevel) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.eWeapons = new Weapons(this);
                this.eWeapons.loadWeaponResource("/megawatt_electricity.png", "/megawatt_electricity.ani");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.eWeapons = new Weapons(this);
                this.eWeapons.loadWeaponResource("/robot_bullet.png", "/robot_bullet.ani");
            }
        }
    }

    public void loadEnemyResources(byte aLevel) {
        switch (aLevel) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.enemyAnimation[0] = new Animation();
                this.enemyAnimation[0].loadAnimImages("/megawatt.png");
                this.enemyAnimation[0].LoadAnimation("/megawatt.ani");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.enemyAnimation[2] = new Animation();
                this.enemyAnimation[2].loadAnimImages("/robotdrones.png");
                this.enemyAnimation[2].LoadAnimation("/robotdrones.ani");
                this.enemyAnimation[1] = new Animation();
                this.enemyAnimation[1].loadAnimImages("/flyingDrones.png");
                this.enemyAnimation[1].LoadAnimation("/flyingDrones.ani");
            }
        }
    }

    public void updateEnemyStates(byte enemyCount) {
        if (this.struct_enemy[enemyCount].state == 0 && this.struct_enemy[enemyCount].iCharFrameNumber == 0) {
            this.struct_enemy[enemyCount].state = this.struct_enemy[enemyCount].nextState;
        }
        switch (this.struct_enemy[enemyCount].state) {
            case 0: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = 0;
                this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                break;
            }
            case 1: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = (byte)2;
                this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                break;
            }
            case 2: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = this.struct_enemy[enemyCount].nextState;
                this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                break;
            }
            case 3: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = this.struct_enemy[enemyCount].nextState;
                this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                break;
            }
            case 4: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = 0;
                this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                break;
            }
            case 5: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = 0;
                this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                break;
            }
            case 6: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = (byte)7;
                this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                break;
            }
            case 7: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = this.struct_enemy[enemyCount].nextState;
                this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                break;
            }
            case 8: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = this.struct_enemy[enemyCount].nextState;
                this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                break;
            }
            case 9: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = 0;
                this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                break;
            }
            case 10: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = 0;
                this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                break;
            }
            case 11: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = 0;
                this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                break;
            }
            case 14: {
                if ((this.struct_enemy[enemyCount].bType == 0 && this.struct_enemy[enemyCount].iCharFrameNumber == 7 || this.struct_enemy[enemyCount].bType == 2 && this.struct_enemy[enemyCount].iCharFrameNumber == 2) && !this.eWeapons.struct_Weapon[enemyCount].mIsActive) {
                    this.eWeapons.struct_Weapon[enemyCount].CurrentAnimFrameRect.x = this.struct_enemy[enemyCount].eCurrentFrameRect.x + (this.struct_enemy[enemyCount].bFlipped ? -1 : 1 * this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[14].AnimationFrames[this.struct_enemy[enemyCount].iCharFrameNumber].AnimationLayers[this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[14].AnimationFrames[this.struct_enemy[enemyCount].iCharFrameNumber].NOFLayers - 1].LayerX);
                    this.eWeapons.struct_Weapon[enemyCount].CurrentAnimFrameRect.y = this.struct_enemy[enemyCount].eCurrentFrameRect.y + this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[14].AnimationFrames[this.struct_enemy[enemyCount].iCharFrameNumber].AnimationLayers[this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[14].AnimationFrames[this.struct_enemy[enemyCount].iCharFrameNumber].NOFLayers - 1].LayerY;
                    this.eWeapons.struct_Weapon[enemyCount].mIsActive = true;
                    this.eWeapons.struct_Weapon[enemyCount].mIsCharacterFlipped = this.struct_enemy[enemyCount].bFlipped;
                }
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = 0;
                this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                this.struct_enemy[enemyCount].DelayTime[0] = 4000L;
                break;
            }
            case 13: {
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = 0;
                this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                this.struct_enemy[enemyCount].bDied = true;
                iEnemySpawnCounter = 4000L;
                if (!this.struct_enemy[enemyCount].isdiedbyFriend) {
                    this.updateScore(enemyCount);
                    break;
                }
                this.struct_enemy[enemyCount].isdiedbyFriend = false;
                break;
            }
            case 12: {
                if (this.struct_enemy[enemyCount].iCharFrameNumber == 1) {
                    this.canvas.mDpsInfo.updateHealth((byte)4, Player.mHeroType, (short)0, enemyCount);
                    this.canvas.mCollisionEffect = true;
                }
                this.struct_enemy[enemyCount].iCharFrameNumber = (byte)(this.struct_enemy[enemyCount].iCharFrameNumber + 1);
                if (this.struct_enemy[enemyCount].iCharFrameNumber < this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].NOFFrames) break;
                this.struct_enemy[enemyCount].state = 0;
                this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                this.struct_enemy[enemyCount].DelayTime[0] = 1000L;
            }
        }
        if (this.struct_enemy[enemyCount].Health <= 0 && this.struct_enemy[enemyCount].state != 13) {
            this.struct_enemy[enemyCount].state = (byte)13;
            this.struct_enemy[enemyCount].iCharFrameNumber = 0;
        }
        this.calcNextFrameRect(enemyCount);
    }

    public void updateScore(byte enemyCount) {
        switch (this.struct_enemy[enemyCount].bType) {
            case 0: {
                switch (this.struct_enemy[enemyCount].bBehaviour) {
                    case 0: {
                        MapObject.levelScore += 250;
                        break;
                    }
                    case 1: {
                        MapObject.levelScore += 350;
                        break;
                    }
                    case 2: {
                        MapObject.levelScore += 450;
                        break;
                    }
                    case 3: {
                        MapObject.levelScore += 500;
                    }
                }
                break;
            }
            case 1: {
                switch (this.struct_enemy[enemyCount].bType) {
                    case 0: {
                        MapObject.levelScore += 250;
                        break;
                    }
                    case 1: {
                        MapObject.levelScore += 350;
                    }
                }
                break;
            }
            case 2: {
                switch (this.struct_enemy[enemyCount].bType) {
                    case 0: {
                        MapObject.levelScore += 400;
                        break;
                    }
                    case 1: {
                        MapObject.levelScore += 550;
                        break;
                    }
                    case 2: {
                        MapObject.levelScore += 650;
                        break;
                    }
                    case 3: {
                        MapObject.levelScore += 750;
                    }
                }
                break;
            }
            case 6: {
                MapObject.levelScore += 750;
                break;
            }
            case 7: {
                MapObject.levelScore += 750;
            }
        }
    }

    public void calcNextFrameRect(byte enemyCount) {
        this.struct_enemy[enemyCount].eNextFrameRect = this.enemyAnimation[this.struct_enemy[enemyCount].bType].GetNextFrame(this.struct_enemy[enemyCount].state, this.struct_enemy[enemyCount].iCharFrameNumber);
        if (this.struct_enemy[enemyCount].bFlipped) {
            this.struct_enemy[enemyCount].eNextFrameRect.x = -this.struct_enemy[enemyCount].eNextFrameRect.x;
        }
    }

    public void updateAnimPosition(byte enemyCount) {
        if (this.struct_enemy[enemyCount].bFlipped) {
            int vWidthDifference = this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].AnimationFrames[this.struct_enemy[enemyCount].iCharFrameNumber].FrameWidth - this.struct_enemy[enemyCount].eCurrentFrameRect.dx;
            this.struct_enemy[enemyCount].eCurrentFrameRect.x -= vWidthDifference - this.struct_enemy[enemyCount].eNextFrameRect.x;
        } else {
            this.struct_enemy[enemyCount].eCurrentFrameRect.x += this.struct_enemy[enemyCount].eNextFrameRect.x;
        }
        this.struct_enemy[enemyCount].eCurrentFrameRect.y += this.struct_enemy[enemyCount].eNextFrameRect.y;
        this.struct_enemy[enemyCount].eCurrentFrameRect.dx = this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].AnimationFrames[this.struct_enemy[enemyCount].iCharFrameNumber].FrameWidth;
        this.struct_enemy[enemyCount].eCurrentFrameRect.dy = this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].AnimationFrames[this.struct_enemy[enemyCount].iCharFrameNumber].FrameHeight;
    }

    public void checkAIMovements(byte enemyCount) {
        switch (this.struct_enemy[enemyCount].bBehaviour) {
            case 0: {
                if (this.struct_enemy[enemyCount].Active) {
                    if (this.struct_enemy[enemyCount].state == 2) {
                        this.struct_enemy[enemyCount].nextState = (byte)4;
                    } else if (this.struct_enemy[enemyCount].state == 3) {
                        this.struct_enemy[enemyCount].nextState = (byte)5;
                    }
                    if (this.struct_enemy[enemyCount].bType == 0 && this.checkCollisionWithHero(enemyCount) >= 0 && this.struct_enemy[enemyCount].state != 0 && this.struct_enemy[enemyCount].state != 13 && this.struct_enemy[enemyCount].state != 12 && this.struct_enemy[enemyCount].state != 14 && !this.canvas.mCollisionEffect) {
                        this.canvas.mCollisionEffect = true;
                        this.canvas.mDpsInfo.updateHealth((byte)4, Player.mHeroType, (short)0, enemyCount);
                    }
                    if (this.struct_enemy[enemyCount].state != 0 || this.struct_enemy[enemyCount].iCharFrameNumber != 0) break;
                    if (this.checkCollisionWithHero(enemyCount) >= 0) {
                        if (this.struct_enemy[enemyCount].DelayTime[0] <= 0L) {
                            this.struct_enemy[enemyCount].state = (byte)12;
                        }
                    } else {
                        this.struct_enemy[enemyCount].state = 1;
                    }
                    this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                    this.calcNextFrameRect(enemyCount);
                    break;
                }
                if (this.struct_enemy[enemyCount].state == 0) {
                    this.struct_enemy[enemyCount].nextState = 1;
                } else if (this.struct_enemy[enemyCount].state == 2) {
                    this.struct_enemy[enemyCount].nextState = (byte)3;
                } else if (this.struct_enemy[enemyCount].state == 3) {
                    this.struct_enemy[enemyCount].nextState = (byte)2;
                }
                if (this.struct_enemy[enemyCount].bType != 0 || this.checkCollisionWithHero(enemyCount) < 0 || this.struct_enemy[enemyCount].state == 0 || this.struct_enemy[enemyCount].state == 13 || this.struct_enemy[enemyCount].state == 12 || this.struct_enemy[enemyCount].state == 14 || this.canvas.mCollisionEffect) break;
                this.canvas.mCollisionEffect = true;
                this.canvas.mDpsInfo.updateHealth((byte)4, Player.mHeroType, (short)0, enemyCount);
                break;
            }
            case 1: {
                if (this.struct_enemy[enemyCount].mBlockSentryBehaviour && this.checkCollisionWithHero(enemyCount) < 0) break;
                if (this.struct_enemy[enemyCount].Active) {
                    if (this.checkCollisionWithHero(enemyCount) < 0) {
                        if (this.struct_enemy[enemyCount].state == 0) {
                            this.struct_enemy[enemyCount].nextState = (byte)6;
                            break;
                        }
                        if (this.struct_enemy[enemyCount].state == 7) {
                            this.struct_enemy[enemyCount].nextState = (byte)8;
                            break;
                        }
                        if (this.struct_enemy[enemyCount].state != 8) break;
                        this.struct_enemy[enemyCount].nextState = (byte)7;
                        break;
                    }
                    if (this.struct_enemy[enemyCount].state == 7) {
                        this.struct_enemy[enemyCount].nextState = (byte)9;
                        break;
                    }
                    if (this.struct_enemy[enemyCount].state == 8) {
                        this.struct_enemy[enemyCount].nextState = (byte)10;
                        break;
                    }
                    if (this.struct_enemy[enemyCount].state != 0 || this.struct_enemy[enemyCount].iCharFrameNumber != 0) break;
                    if (this.struct_enemy[enemyCount].DelayTime[0] <= 0L) {
                        this.struct_enemy[enemyCount].state = (byte)12;
                    }
                    this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                    this.calcNextFrameRect(enemyCount);
                    break;
                }
                if (this.struct_enemy[enemyCount].state == 7) {
                    this.struct_enemy[enemyCount].nextState = (byte)9;
                    break;
                }
                if (this.struct_enemy[enemyCount].state == 8) {
                    this.struct_enemy[enemyCount].nextState = (byte)10;
                    break;
                }
                if (this.struct_enemy[enemyCount].state != 0) break;
                this.struct_enemy[enemyCount].nextState = 0;
                break;
            }
            case 2: {
                if (this.struct_enemy[enemyCount].Active) {
                    if (this.checkCollisionWithHero(enemyCount) < 0) {
                        if (this.struct_enemy[enemyCount].state == 2) {
                            this.struct_enemy[enemyCount].nextState = (byte)4;
                            break;
                        }
                        if (this.struct_enemy[enemyCount].state == 3) {
                            this.struct_enemy[enemyCount].nextState = (byte)5;
                            break;
                        }
                        if (this.struct_enemy[enemyCount].state != 0 || this.struct_enemy[enemyCount].iCharFrameNumber != 0) break;
                        if (this.struct_enemy[enemyCount].DelayTime[0] <= 0L) {
                            if (this.canvas.IsVisible(this.struct_enemy[enemyCount].eCurrentFrameRect, BenGame.getMapXPosition(), BenGame.getMapYPosition()) > 0) {
                                this.struct_enemy[enemyCount].state = (byte)14;
                            }
                        } else {
                            this.struct_enemy[enemyCount].nextState = 0;
                            this.struct_enemy[enemyCount].state = 0;
                        }
                        this.calcNextFrameRect(enemyCount);
                        break;
                    }
                    if (this.struct_enemy[enemyCount].state == 2) {
                        this.struct_enemy[enemyCount].nextState = (byte)4;
                    } else if (this.struct_enemy[enemyCount].state == 3) {
                        this.struct_enemy[enemyCount].nextState = (byte)5;
                    }
                    if (this.struct_enemy[enemyCount].bType == 0 && this.checkCollisionWithHero(enemyCount) >= 0 && this.struct_enemy[enemyCount].state != 13 && this.struct_enemy[enemyCount].state != 12 && this.struct_enemy[enemyCount].state != 14 && (this.struct_enemy[enemyCount].state == 0 && this.struct_enemy[enemyCount].DelayTime[0] > 0L || this.struct_enemy[enemyCount].state != 0) && !this.canvas.mCollisionEffect) {
                        this.canvas.mCollisionEffect = true;
                        this.canvas.mDpsInfo.updateHealth((byte)4, Player.mHeroType, (short)0, enemyCount);
                    }
                    if (this.struct_enemy[enemyCount].state != 0 || this.struct_enemy[enemyCount].iCharFrameNumber != 0) break;
                    if (this.struct_enemy[enemyCount].DelayTime[0] <= 0L) {
                        this.struct_enemy[enemyCount].state = (byte)12;
                    }
                    this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                    this.calcNextFrameRect(enemyCount);
                    break;
                }
                if (this.struct_enemy[enemyCount].state == 0) {
                    this.struct_enemy[enemyCount].nextState = 1;
                    break;
                }
                if (this.struct_enemy[enemyCount].state == 2) {
                    this.struct_enemy[enemyCount].nextState = (byte)3;
                    break;
                }
                if (this.struct_enemy[enemyCount].state != 3) break;
                this.struct_enemy[enemyCount].nextState = (byte)2;
                break;
            }
            case 3: {
                if (this.struct_enemy[enemyCount].Active) {
                    if (this.checkCollisionWithHero(enemyCount) < 0) {
                        if (this.struct_enemy[enemyCount].state != 0 || this.struct_enemy[enemyCount].iCharFrameNumber != 0) break;
                        if (this.struct_enemy[enemyCount].DelayTime[0] <= 0L) {
                            if (this.canvas.IsVisible(this.struct_enemy[enemyCount].eCurrentFrameRect, BenGame.getMapXPosition(), BenGame.getMapYPosition()) > 0) {
                                this.struct_enemy[enemyCount].state = (byte)14;
                            }
                        } else {
                            this.struct_enemy[enemyCount].nextState = 0;
                            this.struct_enemy[enemyCount].state = 0;
                        }
                        this.calcNextFrameRect(enemyCount);
                        break;
                    }
                    if (this.struct_enemy[enemyCount].state != 0 || this.struct_enemy[enemyCount].iCharFrameNumber != 0) break;
                    if (this.struct_enemy[enemyCount].DelayTime[0] <= 0L) {
                        this.struct_enemy[enemyCount].state = (byte)12;
                    }
                    this.struct_enemy[enemyCount].iCharFrameNumber = 1;
                    this.calcNextFrameRect(enemyCount);
                    break;
                }
                if (this.struct_enemy[enemyCount].state != 0) break;
                this.struct_enemy[enemyCount].nextState = 0;
            }
        }
    }

    public void flipEnemy(byte enemyCount) {
        byte mCollisionIndex = this.canvas.mMap.CheckCollision(this.struct_enemy[enemyCount].eCurrentFrameRect, this.struct_enemy[enemyCount].eNextFrameRect, this.struct_enemy[enemyCount].bFlipped, (byte)1);
        this.struct_enemy[enemyCount].mBlockSentryBehaviour = false;
        if (this.canvas.mMap.getScriptIndex() == 2 && !this.struct_enemy[enemyCount].bFlipped) {
            if (this.struct_enemy[enemyCount].state != 14 && this.struct_enemy[enemyCount].state != 12) {
                if (this.struct_enemy[enemyCount].bBehaviour != 1) {
                    if (this.struct_enemy[enemyCount].bBehaviour == 0) {
                        this.struct_enemy[enemyCount].Active = false;
                    }
                    this.struct_enemy[enemyCount].bFlipped = true;
                    this.struct_enemy[enemyCount].eCurrentFrameRect.x = this.canvas.mMap.Tile_Scipt_Rect.x - this.struct_enemy[enemyCount].eNextFrameRect.dx;
                    this.struct_enemy[enemyCount].eNextFrameRect.x = 0;
                } else {
                    this.struct_enemy[enemyCount].mBlockSentryBehaviour = true;
                    if (this.struct_enemy[enemyCount].state != 0 && this.struct_enemy[enemyCount].state != 13) {
                        this.struct_enemy[enemyCount].state = 0;
                        this.struct_enemy[enemyCount].nextState = 0;
                        this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                        this.struct_enemy[enemyCount].eCurrentFrameRect.x = this.canvas.mMap.Tile_Scipt_Rect.x - this.struct_enemy[enemyCount].eNextFrameRect.dx;
                        this.struct_enemy[enemyCount].eCurrentFrameRect.y = this.canvas.mMap.Tile_Scipt_Rect.y + 24 - this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].AnimationFrames[this.struct_enemy[enemyCount].iCharFrameNumber].FrameHeight;
                    }
                }
            } else if (this.struct_enemy[enemyCount].state == 12) {
                // empty if block
            }
            this.enemyStopperX = this.canvas.mMap.Tile_Scipt_Rect.x;
        } else if (this.canvas.mMap.getScriptIndex() == 7 && this.struct_enemy[enemyCount].bFlipped) {
            if (this.struct_enemy[enemyCount].state != 14 && this.struct_enemy[enemyCount].state != 12) {
                if (this.struct_enemy[enemyCount].bBehaviour != 1) {
                    if (this.struct_enemy[enemyCount].bBehaviour == 0) {
                        this.struct_enemy[enemyCount].Active = false;
                    }
                    this.struct_enemy[enemyCount].bFlipped = false;
                    this.struct_enemy[enemyCount].eCurrentFrameRect.x = this.canvas.mMap.Tile_Scipt_Rect.x + this.canvas.mMap.Tile_Scipt_Rect.dx;
                    this.struct_enemy[enemyCount].eNextFrameRect.x = 0;
                } else {
                    this.struct_enemy[enemyCount].mBlockSentryBehaviour = true;
                    if (this.struct_enemy[enemyCount].state != 13) {
                        this.struct_enemy[enemyCount].state = 0;
                        this.struct_enemy[enemyCount].nextState = 0;
                        this.struct_enemy[enemyCount].iCharFrameNumber = 0;
                        this.struct_enemy[enemyCount].eCurrentFrameRect.x = this.canvas.mMap.Tile_Scipt_Rect.x + this.canvas.mMap.Tile_Scipt_Rect.dx - 2;
                        this.struct_enemy[enemyCount].eCurrentFrameRect.y = this.canvas.mMap.Tile_Scipt_Rect.y + 24 - this.enemyAnimation[this.struct_enemy[enemyCount].bType].mObjAnimationsArray[this.struct_enemy[enemyCount].state].AnimationFrames[this.struct_enemy[enemyCount].iCharFrameNumber].FrameHeight;
                    }
                }
            } else if (this.struct_enemy[enemyCount].state == 12) {
                // empty if block
            }
            this.enemyStopperX = this.canvas.mMap.Tile_Scipt_Rect.x + this.canvas.mMap.Tile_Scipt_Rect.dx;
        }
        if (this.struct_enemy[enemyCount].Active && ((this.canvas.mBen.struct_Player.CurrentAnimFrameRect.x < this.enemyStopperX && this.struct_enemy[enemyCount].bFlipped || this.canvas.mBen.struct_Player.CurrentAnimFrameRect.x + this.canvas.mBen.struct_Player.CurrentAnimFrameRect.dx > this.enemyStopperX + 12 && !this.struct_enemy[enemyCount].bFlipped) && this.struct_enemy[enemyCount].bBehaviour == 0 || this.struct_enemy[enemyCount].bBehaviour == 1 || this.struct_enemy[enemyCount].bBehaviour == 2 || this.struct_enemy[enemyCount].bBehaviour == 3) && this.struct_enemy[enemyCount].state == 0) {
            this.struct_enemy[enemyCount].bFlipped = this.canvas.mBen.struct_Player.CurrentAnimFrameRect.x < this.struct_enemy[enemyCount].eCurrentFrameRect.x;
        }
    }

    public byte checkCollisionWithHero(byte enemyCount) {
        if (this.canvas.mBen.struct_Player.state != 4 && this.struct_enemy[enemyCount].eCurrentFrameRect.checkCollide(this.canvas.mBen.struct_Player.CurrentAnimFrameRect)) {
            return enemyCount;
        }
        return -1;
    }

    public void update() {
        for (byte i = 0; i < this.noOfEnemies; i = (byte)((byte)(i + 1))) {
            if (this.struct_enemy[i].bDied) continue;
            this.struct_enemy[i].DelayTime[0] = this.struct_enemy[i].DelayTime[0] - (long)this.pCommonData.mTimer.getDtMSeconds();
            if (this.struct_enemy[i].bType == 6 || this.struct_enemy[i].bType == 7) continue;
            this.checkIsHeroInRange(i);
            this.updateEnemyStates(i);
            if (this.struct_enemy[i].bType == 0 || this.struct_enemy[i].bType == 2) {
                this.eWeapons.updateWeaponState(i);
            }
            this.flipEnemy(i);
            this.checkAIMovements(i);
            this.updateAnimPosition(i);
            this.checkCollisionWithHero(i);
            if (this.struct_enemy[i].bType != 0 && this.struct_enemy[i].bType != 2 || !this.eWeapons.struct_Weapon[i].mIsActive) continue;
            this.eWeapons.updateWeaponPosition(i);
            if (!this.eWeapons.checkEnemyWeaponCollisionWdHero(i)) continue;
            this.canvas.mCollisionEffect = true;
            this.canvas.mDpsInfo.updateHealth((byte)4, Player.mHeroType, (short)1, i);
        }
        if (!this.canvas.mCollisionEffect || this.canvas.mDpsInfo.getPlayerHealth() <= 0 || SoundPlayer.mIsSoundActive) {
            // empty if block
        }
    }

    public void changeToIdleState(byte enemyCount) {
        if (this.struct_enemy[enemyCount].state == 2) {
            this.struct_enemy[enemyCount].nextState = (byte)4;
        }
        if (this.struct_enemy[enemyCount].state == 3) {
            this.struct_enemy[enemyCount].nextState = (byte)5;
        }
    }

    public int onWhichPlatForm(int Tile_Y, int[] Arr) {
        for (int i = 0; i < Arr.length; ++i) {
            if (Tile_Y / 12 != Arr[i]) continue;
            return i;
        }
        return 0;
    }

    public void checkIsHeroInRange(byte enemyCount) {
        this.struct_enemy[enemyCount].rangeRect.x = (short)(this.struct_enemy[enemyCount].eCurrentFrameRect.x - this.struct_enemy[enemyCount].rangeRect.dx);
        this.struct_enemy[enemyCount].rangeRect.y = (short)(this.struct_enemy[enemyCount].eCurrentFrameRect.y - this.struct_enemy[enemyCount].rangeRect.dy);
        Rectangle Rect = new Rectangle();
        Rect.x = this.struct_enemy[enemyCount].rangeRect.x;
        Rect.y = this.struct_enemy[enemyCount].rangeRect.y;
        Rect.dx = 2 * this.struct_enemy[enemyCount].rangeRect.dx + this.struct_enemy[enemyCount].eCurrentFrameRect.dx;
        Rect.dy = 2 * this.struct_enemy[enemyCount].rangeRect.dy + this.struct_enemy[enemyCount].eCurrentFrameRect.dy;
        if (this.struct_enemy[enemyCount].bBehaviour == 0) {
            Rect.x = this.struct_enemy[enemyCount].bFlipped ? this.struct_enemy[enemyCount].eCurrentFrameRect.x - this.struct_enemy[enemyCount].rangeRect.dx : this.struct_enemy[enemyCount].eCurrentFrameRect.x + this.struct_enemy[enemyCount].eCurrentFrameRect.dx;
            Rect.dx = this.struct_enemy[enemyCount].rangeRect.dx;
        }
        if (Rect.checkCollide(this.canvas.mBen.struct_Player.CurrentAnimFrameRect)) {
            this.struct_enemy[enemyCount].Active = true;
            if (BenGame.mCurrentLevel == 2) {
                if (enemyCount == 12 && this.canvas.mMapObjects.pMapLayerInfo[0][97].animId != 1) {
                    this.struct_enemy[enemyCount].Active = false;
                }
            } else if (BenGame.mCurrentLevel == 3 && enemyCount == 0 && this.canvas.mMapObjects.pMapLayerInfo[0][1].animId != 1) {
                this.struct_enemy[enemyCount].Active = false;
            }
            if (BenGame.mCurrentLevel == 5 && enemyCount == 11 && this.canvas.mMapObjects.pMapLayerInfo[0][9].animId != 27) {
                this.struct_enemy[enemyCount].Active = false;
            }
        } else {
            this.struct_enemy[enemyCount].Active = false;
        }
        Rect = null;
    }

    void DrawEnemy(JDisplay g, short Map_X, short Map_Y) {
        if (Map_X < 0) {
            Map_X = 0;
        }
        if (Map_Y < 0) {
            Map_Y = 0;
        }
        for (int i = 0; i < this.noOfEnemies; ++i) {
            if (this.struct_enemy[i].bDied) continue;
            this.struct_enemy[i].eCurrentFrameRect.dx = this.enemyAnimation[this.struct_enemy[i].bType].mObjAnimationsArray[this.struct_enemy[i].state].AnimationFrames[this.struct_enemy[i].iCharFrameNumber].FrameWidth;
            this.struct_enemy[i].eCurrentFrameRect.dy = this.enemyAnimation[this.struct_enemy[i].bType].mObjAnimationsArray[this.struct_enemy[i].state].AnimationFrames[this.struct_enemy[i].iCharFrameNumber].FrameHeight;
            short aEnemyX = (short)(this.struct_enemy[i].eCurrentFrameRect.x - Map_X);
            short aEnemyY = (short)(this.struct_enemy[i].eCurrentFrameRect.y - Map_Y);
            if (this.canvas.IsVisible(this.struct_enemy[i].eCurrentFrameRect, Map_X, Map_Y) > 0) {
                this.enemyAnimation[this.struct_enemy[i].bType].Play(g, this.struct_enemy[i].bFlipped, this.struct_enemy[i].state, this.struct_enemy[i].iCharFrameNumber, aEnemyX, aEnemyY, 1);
            }
            if (this.struct_enemy[i].bType != 0 && this.struct_enemy[i].bType != 2 && this.struct_enemy[i].bType != 6 || !this.eWeapons.struct_Weapon[i].mIsActive) continue;
            this.eWeapons.drawCharacter(g, 1, this.eWeapons.struct_Weapon[i]);
        }
    }
}

