/*
 * Decompiled with CFR 0.152.
 */
package Project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JInputStream {
    public static final byte SEEK_START = 0;
    public static final byte SEEK_END = 1;
    public static final byte SEEK_CURRENT = 2;
    private static final byte STREAM_NONE = 0;
    private static final byte STREAM_BUFFER = 1;
    private static final byte STREAM_FILE = 2;
    private static final byte STREAM_INPUTSTREAM = 3;
    private byte streamType = 0;
    protected Object pStream = null;
    private int length = 0;

    public boolean load(String fileName, Object obj) {
        this.close();
        try {
            this.pStream = this.getClass().getResourceAsStream(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        try {
            this.length = ((InputStream)this.pStream).available();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ((InputStream)this.pStream).close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.pStream = null;
            this.length = 0;
            return false;
        }
        if (((InputStream)this.pStream).markSupported()) {
            ((InputStream)this.pStream).mark(this.length);
        }
        this.streamType = (byte)2;
        return this.onInputStreamLoad(obj);
    }

    public boolean load(byte[] pBuffer, Object obj) {
        this.close();
        if (pBuffer != null && pBuffer.length > 0) {
            this.pStream = new ByteStream();
            ((ByteStream)this.pStream).bs = new ByteArrayInputStream(pBuffer);
            ((ByteStream)this.pStream).index = 0;
            this.streamType = 1;
            this.length = pBuffer.length;
            return this.onInputStreamLoad(obj);
        }
        return false;
    }

    public boolean load(JInputStream is, Object obj) {
        this.close();
        if (is != null) {
            this.streamType = (byte)3;
            this.pStream = is;
            this.length = is.length;
            return this.onInputStreamLoad(obj);
        }
        return false;
    }

    public int getLength() {
        return this.length;
    }

    public void close() {
        switch (this.streamType) {
            case 2: {
                try {
                    ((InputStream)this.pStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                try {
                    ((ByteStream)this.pStream).bs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ((ByteStream)this.pStream).bs = null;
            }
        }
        this.streamType = 0;
        this.pStream = null;
        this.length = 0;
    }

    protected boolean onInputStreamLoad(Object obj) {
        return true;
    }

    public int readBytes(byte[] b, int len) {
        int cnt = 0;
        switch (this.streamType) {
            case 2: {
                try {
                    cnt = ((InputStream)this.pStream).read(b, 0, len);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                cnt = ((ByteStream)this.pStream).bs.read(b, ((ByteStream)this.pStream).index, len);
                if (cnt <= 0) break;
                ((ByteStream)this.pStream).index += cnt;
                break;
            }
            case 3: {
                cnt = ((JInputStream)this.pStream).readBytes(b, len);
            }
        }
        return cnt;
    }

    public void seekBytes(int seekType, int moveDistance) {
        switch (this.streamType) {
            case 2: {
                switch (seekType) {
                    case 0: {
                        if (!((InputStream)this.pStream).markSupported()) break;
                        try {
                            ((InputStream)this.pStream).reset();
                            ((InputStream)this.pStream).skip(moveDistance);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 1: {
                        try {
                            ((InputStream)this.pStream).reset();
                            if (moveDistance < 0 && -moveDistance < this.length) {
                                ((InputStream)this.pStream).skip(this.length + moveDistance);
                                break;
                            }
                            ((InputStream)this.pStream).skip(this.length);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 2: {
                        try {
                            ((InputStream)this.pStream).skip(moveDistance);
                            break;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                break;
            }
            case 1: {
                switch (seekType) {
                    case 0: {
                        ((ByteStream)this.pStream).index = this.length > moveDistance ? moveDistance : this.length;
                        break;
                    }
                    case 1: {
                        if (moveDistance < 0 && -moveDistance < this.length) {
                            ((ByteStream)this.pStream).index = this.length + moveDistance;
                            break;
                        }
                        ((ByteStream)this.pStream).index = this.length;
                        break;
                    }
                    case 2: {
                        ((ByteStream)this.pStream).index = this.length > ((ByteStream)this.pStream).index + moveDistance ? ((ByteStream)this.pStream).index + moveDistance : this.length;
                    }
                }
                break;
            }
            case 3: {
                ((JInputStream)this.pStream).seekBytes(seekType, moveDistance);
            }
        }
    }

    public byte readByte() {
        byte[] b = new byte[1];
        this.readBytes(b, 1);
        byte temp = b[0];
        b = null;
        return temp;
    }

    public short readInt16() {
        short temp = 0;
        temp = (short)(temp | this.readByte() & 0xFF);
        temp = (short)(temp | (this.readByte() & 0xFF) << 8);
        return temp;
    }

    public int readInt32() {
        int temp = 0;
        temp |= this.readByte() & 0xFF;
        temp |= (this.readByte() & 0xFF) << 8;
        temp |= (this.readByte() & 0xFF) << 16;
        return temp |= (this.readByte() & 0xFF) << 24;
    }

    public short read_BigEndian_Int16() {
        short temp = 0;
        temp = (short)(temp | (this.readByte() & 0xFF) << 8);
        temp = (short)(temp | this.readByte() & 0xFF);
        return temp;
    }

    public int read_BigEndian_Int32() {
        int temp = 0;
        temp |= (this.readByte() & 0xFF) << 24;
        temp |= (this.readByte() & 0xFF) << 16;
        temp |= (this.readByte() & 0xFF) << 8;
        return temp |= this.readByte() & 0xFF;
    }

    private class ByteStream {
        ByteArrayInputStream bs;
        int index;

        private ByteStream() {
        }
    }
}

