/*
 * Decompiled with CFR 0.152.
 */
package Project;

import Project.JImage;
import javax.microedition.lcdui.Graphics;

public class JDisplay {
    public static Graphics g;
    public static int screenWidth;
    public static int screenHeight;
    public static final int FLIP_NONE = 0;
    public static final int FLIP_HORIZONTAL = 2;
    public static final int FLIP_VERTICAL = 3;
    public static final int FLIP_HORIZONTAL_VERTICAL = 1;
    public static final int RO_COPY = 0;
    public static final int RO_TRANSPARENT = 1;
    public static final int RO_SEMI_TRANSPARENT = 2;

    public JDisplay(int w, int h) {
        screenWidth = w;
        screenHeight = h;
    }

    public void destroy() {
        screenHeight = 0;
        screenWidth = 0;
    }

    public void clearScreen(int color) {
        if (g != null) {
            g.setColor(color);
            g.setClip(0, 0, screenWidth, screenHeight);
            g.fillRect(0, 0, screenWidth, screenHeight);
        }
    }

    public void drawRect(int x, int y, int dx, int dy, int color, boolean bFill) {
        if (g != null) {
            g.setColor(color);
            g.setClip(0, 0, screenWidth, screenHeight);
            if (bFill) {
                g.fillRect(x, y, dx, dy);
            } else {
                g.drawRect(x, y, dx, dy);
            }
        }
    }

    public void drawImage(JImage img, int x, int y, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int flip, int rop) {
        int clip;
        int overflow;
        int size;
        if (g == null) {
            return;
        }
        if (sourceX < 0) {
            x += sourceX;
            sourceX = 0;
        }
        if (sourceY < 0) {
            y += sourceY;
            sourceY = 0;
        }
        if (sourceWidth > (size = img.width - sourceX)) {
            sourceWidth = size;
        }
        if ((overflow = (clip = g.getClipX()) - x) > 0) {
            sourceWidth -= overflow;
            sourceX += overflow;
            x = clip;
        }
        if ((overflow = x + sourceWidth - (clip += g.getClipWidth())) > 0) {
            sourceWidth -= overflow;
        }
        if (sourceWidth > 0) {
            size = img.height - sourceY;
            if (sourceHeight > size) {
                sourceHeight = size;
            }
            if ((overflow = (clip = g.getClipY()) - y) > 0) {
                sourceHeight -= overflow;
                sourceY += overflow;
                y = clip;
            }
            if ((overflow = y + sourceHeight - (clip += g.getClipHeight())) > 0) {
                sourceHeight -= overflow;
            }
            if (sourceHeight > 0) {
                g.drawRegion(img.image, sourceX, sourceY, sourceWidth, sourceHeight, flip, x, y, 20);
            }
        }
    }
}

